/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.BasicCommandField;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiMsgException;
import com.sun.netstorage.samqfs.mgmt.SamFSWarnings;
import com.sun.netstorage.samqfs.web.archive.PolicySummaryTiledView;
import com.sun.netstorage.samqfs.web.archive.PolicyUtil;
import com.sun.netstorage.samqfs.web.archive.wizards.NewPolicyWizardImpl;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.CommonTableContainerView;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.SecurityManagerFactory;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCRadioButton;
import com.sun.web.ui.view.table.CCActionTable;
import com.sun.web.ui.view.wizard.CCWizardWindow;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;

public class PolicySummaryView
extends CommonTableContainerView {
    public static String TILED_VIEW = "PolicySummaryTiledView";
    public static String WIZARD_FORWARDTO = "policyForwardToVB";
    private CCWizardWindowModel policyWizardWindowModel = null;
    private CCActionTableModel tableModel = null;
    private boolean newPolicyWizardRunning = false;
    static /* synthetic */ Class class$com$iplanet$jato$view$BasicCommandField;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$archive$PolicySummaryTiledView;

    public PolicySummaryView(View parent, String name) {
        super(parent, name);
        TraceUtil.trace3("Entering");
        this.CHILD_ACTION_TABLE = "PolicySummaryTable";
        this.createTableModel();
        this.initializeNewPolicyWizard();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        this.registerChild(WIZARD_FORWARDTO, class$com$iplanet$jato$view$BasicCommandField == null ? (class$com$iplanet$jato$view$BasicCommandField = PolicySummaryView.class$("com.iplanet.jato.view.BasicCommandField")) : class$com$iplanet$jato$view$BasicCommandField);
        this.registerChild(TILED_VIEW, class$com$sun$netstorage$samqfs$web$archive$PolicySummaryTiledView == null ? (class$com$sun$netstorage$samqfs$web$archive$PolicySummaryTiledView = PolicySummaryView.class$("com.sun.netstorage.samqfs.web.archive.PolicySummaryTiledView")) : class$com$sun$netstorage$samqfs$web$archive$PolicySummaryTiledView);
        super.registerChildren(this.tableModel);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        if (name.equals(WIZARD_FORWARDTO)) {
            return new BasicCommandField((View)this, name);
        }
        if (name.equals(TILED_VIEW)) {
            return new PolicySummaryTiledView((View)this, this.tableModel, name);
        }
        return super.createChild(this.tableModel, name, TILED_VIEW);
    }

    private void initializeNewPolicyWizard() {
        TraceUtil.trace3("Entering");
        CommonViewBeanBase parent = (CommonViewBeanBase)this.getParentViewBean();
        NonSyncStringBuffer cmdChild = new NonSyncStringBuffer().append(parent.getQualifiedName()).append(".").append("PolicySummaryView.").append(WIZARD_FORWARDTO);
        this.policyWizardWindowModel = NewPolicyWizardImpl.createModel(cmdChild.toString());
        this.tableModel.setModel("SamQFSWizardNewPolicy", (Object)this.policyWizardWindowModel);
        this.policyWizardWindowModel.setValue("SamQFSWizardNewPolicy", (Object)"archiving.new");
        this.policyWizardWindowModel.setValue("SERVER_NAME", (Object)parent.getServerName());
        TraceUtil.trace3("Exiting");
    }

    private void setWizardState() {
        TraceUtil.trace3("Entering");
        CommonViewBeanBase parent = (CommonViewBeanBase)this.getParentViewBean();
        String temp = (String)parent.getPageSessionAttribute("NewPolicyPageModelName");
        String modelName = (String)parent.getPageSessionAttribute("NewPolicyPageModelName");
        String implName = (String)parent.getPageSessionAttribute("NewPolicyWizardImpl");
        if (modelName == null) {
            modelName = "WizardModel_" + HtmlUtil.getUniqueValue();
            parent.setPageSessionAttribute("NewPolicyPageModelName", (Serializable)((Object)modelName));
        }
        this.policyWizardWindowModel.setValue("NewPolicyPageModelName", (Object)modelName);
        if (implName == null) {
            implName = "WizardImpl_" + HtmlUtil.getUniqueValue();
            parent.setPageSessionAttribute("NewPolicyWizardImpl", (Serializable)((Object)implName));
        }
        this.policyWizardWindowModel.setValue("wizName", (Object)implName);
        String serverName = parent.getServerName();
        this.policyWizardWindowModel.setValue("SERVER_NAME", (Object)serverName);
        TraceUtil.trace3("Exiting");
    }

    public void createTableModel() {
        this.tableModel = new CCActionTableModel(RequestManager.getRequestContext().getServletContext(), "/jsp/archive/PolicySummaryTable.xml");
    }

    private void initializeTableHeaders() {
        TraceUtil.trace3("Entering");
        this.tableModel.setActionValue("PolicyName", (Object)"archiving.policy.name");
        this.tableModel.setActionValue("PolicyType", (Object)"archiving.policy.type");
        this.tableModel.setActionValue("CopyCount", (Object)"archiving.policy.numberofcopies");
        this.tableModel.setActionValue("FileSystems", (Object)"archiving.policy.filesystems");
        this.tableModel.setActionValue("DeletePolicy", (Object)"archiving.delete");
        TraceUtil.trace3("Exiting");
    }

    public void populateTableModel() {
        TraceUtil.trace3("Entering");
        NonSyncStringBuffer types = new NonSyncStringBuffer();
        NonSyncStringBuffer names = new NonSyncStringBuffer();
        Object exception = null;
        boolean hasException = false;
        CommonViewBeanBase parent = (CommonViewBeanBase)this.getParentViewBean();
        String serverName = parent.getServerName();
        CCActionTable theTable = (CCActionTable)this.getChild(this.CHILD_ACTION_TABLE);
        ((CCRadioButton)theTable.getChild("SelectionRadiobutton")).setTitle("");
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            ArchivePolicy[] policy = sysModel.getSamQFSSystemArchiveManager43().getAllArchivePolicies();
            this.tableModel.clear();
            for (int i = 0; i < policy.length; ++i) {
                if (i > 0) {
                    this.tableModel.appendRow();
                }
                this.tableModel.setValue("PolicyNameHref", (Object)policy[i].getPolicyName());
                this.tableModel.setValue("PolicyNameText", (Object)policy[i].getPolicyName());
                this.tableModel.setValue("PolicyTypeValue", (Object)Integer.toString(policy[i].getPolicyType()));
                this.tableModel.setValue("PolicyTypeText", (Object)PolicyUtil.getPolicyTypeString(policy[i]));
                this.tableModel.setValue("CopyCountText", (Object)new Integer(policy[i].getArchiveCopies().length));
                this.tableModel.setValue("FileSystemsText", (Object)PolicyUtil.getPolicyFSString(policy[i]));
                names.append(policy[i].getPolicyName()).append(";");
                types.append(policy[i].getPolicyType()).append(";");
                this.tableModel.setRowSelected(false);
            }
        }
        catch (SamFSWarnings sfw) {
            SamUtil.processException((Exception)((Object)sfw), ((Object)((Object)this)).getClass(), "populateTableModel", "unable to retrieve policy information", serverName);
            SamUtil.setWarningAlert((ContainerView)parent, "Alert", "ArchiveConfig.error.summary", sfw.getMessage());
        }
        catch (SamFSMultiMsgException smme) {
            SamUtil.processException((Exception)((Object)smme), ((Object)((Object)this)).getClass(), "populateTableModel", "unable to retrieve policy information", serverName);
            SamUtil.setErrorAlert((ContainerView)parent, "Alert", "ArchiveConfig.error.summary", smme.getSAMerrno(), "ArchiveConfig.error.detail", serverName);
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "populateTableModel", "unable to retrieve policy information", serverName);
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveConfig.error.summary", sfe.getSAMerrno(), sfe.getMessage(), serverName);
        }
        CCHiddenField child = (CCHiddenField)parent.getChild("policyTypes");
        child.setValue((Object)types.toString());
        child = (CCHiddenField)parent.getChild("policyNames");
        child.setValue((Object)names.toString());
        TraceUtil.trace3("Exiting");
    }

    public void beginDisplay(DisplayEvent evt) throws ModelControlException {
        TraceUtil.trace3("Entering");
        this.initializeTableHeaders();
        this.setWizardState();
        CCButton del = (CCButton)this.getChild("DeletePolicy");
        del.setDisabled(true);
        boolean hasPermission = SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.CONFIG);
        if (!hasPermission) {
            this.tableModel.setSelectionType("none");
        }
        CCWizardWindow button = (CCWizardWindow)this.getChild("SamQFSWizardNewPolicy");
        if (this.newPolicyWizardRunning || !hasPermission) {
            button.setDisabled(true);
        } else {
            button.setDisabled(false);
        }
        TraceUtil.trace3("Exiting");
    }

    public void handlePolicyForwardToVBRequest(RequestInvocationEvent rie) throws ServletException, IOException {
        this.newPolicyWizardRunning = false;
        this.getParentViewBean().forwardTo(this.getRequestContext());
    }

    public void handleSamQFSWizardNewPolicyRequest(RequestInvocationEvent rie) throws ServletException, IOException {
        this.newPolicyWizardRunning = true;
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleDeletePolicyRequest(RequestInvocationEvent rie) throws ServletException, IOException {
        CCHiddenField field = (CCHiddenField)this.getParentViewBean().getChild("policyToDelete");
        String policyName = (String)field.getValue();
        CommonViewBeanBase parent = (CommonViewBeanBase)this.getParentViewBean();
        String serverName = parent.getServerName();
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            sysModel.getSamQFSSystemArchiveManager43().deleteArchivePolicy(policyName);
            SamUtil.setInfoAlert((ContainerView)parent, "Alert", "success.summary", SamUtil.getResourceString("archiving.policy.delete.success", policyName), serverName);
        }
        catch (SamFSWarnings sfw) {
            SamUtil.processException((Exception)((Object)sfw), ((Object)((Object)this)).getClass(), "handleDeletePolicyRequest", "policy deleted", serverName);
            SamUtil.setWarningAlert((ContainerView)parent, "Alert", "ArchiveConfig.error", "ArchiveConfig.warning.detail");
        }
        catch (SamFSMultiMsgException smme) {
            SamUtil.processException((Exception)((Object)smme), ((Object)((Object)this)).getClass(), "handleDeletePolicyRequest", "Unable to delete policy", serverName);
            SamUtil.setErrorAlert((ContainerView)parent, "Alert", "ArchiveConfig.error", smme.getSAMerrno(), "ArchiveConfig.error.detail");
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "handleDeletePolicyRequest", "unable to delete policy", serverName);
            SamUtil.setErrorAlert((ContainerView)parent, "Alert", "ArchiveConfig.error.summary", sfe.getSAMerrno(), sfe.getMessage(), serverName);
        }
        parent.forwardTo(this.getRequestContext());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

