/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSWarnings;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemArchiveManager43;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.VSNPool;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.util.CommonSecondaryViewBeanBase;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCLabel;
import com.sun.web.ui.view.html.CCRadioButton;
import com.sun.web.ui.view.html.CCStaticTextField;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;

public class NewEditVSNPoolViewBean
extends CommonSecondaryViewBeanBase {
    public static final String PAGE_NAME = "NewEditVSNPool";
    private static final String DEFAULT_DISPLAY_URL = "/jsp/archive/NewEditVSNPool.jsp";
    public static final String REQUIRED_LABEL = "requiredLabel";
    public static final String NAME = "name";
    public static final String NAME_LABEL = "nameLabel";
    public static final String MEDIA_TYPE = "mediaType";
    public static final String MEDIA_TYPE_LABEL = "mediaTypeLabel";
    public static final String SPECIFY_VSN_LABEL = "specifyVSNLabel";
    public static final String VSN_START_END_RADIO = "vsnStartEndRadio";
    public static final String VSN_RANGE_RADIO = "vsnRangeRadio";
    public static final String START_LABEL = "startLabel";
    public static final String START = "start";
    public static final String END_LABEL = "endLabel";
    public static final String END = "end";
    public static final String VSN_RANGE_LABEL = "vsnRangeLabel";
    public static final String VSN_RANGE = "vsnRange";
    public static final String VSN_RANGE_HELP = "vsnRangeHelp";
    public static final String OPERATION = "OPERATION";
    public static final String NEW_POOL = "NEW";
    public static final String EDIT_POOL = "EDIT";
    private CCPageTitleModel ptModel = null;
    private boolean isFirstLoad = false;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCLabel;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCTextField;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCDropDownMenu;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCRadioButton;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCStaticTextField;

    public NewEditVSNPoolViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.ptModel = this.createPageTitleModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren();
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.registerChild(REQUIRED_LABEL, class$com$sun$web$ui$view$html$CCLabel == null ? (class$com$sun$web$ui$view$html$CCLabel = NewEditVSNPoolViewBean.class$("com.sun.web.ui.view.html.CCLabel")) : class$com$sun$web$ui$view$html$CCLabel);
        this.registerChild(NAME, class$com$sun$web$ui$view$html$CCTextField == null ? (class$com$sun$web$ui$view$html$CCTextField = NewEditVSNPoolViewBean.class$("com.sun.web.ui.view.html.CCTextField")) : class$com$sun$web$ui$view$html$CCTextField);
        this.registerChild(NAME_LABEL, class$com$sun$web$ui$view$html$CCLabel == null ? (class$com$sun$web$ui$view$html$CCLabel = NewEditVSNPoolViewBean.class$("com.sun.web.ui.view.html.CCLabel")) : class$com$sun$web$ui$view$html$CCLabel);
        this.registerChild(MEDIA_TYPE, class$com$sun$web$ui$view$html$CCDropDownMenu == null ? (class$com$sun$web$ui$view$html$CCDropDownMenu = NewEditVSNPoolViewBean.class$("com.sun.web.ui.view.html.CCDropDownMenu")) : class$com$sun$web$ui$view$html$CCDropDownMenu);
        this.registerChild(MEDIA_TYPE_LABEL, class$com$sun$web$ui$view$html$CCLabel == null ? (class$com$sun$web$ui$view$html$CCLabel = NewEditVSNPoolViewBean.class$("com.sun.web.ui.view.html.CCLabel")) : class$com$sun$web$ui$view$html$CCLabel);
        this.registerChild(SPECIFY_VSN_LABEL, class$com$sun$web$ui$view$html$CCLabel == null ? (class$com$sun$web$ui$view$html$CCLabel = NewEditVSNPoolViewBean.class$("com.sun.web.ui.view.html.CCLabel")) : class$com$sun$web$ui$view$html$CCLabel);
        this.registerChild(VSN_START_END_RADIO, class$com$sun$web$ui$view$html$CCRadioButton == null ? (class$com$sun$web$ui$view$html$CCRadioButton = NewEditVSNPoolViewBean.class$("com.sun.web.ui.view.html.CCRadioButton")) : class$com$sun$web$ui$view$html$CCRadioButton);
        this.registerChild(VSN_RANGE_RADIO, class$com$sun$web$ui$view$html$CCRadioButton == null ? (class$com$sun$web$ui$view$html$CCRadioButton = NewEditVSNPoolViewBean.class$("com.sun.web.ui.view.html.CCRadioButton")) : class$com$sun$web$ui$view$html$CCRadioButton);
        this.registerChild(START_LABEL, class$com$sun$web$ui$view$html$CCLabel == null ? (class$com$sun$web$ui$view$html$CCLabel = NewEditVSNPoolViewBean.class$("com.sun.web.ui.view.html.CCLabel")) : class$com$sun$web$ui$view$html$CCLabel);
        this.registerChild(START, class$com$sun$web$ui$view$html$CCTextField == null ? (class$com$sun$web$ui$view$html$CCTextField = NewEditVSNPoolViewBean.class$("com.sun.web.ui.view.html.CCTextField")) : class$com$sun$web$ui$view$html$CCTextField);
        this.registerChild(END_LABEL, class$com$sun$web$ui$view$html$CCLabel == null ? (class$com$sun$web$ui$view$html$CCLabel = NewEditVSNPoolViewBean.class$("com.sun.web.ui.view.html.CCLabel")) : class$com$sun$web$ui$view$html$CCLabel);
        this.registerChild(END, class$com$sun$web$ui$view$html$CCTextField == null ? (class$com$sun$web$ui$view$html$CCTextField = NewEditVSNPoolViewBean.class$("com.sun.web.ui.view.html.CCTextField")) : class$com$sun$web$ui$view$html$CCTextField);
        this.registerChild(VSN_RANGE_LABEL, class$com$sun$web$ui$view$html$CCLabel == null ? (class$com$sun$web$ui$view$html$CCLabel = NewEditVSNPoolViewBean.class$("com.sun.web.ui.view.html.CCLabel")) : class$com$sun$web$ui$view$html$CCLabel);
        this.registerChild(VSN_RANGE, class$com$sun$web$ui$view$html$CCTextField == null ? (class$com$sun$web$ui$view$html$CCTextField = NewEditVSNPoolViewBean.class$("com.sun.web.ui.view.html.CCTextField")) : class$com$sun$web$ui$view$html$CCTextField);
        this.registerChild(VSN_RANGE_HELP, class$com$sun$web$ui$view$html$CCStaticTextField == null ? (class$com$sun$web$ui$view$html$CCStaticTextField = NewEditVSNPoolViewBean.class$("com.sun.web.ui.view.html.CCStaticTextField")) : class$com$sun$web$ui$view$html$CCStaticTextField);
        TraceUtil.trace3("Exiting");
    }

    protected View createChild(String name) {
        if (name.indexOf("Label") != -1) {
            return new CCLabel((ContainerView)this, name, null);
        }
        if (name.equals(NAME) || name.equals(START) || name.equals(END) || name.equals(VSN_RANGE)) {
            return new CCTextField((ContainerView)this, name, null);
        }
        if (name.equals(MEDIA_TYPE)) {
            return new CCDropDownMenu((ContainerView)this, name, null);
        }
        if (name.equals(VSN_START_END_RADIO)) {
            CCRadioButton radio = new CCRadioButton((ContainerView)this, VSN_START_END_RADIO, (Object)"vsnrange");
            radio.setOptions(new OptionList(new String[]{""}, new String[]{"startend"}));
            return radio;
        }
        if (name.equals(VSN_RANGE_RADIO)) {
            CCRadioButton radio = new CCRadioButton((ContainerView)this, VSN_START_END_RADIO, (Object)"vsnrange");
            radio.setOptions(new OptionList(new String[]{""}, new String[]{"vsnrange"}));
            return radio;
        }
        if (name.equals(VSN_RANGE_HELP)) {
            return new CCStaticTextField((ContainerView)this, name, null);
        }
        if (super.isChildSupported(name)) {
            return super.createChild(name);
        }
        if (name.equals("PageTitle")) {
            return new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name);
        }
        if (this.ptModel.isChildSupported(name)) {
            return this.ptModel.createChild((View)this, name);
        }
        throw new IllegalArgumentException("Invalid child [" + name + "]");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        super.beginDisplay(event);
        CCDropDownMenu mediaType = (CCDropDownMenu)this.getChild(MEDIA_TYPE);
        String serverName = this.getServerName();
        String poolName = "";
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            int[] mediaTypes = sysModel.getSamQFSSystemMediaManager().getAvailableArchiveMediaTypes();
            String[] labels = new String[mediaTypes.length];
            String[] values = new String[mediaTypes.length];
            for (int i = 0; i < mediaTypes.length; ++i) {
                labels[i] = SamUtil.getMediaTypeString(mediaTypes[i]);
                values[i] = Integer.toString(mediaTypes[i]);
            }
            mediaType.setOptions(new OptionList(labels, values));
            if (!this.isNewVSNPool()) {
                this.ptModel.setPageTitleText("NewEditVSNPool.edit.pageTitle");
                poolName = this.getVSNPoolName();
                CCTextField name = (CCTextField)this.getChild(NAME);
                if (this.isFirstLoad) {
                    this.loadPoolDetails(serverName, poolName);
                }
                name.setDisabled(true);
                mediaType.setDisabled(true);
                name.setValue((Object)poolName);
            } else {
                this.ptModel.setPageTitleText("NewEditVSNPool.new.pageTitle");
            }
            String rs = this.getDisplayFieldStringValue(VSN_START_END_RADIO);
            if ("vsnrange".equals(rs)) {
                ((CCTextField)this.getChild(VSN_RANGE)).setDisabled(false);
            }
        }
        catch (SamFSException smfex) {
            SamUtil.processException((Exception)((Object)smfex), ((Object)((Object)this)).getClass(), "beginDisplay", "Exception occurred within framework", serverName);
            ((CCButton)this.getChild("Submit")).setDisabled(true);
            throw new ModelControlException(smfex.getMessage() != null ? smfex.getMessage() : "Exception occurred within framework");
        }
        TraceUtil.trace3("Exiting");
    }

    private CCPageTitleModel createPageTitleModel() {
        return new CCPageTitleModel(RequestManager.getRequestContext().getServletContext(), "/jsp/archive/NewEditVSNPoolPageTitle.xml");
    }

    protected boolean isNewVSNPool() {
        String operation = (String)this.getPageSessionAttribute(OPERATION);
        if (operation == null) {
            operation = RequestManager.getRequest().getParameter(OPERATION);
            this.setPageSessionAttribute(OPERATION, (Serializable)((Object)operation));
            this.isFirstLoad = true;
        }
        return NEW_POOL.equals(operation);
    }

    protected String getVSNPoolName() {
        String poolName = (String)this.getPageSessionAttribute("SAMQFS_vsn_pool_name");
        if (poolName == null) {
            poolName = RequestManager.getRequest().getParameter("SAMQFS_vsn_pool_name");
            this.setPageSessionAttribute("SAMQFS_vsn_pool_name", (Serializable)((Object)poolName));
        }
        return poolName;
    }

    protected List validate() throws SamFSException {
        ArrayList<String> errors = new ArrayList<String>();
        SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
        SamQFSSystemArchiveManager43 archiveManager = sysModel.getSamQFSSystemArchiveManager43();
        String poolName = null;
        int mediaType = 133;
        boolean newPool = this.isNewVSNPool();
        if (newPool) {
            poolName = this.getDisplayFieldStringValue(NAME);
            poolName = poolName == null ? "" : poolName.trim();
            String s = this.getDisplayFieldStringValue(MEDIA_TYPE);
            mediaType = s == null ? 1033 : Integer.parseInt(s);
        } else {
            poolName = this.getVSNPoolName();
        }
        if (poolName.equals("")) {
            errors.add(SamUtil.getResourceString("NewEditVSN.namenull"));
            ((CCLabel)this.getChild(NAME_LABEL)).setShowError(true);
        } else {
            if (!SamUtil.isValidFSNameString(poolName)) {
                errors.add(SamUtil.getResourceString("NewEditVSN.invalidname"));
                ((CCLabel)this.getChild(NAME_LABEL)).setShowError(true);
            }
            String[] allPoolNames = archiveManager.getAllPoolNames();
            boolean found = !newPool;
            for (int i = 0; i < allPoolNames.length && !found; ++i) {
                if (!poolName.equals(allPoolNames[i])) continue;
                found = true;
            }
            if (found && newPool) {
                errors.add(SamUtil.getResourceString("NewEditVSN.nameinuse", poolName));
                ((CCLabel)this.getChild(NAME_LABEL)).setShowError(true);
            }
        }
        String radio = this.getDisplayFieldStringValue(VSN_START_END_RADIO);
        boolean isRange = "vsnrange".equals(radio);
        String expression = "";
        if (isRange) {
            String range = this.getDisplayFieldStringValue(VSN_RANGE);
            String string = range = range == null ? "" : range.trim();
            if (range.equals("")) {
                errors.add(SamUtil.getResourceString("NewEditVSN.rangenull"));
                ((CCLabel)this.getChild(VSN_RANGE_LABEL)).setShowError(true);
            } else {
                expression = range;
            }
        } else {
            boolean valid = true;
            String start = this.getDisplayFieldStringValue(START);
            String end = this.getDisplayFieldStringValue(END);
            start = start == null ? "" : start.trim();
            String string = end = end == null ? "" : end.trim();
            if (start.equals("")) {
                errors.add(SamUtil.getResourceString("NewEditVSN.invalidstart"));
                ((CCLabel)this.getChild(START_LABEL)).setShowError(true);
                valid = false;
            }
            if (end.equals("")) {
                errors.add(SamUtil.getResourceString("NewEditVSN.invalidend"));
                ((CCLabel)this.getChild(END_LABEL)).setShowError(true);
                valid = false;
            }
            if (valid && (expression = SamQFSUtil.createExpression(start, end)) == null) {
                errors.add(SamUtil.getResourceString("NewEditVSN.invalidstartend"));
                ((CCLabel)this.getChild(START_LABEL)).setShowError(true);
                ((CCLabel)this.getChild(END_LABEL)).setShowError(true);
            }
        }
        if (errors.size() == 0) {
            if (this.isNewVSNPool()) {
                archiveManager.createVSNPool(poolName, mediaType, expression);
            } else {
                VSNPool thePool = archiveManager.getVSNPool(poolName);
                if (thePool == null) {
                    throw new SamFSException(null, -2010);
                }
                thePool.setMemberVSNs(thePool.getMediaType(), expression);
            }
        }
        return errors;
    }

    protected void loadPoolDetails(String serverName, String poolName) throws SamFSException {
        SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
        VSNPool thePool = sysModel.getSamQFSSystemArchiveManager43().getVSNPool(poolName);
        if (thePool == null) {
            throw new SamFSException(null, -2010);
        }
        String vsnExpression = thePool.getVSNExpression();
        ((CCTextField)this.getChild(NAME)).setValue((Object)poolName);
        ((CCDropDownMenu)this.getChild(MEDIA_TYPE)).setValue((Object)Integer.toString(thePool.getMediaType()));
        CCTextField range = (CCTextField)this.getChild(VSN_RANGE);
        CCTextField start = (CCTextField)this.getChild(START);
        CCTextField end = (CCTextField)this.getChild(END);
        CCRadioButton radio = (CCRadioButton)this.getChild(VSN_START_END_RADIO);
        if (vsnExpression != null) {
            range.setValue((Object)vsnExpression);
            radio.setValue((Object)"vsnrange");
            start.setDisabled(true);
            end.setDisabled(true);
            range.setDisabled(false);
        } else {
            range.setDisabled(true);
            radio.setValue((Object)"startend");
            start.setDisabled(false);
            end.setDisabled(false);
        }
    }

    public void handleSubmitRequest(RequestInvocationEvent evt) throws ServletException, IOException {
        String serverName = this.getServerName();
        try {
            List errors = this.validate();
            if (errors.size() > 0) {
                NonSyncStringBuffer buffer = new NonSyncStringBuffer();
                Iterator it = errors.iterator();
                while (it.hasNext()) {
                    buffer.append((String)it.next()).append("<br>");
                }
                SamUtil.setErrorAlert((ContainerView)this, "Alert", "-2010", -2010, buffer.toString(), serverName);
            } else {
                String poolName = this.isNewVSNPool() ? this.getDisplayFieldStringValue(NAME) : this.getVSNPoolName();
                SamUtil.setInfoAlert((ContainerView)this, "Alert", "success.summary", SamUtil.getResourceString("archiving.vsnpool.new.success", poolName));
                this.setSubmitSuccessful(true);
            }
        }
        catch (SamFSWarnings sfw) {
            SamUtil.setWarningAlert((ContainerView)this, "Alert", "ArchiveConfig.warning.summary", "ArchiveConfig.warning.detail");
            this.setSubmitSuccessful(true);
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "handleSubmitRequest", "Error validating user input", serverName);
            SamUtil.setErrorAlert((ContainerView)this, "Alert", "-2010", sfe.getSAMerrno(), sfe.getMessage(), serverName);
        }
        this.forwardTo(this.getRequestContext());
    }

    public void handleCancelRequest(RequestInvocationEvent evt) throws ServletException, IOException {
        this.forwardTo(this.getRequestContext());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

