/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemArchiveManager43;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.FSArchiveDirective;
import com.sun.netstorage.samqfs.web.util.CommonTiledViewBase;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCStaticTextField;
import com.sun.web.ui.view.html.CCTextField;
import javax.servlet.http.HttpServletRequest;

public class GeneralArchivingSetupTiledView
extends CommonTiledViewBase {
    public GeneralArchivingSetupTiledView(View parent, CCActionTableModel model, String name) {
        super(parent, model, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        TraceUtil.trace3("Exiting");
    }

    public void mapRequestParameters(HttpServletRequest request) throws ModelControlException {
        ViewBean myParent = this.getParentViewBean();
        CCHiddenField hidden = (CCHiddenField)myParent.getChild("numberofrows");
        String numRows = (String)hidden.getValue();
        if (!"0".equals(numRows)) {
            super.mapRequestParameters(request);
        }
    }

    public boolean beginScanMethodTextDisplay(ChildDisplayEvent evt) throws ModelControlException {
        int index = this.model.getRowIndex();
        CCDropDownMenu dropDown = (CCDropDownMenu)this.getChild("ScanMethodText");
        dropDown.setValue((Object)Integer.toString(this.getScanMethodText(index)));
        return true;
    }

    public boolean beginIntervalTextDisplay(ChildDisplayEvent evt) throws ModelControlException {
        int index = this.model.getRowIndex();
        CCTextField child = (CCTextField)this.getChild("IntervalText");
        long interval = this.getIntervalText(index);
        String intervalStr = interval == -1L ? "" : Long.toString(interval);
        child.setValue((Object)intervalStr);
        return true;
    }

    public boolean beginIntervalUnitsDisplay(ChildDisplayEvent evt) throws ModelControlException {
        int index = this.model.getRowIndex();
        CCDropDownMenu dropDown = (CCDropDownMenu)this.getChild("IntervalUnits");
        dropDown.setValue((Object)Integer.toString(this.getIntervalUnits(index)));
        return true;
    }

    public boolean beginLogFileTextDisplay(ChildDisplayEvent evt) throws ModelControlException {
        int index = this.model.getRowIndex();
        CCTextField child = (CCTextField)this.getChild("LogFileText");
        child.setValue((Object)this.getLogFile(index));
        return true;
    }

    public boolean beginValidationStatusDisplay(ChildDisplayEvent evt) throws ModelControlException {
        CCStaticTextField child = (CCStaticTextField)this.getChild("ValidationStatus");
        child.setValue(null);
        return true;
    }

    private int getScanMethodText(int index) {
        FSArchiveDirective[] directives = this.getFSArchiveDirectives();
        return directives[index].getFSArchiveScanMethod();
    }

    private long getIntervalText(int index) {
        FSArchiveDirective[] directives = this.getFSArchiveDirectives();
        return directives[index].getFSInterval();
    }

    private int getIntervalUnits(int index) {
        FSArchiveDirective[] directives = this.getFSArchiveDirectives();
        return directives[index].getFSIntervalUnit();
    }

    private String getLogFile(int index) {
        FSArchiveDirective[] directives = this.getFSArchiveDirectives();
        return directives[index].getFSArchiveLogfile();
    }

    private FSArchiveDirective[] getFSArchiveDirectives() {
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        FSArchiveDirective[] fsad = (FSArchiveDirective[])request.getAttribute("CACHED_FS_DIRECTIVES");
        if (fsad != null) {
            return fsad;
        }
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel();
            SamQFSSystemArchiveManager43 archiveManager = sysModel.getSamQFSSystemArchiveManager43();
            fsad = archiveManager.getFSGeneralArchiveDirective();
            if (fsad == null) {
                fsad = new FSArchiveDirective[]{};
            }
        }
        catch (SamFSException samFSException) {
            // empty catch block
        }
        request.setAttribute("CACHED_FS_DIRECTVIES", (Object)fsad);
        return fsad;
    }
}

