/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.media.DiskVolume;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.CommonSecondaryViewBeanBase;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.PropertySheetUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.SecurityManagerFactory;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCCheckBox;
import com.sun.web.ui.view.html.CCHiddenField;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;

public class EditDiskVSNFlagsViewBean
extends CommonSecondaryViewBeanBase {
    private static final String PAGE_NAME = "EditDiskVSNFlags";
    private static final String DEFAULT_URL = "/jsp/archive/EditDiskVSNFlags.jsp";
    public static final String BAD_MEDIA = "badMedia";
    public static final String UNAVAILABLE = "unavailable";
    public static final String READ_ONLY = "readOnly";
    public static final String LABELED = "labeled";
    public static final String UNKNOWN = "unknown";
    public static final String REMOTE = "remote";
    public static final String SUBMIT = "Submit";
    public static final String CANCEL = "Cancel";
    public static final String VSN_NAME = "selected_vsn_name";
    private static final String psFileName = "/jsp/archive/EditDiskVSNFlagsPropertySheet.xml";
    private static final String ptFileName = "/jsp/archive/EditDiskVSNFlagsPageTitle.xml";
    private CCPropertySheetModel psModel = null;
    private CCPageTitleModel ptModel = null;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;

    public EditDiskVSNFlagsViewBean() {
        super(PAGE_NAME, DEFAULT_URL);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.psModel = PropertySheetUtil.createModel(psFileName);
        this.ptModel = PageTitleUtil.createModel(ptFileName);
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren();
        this.registerChild(VSN_NAME, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = EditDiskVSNFlagsViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        PropertySheetUtil.registerChildren((ContainerViewBase)this, this.psModel);
        PageTitleUtil.registerChildren((ContainerViewBase)this, this.ptModel);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        if (name.equals(VSN_NAME)) {
            return new CCHiddenField((ContainerView)this, name, null);
        }
        if (PropertySheetUtil.isChildSupported(this.psModel, name)) {
            return PropertySheetUtil.createChild((ContainerView)this, this.psModel, name);
        }
        if (super.isChildSupported(name)) {
            return super.createChild(name);
        }
        if (PageTitleUtil.isChildSupported(this.ptModel, name)) {
            return PageTitleUtil.createChild((ContainerView)this, this.ptModel, name);
        }
        throw new IllegalArgumentException("invalid child '" + name + "'");
    }

    public void beginDisplay(DisplayEvent evt) throws ModelControlException {
        TraceUtil.trace3("Entering");
        super.beginDisplay(evt);
        String serverName = this.getServerName();
        String vsnName = this.getSelectedVSNName();
        System.out.println("Server Name = " + serverName);
        System.out.println("selecte vsn = " + vsnName);
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            DiskVolume vsn = sysModel.getSamQFSSystemMediaManager().getDiskVSN(vsnName);
            ((CCCheckBox)this.getChild(BAD_MEDIA)).setChecked(vsn.isBadMedia());
            ((CCCheckBox)this.getChild(UNAVAILABLE)).setChecked(vsn.isUnavailable());
            ((CCCheckBox)this.getChild(READ_ONLY)).setChecked(vsn.isReadOnly());
            ((CCCheckBox)this.getChild(LABELED)).setChecked(vsn.isLabeled());
            ((CCCheckBox)this.getChild(UNKNOWN)).setChecked(vsn.isUnknown());
            ((CCCheckBox)this.getChild(REMOTE)).setChecked(vsn.isRemote());
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "beginDisplay", "Error retrieving disk vsn media flags", serverName);
        }
        if (!SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.MEDIA_OPERATOR)) {
            ((CCButton)this.getChild(SUBMIT)).setDisabled(true);
        }
        TraceUtil.trace3("Exiting");
    }

    public void handleSubmitRequest(RequestInvocationEvent rie) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        String serverName = this.getServerName();
        String vsnName = this.getSelectedVSNName();
        boolean badMedia = ((CCCheckBox)this.getChild(BAD_MEDIA)).isChecked();
        boolean unavailable = ((CCCheckBox)this.getChild(UNAVAILABLE)).isChecked();
        boolean readOnly = ((CCCheckBox)this.getChild(READ_ONLY)).isChecked();
        boolean labeled = ((CCCheckBox)this.getChild(LABELED)).isChecked();
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            DiskVolume vsn = sysModel.getSamQFSSystemMediaManager().getDiskVSN(vsnName);
            vsn.setBadMedia(badMedia);
            vsn.setUnavailable(unavailable);
            vsn.setReadOnly(readOnly);
            vsn.setLabeled(labeled);
            sysModel.getSamQFSSystemMediaManager().updateDiskVSNFlags(vsn);
            SamUtil.setInfoAlert((ContainerView)this, "Alert", "success.summary", SamUtil.getResourceString("archiving.diskvsn.mediachange.success", vsnName), serverName);
            this.setSubmitSuccessful(true);
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "handleEditMediaFlagsRequest", "Error modifying media flags", serverName);
            SamUtil.setErrorAlert((ContainerView)this, "Alert", SamUtil.getResourceString("archiving.diskvsn.mediachange.failure", vsnName), sfe.getSAMerrno(), sfe.getMessage(), serverName);
        }
        TraceUtil.trace3("Exiting");
        this.forwardTo(this.getRequestContext());
    }

    protected String getSelectedVSNName() {
        String vsnName = (String)this.getPageSessionAttribute(VSN_NAME);
        if (vsnName == null) {
            vsnName = RequestManager.getRequest().getParameter(VSN_NAME);
            this.setPageSessionAttribute(VSN_NAME, (Serializable)((Object)vsnName));
        }
        return vsnName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

