/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiMsgException;
import com.sun.netstorage.samqfs.mgmt.SamFSWarnings;
import com.sun.netstorage.samqfs.web.archive.ApplyCriteriaToFileSystemDumpView;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.util.CommonSecondaryViewBeanBase;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.html.CCCheckBox;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.ServletException;

public class ApplyCriteriaToFileSystemViewBean
extends CommonSecondaryViewBeanBase {
    public static final String DUMP_PARAMETERS = "writeToaDumpFile";
    private static final String PAGE_NAME = "ApplyCriteriaToFileSystem";
    private static final String DEFAULT_URL = "/jsp/archive/ApplyCriteriaToFileSystem.jsp";
    private static final String ALERT = "alert";
    private static final String FS_TABLE = "filesystemTable";
    private static final String PAGE_TITLE = "pageTitle";
    private static final String DUMP_VIEW = "dumpView";
    private static final String DUMP_ON = "dumpOn";
    private static final String FILENAMES = "filenames";
    private static final String ERROR_MESSAGES = "errorMessages";
    private static final String[] errorMessages = new String[]{"ApplyPolWizard.page1.errMsg", "ApplyPolWizard.page3.errMsg2", "ApplyPolWizard.page3.errMsg3"};
    private static final String DUMP_PATH = "savePath";
    private static final String DUMP_RADIO = "commitSave";
    private static final String FS_NAME = "hiddenFSName";
    private CCActionTableModel fsTableModel = null;
    private CCPageTitleModel pageTitleModel = null;
    private static final String SELECTED_FS = "selected_filesystems";
    private static final String ERROR_FS = "error_no_fs_selected";
    static /* synthetic */ Class class$com$sun$web$ui$view$pagetitle$CCPageTitle;
    static /* synthetic */ Class class$com$sun$web$ui$view$alert$CCAlertInline;
    static /* synthetic */ Class class$com$sun$web$ui$view$table$CCActionTable;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$archive$ApplyCriteriaToFileSystemDumpView;

    public ApplyCriteriaToFileSystemViewBean() {
        super(PAGE_NAME, DEFAULT_URL);
        TraceUtil.trace3("Entering");
        this.createFSTableModel();
        this.createPageTitleModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren();
        this.registerChild(PAGE_TITLE, class$com$sun$web$ui$view$pagetitle$CCPageTitle == null ? (class$com$sun$web$ui$view$pagetitle$CCPageTitle = ApplyCriteriaToFileSystemViewBean.class$("com.sun.web.ui.view.pagetitle.CCPageTitle")) : class$com$sun$web$ui$view$pagetitle$CCPageTitle);
        this.registerChild(ALERT, class$com$sun$web$ui$view$alert$CCAlertInline == null ? (class$com$sun$web$ui$view$alert$CCAlertInline = ApplyCriteriaToFileSystemViewBean.class$("com.sun.web.ui.view.alert.CCAlertInline")) : class$com$sun$web$ui$view$alert$CCAlertInline);
        this.registerChild(FS_TABLE, class$com$sun$web$ui$view$table$CCActionTable == null ? (class$com$sun$web$ui$view$table$CCActionTable = ApplyCriteriaToFileSystemViewBean.class$("com.sun.web.ui.view.table.CCActionTable")) : class$com$sun$web$ui$view$table$CCActionTable);
        this.registerChild(DUMP_ON, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = ApplyCriteriaToFileSystemViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(ERROR_MESSAGES, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = ApplyCriteriaToFileSystemViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(DUMP_VIEW, class$com$sun$netstorage$samqfs$web$archive$ApplyCriteriaToFileSystemDumpView == null ? (class$com$sun$netstorage$samqfs$web$archive$ApplyCriteriaToFileSystemDumpView = ApplyCriteriaToFileSystemViewBean.class$("com.sun.netstorage.samqfs.web.archive.ApplyCriteriaToFileSystemDumpView")) : class$com$sun$netstorage$samqfs$web$archive$ApplyCriteriaToFileSystemDumpView);
        this.registerChild(SELECTED_FS, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = ApplyCriteriaToFileSystemViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(ERROR_FS, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = ApplyCriteriaToFileSystemViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.fsTableModel.registerChildren((ContainerViewBase)this);
        this.pageTitleModel.registerChildren((ContainerViewBase)this);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        if (name.equals(PAGE_TITLE)) {
            return new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.pageTitleModel, name);
        }
        if (name.equals(ALERT)) {
            return new CCAlertInline((ContainerView)this, name, null);
        }
        if (name.equals(DUMP_VIEW)) {
            return new ApplyCriteriaToFileSystemDumpView((View)this, name);
        }
        if (name.equals(FS_TABLE)) {
            return new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.fsTableModel, name);
        }
        if (this.fsTableModel.isChildSupported(name)) {
            return this.fsTableModel.createChild((View)this, name);
        }
        if (this.pageTitleModel.isChildSupported(name)) {
            return this.pageTitleModel.createChild((View)this, name);
        }
        if (super.isChildSupported(name)) {
            return super.createChild(name);
        }
        if (name.equals(DUMP_ON) || name.equals(FILENAMES) || name.equals(ERROR_MESSAGES) || name.equals(SELECTED_FS) || name.equals(ERROR_FS)) {
            return new CCHiddenField((ContainerView)this, name, null);
        }
        throw new IllegalArgumentException("invalid child '" + name + "'");
    }

    private String parseRequestParameters(int index) {
        String psAttributes = RequestManager.getRequestContext().getRequest().getParameter("psAttributes");
        String[] parameters = psAttributes.split("-_-");
        this.setPageSessionAttribute("SERVER_NAME", (Serializable)((Object)parameters[0]));
        this.setPageSessionAttribute("SAMQFS_POLICY_NAME", (Serializable)((Object)parameters[1]));
        Integer ci = new Integer(parameters[2]);
        this.setPageSessionAttribute("SAMQFS_criteria_number", ci);
        return parameters[index];
    }

    public String getPolicyName() {
        String policyName = (String)this.getPageSessionAttribute("SAMQFS_POLICY_NAME");
        if (policyName == null) {
            policyName = this.parseRequestParameters(1);
        }
        return policyName;
    }

    public int getCriteriaNumber() {
        Integer criteriaNumber = (Integer)this.getPageSessionAttribute("SAMQFS_criteria_number");
        if (criteriaNumber == null) {
            criteriaNumber = new Integer(this.parseRequestParameters(2));
        }
        return criteriaNumber;
    }

    public boolean isDumpOn() {
        Boolean dump = (Boolean)this.getPageSessionAttribute(DUMP_PARAMETERS);
        if (dump == null) {
            String serverName = this.getServerName();
            try {
                SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
                dump = appModel.isDumpOn();
                this.setPageSessionAttribute(DUMP_PARAMETERS, dump);
            }
            catch (SamFSException sfe) {
                SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "isDumpOn", "unable to get the application model", serverName);
            }
        }
        return dump;
    }

    public void beginDisplay(DisplayEvent evt) throws ModelControlException {
        TraceUtil.trace3("Entering");
        super.beginDisplay(evt);
        this.initializeTableHeaders();
        this.populateFSTableModel();
        if (this.isDumpOn()) {
            CCHiddenField dumpField = (CCHiddenField)this.getChild(DUMP_ON);
            dumpField.setValue((Object)"true");
        }
        ((CCHiddenField)this.getChild(ERROR_FS)).setValue((Object)SamUtil.getResourceString("archiving.applycriteria.nofs"));
        TraceUtil.trace3("Exiting");
    }

    private void createFSTableModel() {
        this.fsTableModel = new CCActionTableModel(RequestManager.getRequestContext().getServletContext(), "/jsp/archive/ApplyCriteriaToFileSystemTable.xml");
        this.fsTableModel.setSelectionType("multiple");
    }

    private void createPageTitleModel() {
        this.pageTitleModel = new CCPageTitleModel(RequestManager.getRequestContext().getServletContext(), "/jsp/archive/ApplyCriteriaToFileSystemPageTitle.xml");
    }

    private void populateFSTableModel() {
        CCActionTable table = (CCActionTable)this.getChild(FS_TABLE);
        CCActionTableModel tableModel = (CCActionTableModel)table.getModel();
        tableModel.clear();
        ArrayList list = this.getAssignableFileSystems();
        NonSyncStringBuffer buffer = new NonSyncStringBuffer();
        if (list != null) {
            Iterator it = list.iterator();
            int counter = 0;
            while (it.hasNext()) {
                if (counter > 0) {
                    tableModel.appendRow();
                }
                FileSystem fs2 = (FileSystem)it.next();
                tableModel.setValue("fsname", (Object)fs2.getName());
                tableModel.setValue(FS_NAME, (Object)fs2.getName());
                tableModel.setValue("mountpoint", (Object)fs2.getMountPoint());
                ((CCCheckBox)table.getChild("SelectionCheckbox" + counter++)).setTitle("");
                buffer.append(fs2.getName()).append(";");
            }
        }
        ((CCHiddenField)this.getChild(FILENAMES)).setValue((Object)buffer.toString());
        table.setModel((CCActionTableModelInterface)tableModel);
    }

    private void initializeTableHeaders() {
        this.fsTableModel.setActionValue("fsnamecol", (Object)"archiving.fs.name");
        this.fsTableModel.setActionValue("mountpointcol", (Object)"archiving.fs.mountpoint");
    }

    private ArrayList getAssignableFileSystems() {
        ArrayList<FileSystem> assignableFSList = new ArrayList<FileSystem>();
        String serverName = this.getServerName();
        int index = -1;
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            String policyName = this.getPolicyName();
            ArchivePolicy policy = sysModel.getSamQFSSystemArchiveManager43().getArchivePolicy(policyName);
            index = this.getCriteriaNumber();
            ArchivePolCriteria criteria = policy.getArchivePolCriteria(index);
            FileSystem[] criteriaFS = criteria.getFileSystemsForCriteria();
            FileSystem[] allFS = sysModel.getSamQFSSystemFSManager().getAllFileSystems(2);
            for (int i = 0; i < allFS.length; ++i) {
                String allfs_name = allFS[i].getName();
                boolean found = false;
                for (int j = 0; j < criteriaFS.length && !found; ++j) {
                    if (!allfs_name.equals(criteriaFS[j].getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                assignableFSList.add(allFS[i]);
            }
            assignableFSList.trimToSize();
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "getAssibleFileSystems", "Unable to retrieve files systems", serverName);
            String cis = SamUtil.getResourceString("archiving.criterianumber", new String[]{Integer.toString(index)});
            SamUtil.setErrorAlert((ContainerView)this, ALERT, SamUtil.getResourceString("archiving.criteria.fsload.failure", new String[]{cis}), sfe.getSAMerrno(), sfe.getMessage(), serverName);
        }
        return assignableFSList;
    }

    public void handleSubmitRequest(RequestInvocationEvent rie) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        String serverName = this.getServerName();
        String policyName = this.getPolicyName();
        int criteriaIndex = this.getCriteriaNumber();
        ContainerViewBase dumpView = (ContainerViewBase)this.getChild(DUMP_VIEW);
        String dumpPath = dumpView.getDisplayFieldStringValue(DUMP_PATH);
        boolean isDumpOn = "save".equals(dumpView.getDisplayFieldStringValue(DUMP_RADIO));
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            if (isDumpOn && dumpPath != null) {
                sysModel.setDumpPath(dumpPath);
            }
            ArchivePolicy thePolicy = sysModel.getSamQFSSystemArchiveManager43().getArchivePolicy(policyName);
            ArchivePolCriteria theCriteria = thePolicy.getArchivePolCriteria(criteriaIndex);
            String[] fs_names = this.getDisplayFieldStringValue(SELECTED_FS).split(";");
            SamFSWarnings warning = null;
            for (int i = 0; i < fs_names.length; ++i) {
                try {
                    FileSystem fs2 = sysModel.getSamQFSSystemFSManager().getFileSystem(fs_names[i]);
                    fs2.addPolCriteria(new ArchivePolCriteria[]{theCriteria});
                    continue;
                }
                catch (SamFSWarnings sfw) {
                    if (warning != null) continue;
                    warning = sfw;
                }
            }
            if (warning != null) {
                throw warning;
            }
            SamUtil.setInfoAlert((ContainerView)this, ALERT, "success.summary", "archiving.applycriteriatofs.success", serverName);
            this.setSubmitSuccessful(true);
        }
        catch (SamFSWarnings sfw) {
            this.setSubmitSuccessful(true);
            SamUtil.processException((Exception)((Object)sfw), ((Object)((Object)this)).getClass(), "handleSubmitRequest", "ArchveConfig.warning", serverName);
            SamUtil.setWarningAlert((ContainerView)this, ALERT, "ArchiveConfig.info.saved", "ArchiveConfig.warning.detail");
        }
        catch (SamFSMultiMsgException smme) {
            SamUtil.processException((Exception)((Object)smme), ((Object)((Object)this)).getClass(), "handleSubmitRequest", "ArchiveConfig.error", serverName);
            SamUtil.setErrorAlert((ContainerView)this, ALERT, "PolFileSystem.error.failedAddFs", smme.getSAMerrno(), smme.getMessage(), serverName);
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "handleSubmitRequest", "ArchiveConfig.error", serverName);
            SamUtil.setErrorAlert((ContainerView)this, ALERT, "PolFileSystem.error.failedAddFs", sfe.getSAMerrno(), sfe.getMessage(), serverName);
        }
        this.forwardTo();
        TraceUtil.trace3("Exiting");
    }

    protected int getCriteriaIndex() {
        String ci = (String)this.getPageSessionAttribute("SAMQFS_criteria_number");
        if (ci == null) {
            ci = RequestManager.getRequest().getParameter("SAMQFS_criteria_number");
            this.setPageSessionAttribute("SAMQFS_criteria_number", (Serializable)((Object)ci));
        }
        return Integer.parseInt(ci);
    }

    public String getServerName() {
        return super.getServerName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

