/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.alarms;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.alarm.Alarm;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.util.FormattedDate;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.alarm.CCAlarmObject;
import java.util.ArrayList;
import java.util.GregorianCalendar;

public final class CurrentAlarmSummaryModel
extends CCActionTableModel {
    private String selectedFault = null;
    private ArrayList latestRows;

    public CurrentAlarmSummaryModel() {
        super(RequestManager.getRequestContext().getServletContext(), "/jsp/alarms/CurrentAlarmSummaryTable.xml");
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.initActionButtons();
        this.initHeaders();
        this.initProductName();
        this.initFilterMenu();
        this.initSortingCriteria();
        TraceUtil.trace3("Exiting");
    }

    private void initSortingCriteria() {
        TraceUtil.trace3("Entering");
        this.setPrimarySortName("TimeText");
        this.setPrimarySortOrder("descending");
        this.setSecondarySortName("Alarm");
        this.setSecondarySortOrder("descending");
    }

    private void initActionButtons() {
        TraceUtil.trace3("Entering");
        this.setActionValue("AcknowledgeButton", "alarm.button.ack");
        this.setActionValue("DeleteButton", "alarm.button.delete");
        TraceUtil.trace3("Exiting");
    }

    private void initHeaders() {
        TraceUtil.trace3("Entering");
        this.setActionValue("IDColumn", "alarm.heading.id");
        this.setActionValue("SeverityColumn", "alarm.heading.severity");
        this.setActionValue("TimeColumn", "alarm.heading.time");
        this.setActionValue("DeviceColumn", "alarm.heading.device");
        this.setActionValue("StateColumn", "alarm.heading.state");
        this.setActionValue("DescriptionColumn", "alarm.heading.desc");
        TraceUtil.trace3("Exiting");
    }

    private void initProductName() {
        TraceUtil.trace3("Entering");
        this.setProductNameAlt("secondaryMasthead.productNameAlt");
        this.setProductNameSrc("secondaryMasthead.productNameSrc");
        this.setProductNameHeight("20");
        this.setProductNameWidth("170");
        TraceUtil.trace3("Exiting");
    }

    private void initFilterMenu() {
        TraceUtil.trace3("Entering");
        this.setActionValue("FilterMenu", "alarm.filterOptions.header");
        TraceUtil.trace3("Exiting");
    }

    public void initModelRows(String serverName) throws SamFSException {
        TraceUtil.trace3("Entering");
        this.clear();
        this.latestRows = new ArrayList();
        SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
        Alarm[] allAlarms = sysModel.getSamQFSSystemAlarmManager().getAllAlarms();
        if (allAlarms == null) {
            return;
        }
        String severity = null;
        String description = null;
        String state = null;
        String device = null;
        Object timeString = null;
        GregorianCalendar time = null;
        Library myLibrary = null;
        long alarmID = -1L;
        for (int i = 0; i < allAlarms.length; ++i) {
            switch (allAlarms[i].getSeverity()) {
                case 0: {
                    severity = "CRITICAL";
                    break;
                }
                case 1: {
                    severity = "MAJOR";
                    break;
                }
                case 2: {
                    severity = "MINOR";
                    break;
                }
                default: {
                    severity = "";
                }
            }
            if (!this.selectedFault.equals(severity) && !this.selectedFault.equals("ALL")) continue;
            description = allAlarms[i].getDescription();
            time = allAlarms[i].getDateTimeGenerated();
            myLibrary = allAlarms[i].getAssociatedLibrary();
            device = myLibrary != null ? myLibrary.getName() : "";
            switch (allAlarms[i].getStatus()) {
                case 3: {
                    state = "alarm.status.active";
                    break;
                }
                case 4: {
                    state = "alarm.status.ack";
                }
            }
            alarmID = allAlarms[i].getAlarmID();
            this.latestRows.add(new Integer(i));
            if (i > 0) {
                this.appendRow();
            }
            this.setValue("IDText", Long.toString(alarmID));
            if (time != null) {
                FormattedDate date = new FormattedDate(time, SamUtil.getTimeFormat());
                this.setValue("TimeText", date);
            } else {
                this.setValue("TimeText", "");
            }
            this.setValue("DeviceText", device);
            this.setValue("StateText", state);
            this.setValue("DescriptionText", description.replaceAll("\n", "<br>"));
            this.setValue("IDHidden", Long.toString(alarmID));
            this.setValue("DevHref", device);
            if (severity.equals("CRITICAL")) {
                this.setValue("SeverityText", "alarm.filterOptions.critical");
                this.setValue("Alarm", new CCAlarmObject(2));
                continue;
            }
            if (severity.equals("MAJOR")) {
                this.setValue("SeverityText", "alarm.filterOptions.major");
                this.setValue("Alarm", new CCAlarmObject(3));
                continue;
            }
            if (severity.equals("MINOR")) {
                this.setValue("SeverityText", "alarm.filterOptions.minor");
                this.setValue("Alarm", new CCAlarmObject(4));
                continue;
            }
            this.setValue("SeverityText", "");
            this.setValue("Alarm", new CCAlarmObject(5));
        }
        TraceUtil.trace3("Exiting");
    }

    public void setFilter(String selectedType) {
        TraceUtil.trace3("Entering");
        this.selectedFault = selectedType;
        TraceUtil.trace3("Exiting");
    }

    public ArrayList getLatestIndex() {
        TraceUtil.trace3("Entering");
        TraceUtil.trace3("Exiting");
        return this.latestRows;
    }
}

