/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.admin;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.media.MediaUtil;
import com.sun.netstorage.samqfs.web.model.ClusterNodeInfo;
import com.sun.netstorage.samqfs.web.model.ConfigStatus;
import com.sun.netstorage.samqfs.web.model.DaemonInfo;
import com.sun.netstorage.samqfs.web.model.LogAndTraceInfo;
import com.sun.netstorage.samqfs.web.model.PkgInfo;
import com.sun.netstorage.samqfs.web.model.SamExplorerOutputs;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.SystemInfo;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.server.ServerUtil;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.Capacity;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.FormattedDate;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.PropertySheetUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.SecurityManagerFactory;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.html.CCButton;

public class ServerConfigurationViewBean
extends CommonViewBeanBase {
    private static final String PAGE_NAME = "ServerConfiguration";
    private static final String DEFAULT_DISPLAY_URL = "/jsp/admin/ServerConfiguration.jsp";
    private static final int TAB_NAME = 21;
    public static final String CHILD_ALERT = "Alert";
    private static CCPageTitleModel pageTitleModel = null;
    private static CCPropertySheetModel propertySheetModel = null;
    private static CCActionTableModel logTraceTable = null;
    private static CCActionTableModel packagesTable = null;
    private static CCActionTableModel configTable = null;
    private static CCActionTableModel daemonsTable = null;
    private static CCActionTableModel clusterTable = null;
    private static CCActionTableModel explorerTable = null;
    static /* synthetic */ Class class$com$sun$web$ui$view$alert$CCAlertInline;

    public ServerConfigurationViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL, 21);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        pageTitleModel = this.createPageTitleModel();
        propertySheetModel = this.createPropertySheetModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren();
        this.registerChild(CHILD_ALERT, class$com$sun$web$ui$view$alert$CCAlertInline == null ? (class$com$sun$web$ui$view$alert$CCAlertInline = ServerConfigurationViewBean.class$("com.sun.web.ui.view.alert.CCAlertInline")) : class$com$sun$web$ui$view$alert$CCAlertInline);
        PageTitleUtil.registerChildren((ContainerViewBase)this, pageTitleModel);
        PropertySheetUtil.registerChildren((ContainerViewBase)this, propertySheetModel);
        TraceUtil.trace3("Exiting");
    }

    protected View createChild(String name) {
        TraceUtil.trace3(new NonSyncStringBuffer("Entering: name is ").append(name).toString());
        View child = null;
        if (super.isChildSupported(name)) {
            child = super.createChild(name);
        } else if (name.equals(CHILD_ALERT)) {
            child = new CCAlertInline((ContainerView)this, name, null);
        } else if (PropertySheetUtil.isChildSupported(propertySheetModel, name)) {
            child = PropertySheetUtil.createChild((ContainerView)this, propertySheetModel, name);
        } else if (PageTitleUtil.isChildSupported(pageTitleModel, name)) {
            child = PageTitleUtil.createChild((ContainerView)this, pageTitleModel, name);
        } else {
            throw new IllegalArgumentException("Invalid child name [" + name + "]");
        }
        TraceUtil.trace3("Exiting");
        return child;
    }

    private CCPageTitleModel createPageTitleModel() {
        TraceUtil.trace3("Entering");
        if (pageTitleModel == null) {
            pageTitleModel = new CCPageTitleModel(SamUtil.createBlankPageTitleXML());
        }
        TraceUtil.trace3("Exiting");
        return pageTitleModel;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        this.loadPropertySheetModel(propertySheetModel);
        this.loadTableModels();
        this.loadMediaString();
        TraceUtil.trace3("Exiting");
    }

    private CCPropertySheetModel createPropertySheetModel() {
        TraceUtil.trace3("Entering");
        if (propertySheetModel == null) {
            propertySheetModel = PropertySheetUtil.createModel("/jsp/admin/ServerConfigurationPropertySheet.xml");
            clusterTable = new CCActionTableModel(RequestManager.getRequestContext().getServletContext(), "/jsp/admin/ClusterTable.xml");
            logTraceTable = new CCActionTableModel(RequestManager.getRequestContext().getServletContext(), "/jsp/admin/LogTraceTable.xml");
            packagesTable = new CCActionTableModel(RequestManager.getRequestContext().getServletContext(), "/jsp/admin/PackagesTable.xml");
            daemonsTable = new CCActionTableModel(RequestManager.getRequestContext().getServletContext(), "/jsp/admin/DaemonsTable.xml");
            configTable = new CCActionTableModel(RequestManager.getRequestContext().getServletContext(), "/jsp/admin/ConfigTable.xml");
            explorerTable = new CCActionTableModel(RequestManager.getRequestContext().getServletContext(), "/jsp/admin/ExplorerTable.xml");
            propertySheetModel.setModel("clusterTable", (Object)clusterTable);
            propertySheetModel.setModel("logTraceTable", (Object)logTraceTable);
            propertySheetModel.setModel("packagesTable", (Object)packagesTable);
            propertySheetModel.setModel("daemonsTable", (Object)daemonsTable);
            propertySheetModel.setModel("configTable", (Object)configTable);
            propertySheetModel.setModel("explorerTable", (Object)explorerTable);
        }
        TraceUtil.trace3("Exiting");
        return propertySheetModel;
    }

    private void loadTableModels() {
        TraceUtil.trace3("Entering");
        this.loadClusterTable(clusterTable);
        this.loadPackagesTable(packagesTable);
        this.loadDaemonsTable(daemonsTable);
        this.loadConfigTable(configTable);
        this.loadLogAndTraceTable(logTraceTable);
        this.loadExplorerTable(explorerTable);
        TraceUtil.trace3("Exiting");
    }

    private void loadClusterTable(CCActionTableModel actionTableModel) {
        TraceUtil.trace3("Entering");
        if (actionTableModel == null) {
            return;
        }
        actionTableModel.clear();
        actionTableModel.setActionValue("NodeNameColumn", (Object)"ServerConfiguration.cluster.name");
        actionTableModel.setActionValue("NodeIDColumn", (Object)"ServerConfiguration.cluster.id");
        actionTableModel.setActionValue("NodeStatusColumn", (Object)"ServerConfiguration.cluster.status");
        actionTableModel.setActionValue("NodePrivateIPColumn", (Object)"ServerConfiguration.cluster.privateip");
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            String samfsServerAPIVersion = SamUtil.getServerInfo(this.getServerName()).getSamfsServerAPIVersion();
            if (!SamUtil.isVersionCurrentOrLaterThan(samfsServerAPIVersion, "1.4")) {
                propertySheetModel.setVisible("cluster", false);
            } else if (!sysModel.isClusterNode()) {
                propertySheetModel.setVisible("cluster", false);
            } else {
                propertySheetModel.setVisible("cluster", true);
                ClusterNodeInfo[] nodeInfos = sysModel.getClusterNodes();
                for (int i = 0; i < nodeInfos.length; ++i) {
                    if (i > 0) {
                        actionTableModel.appendRow();
                    }
                    actionTableModel.setValue("NodeNameText", (Object)nodeInfos[i].getName());
                    actionTableModel.setValue("NodeIDText", (Object)new Integer(nodeInfos[i].getID()));
                    actionTableModel.setValue("NodeStatusText", (Object)nodeInfos[i].getStatus());
                    actionTableModel.setValue("NodePrivateIPText", (Object)nodeInfos[i].getPrivIP());
                }
            }
        }
        catch (Exception ex) {
            TraceUtil.trace1("Failed to retrieve cluster node information.");
            TraceUtil.trace1("Cause: " + ex.getMessage());
            SamUtil.processException(ex, ((Object)((Object)this)).getClass(), "loadClusterTable()", "Failed to populate cluster node information", this.getServerName());
            actionTableModel.setEmpty("ServerConfiguration.cluster.failed");
        }
        TraceUtil.trace3("Exiting");
    }

    private void loadLogAndTraceTable(CCActionTableModel actionTableModel) {
        TraceUtil.trace3("Entering");
        if (actionTableModel == null) {
            return;
        }
        actionTableModel.clear();
        actionTableModel.setActionValue("LogTraceNameColumn", (Object)"ServerConfiguration.logtrace.name");
        actionTableModel.setActionValue("LogTraceTypeColumn", (Object)"ServerConfiguration.logtrace.type");
        actionTableModel.setActionValue("LogTraceStatusColumn", (Object)"ServerConfiguration.logtrace.status");
        actionTableModel.setActionValue("LogTracePathColumn", (Object)"ServerConfiguration.logtrace.path");
        actionTableModel.setActionValue("LogTraceFlagsColumn", (Object)"ServerConfiguration.logtrace.flags");
        actionTableModel.setActionValue("LogTraceSizeColumn", (Object)"ServerConfiguration.logtrace.size");
        actionTableModel.setActionValue("LogTraceModTimeColumn", (Object)"ServerConfiguration.logtrace.modTime");
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            LogAndTraceInfo[] myLogAndTraceArray = sysModel.getLogAndTraceInfo();
            if (myLogAndTraceArray == null) {
                return;
            }
            for (int i = 0; i < myLogAndTraceArray.length; ++i) {
                if (i != 0) {
                    actionTableModel.appendRow();
                }
                actionTableModel.setValue("LogTraceNameText", (Object)myLogAndTraceArray[i].getName());
                actionTableModel.setValue("LogTraceTypeText", (Object)myLogAndTraceArray[i].getType());
                boolean isLogTraceOn = myLogAndTraceArray[i].isOn();
                if (isLogTraceOn) {
                    actionTableModel.setValue("LogTraceStatusText", (Object)SamUtil.getResourceString("ServerConfiguration.logtrace.on"));
                    actionTableModel.setValue("LogTracePathText", (Object)myLogAndTraceArray[i].getPath());
                    actionTableModel.setValue("PathHref", (Object)myLogAndTraceArray[i].getPath());
                    actionTableModel.setValue("LogTraceFlagText", (Object)myLogAndTraceArray[i].getFlags());
                    actionTableModel.setValue("LogTraceSizeText", (Object)Capacity.newCapacity(myLogAndTraceArray[i].getSize(), 0).toString());
                    actionTableModel.setValue("LogTraceModTimeText", (Object)new FormattedDate(myLogAndTraceArray[i].getModtime(), SamUtil.getTimeFormat()));
                    continue;
                }
                actionTableModel.setValue("LogTraceStatusText", (Object)SamUtil.getResourceString("ServerConfiguration.logtrace.off"));
                actionTableModel.setValue("LogTracePathText", (Object)"");
                actionTableModel.setValue("PathHref", (Object)"");
                actionTableModel.setValue("LogTraceFlagText", (Object)"");
                actionTableModel.setValue("LogTraceSizeText", (Object)"");
                actionTableModel.setValue("LogTraceModTimeText", (Object)"");
            }
        }
        catch (Exception ex) {
            TraceUtil.trace1("Failed to retrieve Log/Trace Information.");
            TraceUtil.trace1("Cause: " + ex.getMessage());
            SamUtil.processException(ex, ((Object)((Object)this)).getClass(), "loadLogAndTraceTable()", "Failed to populate log and trace files information", this.getServerName());
            actionTableModel.setEmpty("ServerConfiguration.logtrace.failed");
        }
        TraceUtil.trace3("Exiting");
    }

    private void loadPackagesTable(CCActionTableModel actionTableModel) {
        TraceUtil.trace3("Entering");
        if (actionTableModel == null) {
            return;
        }
        actionTableModel.clear();
        actionTableModel.setActionValue("PackageNameColumn", (Object)"ServerConfiguration.packages.name");
        actionTableModel.setActionValue("PackageDescColumn", (Object)"ServerConfiguration.packages.desc");
        actionTableModel.setActionValue("PackageVersionColumn", (Object)"ServerConfiguration.packages.version");
        actionTableModel.setActionValue("PackageStatusColumn", (Object)"ServerConfiguration.packages.status");
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            PkgInfo[] myPkgInfoArray = sysModel.getPkgInfo();
            if (myPkgInfoArray == null) {
                return;
            }
            for (int i = 0; i < myPkgInfoArray.length; ++i) {
                if (i != 0) {
                    actionTableModel.appendRow();
                }
                actionTableModel.setValue("PackageNameText", (Object)myPkgInfoArray[i].getPKGINST());
                actionTableModel.setValue("PackageDescText", (Object)myPkgInfoArray[i].getNAME());
                actionTableModel.setValue("PackageVersionText", (Object)myPkgInfoArray[i].getVERSION());
                actionTableModel.setValue("PackageStatusText", (Object)this.getStatusString(myPkgInfoArray[i].getSTATUS()));
            }
        }
        catch (Exception ex) {
            TraceUtil.trace1("Failed to retrieve packages Information.");
            TraceUtil.trace1("Cause: " + ex.getMessage());
            SamUtil.processException(ex, ((Object)((Object)this)).getClass(), "loadPackagesTable()", "Failed to populate packages information", this.getServerName());
            actionTableModel.setEmpty("ServerConfiguration.packages.failed");
        }
        TraceUtil.trace3("Exiting");
    }

    private void loadDaemonsTable(CCActionTableModel actionTableModel) {
        TraceUtil.trace3("Entering");
        if (actionTableModel == null) {
            return;
        }
        actionTableModel.clear();
        actionTableModel.setActionValue("DaemonDescColumn", (Object)"ServerConfiguration.daemons.desc");
        actionTableModel.setActionValue("DaemonNameColumn", (Object)"ServerConfiguration.daemons.name");
        actionTableModel.setActionValue("BlankColumn", (Object)"                                                 ");
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            DaemonInfo[] myInfoArray = sysModel.getDaemonInfo();
            if (myInfoArray == null) {
                return;
            }
            for (int i = 0; i < myInfoArray.length; ++i) {
                if (i != 0) {
                    actionTableModel.appendRow();
                }
                actionTableModel.setValue("BlankText", (Object)"                                                        ");
                actionTableModel.setValue("DaemonDescText", (Object)myInfoArray[i].getDescr());
                actionTableModel.setValue("DaemonNameText", (Object)myInfoArray[i].getName());
            }
        }
        catch (Exception ex) {
            TraceUtil.trace1("Failed to retrieve running daemons information.");
            TraceUtil.trace1("Cause: " + ex.getMessage());
            SamUtil.processException(ex, ((Object)((Object)this)).getClass(), "loadDaemonsTable()", "Failed to populate daemons information", this.getServerName());
            actionTableModel.setEmpty("ServerConfiguration.daemons.failed");
        }
        TraceUtil.trace3("Exiting");
    }

    private void loadConfigTable(CCActionTableModel actionTableModel) {
        TraceUtil.trace3("Entering");
        if (actionTableModel == null) {
            return;
        }
        actionTableModel.clear();
        actionTableModel.setActionValue("ConfigNameColumn", (Object)"ServerConfiguration.config.name");
        actionTableModel.setActionValue("ConfigStatusColumn", (Object)"ServerConfiguration.config.status");
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            ConfigStatus[] myInfoArray = sysModel.getConfigStatus();
            if (myInfoArray == null) {
                return;
            }
            for (int i = 0; i < myInfoArray.length; ++i) {
                if (i != 0) {
                    actionTableModel.appendRow();
                }
                actionTableModel.setValue("BlankText", (Object)"                                                        ");
                actionTableModel.setValue("ConfigNameText", (Object)myInfoArray[i].getConfig());
                actionTableModel.setValue("FileHref", (Object)myInfoArray[i].getConfig());
                String status = myInfoArray[i].getStatus();
                status = status == null ? "" : status.trim();
                String content = myInfoArray[i].getMsg();
                if (content != null && content.length() != 0) {
                    actionTableModel.setValue("ConfigStatusTextWithLink", (Object)myInfoArray[i].getStatus());
                    actionTableModel.setValue("ConfigStatusText", (Object)"");
                    actionTableModel.setValue("StatusHref", (Object)myInfoArray[i].getConfig());
                    continue;
                }
                actionTableModel.setValue("ConfigStatusText", (Object)myInfoArray[i].getStatus());
                actionTableModel.setValue("ConfigStatusTextWithLink", (Object)"");
                actionTableModel.setValue("StatusHref", (Object)"");
            }
        }
        catch (Exception ex) {
            TraceUtil.trace1("Failed to retrieve configuration files information.");
            TraceUtil.trace1("Cause: " + ex.getMessage());
            SamUtil.processException(ex, ((Object)((Object)this)).getClass(), "loadConfigTable()", "Failed to populate configuration files information", this.getServerName());
            actionTableModel.setEmpty("ServerConfiguration.config.failed");
        }
        TraceUtil.trace3("Exiting");
    }

    private void loadExplorerTable(CCActionTableModel actionTableModel) {
        TraceUtil.trace3("Entering");
        if (actionTableModel == null) {
            return;
        }
        ((CCButton)this.getChild("GenerateButton")).setDisabled(!SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.SAM_CONTROL));
        actionTableModel.clear();
        actionTableModel.setActionValue("ReportPathColumn", (Object)"ServerConfiguration.explorer.path");
        actionTableModel.setActionValue("ReportNameColumn", (Object)"ServerConfiguration.explorer.name");
        actionTableModel.setActionValue("ReportSizeColumn", (Object)"ServerConfiguration.explorer.size");
        actionTableModel.setActionValue("ReportCreateTimeColumn", (Object)"ServerConfiguration.explorer.createtime");
        actionTableModel.setActionValue("ReportModTimeColumn", (Object)"ServerConfiguration.explorer.modtime");
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            String samfsServerAPIVersion = SamUtil.getServerInfo(this.getServerName()).getSamfsServerAPIVersion();
            if (!SamUtil.isVersionCurrentOrLaterThan(samfsServerAPIVersion, "1.4")) {
                propertySheetModel.setVisible("explorer", false);
            } else {
                propertySheetModel.setVisible("explorer", true);
                SamExplorerOutputs[] outputs = sysModel.getSamExplorerOutputs();
                for (int i = 0; i < outputs.length; ++i) {
                    if (i > 0) {
                        actionTableModel.appendRow();
                    }
                    actionTableModel.setValue("ReportPathText", (Object)outputs[i].getPath());
                    actionTableModel.setValue("ReportNameText", (Object)outputs[i].getName());
                    actionTableModel.setValue("ReportPathHref", (Object)new NonSyncStringBuffer(outputs[i].getPath()).append("/").append(outputs[i].getName()).toString());
                    actionTableModel.setValue("ReportSizeText", (Object)Capacity.newCapacity(outputs[i].getSize(), 0).toString());
                    actionTableModel.setValue("ReportCreateTimeText", (Object)new FormattedDate(outputs[i].getCreatedTime(), SamUtil.getTimeFormat()));
                    actionTableModel.setValue("ReportModTimeText", (Object)new FormattedDate(outputs[i].getModifiedTime(), SamUtil.getTimeFormat()));
                }
            }
        }
        catch (Exception ex) {
            TraceUtil.trace1("Failed to retrieve SAM Explorer information.");
            TraceUtil.trace1("Cause: " + ex.getMessage());
            SamUtil.processException(ex, ((Object)((Object)this)).getClass(), "loadExplorerTable()", "Failed to populate SAM explorer information", this.getServerName());
            actionTableModel.setEmpty("ServerConfiguration.explorer.failed");
        }
        TraceUtil.trace3("Exiting");
    }

    private void loadPropertySheetModel(CCPropertySheetModel propertySheetModel) {
        TraceUtil.trace3("Entering");
        propertySheetModel.clear();
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            SystemInfo mySystemInfo = sysModel.getSystemInfo();
            propertySheetModel.setValue("NameValue", (Object)mySystemInfo.getHostname());
            propertySheetModel.setValue("IDValue", (Object)mySystemInfo.getHostid());
            propertySheetModel.setValue("OSValue", (Object)ServerUtil.createOSString(mySystemInfo.getOSname(), mySystemInfo.getRelease(), mySystemInfo.getVersion()));
            propertySheetModel.setValue("MachineValue", (Object)mySystemInfo.getMachine());
            propertySheetModel.setValue("CPUValue", (Object)Integer.toString(mySystemInfo.getCPUs()));
            propertySheetModel.setValue("MemoryValue", (Object)new Capacity(mySystemInfo.getMemoryMB(), 2).toString());
            propertySheetModel.setValue("ArchValue", (Object)SamUtil.swapArchString(mySystemInfo.getArchitecture()));
            propertySheetModel.setValue("IPAddressValue", (Object)this.createIPAddressString(mySystemInfo.getIPAddresses()));
        }
        catch (SamFSException samEx) {
            this.resetAllFieldsToBlank();
            TraceUtil.trace1("Failed to retrieve server basic information.");
            TraceUtil.trace1("Cause: " + samEx.getMessage());
            SamUtil.processException((Exception)((Object)samEx), ((Object)((Object)this)).getClass(), "loadPropertySheet", "Failed to retrieve system information", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), CHILD_ALERT, "ServerConfiguration.error", samEx.getSAMerrno(), samEx.getMessage(), this.getServerName());
        }
        TraceUtil.trace3("Exiting");
    }

    private void loadMediaString() {
        TraceUtil.trace3("Entering");
        NonSyncStringBuffer allMediaStringBuf = new NonSyncStringBuffer();
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            Library[] allLibraries = sysModel.getSamQFSSystemMediaManager().getAllLibraries();
            if (allLibraries == null || allLibraries.length == 0) {
                propertySheetModel.setVisible("media", false);
                return;
            }
            propertySheetModel.setVisible("media", true);
            for (int i = 0; i < allLibraries.length; ++i) {
                if (allMediaStringBuf.length() != 0) {
                    allMediaStringBuf.append("<br /><br />");
                }
                if (allLibraries[i].getName().equals("Historian") || allLibraries[i].getName().equals("historian")) continue;
                allMediaStringBuf.append(MediaUtil.createLibraryEntry(allLibraries[i]));
            }
        }
        catch (SamFSException samEx) {
            TraceUtil.trace1("Failed to retrieve media information.");
            TraceUtil.trace1("Cause: " + samEx.getMessage());
            SamUtil.processException((Exception)((Object)samEx), ((Object)((Object)this)).getClass(), "loadMediaString", "Failed to retrieve media device information", this.getServerName());
            propertySheetModel.setValue("MediaText", (Object)SamUtil.getResourceString("ServerConfiguration.media.failed"));
            return;
        }
        if (allMediaStringBuf.length() != 0) {
            propertySheetModel.setValue("MediaText", (Object)allMediaStringBuf.toString());
        }
        TraceUtil.trace3("Exiting");
    }

    private String createIPAddressString(String origIPAddressString) {
        NonSyncStringBuffer buf = new NonSyncStringBuffer();
        String[] ipArray = origIPAddressString.split(" ");
        for (int i = 0; i < ipArray.length; ++i) {
            if (i > 0) {
                buf.append("<br />");
            }
            buf.append(ipArray[i]);
        }
        return buf.toString();
    }

    private String getStatusString(String statusNumberString) {
        try {
            int status = Integer.parseInt(statusNumberString);
            if (status >= 0 && status <= 4) {
                return SamUtil.getResourceString(new NonSyncStringBuffer("ServerConfiguration.packages.").append(status).toString());
            }
        }
        catch (NumberFormatException numEx) {
            TraceUtil.trace1("NumberFormatException while parsing status of packages!");
        }
        return SamUtil.getResourceString("ServerConfiguration.packages.error");
    }

    private void resetAllFieldsToBlank() {
        propertySheetModel.setValue("NameValue", (Object)"");
        propertySheetModel.setValue("IDValue", (Object)"");
        propertySheetModel.setValue("OSValue", (Object)"");
        propertySheetModel.setValue("MachineValue", (Object)"");
        propertySheetModel.setValue("CPUValue", (Object)"");
        propertySheetModel.setValue("MemoryValue", (Object)"");
        propertySheetModel.setValue("ArchValue", (Object)"");
        propertySheetModel.setValue("IPAddressValue", (Object)"");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

