/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.admin;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.admin.Notification;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.ArrayList;

public final class AdminNotificationModel
extends CCActionTableModel {
    protected String[][] subscriptions;

    public AdminNotificationModel(String xmlSchema) {
        super(RequestManager.getRequestContext().getServletContext(), xmlSchema);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.createHeader();
        this.initProductName();
        TraceUtil.trace3("Exiting");
    }

    private void createHeader() {
        TraceUtil.trace3("Entering");
        this.setActionValue("NewButton", "AdminNotification.button.new");
        this.setActionValue("EditButton", "AdminNotification.button.edit");
        this.setActionValue("DeleteButton", "AdminNotification.button.delete");
        this.setActionValue("EmailColumn", "AdminNotification.heading.emailAddress");
        this.setActionValue("SubscriptionColumn", "AdminNotification.heading.subscription");
        TraceUtil.trace3("Exiting");
    }

    private void initProductName() {
        TraceUtil.trace3("Entering");
        this.setProductNameAlt("secondaryMasthead.productNameAlt");
        this.setProductNameSrc("secondaryMasthead.productNameSrc");
        this.setProductNameHeight("20");
        this.setProductNameWidth("170");
        TraceUtil.trace3("Exiting");
    }

    public void initModelRows(String serverName) throws SamFSException {
        TraceUtil.trace3("Entering");
        this.clear();
        SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
        Notification[] notis = sysModel.getSamQFSSystemAdminManager().getAllNotifications();
        if (notis == null) {
            return;
        }
        SamUtil.doPrint(new NonSyncStringBuffer("Notifications.length is ").append(notis.length).toString());
        TraceUtil.trace2("Received " + notis.length + " notifications");
        this.subscriptions = new String[notis.length][];
        for (int i = 0; i < notis.length; ++i) {
            String email = notis[i].getEmailAddress();
            ArrayList<String> subscriptionList = new ArrayList<String>();
            if (notis[i].isDeviceDownNotify()) {
                subscriptionList.add("AdminNotification.eventType.deviceDown");
            }
            if (notis[i].isArchiverInterruptNotify()) {
                subscriptionList.add("AdminNotification.eventType.archiverInterrupted");
            }
            if (notis[i].isReqMediaNotify()) {
                subscriptionList.add("AdminNotification.eventType.mediaRequired");
            }
            if (notis[i].isRecycleNotify()) {
                subscriptionList.add("AdminNotification.eventType.recyclerStatus");
            }
            if (notis[i].isDumpInterruptNotify()) {
                subscriptionList.add("AdminNotification.eventType.dumpInterrupted");
            }
            if (notis[i].isFsNospaceNotify()) {
                subscriptionList.add("AdminNotification.eventType.fsNoSpace");
            }
            if (i > 0) {
                this.appendRow();
            }
            this.subscriptions[i] = subscriptionList.toArray(new String[subscriptionList.size()]);
            if (email.charAt(0) == '$') {
                this.setValue("EmailText", email.concat(" (").concat(notis[i].getName()).concat(" )"));
                this.setSelectionVisible(i, false);
            } else {
                this.setValue("EmailText", email);
            }
            this.setValue("AdminHiddenField", email);
            TraceUtil.trace3("Exiting");
        }
    }

    public String[] getSubscriptions(int index) {
        return this.subscriptions[index];
    }
}

