/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.mgmt.stg.job;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.Job;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.stg.job.StagerStream;
import com.sun.netstorage.samqfs.mgmt.stg.job.StgFileInfo;

public class StagerJob
extends Job {
    private StagerStream ss;
    private StgFileInfo crtFileInfo;
    public static final int ST_SORT_BY_FILENAME = 0;
    public static final int ST_SORT_BY_UID = 1;
    public static final int ST_NO_SORT = 2;

    private StagerJob(StagerStream stagerStream) {
        super((short)2, stagerStream.active ? (short)0 : 1, stagerStream.seqNum * 100 + 2);
        this.ss = stagerStream;
    }

    public String getVSN() {
        return this.ss.vsn;
    }

    public String getMediaType() {
        return this.ss.mediaType;
    }

    public long getCreationTime() {
        return this.ss.creationTime;
    }

    public StgFileInfo getCrtFileInfo() {
        return this.ss.crtFileInfo;
    }

    public long getNumberOfFiles(Ctx ctx) throws SamFSException {
        return StagerJob.getNumOfFiles(ctx, this.ss);
    }

    private static native long getNumOfFiles(Ctx var0, StagerStream var1) throws SamFSException;

    public StgFileInfo[] getFilesInfo(Ctx ctx, int n, int n2, short s, boolean bl) throws SamFSException {
        return StagerJob.getFiles(ctx, this.ss, n, n2, s, bl);
    }

    private static native StgFileInfo[] getFiles(Ctx var0, StagerStream var1, int var2, int var3, short var4, boolean var5) throws SamFSException;

    public static StagerJob[] getAll(Ctx ctx) throws SamFSException {
        StagerStream[] stagerStreamArray = StagerStream.getAll(ctx);
        StagerJob[] stagerJobArray = new StagerJob[stagerStreamArray.length];
        for (int i = 0; i < stagerStreamArray.length; ++i) {
            stagerJobArray[i] = new StagerJob(stagerStreamArray[i]);
        }
        return stagerJobArray;
    }

    public void cancel(Ctx ctx) throws SamFSException {
        StagerJob.clearRequest(ctx, this.getMediaType(), this.getVSN());
    }

    public static native void cancelStgForFiles(Ctx var0, String[] var1, boolean var2) throws SamFSException;

    public static native void clearRequest(Ctx var0, String var1, String var2) throws SamFSException;

    public String toString() {
        String string = super.toString() + " " + this.getVSN() + "," + this.getMediaType() + "," + this.getCreationTime() + " " + this.getCrtFileInfo();
        return string;
    }
}

