/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.mgmt.stg;

import com.sun.netstorage.samqfs.mgmt.arc.BufDirective;
import com.sun.netstorage.samqfs.mgmt.arc.DrvDirective;

public class StagerParams {
    private String logPath;
    private int maxActive;
    private int maxRetries;
    private BufDirective[] bufDirs;
    private DrvDirective[] drvDirs;
    private long chgFlags;
    private long options;
    public static final int ST_LOG_START = 1;
    public static final int ST_LOG_ERROR = 2;
    public static final int ST_LOG_CANCEL = 4;
    public static final int ST_LOG_FINISH = 8;
    public static final int ST_LOG_ALL = 16;
    public static final int ST_stage_log = 1;
    public static final int ST_max_active = 2;
    public static final int ST_max_retries = 4;
    public static final int ST_log_events = 8;

    private StagerParams(String string, int n, int n2, BufDirective[] bufDirectiveArray, DrvDirective[] drvDirectiveArray, long l, long l2) {
        this.logPath = string;
        this.maxActive = n;
        this.maxRetries = n2;
        this.bufDirs = bufDirectiveArray;
        this.drvDirs = drvDirectiveArray;
        this.options = l;
        this.chgFlags = l2;
    }

    public StagerParams(BufDirective[] bufDirectiveArray, DrvDirective[] drvDirectiveArray) {
        this.bufDirs = bufDirectiveArray;
        this.drvDirs = drvDirectiveArray;
        this.chgFlags = 0L;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String string) {
        this.logPath = string;
        this.chgFlags |= 1L;
    }

    public void resetLogPath() {
        this.chgFlags &= 0xFFFFFFFFFFFFFFFEL;
    }

    public BufDirective[] getBufDirectives() {
        return this.bufDirs;
    }

    public void setBufDirectives(BufDirective[] bufDirectiveArray) {
        this.bufDirs = bufDirectiveArray;
    }

    public DrvDirective[] getDrvDirectives() {
        return this.drvDirs;
    }

    public void setDrvDirectives(DrvDirective[] drvDirectiveArray) {
        this.drvDirs = drvDirectiveArray;
    }

    public String toString() {
        int n;
        String string = (this.logPath != null ? this.logPath : "nolog") + "," + this.maxActive + "," + this.maxRetries;
        for (n = 0; n < this.bufDirs.length; ++n) {
            string = string + (n == 0 ? "\n buffer directives:" : "") + "\n  " + this.bufDirs[n];
        }
        for (n = 0; n < this.drvDirs.length; ++n) {
            string = string + (n == 0 ? "\n drive directives:" : "") + "\n  " + this.drvDirs[n];
        }
        return string;
    }
}

