/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.mgmt.arc;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.SamFSException;

public class DiskVol {
    private String volName;
    private String host;
    private String path;
    private long kbytesTotal;
    private long kbytesAvail;
    private int statusFlags;
    private static final int DV_LABELED = 1;
    private static final int DV_REMOTE = 2;
    private static final int DV_UNAVAILABLE = 4;
    private static final int DV_READ_ONLY = 8;
    private static final int DV_BAD_MEDIA = 16;
    private static final int DV_UNKNOWN_VOLUME = Integer.MIN_VALUE;

    private DiskVol(String string, String string2, String string3, long l, long l2, int n) {
        this(string, string2, string3);
        this.kbytesTotal = l;
        this.kbytesAvail = l2;
        this.statusFlags = n;
    }

    public DiskVol(String string, String string2, String string3) {
        this.volName = string;
        this.host = string2;
        this.path = string3;
    }

    public String getVolName() {
        return this.volName;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public long getCapacity() {
        return this.kbytesTotal;
    }

    public long getAvailableSpace() {
        return this.kbytesAvail;
    }

    public boolean isLabeled() {
        return (this.statusFlags & 1) == 1;
    }

    public boolean isReadOnly() {
        return (this.statusFlags & 8) == 8;
    }

    public boolean isRemote() {
        return (this.statusFlags & 2) == 2;
    }

    public boolean isUnavailable() {
        return (this.statusFlags & 4) == 4;
    }

    public boolean isBadMedia() {
        return (this.statusFlags & 0x10) == 16;
    }

    public boolean isUnknown() {
        return (this.statusFlags & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    public void setLabeled(boolean bl) {
        this.statusFlags = bl ? (this.statusFlags |= 1) : (this.statusFlags &= 0xFFFFFFFE);
    }

    public void setUnavailable(boolean bl) {
        this.statusFlags = bl ? (this.statusFlags |= 4) : (this.statusFlags &= 0xFFFFFFFB);
    }

    public void setReadOnly(boolean bl) {
        this.statusFlags = bl ? (this.statusFlags |= 8) : (this.statusFlags &= 0xFFFFFFF7);
    }

    public void setBadMedia(boolean bl) {
        this.statusFlags = bl ? (this.statusFlags |= 0x10) : (this.statusFlags &= 0xFFFFFFEF);
    }

    public void setStatusFlags(Ctx ctx) throws SamFSException {
        DiskVol.setFlags(ctx, this.volName, this.statusFlags);
    }

    public static native DiskVol get(Ctx var0, String var1) throws SamFSException;

    public static native DiskVol[] getAll(Ctx var0) throws SamFSException;

    public static native void add(Ctx var0, DiskVol var1) throws SamFSException;

    public static native void remove(Ctx var0, String var1) throws SamFSException;

    public static native String[] getClients(Ctx var0) throws SamFSException;

    public static native void addClient(Ctx var0, String var1) throws SamFSException;

    public static native void removeClient(Ctx var0, String var1) throws SamFSException;

    public static native void setFlags(Ctx var0, String var1, int var2) throws SamFSException;

    public String toString() {
        String string = this.volName + " " + this.host + " " + this.path + " cap=" + this.kbytesAvail + "k,free=" + this.kbytesAvail + "k flags=" + this.statusFlags;
        return string;
    }
}

