/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.mgmt.adm;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.media.MdLicense;

public class License {
    private short type = (short)-1;
    private short fsType = (short)-1;
    private long expire = -1L;
    private long hostID = -1L;
    private int featureFlags = -1;
    private MdLicense[] mdLicenses;
    public static final short NON_EXPIRING = 0;
    public static final short EXPIRING = 1;
    public static final short DEMO = 2;
    public static final short QFS_TRIAL = 3;
    public static final short QFS_SPECIAL = 4;
    public static final short QFS = 1;
    public static final short SAMFS = 2;
    public static final short SAMQFS = 3;
    private static final int REMOTE_SAM_SVR_SUPPORT = 1;
    private static final int REMOTE_SAM_CLNT_SUPPORT = 2;
    private static final int MIG_TOOLKIT_SUPPORT = 4;
    private static final int FAST_FS_SUPPORT = 8;
    private static final int DATABASE_SUPPORT = 16;
    private static final int FOREIGN_TAPE_SUPPORT = 32;
    private static final int SHARED_FS_SUPPORT = 64;
    private static final int SEGMENT_SUPPORT = 128;
    private static final int SANAPI_SUPPORT = 256;
    private static final int STANDALONE_QFS_SUPPORT = 512;

    private License(short s, long l, short s2, long l2, int n, MdLicense[] mdLicenseArray) {
        this.type = s;
        this.fsType = s2;
        this.expire = l;
        this.hostID = l2;
        this.featureFlags = n;
        this.mdLicenses = mdLicenseArray;
    }

    public short getLicenseType() {
        return this.type;
    }

    public long getExpiration() {
        return this.expire;
    }

    public short getFSType() {
        return this.fsType;
    }

    public long getHostID() {
        return this.hostID;
    }

    public boolean isRemoteSamServerSupported() {
        return (this.featureFlags & 1) == 1;
    }

    public boolean isRemoteSamClientSupported() {
        return (this.featureFlags & 2) == 2;
    }

    public boolean isMigrationToolkitSupported() {
        return (this.featureFlags & 4) == 4;
    }

    public boolean isFastFileSystemSupported() {
        return (this.featureFlags & 8) == 8;
    }

    public boolean isDatabaseSupported() {
        return (this.featureFlags & 0x10) == 16;
    }

    public boolean isForeignTapeSupported() {
        return (this.featureFlags & 0x20) == 32;
    }

    public boolean isSegmentSupported() {
        return (this.featureFlags & 0x80) == 128;
    }

    public boolean isSharedFileSystemSupported() {
        return (this.featureFlags & 0x40) == 64;
    }

    public boolean isSANAPISupported() {
        return (this.featureFlags & 0x100) == 256;
    }

    public boolean isStandaloneQFSSupported() {
        return (this.featureFlags & 0x200) == 512;
    }

    public MdLicense[] getMediaLicenses() {
        return this.mdLicenses;
    }

    public String toString() {
        String string = "License Type: " + this.fsType + " " + this.type + "," + " Expiration: " + this.expire + " Host ID: " + Long.toHexString(this.hostID) + "\nRemote server: " + this.isRemoteSamServerSupported() + "\nRemote client: " + this.isRemoteSamClientSupported() + "\nMigration: " + this.isMigrationToolkitSupported() + "\nQFS: " + this.isStandaloneQFSSupported() + "\nData Base features: " + this.isDatabaseSupported() + "\nForeign tape support: " + this.isForeignTapeSupported() + "\nSAN API support: " + this.isSANAPISupported() + "\nSegment feature: " + this.isSegmentSupported() + "\nShared filesystem support: " + this.isSharedFileSystemSupported() + "\nFast filesystem support: " + this.isFastFileSystemSupported() + "\n";
        if (this.mdLicenses != null) {
            for (int i = 0; i < this.mdLicenses.length; ++i) {
                string = string + "   " + this.mdLicenses[i] + "\n";
            }
        } else {
            string = string + "  none\n";
        }
        return string;
    }

    public static native short getFSType(Ctx var0) throws SamFSException;

    public static native License getLicense(Ctx var0) throws SamFSException;
}

