/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.util;

import com.iplanet.jato.RequestManager;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.management.services.authorization.AuthorizationException;
import com.sun.management.services.authorization.AuthorizationService;
import com.sun.management.services.authorization.AuthorizationServiceFactory;
import com.sun.management.services.authorization.SolarisRbacPermission;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.SecurityManager;
import java.security.Permission;
import javax.security.auth.Subject;

public class RBACSecurityManagerImpl
implements SecurityManager {
    private int currentAuthorization;
    private String authorizationString;

    RBACSecurityManagerImpl() {
        this.initAuthorization();
    }

    protected void initAuthorization() {
        Authorization[] allAuths = new Authorization[]{Authorization.CONFIG, Authorization.MEDIA_OPERATOR, Authorization.SAM_CONTROL, Authorization.FILE_OPERATOR, Authorization.FILESYSTEM_OPERATOR};
        this.currentAuthorization = 0;
        try {
            SSOTokenManager tokenManager = SSOTokenManager.getInstance();
            SSOToken token = tokenManager.createSSOToken(RequestManager.getRequest());
            Subject subject = token.getSubject();
            AuthorizationService authService = AuthorizationServiceFactory.getAuthorizationService((String)"SolarisRbac");
            if (authService == null) {
                throw new SamFSException(null, -2200);
            }
            for (int i = 0; i < allAuths.length; ++i) {
                SolarisRbacPermission permission = new SolarisRbacPermission(allAuths[i].toString());
                if (!authService.checkPermission(subject, (Permission)permission)) continue;
                this.currentAuthorization |= allAuths[i].intValue();
                this.authorizationString = this.authorizationString == null ? SamUtil.getResourceString(allAuths[i].toString()) : this.authorizationString.concat(":").concat(SamUtil.getResourceString(allAuths[i].toString()));
            }
            SolarisRbacPermission permission = new SolarisRbacPermission("com.sun.netstorage.samqfs.web.write");
            if (authService.checkPermission(subject, (Permission)permission)) {
                this.currentAuthorization = Authorization.CONFIG.intValue();
            }
        }
        catch (SSOException ssoe) {
        }
        catch (AuthorizationException ae) {
        }
        catch (SamFSException samFSException) {
            // empty catch block
        }
    }

    public boolean hasAuthorization(Authorization auth) {
        return (this.currentAuthorization & auth.intValue()) == auth.intValue();
    }

    public String getCurrentAuthorization() {
        return this.authorizationString;
    }
}

