/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.util;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.util.ConversionUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.StringTokenizer;

public class Filter
implements Serializable {
    private String namePattern;
    private SizeCriteria sizeGreater;
    private SizeCriteria sizeLess;
    private DateCriteria dateCreated;
    private DateCriteria dateModified;
    private DateCriteria dateAccessed;
    private String owner;
    private String group;
    private Boolean isDamaged;
    private Boolean isOnline;
    private int version;
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final int VERSION_LATEST = 2;
    private static final String KEY_VERSION = "version";
    public static final String KEY_FILENAME = "filename";
    public static final String KEY_OWNER = "owner";
    public static final String KEY_GROUP = "group";
    public static final String KEY_MODBEFORE = "modifiedBefore";
    public static final String KEY_MODAFTER = "modifiedAfter";
    public static final String KEY_CREATEDBEFORE = "createdBefore";
    public static final String KEY_CREATEDAFTER = "createdAfter";
    public static final String KEY_BIGGERTHAN = "biggerThan";
    public static final String KEY_SMALLERTHAN = "smallerThan";
    public static final String KEY_DATEMODIFIED = "dateModified";
    public static final String KEY_DATEACCESSED = "dateAccessed";
    public static final String KEY_DATECREATED = "dateCreated";
    public static final String KEY_SIZEGREATER = "sizeGreater";
    public static final String KEY_SIZELESS = "sizeLess";
    public static final String KEY_DAMAGED = "damaged";
    public static final String KEY_ONLINE = "online";
    private static final String CHAR_ENCODING = "UTF-8";

    public Filter() {
        this(2);
    }

    public Filter(int version) {
        TraceUtil.initTrace();
        this.namePattern = null;
        this.sizeGreater = null;
        this.sizeLess = null;
        this.dateCreated = null;
        this.dateModified = null;
        this.dateAccessed = null;
        this.owner = null;
        this.group = null;
        this.isDamaged = null;
        this.isOnline = null;
        this.version = version;
    }

    public Filter(int version, Properties props) throws SamFSException {
        this(version);
        SizeCriteria size;
        DateCriteria date;
        String prop = props.getProperty(KEY_FILENAME);
        if (null != prop) {
            this.filterOnNamePattern(true, prop);
        }
        if (null != (prop = props.getProperty(KEY_OWNER))) {
            this.filterOnOwner(true, prop);
        }
        if (null != (prop = props.getProperty(KEY_GROUP))) {
            this.filterOnGroup(true, prop);
        }
        if (null != (prop = props.getProperty(KEY_MODBEFORE))) {
            this.filterOnDateModified(true);
            date = this.getDateModified();
            date.setBeforeDate(SamQFSUtil.convertTime(ConversionUtil.strToLongVal(prop)));
        }
        if (null != (prop = props.getProperty(KEY_MODAFTER))) {
            this.filterOnDateModified(true);
            date = this.getDateModified();
            date.setAfterDate(SamQFSUtil.convertTime(ConversionUtil.strToLongVal(prop)));
        }
        if (null != (prop = props.getProperty(KEY_CREATEDBEFORE))) {
            this.filterOnDateCreated(true);
            date = this.getDateCreated();
            date.setBeforeDate(SamQFSUtil.convertTime(ConversionUtil.strToLongVal(prop)));
        }
        if (null != (prop = props.getProperty(KEY_CREATEDAFTER))) {
            this.filterOnDateCreated(true);
            date = this.getDateCreated();
            date.setAfterDate(SamQFSUtil.convertTime(ConversionUtil.strToLongVal(prop)));
        }
        if (null != (prop = props.getProperty(KEY_BIGGERTHAN))) {
            this.filterOnSizeGreater(true);
            size = this.getSizeGreater();
            size.setSize(ConversionUtil.strToLongVal(prop));
        }
        if (null != (prop = props.getProperty(KEY_SMALLERTHAN))) {
            this.filterOnSizeLess(true);
            size = this.getSizeLess();
            size.setSize(ConversionUtil.strToLongVal(prop));
        }
        if (null != (prop = props.getProperty(KEY_DAMAGED))) {
            this.filterOnIsDamaged(true, prop.equals("1"));
        }
        if (null != (prop = props.getProperty(KEY_ONLINE))) {
            this.filterOnIsOnline(true, prop.equals("1"));
        }
    }

    public int getVersion() {
        return this.version;
    }

    public String getNamePattern() {
        return this.namePattern;
    }

    public void filterOnNamePattern(boolean enabled, String namePattern) {
        this.namePattern = enabled ? namePattern : null;
    }

    public DateCriteria getDateCreated() {
        return this.dateCreated;
    }

    public void filterOnDateCreated(boolean enabled) {
        this.dateCreated = enabled ? new DateCriteria() : null;
    }

    public DateCriteria getDateModified() {
        return this.dateModified;
    }

    public void filterOnDateModified(boolean enabled) {
        this.dateModified = enabled ? new DateCriteria() : null;
    }

    public DateCriteria getDateAccessed() {
        return this.dateAccessed;
    }

    public void filterOnDateAccessed(boolean enabled) {
        this.dateAccessed = enabled ? new DateCriteria() : null;
    }

    public SizeCriteria getSizeGreater() {
        return this.sizeGreater;
    }

    public void filterOnSizeGreater(boolean enabled) {
        this.sizeGreater = enabled ? new SizeCriteria() : null;
    }

    public SizeCriteria getSizeLess() {
        return this.sizeLess;
    }

    public void filterOnSizeLess(boolean enabled) {
        this.sizeLess = enabled ? new SizeCriteria() : null;
    }

    public String getOwner() {
        return this.owner;
    }

    public void filterOnOwner(boolean enabled, String owner) {
        this.owner = enabled ? owner : null;
    }

    public String getGroup() {
        return this.group;
    }

    public void filterOnGroup(boolean enabled, String group) {
        this.group = enabled ? group : null;
    }

    public Boolean getIsDamaged() {
        return this.isDamaged;
    }

    public void filterOnIsDamaged(boolean filterEnabled, boolean isDamaged) {
        this.isDamaged = filterEnabled ? Boolean.valueOf(isDamaged) : null;
    }

    public Boolean getIsOnline() {
        return this.isOnline;
    }

    public void filterOnIsOnline(boolean filterEnabled, boolean isOnline) {
        this.isOnline = filterEnabled ? Boolean.valueOf(isOnline) : null;
    }

    public String toString() {
        NonSyncStringBuffer s = new NonSyncStringBuffer();
        if (this.namePattern != null) {
            s.append(KEY_FILENAME).append('=').append(this.namePattern).append(',');
        }
        if (this.owner != null) {
            s.append(KEY_OWNER).append('=').append(this.owner).append(',');
        }
        if (this.group != null) {
            s.append(KEY_GROUP).append('=').append(this.group).append(',');
        }
        if (this.dateModified != null && this.dateModified.getBeforeDate() != null) {
            s.append(KEY_MODBEFORE).append('=').append(String.valueOf(SamQFSUtil.convertTime(this.dateModified.getBeforeDate()))).append(',');
        }
        if (this.dateModified != null && this.dateModified.getAfterDate() != null) {
            s.append(KEY_MODAFTER).append('=').append(String.valueOf(SamQFSUtil.convertTime(this.dateModified.getAfterDate()))).append(',');
        }
        if (this.dateCreated != null && this.dateCreated.getBeforeDate() != null) {
            s.append(KEY_CREATEDBEFORE).append('=').append(String.valueOf(SamQFSUtil.convertTime(this.dateCreated.getBeforeDate()))).append(',');
        }
        if (this.dateCreated != null && this.dateCreated.getAfterDate() != null) {
            s.append(KEY_CREATEDAFTER).append('=').append(String.valueOf(SamQFSUtil.convertTime(this.dateCreated.getAfterDate()))).append(',');
        }
        if (this.sizeGreater != null) {
            s.append(KEY_BIGGERTHAN).append('=').append(String.valueOf(SamQFSUtil.getSizeInBytes(this.sizeGreater.getSize(), this.sizeGreater.getSizeUnit()))).append(',');
        }
        if (this.sizeLess != null) {
            s.append(KEY_SMALLERTHAN).append('=').append(String.valueOf(SamQFSUtil.getSizeInBytes(this.sizeLess.getSize(), this.sizeLess.getSizeUnit()))).append(',');
        }
        if (this.isDamaged != null) {
            s.append(KEY_DAMAGED).append('=').append(this.isDamaged != false ? "1" : "0").append(',');
        }
        if (this.isOnline != null) {
            s.append(KEY_ONLINE).append('=').append(this.isOnline != false ? "1" : "0").append(',');
        }
        if (s.length() > 0) {
            s.setLength(s.length() - 1);
        }
        return s.toString();
    }

    public String getDisplayString() {
        NonSyncStringBuffer s = new NonSyncStringBuffer();
        if (this.namePattern != null) {
            s.append(SamUtil.getResourceString("FilterSettings.fileNamePatternLabel")).append(" = ").append(this.namePattern).append("<br>");
        }
        if (this.sizeGreater != null) {
            s.append(SamUtil.getResourceString("FilterSettings.fileSizeGreaterLabel")).append(" ").append(this.sizeGreater.toString()).append("<br>");
        }
        if (this.sizeLess != null) {
            s.append(SamUtil.getResourceString("FilterSettings.fileSizeLessLabel")).append(" ").append(this.sizeLess.toString()).append("<br>");
        }
        if (this.dateCreated != null) {
            s.append(SamUtil.getResourceString("FilterSettings.fileDateLabel")).append(" ").append(SamUtil.getResourceString("FilterSettings.fileDateType.created")).append(" = ").append(this.dateCreated.toString()).append("<br>");
        }
        if (this.dateModified != null) {
            s.append(SamUtil.getResourceString("FilterSettings.fileDateLabel")).append(" ").append(SamUtil.getResourceString("FilterSettings.fileDateType.modified")).append(" = ").append(this.dateModified.toString()).append("<br>");
        }
        if (this.dateAccessed != null) {
            s.append(SamUtil.getResourceString("FilterSettings.fileDateLabel")).append(" ").append(SamUtil.getResourceString("FilterSettings.fileDateType.lastAccessed")).append(" = ").append(this.dateAccessed.toString()).append("<br>");
        }
        if (this.owner != null) {
            s.append(SamUtil.getResourceString("FilterSettings.ownerLabel")).append(" = ").append(this.owner).append("<br>");
        }
        if (this.group != null) {
            s.append(SamUtil.getResourceString("FilterSettings.groupLabel")).append(" = ").append(this.group).append("<br>");
        }
        if (this.isDamaged != null) {
            s.append(SamUtil.getResourceString("FilterSettings.isDamagedLabel")).append(" = ").append(this.isDamaged != false ? SamUtil.getResourceString("samqfsui.yes") : SamUtil.getResourceString("samqfsui.no")).append("<br>");
        }
        if (this.isOnline != null) {
            s.append(SamUtil.getResourceString("FilterSettings.isOnlineLabel")).append(" = ").append(this.isOnline != false ? SamUtil.getResourceString("samqfsui.yes") : SamUtil.getResourceString("samqfsui.no")).append("<br>");
        }
        String outStr = s.toString();
        if (s.length() > 1) {
            outStr = outStr.substring(0, outStr.length() - 4);
        }
        return outStr;
    }

    public String writeEncodedString() throws UnsupportedEncodingException {
        NonSyncStringBuffer out = new NonSyncStringBuffer();
        String delimiter = "\n";
        out.append(KEY_VERSION).append(delimiter).append(this.version).append(delimiter);
        if (this.namePattern != null) {
            out.append(KEY_FILENAME).append(delimiter).append(this.namePattern).append(delimiter);
        }
        if (this.owner != null) {
            out.append(KEY_OWNER).append(delimiter).append(this.owner).append(delimiter);
        }
        if (this.group != null) {
            out.append(KEY_GROUP).append(delimiter).append(this.group).append(delimiter);
        }
        if (this.isDamaged != null) {
            out.append(KEY_DAMAGED).append(delimiter).append(this.isDamaged.toString()).append(delimiter);
        }
        if (this.isOnline != null) {
            out.append(KEY_ONLINE).append(delimiter).append(this.isOnline.toString()).append(delimiter);
        }
        if (this.dateAccessed != null) {
            out.append(KEY_DATEACCESSED).append(delimiter);
            this.dateAccessed.writePersistString(out);
            out.append(delimiter);
        }
        if (this.dateCreated != null) {
            out.append(KEY_DATECREATED).append(delimiter);
            this.dateCreated.writePersistString(out);
            out.append(delimiter);
        }
        if (this.dateModified != null) {
            out.append(KEY_DATEMODIFIED).append(delimiter);
            this.dateModified.writePersistString(out);
            out.append(delimiter);
        }
        if (this.sizeGreater != null) {
            out.append(KEY_SIZEGREATER).append(delimiter);
            this.sizeGreater.writePersistString(out);
            out.append(delimiter);
        }
        if (this.sizeLess != null) {
            out.append(KEY_SIZELESS).append(delimiter);
            this.sizeLess.writePersistString(out);
            out.append(delimiter);
        }
        return URLEncoder.encode(out.toString(), CHAR_ENCODING);
    }

    public static Filter getFilterFromEncodedString(String persistString) throws UnsupportedEncodingException {
        String unencodedStr = URLDecoder.decode(persistString, CHAR_ENCODING);
        StringTokenizer strTok = new StringTokenizer(unencodedStr, "\n");
        Filter filter = new Filter();
        while (strTok.hasMoreTokens()) {
            String name = strTok.nextToken();
            String value = strTok.nextToken();
            if (name.equals(KEY_VERSION)) {
                int version = 2;
                try {
                    version = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                filter.version = version;
                continue;
            }
            if (name.equals(KEY_FILENAME)) {
                filter.filterOnNamePattern(true, value);
                continue;
            }
            if (name.equals(KEY_OWNER)) {
                filter.filterOnOwner(true, value);
                continue;
            }
            if (name.equals(KEY_GROUP)) {
                filter.filterOnGroup(true, value);
                continue;
            }
            if (name.equals(KEY_DAMAGED)) {
                filter.filterOnIsDamaged(true, Boolean.valueOf(value));
                continue;
            }
            if (name.equals(KEY_ONLINE)) {
                filter.filterOnIsOnline(true, Boolean.valueOf(value));
                continue;
            }
            if (name.equals(KEY_DATEACCESSED)) {
                filter.filterOnDateAccessed(true);
                filter.getDateAccessed().loadPersistString(value);
                continue;
            }
            if (name.equals(KEY_DATECREATED)) {
                filter.filterOnDateCreated(true);
                filter.getDateCreated().loadPersistString(value);
                continue;
            }
            if (name.equals(KEY_DATEMODIFIED)) {
                filter.filterOnDateModified(true);
                filter.getDateModified().loadPersistString(value);
                continue;
            }
            if (name.equals(KEY_SIZEGREATER)) {
                filter.filterOnSizeGreater(true);
                filter.getSizeGreater().loadPersistString(value);
                continue;
            }
            if (!name.equals(KEY_SIZELESS)) continue;
            filter.filterOnSizeLess(true);
            filter.getSizeLess().loadPersistString(value);
        }
        return filter;
    }

    public class SizeCriteria
    implements Serializable {
        private long size;
        private int sizeUnit;
        private final String KEY_SIZE = "size";
        private final String KEY_SIZE_UNIT = "sizeUnit";

        public SizeCriteria() {
            try {
                this.setSize(0L);
                this.setSizeUnit(0);
            }
            catch (SamFSException samFSException) {
                // empty catch block
            }
        }

        public SizeCriteria(long size, int sizeUnit) throws SamFSException {
            this.setSize(size);
            this.setSizeUnit(sizeUnit);
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) throws SamFSException {
            if (size < 0L) {
                throw new SamFSException(SamUtil.getResourceString("FilterSettings.filter.error.invalidSizeValue"));
            }
            this.size = size;
        }

        public int getSizeUnit() {
            return this.sizeUnit;
        }

        public void setSizeUnit(int sizeUnit) throws SamFSException {
            if (sizeUnit != 0 && sizeUnit != 3 && sizeUnit != 1 && sizeUnit != 2 && sizeUnit != 41 && sizeUnit != 4) {
                throw new SamFSException(SamUtil.getResourceString("FilterSettings.filter.error.invalidSizeUnit", String.valueOf(sizeUnit)));
            }
            this.sizeUnit = sizeUnit;
        }

        public String toString() {
            NonSyncStringBuffer out = new NonSyncStringBuffer().append(this.size).append(" ");
            switch (this.sizeUnit) {
                case 0: {
                    out.append(SamUtil.getResourceString("FilterSettings.fileSizeUnit.b"));
                    break;
                }
                case 1: {
                    out.append(SamUtil.getResourceString("FilterSettings.fileSizeUnit.kb"));
                    break;
                }
                case 2: {
                    out.append(SamUtil.getResourceString("FilterSettings.fileSizeUnit.mb"));
                    break;
                }
                case 3: {
                    out.append(SamUtil.getResourceString("FilterSettings.fileSizeUnit.gb"));
                    break;
                }
                case 4: {
                    out.append(SamUtil.getResourceString("FilterSettings.fileSizeUnit.tb"));
                    break;
                }
                case 41: {
                    out.append(SamUtil.getResourceString("FilterSettings.fileSizeUnit.pb"));
                }
            }
            return out.toString();
        }

        public void writePersistString(NonSyncStringBuffer out) {
            out.append("size").append("\t").append(this.size).append("\t").append("sizeUnit").append("\t").append(this.sizeUnit).append("\t");
        }

        public void loadPersistString(String persistString) {
            StringTokenizer strTok = new StringTokenizer(persistString, "\t");
            while (strTok.hasMoreTokens()) {
                String name = strTok.nextToken();
                String value = strTok.nextToken();
                try {
                    if (name.equals("size")) {
                        this.setSize(Long.parseLong(value));
                        continue;
                    }
                    if (!name.equals("sizeUnit")) continue;
                    this.setSizeUnit(Integer.parseInt(value));
                }
                catch (Exception e) {
                    TraceUtil.trace1("Failed to load value \"" + name + "\" from persisted string: " + persistString, e);
                }
            }
        }
    }

    public class DateCriteria
    implements Serializable {
        private int dateRangeType = 9;
        public static final int DATERANGETYPE_INTHELAST = 9;
        public static final int DATERANGETYPE_BETWEEN = 10;
        private int dateValue = 0;
        private int dateUnit = 11;
        public static final int DATEUNIT_DAYS = 11;
        public static final int DATEUNIT_MONTHS = 12;
        private GregorianCalendar beforeDate;
        private GregorianCalendar afterDate;
        private final String KEY_DATE_RANGE_TYPE = "dateRangeType";
        private final String KEY_DATE_VALUE = "dateValue";
        private final String KEY_DATE_UNIT = "dateUnit";
        private final String KEY_BEFORE_DATE = "beforeDate";
        private final String KEY_AFTER_DATE = "afterDate";

        private DateCriteria() {
        }

        public GregorianCalendar getBeforeDate() {
            return this.beforeDate;
        }

        public void setBeforeDate(GregorianCalendar date) {
            this.beforeDate = date;
        }

        public GregorianCalendar getAfterDate() {
            return this.afterDate;
        }

        public void setAfterDate(GregorianCalendar date) {
            this.afterDate = date;
        }

        public int getDateRangeType() {
            return this.dateRangeType;
        }

        public void setDateRangeType(int dateRangeType) throws SamFSException {
            if (dateRangeType != 9 && dateRangeType != 10) {
                throw new SamFSException(SamUtil.getResourceString("FilterSettings.filter.error.invalidDateRangeType", String.valueOf(dateRangeType)));
            }
            this.dateRangeType = dateRangeType;
        }

        public int getDateValue() {
            return this.dateValue;
        }

        public void setDateValue(int dateValue) {
            this.dateValue = dateValue;
        }

        public int getDateUnit() {
            return this.dateUnit;
        }

        public void setDateUnit(int dateUnit) throws SamFSException {
            if (dateUnit != 11 && dateUnit != 12) {
                throw new SamFSException(SamUtil.getResourceString("FilterSettings.filter.error.invalidDateUnit," + String.valueOf(dateUnit)));
            }
            this.dateUnit = dateUnit;
        }

        public void setDatesPrior(int dateValue, int dateUnit) throws SamFSException {
            this.setDateUnit(dateUnit);
            this.setDateValue(dateValue);
            this.setDateRangeType(9);
            this.beforeDate = new GregorianCalendar();
            this.afterDate = new GregorianCalendar();
            if (dateValue > 0) {
                dateValue -= 2 * dateValue;
            }
            if (dateUnit == 11) {
                this.afterDate.add(5, dateValue);
            } else {
                this.afterDate.add(2, dateValue);
            }
        }

        public void setDatesBetween(GregorianCalendar afterDate, GregorianCalendar beforeDate) throws SamFSException {
            afterDate.set(11, 0);
            afterDate.set(12, 0);
            afterDate.set(13, 0);
            afterDate.set(14, 0);
            beforeDate.set(11, 0);
            beforeDate.set(12, 0);
            beforeDate.set(13, 0);
            beforeDate.set(14, 0);
            if (afterDate.getTimeInMillis() > beforeDate.getTimeInMillis()) {
                throw new SamFSException(SamUtil.getResourceString("FilterSettings.filter.error.invalidDatesBetween"));
            }
            this.setDateRangeType(10);
            this.setAfterDate(afterDate);
            this.setBeforeDate(beforeDate);
        }

        public String toString() {
            NonSyncStringBuffer out = new NonSyncStringBuffer();
            if (this.dateRangeType == 9) {
                out.append(SamUtil.getResourceString("FilterSettings.fileDateRange.inTheLast")).append(" ").append(this.dateValue).append(" ");
                if (this.dateUnit == 11) {
                    out.append(SamUtil.getResourceString("FilterSettings.fileDateUnit.days"));
                } else {
                    out.append(SamUtil.getResourceString("FilterSettings.fileDateUnit.months"));
                }
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat(SamUtil.getResourceString("FilterSettings.fileDatePattern"));
                out.append(SamUtil.getResourceString("FilterSettings.fileDateRange.between")).append(" ").append(sdf.format(this.afterDate.getTime())).append(" ").append(SamUtil.getResourceString("FilterSettings.fileDateText")).append(" ").append(sdf.format(this.beforeDate.getTime()));
            }
            return out.toString();
        }

        public void writePersistString(NonSyncStringBuffer out) {
            out.append("dateRangeType").append("\t").append(this.dateRangeType).append("\t").append("dateUnit").append("\t").append(this.dateUnit).append("\t").append("dateValue").append("\t").append(this.dateValue).append("\t").append("afterDate").append("\t").append(this.afterDate.getTimeInMillis()).append("\t").append("beforeDate").append("\t").append(this.beforeDate.getTimeInMillis()).append("\t");
        }

        public void loadPersistString(String persistString) {
            StringTokenizer strTok = new StringTokenizer(persistString, "\t");
            while (strTok.hasMoreTokens()) {
                String name = strTok.nextToken();
                String value = strTok.nextToken();
                try {
                    GregorianCalendar date;
                    if (name.equals("dateRangeType")) {
                        this.setDateRangeType(Integer.parseInt(value));
                        continue;
                    }
                    if (name.equals("dateUnit")) {
                        this.setDateUnit(Integer.parseInt(value));
                        continue;
                    }
                    if (name.equals("dateValue")) {
                        this.setDateValue(Integer.parseInt(value));
                        continue;
                    }
                    if (name.equals("afterDate")) {
                        date = new GregorianCalendar();
                        date.setTimeInMillis(Long.parseLong(value));
                        this.setAfterDate(date);
                        continue;
                    }
                    if (!name.equals("beforeDate")) continue;
                    date = new GregorianCalendar();
                    date.setTimeInMillis(Long.parseLong(value));
                    this.setBeforeDate(date);
                }
                catch (Exception e) {
                    TraceUtil.trace1("Failed to load value \"" + name + "\" from persisted string: " + persistString, e);
                }
            }
        }
    }
}

