/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.test.fs;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiHostException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemFSManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemSharedFSManager;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.fs.SharedMember;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSAppModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemSharedFSManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.test.BaseTest;

public class SharedTest {
    static void testGetSharedLicenses(SamQFSSystemSharedFSManager manager, String[] hostNames) throws Exception {
        int[] result = manager.getSharedLicenses(hostNames);
        System.out.println("Licence status:");
        block5: for (int i = 0; i < hostNames.length; ++i) {
            if (hostNames[i] == null) continue;
            System.out.print(hostNames[i] + " ");
            switch (result[i]) {
                case -1: {
                    System.out.println("UNREACHABLE");
                    continue block5;
                }
                case 1: {
                    System.out.println("ENABLED");
                    continue block5;
                }
                case 0: {
                    System.out.println("NOT_ENABLED");
                }
            }
        }
    }

    static void testGetIPAddresses(SamQFSSystemSharedFSManager manager, String[] hostNames) throws Exception {
        for (int i = 0; i < hostNames.length; ++i) {
            if (hostNames[i] == null) continue;
            System.out.println("IP Addresses for: " + hostNames[i]);
            String[] ips = manager.getIPAddresses(hostNames[i]);
            for (int j = 0; j < ips.length; ++j) {
                System.out.println("    " + ips[j]);
            }
        }
    }

    static void testGetSharedFSType(SamQFSSystemSharedFSManager manager, SamQFSSystemModel[] models) throws Exception {
        System.out.println("Host type for: host_name (fs_name) MD server/Potential MD server/Client");
        for (int i = 0; i < models.length; ++i) {
            if (models[i] == null) continue;
            SamQFSSystemFSManager fsManager = models[i].getSamQFSSystemFSManager();
            FileSystem[] fileSystems = fsManager.getAllFileSystems();
            block7: for (int j = 0; j < fileSystems.length; ++j) {
                FileSystem fs2 = fileSystems[j];
                System.out.print(models[i].getHostname() + " (" + fs2.getName() + ") ");
                switch (manager.getSharedFSType(models[i].getHostname(), fs2.getName())) {
                    case 0: {
                        System.out.println("MD server");
                        continue block7;
                    }
                    case 1: {
                        System.out.println("Potential MD server");
                        continue block7;
                    }
                    case 2: {
                        System.out.println("Client");
                        continue block7;
                    }
                    case -1: {
                        System.out.println("Not Shared");
                    }
                }
            }
        }
    }

    static void testFailingover(SamQFSSystemSharedFSManager manager, SamQFSSystemModel[] models) throws Exception {
        System.out.println("Failover status for: host_name (fs_name) true/false");
        for (int i = 0; i < models.length; ++i) {
            if (models[i] == null) continue;
            SamQFSSystemFSManager fsManager = models[i].getSamQFSSystemFSManager();
            FileSystem[] fileSystems = fsManager.getAllFileSystems();
            for (int j = 0; j < fileSystems.length; ++j) {
                FileSystem fs2 = fileSystems[j];
                if (fs2.getShareStatus() == 0) continue;
                System.out.print(models[i].getHostname() + " (" + fs2.getName() + ") ");
                System.out.println(manager.failingover(models[i].getHostname(), fs2.getName()));
            }
        }
    }

    static void testGetSharedMembers(SamQFSSystemSharedFSManager manager, SamQFSSystemModel[] models) throws Exception {
        for (int i = 0; i < models.length; ++i) {
            if (models[i] == null) continue;
            SamQFSSystemFSManager fsManager = models[i].getSamQFSSystemFSManager();
            FileSystem[] fileSystems = fsManager.getAllFileSystems();
            for (int j = 0; j < fileSystems.length; ++j) {
                SharedMember[] members;
                block8: {
                    FileSystem fs2 = fileSystems[j];
                    int hostType = manager.getSharedFSType(models[i].getHostname(), fs2.getName());
                    if (fs2.getShareStatus() == 0 || hostType != 0 && hostType != 1) continue;
                    System.out.println("Members of " + models[i].getHostname() + " (" + fs2.getName() + ")");
                    members = null;
                    try {
                        members = manager.getSharedMembers(models[i].getHostname(), fs2.getName());
                    }
                    catch (SamFSMultiHostException e) {
                        members = (SharedMember[])e.getPartialResult();
                        e.printStackTrace();
                        SamFSException[] exceptions = e.getExceptions();
                        String[] hostNames = e.getHostNames();
                        if (exceptions != null && exceptions.length > 0) {
                            for (int k = 0; k < exceptions.length; ++k) {
                                System.out.println("Exception on host name: " + hostNames[k]);
                                exceptions[k].printStackTrace();
                            }
                            System.out.println();
                        }
                        if (members != null) break block8;
                        throw e;
                    }
                }
                for (int k = 0; k < members.length; ++k) {
                    if (members[k] == null) {
                        System.out.println("*** Got NULL member! ***");
                        continue;
                    }
                    System.out.println("   " + members[k].getHostName());
                }
            }
        }
    }

    static void testGetHostsNotUsedBy(SamQFSSystemSharedFSManager manager, SamQFSSystemModel[] models) throws Exception {
        for (int i = 0; i < models.length; ++i) {
            if (models[i] == null) continue;
            SamQFSSystemFSManager fsManager = models[i].getSamQFSSystemFSManager();
            FileSystem[] fileSystems = fsManager.getAllFileSystems();
            for (int j = 0; j < fileSystems.length; ++j) {
                FileSystem fs2 = fileSystems[j];
                int hostType = manager.getSharedFSType(models[i].getHostname(), fs2.getName());
                if (fs2.getShareStatus() == 0 || hostType != 0 && hostType != 1) continue;
                System.out.println("Hosts that are not members of " + models[i].getHostname() + " (" + fs2.getName() + ")");
                String[] hosts = manager.getHostsNotUsedBy(fs2.getName(), models[i].getHostname());
                for (int k = 0; k < hosts.length; ++k) {
                    System.out.println("   " + hosts[k]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        block12: {
            SamQFSSystemSharedFSManagerImpl fsManager = null;
            try {
                SamQFSSystemModel[] models = BaseTest.getAllSamQFSSystemModels();
                fsManager = new SamQFSSystemSharedFSManagerImpl((SamQFSAppModelImpl)BaseTest.getSamQFSAppModel());
                if (models != null && models.length > 0) {
                    String[] servers = new String[models.length];
                    System.out.println("Checking for down hosts...");
                    for (int i = 0; i < models.length; ++i) {
                        if (models[i].isDown()) {
                            System.out.println("Host is down: " + models[i].getHostname());
                            servers[i] = null;
                            models[i] = null;
                            continue;
                        }
                        servers[i] = models[i].getHostname();
                    }
                    System.out.println("Test getSharedLicenses()");
                    SharedTest.testGetSharedLicenses(fsManager, servers);
                    System.out.println();
                    System.out.println("Test getIPAddresses()");
                    SharedTest.testGetIPAddresses(fsManager, servers);
                    System.out.println();
                    System.out.println("Test getSharedFSType()");
                    SharedTest.testGetSharedFSType(fsManager, models);
                    System.out.println();
                    System.out.println("Test getSharedMembers()");
                    SharedTest.testGetSharedMembers(fsManager, models);
                    System.out.println();
                    System.out.println("Test getHostsNotUsedBy()");
                    SharedTest.testGetHostsNotUsedBy(fsManager, models);
                    System.out.println();
                    System.out.println("Test getFailingover()");
                    SharedTest.testFailingover(fsManager, models);
                    System.out.println();
                }
                fsManager.freeResources();
            }
            catch (SamFSMultiHostException e) {
                SamFSException[] exceptions = e.getExceptions();
                String[] hostNames = e.getHostNames();
                if (exceptions != null && exceptions.length > 0) {
                    for (int i = 0; i < exceptions.length; ++i) {
                        System.out.println("Exception on host name: " + hostNames[i]);
                        exceptions[i].printStackTrace();
                    }
                    System.out.println();
                }
                e.printStackTrace();
                fsManager.freeResources();
            }
            catch (Exception e2) {
                e2.printStackTrace();
                break block12;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                ((SamQFSSystemSharedFSManagerImpl)fsManager).freeResources();
            }
        }
    }
}

