/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.test.fs;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemFSManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.fs.GenericFileSystem;
import com.sun.netstorage.samqfs.web.model.fs.NFSOptions;
import com.sun.netstorage.samqfs.web.model.impl.test.BaseTest;

public class NFSTest {
    static SamQFSSystemModel[] models;

    public static GenericFileSystem[] getAllFileSystems(int modelIdx, boolean samq) throws SamFSException {
        SamQFSSystemModel model = models[modelIdx];
        SamQFSSystemFSManager fsMgr = model.getSamQFSSystemFSManager();
        return samq ? fsMgr.getAllFileSystems() : fsMgr.getNonSAMQFileSystems();
    }

    public static void main(String[] args) {
        NFSOptions[] opts;
        try {
            System.out.println("getting all models...\n");
            models = BaseTest.getAllSamQFSSystemModels();
            if (models != null && models.length > 0) {
                for (int i = 0; i < 1; ++i) {
                    System.out.println("STEP1 Calling Filesystems...");
                    FileSystem[] fsList = (FileSystem[])NFSTest.getAllFileSystems(i, true);
                    System.out.println("Filesystems for host: " + models[i].getHostname());
                    System.out.println("No of file systems: " + fsList.length);
                    if (fsList != null && fsList.length > 0) {
                        for (int j = 0; j < fsList.length; ++j) {
                            System.out.println("Filesystem " + (j + 1) + ":");
                            System.out.println(fsList[j]);
                            System.out.println("NFS Options: \n------------");
                            opts = fsList[j].getNFSOptions();
                            for (i = 0; i < opts.length; ++i) {
                                System.out.println(" " + opts[i]);
                            }
                            System.out.println("========================");
                        }
                    }
                    System.out.println("===================================");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\nSTEP2: Retrieve non-SAMQ filesystems");
        try {
            SamQFSSystemModel[] models = BaseTest.getAllSamQFSSystemModels();
            if (models != null && models.length > 0) {
                for (int i = 0; i < models.length; ++i) {
                    System.out.println("Other filesystems on host: " + models[i].getHostname());
                    GenericFileSystem[] fs2 = NFSTest.getAllFileSystems(i, false);
                    for (int j = 0; j < fs2.length; ++j) {
                        System.out.println(" " + fs2[j]);
                        System.out.println("  NFS Options:");
                        opts = fs2[j].getNFSOptions();
                        for (int k = 0; k < opts.length; ++k) {
                            System.out.println("   " + opts[k]);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

