/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.test.fs;

import com.sun.netstorage.samqfs.web.model.SamQFSSystemFSManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.fs.DumpSched;
import com.sun.netstorage.samqfs.web.model.fs.RestoreDumpFile;
import com.sun.netstorage.samqfs.web.model.impl.test.BaseTest;

public class DumpListTest {
    public static void main(String[] args) {
        try {
            SamQFSSystemModel[] models = BaseTest.getAllSamQFSSystemModels();
            if (models != null && models.length > 0) {
                SamQFSSystemModel selModel = models[0];
                System.out.println("dump files on host " + selModel.getHostname());
                SamQFSSystemFSManager fsMgr = selModel.getSamQFSSystemFSManager();
                String[] fsNames = fsMgr.getAllFileSystemNames();
                if (fsNames != null && fsNames.length > 0) {
                    int i;
                    String fsName = fsNames[0];
                    System.out.println("Retrieving dump file list for fs " + fsName);
                    DumpSched sched = fsMgr.getMetadataDumpSchedParams(fsName);
                    RestoreDumpFile[] dmpFiles = fsMgr.getAvailableDumpFiles(fsName, sched.getLocation());
                    if (dmpFiles != null) {
                        for (i = 0; i < dmpFiles.length; ++i) {
                            System.out.println("\t " + dmpFiles[i]);
                        }
                    }
                    if (i == 0) {
                        System.out.println("no dump files found");
                    }
                    return;
                }
                System.out.println("no filesystems founds. test aborted");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

