/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator.archive;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.archive.ArchiveCopy;
import com.sun.netstorage.samqfs.web.model.archive.ArchiveVSNMap;
import com.sun.netstorage.samqfs.web.model.archive.VSNPool;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive.VSNPoolImpl;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import java.util.ArrayList;

public class ArchiveVSNMapImpl
implements ArchiveVSNMap,
Cloneable {
    private ArchiveCopy archCopy = null;
    private int archType = -1;
    private ArrayList vsns = null;
    private ArrayList vsnPools = null;
    private String expression = new String();
    private String startVSNname = new String();
    private String endVSNname = new String();
    private String poolExpression = new String();

    public ArchiveVSNMapImpl() {
    }

    public ArchiveVSNMapImpl(ArchiveCopy archCopy, int archType, ArrayList vsns, ArrayList vsnPools) throws SamFSException {
        this.archCopy = archCopy;
        this.archType = archType;
        this.vsns = vsns;
        this.vsnPools = vsnPools;
    }

    public ArchiveCopy getArchiveCopy() throws SamFSException {
        return this.archCopy;
    }

    public void setArchiveCopy(ArchiveCopy copy) throws SamFSException {
        this.archCopy = copy;
    }

    public int getArchiveMediaType() throws SamFSException {
        return this.archType;
    }

    public void setArchiveMediaType(int type) throws SamFSException {
        this.archType = type;
    }

    public VSN[] getVSNs() throws SamFSException {
        VSN[] vsnList = null;
        if (this.vsns != null) {
            vsnList = this.vsns.toArray(new VSN[0]);
        }
        return vsnList;
    }

    public void setVSNs(VSN[] vsns) throws SamFSException {
        if (this.vsns == null) {
            this.vsns = new ArrayList();
        } else {
            this.vsns.clear();
        }
        if (vsns != null) {
            for (int i = 0; i < vsns.length; ++i) {
                this.vsns.add(vsns[i]);
            }
        }
    }

    public VSNPool[] getVSNPools() throws SamFSException {
        VSNPool[] pools = null;
        if (this.vsnPools != null) {
            pools = this.vsnPools.toArray(new VSNPool[0]);
        }
        return pools;
    }

    public void setVSNPools(VSNPool[] pools) throws SamFSException {
        if (this.vsnPools == null) {
            this.vsnPools = new ArrayList();
        } else {
            this.vsnPools.clear();
        }
        if (pools != null) {
            for (int i = 0; i < pools.length; ++i) {
                this.vsnPools.add(pools[i]);
            }
        }
    }

    public String getMapExpression() throws SamFSException {
        StringBuffer returnedExp = new StringBuffer();
        if (this.expression != null && !this.expression.equals(new String())) {
            returnedExp.append(this.expression);
        } else if (this.startVSNname != null && !this.startVSNname.equals(new String()) || this.endVSNname != null && !this.endVSNname.equals(new String())) {
            boolean start = false;
            if (this.startVSNname != null && !this.startVSNname.equals(new String())) {
                returnedExp.append(this.startVSNname);
                start = true;
            }
            if (this.endVSNname != null && !this.endVSNname.equals(new String())) {
                if (start) {
                    returnedExp.append("-");
                }
                returnedExp.append(this.endVSNname);
            }
        } else {
            int i;
            if (this.vsns != null) {
                for (i = 0; i < this.vsns.size(); ++i) {
                    if (i != 0) {
                        returnedExp.append(",");
                    }
                    returnedExp.append(((VSN)this.vsns.get(i)).getVSN());
                }
            }
            if (this.vsnPools != null) {
                for (i = 0; i < this.vsnPools.size(); ++i) {
                    if (this.vsns != null && this.vsns.size() > 0) {
                        returnedExp.append(",");
                    }
                    returnedExp.append(((VSNPool)this.vsnPools.get(i)).getPoolName());
                }
            }
        }
        return returnedExp.toString();
    }

    public void setMapExpression(String expression) throws SamFSException {
        if (expression != null) {
            this.expression = expression;
        }
    }

    public String getMapExpressionStartVSN() throws SamFSException {
        return this.startVSNname;
    }

    public String getPoolExpression() {
        String poolExp = this.poolExpression;
        if (poolExp == null || poolExp.equals(new String())) {
            StringBuffer buf = new StringBuffer();
            if (this.vsnPools != null) {
                for (int i = 0; i < this.vsnPools.size(); ++i) {
                    if (i != 0) {
                        buf.append(",");
                    }
                    buf.append(((VSNPool)this.vsnPools.get(i)).getPoolName());
                }
            }
            poolExp = buf.toString();
        }
        return poolExp;
    }

    public void setPoolExpression(String poolExp) {
        if (poolExp != null) {
            this.poolExpression = poolExp;
        }
    }

    public void setMapExpressionStartVSN(String expression) throws SamFSException {
        if (expression != null & !this.startVSNname.equals(expression)) {
            this.startVSNname = expression;
        }
    }

    public String getMapExpressionEndVSN() throws SamFSException {
        return this.endVSNname;
    }

    public void setMapExpressionEndVSN(String expression) throws SamFSException {
        if (expression != null & !this.endVSNname.equals(expression)) {
            this.endVSNname = expression;
        }
    }

    public String[] getAvailableVSNs() throws SamFSException {
        int i;
        ArrayList<String> vsnList = new ArrayList<String>();
        if (this.vsns != null) {
            for (i = 0; i < this.vsns.size(); ++i) {
                if (((VSN)this.vsns.get(i)).getAvailableSpace() <= 0L) continue;
                vsnList.add(((VSN)this.vsns.get(i)).getVSN());
            }
        }
        if (this.vsnPools != null) {
            for (i = 0; i < this.vsnPools.size(); ++i) {
                VSNPool pool = (VSNPool)this.vsnPools.get(i);
                VSN[] members = ((VSNPoolImpl)pool).getMemberVSNs();
                if (members == null) continue;
                for (int j = 0; j < members.length; ++j) {
                    if (members[j].getAvailableSpace() <= 0L) continue;
                    vsnList.add(members[j].getVSN());
                }
            }
        }
        return vsnList.toArray(new String[0]);
    }

    private VSN[] getAvailVSNs() throws SamFSException {
        int i;
        ArrayList vsnList = new ArrayList();
        if (this.vsns != null) {
            for (i = 0; i < this.vsns.size(); ++i) {
                if (((VSN)this.vsns.get(i)).getAvailableSpace() <= 0L) continue;
                vsnList.add(this.vsns.get(i));
            }
        }
        if (this.vsnPools != null) {
            for (i = 0; i < this.vsnPools.size(); ++i) {
                VSNPool pool = (VSNPool)this.vsnPools.get(i);
                VSN[] members = ((VSNPoolImpl)pool).getMemberVSNs();
                if (members == null) continue;
                for (int j = 0; j < members.length; ++j) {
                    if (members[j].getAvailableSpace() <= 0L) continue;
                    vsnList.add(members[j]);
                }
            }
        }
        return vsnList.toArray(new VSN[0]);
    }

    public long getAvailableSpace() throws SamFSException {
        VSN[] availableVSNs = this.getAvailVSNs();
        long available = 0L;
        if (availableVSNs != null) {
            for (int i = 0; i < availableVSNs.length; ++i) {
                available += availableVSNs[i].getAvailableSpace();
            }
        }
        return available;
    }

    public Object clone() {
        ArchiveVSNMapImpl map = null;
        try {
            int i;
            ArrayList listVSN = null;
            ArrayList listPool = null;
            if (this.vsns != null) {
                listVSN = new ArrayList();
                for (i = 0; i < this.vsns.size(); ++i) {
                    listVSN.add(this.vsns.get(i));
                }
            }
            if (this.vsnPools != null) {
                listPool = new ArrayList();
                for (i = 0; i < this.vsnPools.size(); ++i) {
                    listPool.add(this.vsnPools.get(i));
                }
            }
            map = new ArchiveVSNMapImpl(this.getArchiveCopy(), this.getArchiveMediaType(), listVSN, listPool);
            map.setMapExpression(this.getMapExpression());
            map.setMapExpressionStartVSN(this.getMapExpressionStartVSN());
            map.setMapExpressionEndVSN(this.getMapExpressionEndVSN());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.archCopy != null) {
            try {
                buf.append("Archive Copy Number: " + this.archCopy.getCopyNumber() + "\n");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        buf.append("Archive Type: " + this.archType + "\n");
        try {
            if (this.vsns != null) {
                for (int i = 0; i < this.vsns.size(); ++i) {
                    buf.append("VSN: " + ((VSN)this.vsns.get(i)).getVSN() + "\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.vsnPools != null) {
                for (int i = 0; i < this.vsnPools.size(); ++i) {
                    buf.append("VSN Pools: " + ((VSNPool)this.vsnPools.get(i)).getPoolName() + "\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            VSN[] availVSNs = this.getAvailVSNs();
            if (availVSNs != null) {
                for (int i = 0; i < availVSNs.length; ++i) {
                    buf.append("Available VSN: " + availVSNs[i].getVSN() + "\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            buf.append("Space Available: " + this.getAvailableSpace() + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buf.toString();
    }
}

