/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiHostException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiStepOpException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemFSManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.fs.DumpSched;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.fs.FileSystemMountProperties;
import com.sun.netstorage.samqfs.web.model.fs.GenericFileSystem;
import com.sun.netstorage.samqfs.web.model.fs.GenericMountOptions;
import com.sun.netstorage.samqfs.web.model.fs.RemoteFile;
import com.sun.netstorage.samqfs.web.model.fs.RestoreDumpFile;
import com.sun.netstorage.samqfs.web.model.fs.RestoreFile;
import com.sun.netstorage.samqfs.web.model.fs.StageFile;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemArchiveManager43Impl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemJobManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.ArchivePolicyImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.FSArchiveDirectiveImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.fs.FileSystemImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.fs.FileSystemMountPropertiesImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.fs.GenericFileSystemImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.fs.RestoreDumpFileContents;
import com.sun.netstorage.samqfs.web.model.impl.simulator.fs.RestoreFileImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.job.EnableDumpJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.job.FSDumpJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.job.RestoreJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.job.RestoreSearchJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.media.BaseDeviceImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.media.DiskCacheImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.media.StripedGroupImpl;
import com.sun.netstorage.samqfs.web.model.job.BaseJob;
import com.sun.netstorage.samqfs.web.model.job.RestoreJob;
import com.sun.netstorage.samqfs.web.model.job.RestoreSearchJob;
import com.sun.netstorage.samqfs.web.model.media.BaseDevice;
import com.sun.netstorage.samqfs.web.model.media.DiskCache;
import com.sun.netstorage.samqfs.web.model.media.StripedGroup;
import com.sun.netstorage.samqfs.web.util.Filter;
import com.sun.netstorage.samqfs.web.util.FsmVersion;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.PatternSyntaxException;

public class SamQFSSystemFSManagerImpl
implements SamQFSSystemFSManager {
    private SamQFSSystemModelImpl theModel;
    private HashMap fsMap = new HashMap();
    private HashMap genericFSMap = new HashMap();
    private HashMap fsDumpScheduleMap = new HashMap();
    private int stripeGroupIndex = 1;
    private FsmVersion version45;
    private TreeMap dumpFilesByFS = new TreeMap();
    private RestoreDumpFileContents dumpFileContents;
    private RestoreFile[] cachedBrowseResults = null;
    private RestoreFile[] cachedSearchResults = null;
    private String cachedFileSystemName = "";
    private long currentRestoreJobId = -1L;
    private int restoreSearchCnt;

    public SamQFSSystemFSManagerImpl(SamQFSSystemModel model) {
        this.theModel = (SamQFSSystemModelImpl)model;
    }

    private FsmVersion getVersion45() {
        if (this.version45 == null) {
            this.version45 = new FsmVersion("4.5", this.theModel.getHostname());
        }
        return this.version45;
    }

    public String[] getAllFileSystemNames() throws SamFSException {
        String[] fsNames = new String[]{};
        FileSystem[] fs2 = this.getAllFileSystems();
        if (fs2 != null) {
            fsNames = new String[fs2.length];
            for (int i = 0; i < fs2.length; ++i) {
                fsNames[i] = fs2[i].getName();
            }
        }
        return fsNames;
    }

    public String[] getFileSystemNamesAllTypes() throws SamFSException {
        return this.getAllFileSystemNames();
    }

    public FileSystem[] getAllFileSystems() throws SamFSException {
        return this.fsMap.values().toArray(new FileSystem[0]);
    }

    public FileSystem[] getAllFileSystems(int archivingType) throws SamFSException {
        ArrayList<FileSystem> fsList = new ArrayList<FileSystem>();
        FileSystem[] fsAll = this.fsMap.values().toArray(new FileSystem[0]);
        if (fsAll != null && fsAll.length > 0) {
            for (int i = 0; i < fsAll.length; ++i) {
                if (fsAll[i].getArchivingType() != archivingType) continue;
                fsList.add(fsAll[i]);
            }
        }
        return fsList.toArray(new FileSystem[0]);
    }

    public GenericFileSystem[] getNonSAMQFileSystems() throws SamFSException {
        if (this.genericFSMap.isEmpty()) {
            GenericFileSystemImpl fs1 = new GenericFileSystemImpl(this.theModel.getHostname(), "/dev/dsk/c0t0d0s0", "UFS", 0, "/", 1000000L, 750000L);
            this.genericFSMap.put("/dev/dsk/c0t0d0s0", fs1);
        }
        return this.genericFSMap.values().toArray(new GenericFileSystem[0]);
    }

    public GenericFileSystem getGenericFileSystem(String fsName) throws SamFSException {
        GenericFileSystem fs2 = (GenericFileSystem)this.genericFSMap.get(fsName);
        if (fs2 == null) {
            fs2 = (GenericFileSystem)this.fsMap.get(fsName);
        }
        return fs2;
    }

    public FileSystem getFileSystem(String fsName) throws SamFSException {
        return (FileSystem)this.getGenericFileSystem(fsName);
    }

    public FileSystemMountProperties getDefaultMountProperties(int fsType, int archType, int dauSize, boolean stripedGrp, int shareStatus, boolean multiReader) throws SamFSException {
        return new FileSystemMountPropertiesImpl(fsType, archType, shareStatus);
    }

    public String[] checkSlicesForOverlaps(String[] slices) throws SamFSException {
        return new String[0];
    }

    public FileSystem createFileSystem(String fsName, int fsType, int archType, int equipOrdinal, String mountPoint, int shareStatus, int DAUSize, FileSystemMountProperties mountProps, DiskCache[] metadataDevices, DiskCache[] dataDevices, StripedGroup[] stripedGroups) throws SamFSException {
        if (fsName == null || fsName.equals("") || fsName.equals(new String())) {
            throw new SamFSException("INVALID_FILE_SYSTEM_NAME");
        }
        FileSystem existingFS = (FileSystem)this.fsMap.get(fsName);
        if (existingFS != null) {
            throw new SamFSException("EXISTING_FILE_SYSTEM");
        }
        ArrayList<DiskCache> changeDisks = new ArrayList<DiskCache>();
        ArrayList<DiskCache> meta = null;
        if (metadataDevices != null) {
            meta = new ArrayList<DiskCache>();
            for (int i = 0; i < metadataDevices.length; ++i) {
                meta.add(metadataDevices[i]);
                changeDisks.add(metadataDevices[i]);
                ((DiskCacheImpl)metadataDevices[i]).setDiskCacheType(1);
                int index = this.theModel.getAvailableAUs().indexOf(metadataDevices[i]);
                if (index == -1) continue;
                this.theModel.getAvailableAUs().remove(index);
            }
        }
        ArrayList<DiskCache> data = null;
        if (dataDevices != null) {
            data = new ArrayList<DiskCache>();
            for (int i = 0; i < dataDevices.length; ++i) {
                data.add(dataDevices[i]);
                changeDisks.add(dataDevices[i]);
                if (meta != null && meta.size() > 0) {
                    ((DiskCacheImpl)dataDevices[i]).setDiskCacheType(3);
                } else {
                    ((DiskCacheImpl)dataDevices[i]).setDiskCacheType(2);
                }
                int index = this.theModel.getAvailableAUs().indexOf(dataDevices[i]);
                if (index == -1) continue;
                this.theModel.getAvailableAUs().remove(index);
            }
        }
        ArrayList<StripedGroup> grp = null;
        if (stripedGroups != null) {
            grp = new ArrayList<StripedGroup>();
            for (int i = 0; i < stripedGroups.length; ++i) {
                grp.add(stripedGroups[i]);
                this.assignEQ(stripedGroups[i]);
                DiskCache[] disks = stripedGroups[i].getMembers();
                if (disks == null) continue;
                for (int j = 0; j < disks.length; ++j) {
                    changeDisks.add(disks[j]);
                    int index = this.theModel.getAvailableAUs().indexOf(disks[j]);
                    if (index == -1) continue;
                    this.theModel.getAvailableAUs().remove(index);
                }
            }
        }
        Integer key = new Integer(equipOrdinal);
        if (this.theModel.getEqMap().get(key) != null) {
            throw new SamFSException("EQUIPMENT_ORDINAL_IN_USE");
        }
        if (equipOrdinal == -1) {
            ++this.theModel.eqCounter;
            equipOrdinal = this.theModel.eqCounter;
            key = new Integer(equipOrdinal);
        }
        this.assignEQ(changeDisks.toArray(new BaseDevice[0]));
        this.setFamily(changeDisks.toArray(new BaseDevice[0]), fsName, equipOrdinal);
        FileSystemImpl fs2 = new FileSystemImpl(fsName, fsType, archType, equipOrdinal, mountPoint, 0, shareStatus, DAUSize, null, new GregorianCalendar(), mountProps, meta, data, grp, null, null, null, "/var/opt/SUNWsamfs/fs/fslog");
        fs2.setModel(this.theModel);
        this.fsMap.put(fs2.getName(), fs2);
        this.theModel.getEqMap().put(key, fs2);
        this.theModel.getDataStore().resetAvailableAllocatableUnits(null);
        this.theModel.getDataStore().clearTemporaryStripedGroups();
        if (archType == 2) {
            FSArchiveDirectiveImpl dir = new FSArchiveDirectiveImpl(fs2.getName());
            ((SamQFSSystemArchiveManager43Impl)this.theModel.getSamQFSSystemArchiveManager43()).addFSGeneralArchiveDirective(dir);
        }
        return fs2;
    }

    public FileSystem createFileSystem(String fsName, int fsType, int archType, int equipOrdinal, String mountPoint, int shareStatus, int DAUSize, FileSystemMountProperties mountProps, DiskCache[] metadataDevices, DiskCache[] dataDevices, boolean mountAtBoot, boolean createMountPoint, boolean mountAfterCreate) throws SamFSMultiStepOpException, SamFSException {
        FileSystem fs2 = this.createFileSystem(fsName, fsType, archType, equipOrdinal, mountPoint, shareStatus, DAUSize, mountProps, metadataDevices, dataDevices, new StripedGroup[0]);
        if (mountAfterCreate) {
            fs2.mount();
        } else {
            fs2.unmount();
        }
        return fs2;
    }

    public FileSystem createFileSystem(String fsName, int fsType, int archType, int equipOrdinal, String mountPoint, int shareStatus, int DAUSize, FileSystemMountProperties mountProps, DiskCache[] metadataDevices, DiskCache[] dataDevices, StripedGroup[] stripedGroups, boolean single, boolean mountAtBoot, boolean createMountPoint, boolean mountAfterCreate) throws SamFSMultiStepOpException, SamFSException {
        if (stripedGroups == null) {
            stripedGroups = new StripedGroup[]{};
        }
        FileSystem fs2 = this.createFileSystem(fsName, fsType, archType, equipOrdinal, mountPoint, shareStatus, DAUSize, mountProps, metadataDevices, dataDevices, stripedGroups);
        if (mountAfterCreate) {
            fs2.mount();
        } else {
            fs2.unmount();
        }
        return fs2;
    }

    public FileSystem createHAFileSystem(String[] hostnames, String fsName, int fsType, int equipOrdinal, String mountPoint, int DAUSize, FileSystemMountProperties mountProps, DiskCache[] metadataDevices, DiskCache[] dataDevices, StripedGroup[] stripedGroups, boolean singleDAU, boolean createMountPoint, boolean mountAfterCreate) throws SamFSMultiHostException {
        if (stripedGroups == null) {
            stripedGroups = new StripedGroup[]{};
        }
        FileSystem fs2 = null;
        try {
            fs2 = this.createFileSystem(fsName, fsType, 3, equipOrdinal, mountPoint, 0, DAUSize, mountProps, metadataDevices, dataDevices, stripedGroups);
            if (mountAfterCreate) {
                fs2.mount();
            } else {
                fs2.unmount();
            }
            for (int i = 0; i < hostnames.length; ++i) {
                GenericFileSystemImpl newfs = new GenericFileSystemImpl(hostnames[i], fs2.getName(), fs2.getFSTypeName(), i == 0 ? fs2.getState() : 1, fs2.getMountPoint(), fs2.getCapacity(), fs2.getAvailableSpace());
                ((GenericFileSystemImpl)((Object)fs2)).addHAFSInstance(newfs);
            }
        }
        catch (SamFSException e) {
            throw new SamFSMultiHostException(e.getMessage());
        }
        ((GenericFileSystemImpl)((Object)fs2)).setHA(true);
        return fs2;
    }

    public void addHostToHAFS(FileSystem fs2, String host) throws SamFSMultiStepOpException, SamFSException {
        GenericFileSystemImpl newfs = new GenericFileSystemImpl(host, fs2.getName(), fs2.getFSTypeName(), 1, fs2.getMountPoint(), fs2.getCapacity(), fs2.getAvailableSpace());
        ((GenericFileSystemImpl)((Object)fs2)).addHAFSInstance(newfs);
    }

    public void removeHostFromHAFS(FileSystem fs2, String host) {
        ((GenericFileSystemImpl)((Object)fs2)).removeHAFSInstance(host);
    }

    public GenericFileSystem createUFS(DiskCache dev, String mountPoint, GenericMountOptions mountOpts, boolean mountAtBoot, boolean createMountPoint, boolean mountAfterCreate) throws SamFSMultiStepOpException, SamFSException {
        return new GenericFileSystemImpl(this.theModel.getHostname(), dev.getDevicePath(), "ufs", mountAfterCreate ? 0 : 1, mountPoint, 234567L, 123456L);
    }

    public void growFileSystem(FileSystem fs2, DiskCache[] metadataDevices, DiskCache[] dataDevices, StripedGroup[] stripedGroups) throws SamFSException {
        int i;
        if (fs2.getState() == 0) {
            throw new SamFSException("A mounted file system can not be grown.\nPlease unmount the file system first.");
        }
        if (metadataDevices != null) {
            for (int i2 = 0; i2 < metadataDevices.length; ++i2) {
                this.assignEQ(metadataDevices[i2]);
                ((DiskCacheImpl)metadataDevices[i2]).setDiskCacheType(1);
                int index = this.theModel.getAvailableAUs().indexOf(metadataDevices[i2]);
                if (index == -1) continue;
                this.theModel.getAvailableAUs().remove(index);
            }
        }
        int diskCacheType = 2;
        if (fs2.getFSType() == 0) {
            diskCacheType = 3;
        }
        if (dataDevices != null) {
            for (i = 0; i < dataDevices.length; ++i) {
                this.assignEQ(dataDevices[i]);
                ((DiskCacheImpl)dataDevices[i]).setDiskCacheType(diskCacheType);
                int index = this.theModel.getAvailableAUs().indexOf(dataDevices[i]);
                if (index == -1) continue;
                this.theModel.getAvailableAUs().remove(index);
            }
        }
        if (stripedGroups != null) {
            for (i = 0; i < stripedGroups.length; ++i) {
                this.assignEQ(stripedGroups[i]);
                DiskCache[] disks = stripedGroups[i].getMembers();
                if (disks == null) continue;
                for (int j = 0; j < disks.length; ++j) {
                    this.assignEQ(disks[j]);
                    int index = this.theModel.getAvailableAUs().indexOf(disks[j]);
                    if (index == -1) continue;
                    this.theModel.getAvailableAUs().remove(index);
                }
            }
        }
        ((FileSystemImpl)fs2).grow(metadataDevices, dataDevices, stripedGroups);
        this.theModel.getDataStore().resetAvailableAllocatableUnits(null);
    }

    public void createDirectory(String fullPath) throws SamFSException {
    }

    private DiskCache[] getAUs(boolean ha) {
        DiskCache[] availAUs = this.theModel.getAvailableAUs().toArray(new DiskCache[0]);
        if (availAUs == null) {
            return availAUs;
        }
        ArrayList<DiskCache> haAUs = new ArrayList<DiskCache>();
        for (int i = 0; i < availAUs.length; ++i) {
            if (ha != availAUs[i].isHA()) continue;
            haAUs.add(availAUs[i]);
        }
        availAUs = haAUs.toArray(availAUs);
        return availAUs;
    }

    public DiskCache[] discoverAvailableAllocatableUnits(String[] hosts) throws SamFSException {
        return this.getAUs(hosts != null);
    }

    public DiskCache[] discoverAllocatableUnits(String[] hosts) throws SamFSException {
        return this.discoverAvailableAllocatableUnits(hosts);
    }

    public DiskCache getAvailableDisk(String path) throws SamFSException {
        DiskCache disk = null;
        if (this.theModel.getAvailableAUs() != null) {
            for (int i = 0; i < this.theModel.getAvailableAUs().size(); ++i) {
                if (!((DiskCache)this.theModel.getAvailableAUs().get(i)).getDevicePath().equals(path)) continue;
                disk = (DiskCache)this.theModel.getAvailableAUs().get(i);
                break;
            }
        }
        return disk;
    }

    public StripedGroup createStripedGroup(String name, DiskCache[] disks) throws SamFSException {
        if (name == null || name == new String() || name == "") {
            name = "g" + this.stripeGroupIndex;
            ++this.stripeGroupIndex;
        }
        return new StripedGroupImpl(name, disks);
    }

    private void assignEQ(BaseDevice dev) throws SamFSException {
        ++this.theModel.eqCounter;
        dev.setEquipOrdinal(this.theModel.eqCounter);
    }

    private void assignEQ(BaseDevice[] dev) throws SamFSException {
        if (dev != null) {
            for (int i = 0; i < dev.length; ++i) {
                ++this.theModel.eqCounter;
                dev[i].setEquipOrdinal(this.theModel.eqCounter);
            }
        }
    }

    private void freeEQ(BaseDevice[] dev) throws SamFSException {
        if (dev != null) {
            for (int i = 0; i < dev.length; ++i) {
                Integer key = new Integer(dev[i].getEquipOrdinal());
                this.theModel.getEqMap().remove(key);
            }
        }
    }

    private void setFamily(BaseDevice[] dev, String family, int familyEQ) throws SamFSException {
        if (dev != null) {
            for (int i = 0; i < dev.length; ++i) {
                ((BaseDeviceImpl)dev[i]).setFamilySetName(family);
                ((BaseDeviceImpl)dev[i]).setFamilySetEquipOrdinal(familyEQ);
            }
        }
    }

    private void preCleanupDeleteFS(FileSystem fs2) throws SamFSException {
        StripedGroup[] grp;
        DiskCache[] data;
        if (fs2 == null) {
            throw new SamFSException("INVALID_FS");
        }
        ArrayList<DiskCache> freeList = new ArrayList<DiskCache>();
        DiskCache[] meta = fs2.getMetadataDevices();
        if (meta != null) {
            for (int i = 0; i < meta.length; ++i) {
                freeList.add(meta[i]);
                this.theModel.getAvailableAUs().add(meta[i]);
            }
        }
        if ((data = fs2.getDataDevices()) != null) {
            for (int i = 0; i < data.length; ++i) {
                freeList.add(data[i]);
                this.theModel.getAvailableAUs().add(data[i]);
            }
        }
        if ((grp = fs2.getStripedGroups()) != null) {
            for (int i = 0; i < grp.length; ++i) {
                DiskCache[] disks = grp[i].getMembers();
                if (disks == null) continue;
                for (int j = 0; j < disks.length; ++j) {
                    freeList.add(disks[j]);
                    this.theModel.getAvailableAUs().add(disks[j]);
                }
            }
        }
        this.freeEQ(freeList.toArray(new BaseDevice[0]));
    }

    private void postCleanupDeleteFS(FileSystem fs2) throws SamFSException {
        Integer key = new Integer(fs2.getEquipOrdinal());
        this.fsMap.remove(fs2.getName());
        this.theModel.getEqMap().remove(key);
        this.theModel.getDataStore().clearAvailableAllocatableUnits();
    }

    public void deleteFileSystem43(FileSystem fs2) throws SamFSException {
        this.preCleanupDeleteFS(fs2);
        ArchivePolCriteria[] polCrits = fs2.getArchivePolCriteriaForFS();
        if (polCrits != null) {
            for (int i = 0; i < polCrits.length; ++i) {
                polCrits[i].deleteFileSystemForCriteria(fs2.getName());
            }
        }
        ((SamQFSSystemArchiveManager43Impl)this.theModel.getSamQFSSystemArchiveManager43()).removeFSGeneralArchiveDirective(fs2.getName());
        if (fs2.getArchivingType() == 2 && this.theModel.getServerAPIVersion().compareTo("1.3") >= 0) {
            this.setMetadataDumpSchedParams(fs2.getName(), null);
        }
        this.postCleanupDeleteFS(fs2);
    }

    public ArchivePolCriteria[] getAllAvailablePolCriteria(FileSystem fs2) throws SamFSException {
        ArrayList<ArchivePolCriteria> available = new ArrayList<ArchivePolCriteria>();
        if (fs2 != null && fs2.getArchivingType() == 2) {
            ArchivePolicy[] policies = this.theModel.getSamQFSSystemArchiveManager43().getAllArchivePolicies();
            ArrayList<ArchivePolCriteria> tempList = new ArrayList<ArchivePolCriteria>();
            if (policies != null) {
                for (int i = 0; i < policies.length; ++i) {
                    if (policies[i].getPolicyType() != 1002 && policies[i].getPolicyType() != 1003) continue;
                    ArchivePolCriteria[] polCrits = ((ArchivePolicyImpl)policies[i]).getArchivePolCriteriaForFS(fs2.getName());
                    tempList.clear();
                    for (int j = 0; j < polCrits.length; ++j) {
                        tempList.add(polCrits[j]);
                    }
                    ArchivePolCriteria[] polTotCrits = policies[i].getArchivePolCriteria();
                    for (int j = 0; j < polTotCrits.length; ++j) {
                        int index = tempList.indexOf(polTotCrits[j]);
                        if (index != -1) continue;
                        available.add(polTotCrits[j]);
                    }
                }
            }
        }
        return available.toArray(new ArchivePolCriteria[0]);
    }

    public void deleteFileSystem(GenericFileSystem gfs) throws SamFSException {
        if (gfs.getFSTypeByProduct() == 13) {
            return;
        }
        FileSystem fs2 = (FileSystem)gfs;
        this.preCleanupDeleteFS(fs2);
        com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy[] pol = fs2.getArchivePoliciesForFS();
        if (pol != null) {
            for (int i = 0; i < pol.length; ++i) {
                pol[i].deleteFileSystemForPolicy(fs2);
            }
        }
        ((SamQFSSystemArchiveManager43Impl)this.theModel.getSamQFSSystemArchiveManager43()).removeFSGeneralArchiveDirective(fs2.getName());
        this.postCleanupDeleteFS(fs2);
    }

    public com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy[] getAllAvailableArchivePolicies(FileSystem fs2) throws SamFSException {
        int i;
        com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy[] pols;
        ArrayList<com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy> list = new ArrayList<com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy>();
        if (this.theModel != null && (pols = this.theModel.getSamQFSSystemArchiveManager().getAllArchivePolicies()) != null) {
            for (i = 0; i < pols.length; ++i) {
                list.add(pols[i]);
            }
        }
        if ((pols = fs2.getArchivePoliciesForFS()) != null && pols.length > 0) {
            for (i = 0; i < pols.length; ++i) {
                int index = list.indexOf(pols[i]);
                list.remove(index);
            }
        }
        return list.toArray(new com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy[0]);
    }

    public RemoteFile[] getDirEntries(int maxEntries, String dirPath, Filter filter) throws SamFSException {
        File file = new File(dirPath);
        if (!file.exists()) {
            return null;
        }
        if (file.isFile()) {
            return null;
        }
        File[] files = file.listFiles();
        RemoteFile[] remoteFiles = new RemoteFile[files.length];
        for (int i = 0; i < files.length; ++i) {
            remoteFiles[i] = new RemoteFile(files[i].getName(), files[i].length(), files[i].lastModified(), files[i].isDirectory());
        }
        return remoteFiles;
    }

    public RemoteFile[] getDirEntriesFromLocalCache(int startPos, int howMany) {
        return null;
    }

    private ArrayList getDumpFileList(String fileSystemName, String directory) {
        ArrayList<RestoreDumpFile> dumpFileList;
        TreeMap fsDumpFiles = (TreeMap)this.dumpFilesByFS.get(fileSystemName);
        if (fsDumpFiles == null) {
            fsDumpFiles = new TreeMap();
            this.dumpFilesByFS.put(fileSystemName, fsDumpFiles);
        }
        if ((dumpFileList = (ArrayList<RestoreDumpFile>)fsDumpFiles.get(directory)) == null) {
            dumpFileList = new ArrayList<RestoreDumpFile>();
            if (fsDumpFiles.size() == 0) {
                GregorianCalendar fileDate = new GregorianCalendar();
                SimpleDateFormat sdf = new SimpleDateFormat("MMddyy");
                File dirFile = new File(directory);
                String fileNamePrefix = fileSystemName + "-" + dirFile.getName() + "-";
                for (int i = 0; i < 4; ++i) {
                    String state = "offline";
                    Boolean isLocked = null;
                    Boolean isCompressed = null;
                    Boolean isIndexed = null;
                    Integer numEntries = null;
                    NonSyncStringBuffer fileName = new NonSyncStringBuffer().append(fileNamePrefix).append(sdf.format(fileDate.getTime()));
                    switch (i) {
                        case 0: {
                            state = "available";
                            isIndexed = Boolean.TRUE;
                            isCompressed = Boolean.TRUE;
                            isLocked = Boolean.TRUE;
                            numEntries = new Integer(6430);
                            break;
                        }
                        case 1: {
                            state = "unindexed";
                            isIndexed = Boolean.FALSE;
                            isCompressed = Boolean.FALSE;
                            isLocked = Boolean.FALSE;
                            numEntries = null;
                            break;
                        }
                        case 2: {
                            state = "compressed";
                            isIndexed = Boolean.FALSE;
                            isCompressed = Boolean.TRUE;
                            isLocked = Boolean.FALSE;
                            numEntries = null;
                            break;
                        }
                        case 3: {
                            state = "available";
                            isIndexed = Boolean.TRUE;
                            isCompressed = Boolean.FALSE;
                            isLocked = Boolean.FALSE;
                            numEntries = new Integer(5437);
                            break;
                        }
                        default: {
                            state = "unindexed";
                            isIndexed = Boolean.FALSE;
                            isCompressed = Boolean.TRUE;
                            isLocked = Boolean.FALSE;
                            numEntries = null;
                        }
                    }
                    if (!this.getVersion45().isAPICompatibleWithUI()) {
                        isIndexed = null;
                        isCompressed = null;
                        isLocked = null;
                        numEntries = null;
                    }
                    RestoreDumpFile dumpFile = new RestoreDumpFile(fileName.toString(), state, "1234567890", fileDate, fileDate, isLocked, isCompressed, isIndexed, numEntries);
                    dumpFileList.add(dumpFile);
                    fileDate.add(5, -1);
                }
            }
            fsDumpFiles.put(directory, dumpFileList);
        }
        return dumpFileList;
    }

    public void setMetadataDumpSchedParams(String fsName, DumpSched params) throws SamFSException {
        if (params == null) {
            this.fsDumpScheduleMap.remove(fsName);
        } else {
            this.fsDumpScheduleMap.put(fsName, params);
        }
    }

    public DumpSched getMetadataDumpSchedParams(String fsName) throws SamFSException {
        return (DumpSched)this.fsDumpScheduleMap.get(fsName);
    }

    public long startMetadataDump(String fsName, String fullDumpPath) throws SamFSException {
        FSDumpJobImpl job = new FSDumpJobImpl(fsName, fullDumpPath);
        SamQFSSystemJobManagerImpl jobMgr = (SamQFSSystemJobManagerImpl)this.theModel.getSamQFSSystemJobManager();
        jobMgr.addJob(job);
        FileSystemImpl fs2 = (FileSystemImpl)this.getFileSystem(fsName);
        fs2.addJob(job);
        File dumpFile = new File(fullDumpPath);
        String directory = dumpFile.getParent();
        String dumpName = dumpFile.getName();
        RestoreDumpFile newDumpFile = new RestoreDumpFile(dumpName, "unindexed", "1234567890", new GregorianCalendar(), new GregorianCalendar(), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null);
        ArrayList dumpFileList = this.getDumpFileList(fsName, directory);
        dumpFileList.add(newDumpFile);
        return job.getJobId();
    }

    public long enableDumpFileForUse(String fsName, String directory, String dumpFilename) throws SamFSException {
        ArrayList dumpFileList = this.getDumpFileList(fsName, directory);
        String fullPath = SamUtil.buildPath(directory, dumpFilename);
        if (dumpFileList == null) {
            return -1L;
        }
        Iterator iter = dumpFileList.iterator();
        while (iter.hasNext()) {
            RestoreDumpFile dumpFile = (RestoreDumpFile)iter.next();
            if (!dumpFile.getFileName().equals(dumpFilename)) continue;
            if (dumpFile.isAvailable()) {
                return 0L;
            }
            if (dumpFile.getIsIndexing()) {
                return dumpFile.getEnableDumpJobId();
            }
            SamQFSSystemJobManagerImpl jobMgr = (SamQFSSystemJobManagerImpl)this.theModel.getSamQFSSystemJobManager();
            EnableDumpJobImpl dumpEnableJob = new EnableDumpJobImpl(fsName, fullPath);
            jobMgr.addJob(dumpEnableJob);
            dumpFile.startMakingAvailable(dumpEnableJob.getJobId());
            return dumpEnableJob.getJobId();
        }
        return -1L;
    }

    public void cleanDump(String fsName, String directory, String dumpFilename) throws SamFSException {
        ArrayList dumpFileList = this.getDumpFileList(fsName, directory);
        if (dumpFileList == null) {
            return;
        }
        Iterator iter = dumpFileList.iterator();
        while (iter.hasNext()) {
            RestoreDumpFile dumpFile = (RestoreDumpFile)iter.next();
            if (!dumpFile.getFileName().equals(dumpFilename)) continue;
            dumpFile.makeUnindexed();
        }
    }

    public void deleteDump(String fsName, String directory, String dumpFilename) throws SamFSException {
        ArrayList dumpFileList = this.getDumpFileList(fsName, directory);
        if (dumpFileList == null) {
            return;
        }
        Iterator iter = dumpFileList.iterator();
        while (iter.hasNext()) {
            RestoreDumpFile dumpFile = (RestoreDumpFile)iter.next();
            if (!dumpFile.getFileName().equals(dumpFilename)) continue;
            iter.remove();
            break;
        }
    }

    public void setIsDumpRetainedPermanently(String fsName, String directory, String dumpName, boolean retainValue) {
        ArrayList dumpFileList = this.getDumpFileList(fsName, directory);
        if (dumpFileList == null) {
            return;
        }
        Iterator iter = dumpFileList.iterator();
        while (iter.hasNext()) {
            RestoreDumpFile dumpFile = (RestoreDumpFile)iter.next();
            if (!dumpFile.getFileName().equals(dumpName)) continue;
            dumpFile.setIsLocked(retainValue);
            break;
        }
    }

    public RestoreDumpFile[] getAvailableDumpFiles(String fsName, String directory) throws SamFSException {
        ArrayList dumpFileList = this.getDumpFileList(fsName, directory);
        Iterator iter = dumpFileList.iterator();
        while (iter.hasNext()) {
            RestoreDumpFile dumpFile = (RestoreDumpFile)iter.next();
            dumpFile.changeNextState();
        }
        this.updateSearchRestoreJobCounter();
        return dumpFileList.toArray(new RestoreDumpFile[dumpFileList.size()]);
    }

    public String getDumpFileTopLevelDirectory(String fsName, String directory, String dumpFile) {
        return ".";
    }

    public RestoreFile[] getDumpFileContents(String fsName, String directory, String dumpFilename, String browsePath, Filter filterCriteria, int maxCount, int startIdx, int endIdx) throws SamFSException {
        ArrayList<RestoreFile> filesList = new ArrayList<RestoreFile>();
        RestoreFile[] restoreFiles = this.generateRestoreFiles(fsName, maxCount);
        Filter newCriteria = new Filter();
        if (filterCriteria != null) {
            String newPattern = this.searchPatternToRegExp(filterCriteria.getNamePattern());
            newCriteria.filterOnNamePattern(true, newPattern);
        }
        for (int i = 0; i < restoreFiles.length && filesList.size() < maxCount; ++i) {
            RestoreFile file = restoreFiles[i];
            if (!browsePath.equals(file.getParentPath()) || !this.passesThroughFilter(newCriteria, file)) continue;
            filesList.add(file);
        }
        this.cachedBrowseResults = filesList.toArray(new RestoreFile[filesList.size()]);
        return this.cachedBrowseResults;
    }

    public long searchDumpFileContents(String fsName, String directory, String dumpFileName, Filter searchCriteria, int maxCount) throws SamFSException {
        this.verifyRestoreJobNotRunning();
        ArrayList<RestoreFile> filesList = new ArrayList<RestoreFile>();
        RestoreFile[] restoreFiles = this.generateRestoreFiles(fsName, maxCount);
        Filter newCriteria = new Filter();
        if (searchCriteria != null) {
            String newPattern = this.searchPatternToRegExp(searchCriteria.getNamePattern());
            newCriteria.filterOnNamePattern(true, newPattern);
        }
        if (searchCriteria != null) {
            for (int i = 0; i < restoreFiles.length && filesList.size() < maxCount; ++i) {
                RestoreFile file = restoreFiles[i];
                if (!this.passesThroughFilter(newCriteria, file)) continue;
                filesList.add(file);
            }
        }
        this.cachedSearchResults = filesList.toArray(new RestoreFile[filesList.size()]);
        this.cachedFileSystemName = fsName;
        SamQFSSystemJobManagerImpl jobMgr = (SamQFSSystemJobManagerImpl)this.theModel.getSamQFSSystemJobManager();
        String fullPath = SamUtil.buildPath(directory, dumpFileName);
        RestoreSearchJobImpl searchJob = new RestoreSearchJobImpl(fsName, fullPath, searchCriteria.getDisplayString());
        jobMgr.addJob(searchJob);
        this.currentRestoreJobId = searchJob.getJobId();
        this.restoreSearchCnt = 3;
        return this.currentRestoreJobId;
    }

    private void verifyRestoreJobNotRunning() throws SamFSException {
        if (this.currentRestoreJobId == -1L) {
            return;
        }
        BaseJob job = this.theModel.getSamQFSSystemJobManager().getJobById(this.currentRestoreJobId);
        if (job == null) {
            this.currentRestoreJobId = -1L;
            return;
        }
        if (job.getType() == 22) {
            RestoreSearchJob searchJob = (RestoreSearchJob)job;
            throw new SamFSException(SamUtil.getResourceString("A search job is already running.", searchJob.getFileSystemName()));
        }
        if (job.getType() == 23) {
            RestoreJob restoreJob = (RestoreJob)job;
            throw new SamFSException(SamUtil.getResourceString("A restore job is already running", restoreJob.getFileSystemName()));
        }
        throw new SamFSException("A <job type unknown> job is already running" + String.valueOf(job.getType()));
    }

    private void updateSearchRestoreJobCounter() throws SamFSException {
        if (this.restoreSearchCnt > 0) {
            --this.restoreSearchCnt;
            if (this.restoreSearchCnt == 0) {
                this.cancelSearchOrRestoreJob();
            }
        }
    }

    public RestoreFile[] getSearchResults(String fsName, int startIdx, int endIdx) throws SamFSException {
        RestoreFile[] files = null;
        if (this.currentRestoreJobId == -1L && this.cachedFileSystemName.equals(fsName)) {
            files = this.cachedSearchResults;
        }
        return files;
    }

    private void cancelSearchOrRestoreJob() throws SamFSException {
        if (this.currentRestoreJobId == -1L) {
            return;
        }
        BaseJob job = this.theModel.getSamQFSSystemJobManager().getJobById(this.currentRestoreJobId);
        if (job != null) {
            this.theModel.getSamQFSSystemJobManager().cancelJob(job);
        }
        this.currentRestoreJobId = -1L;
    }

    private RestoreFile[] generateRestoreFiles(String fsName, int maxCount) throws SamFSException {
        if (this.dumpFileContents == null || this.dumpFileContents.getRestoreFiles().length != maxCount) {
            this.dumpFileContents = new RestoreDumpFileContents(fsName, maxCount);
        }
        return this.dumpFileContents.getRestoreFiles();
    }

    private String searchPatternToRegExp(String searchPattern) {
        if (searchPattern == null) {
            return searchPattern;
        }
        StringTokenizer strTok = new StringTokenizer(searchPattern, "*?", true);
        StringBuffer newSearchPattern = new StringBuffer();
        while (strTok.hasMoreTokens()) {
            String tok = strTok.nextToken();
            if (tok.equals("?")) {
                newSearchPattern.append(".?");
                continue;
            }
            if (tok.equals("*")) {
                newSearchPattern.append(".*");
                continue;
            }
            newSearchPattern.append(tok);
        }
        return newSearchPattern.toString();
    }

    private boolean passesThroughFilter(Filter filter, RestoreFile file) throws SamFSException {
        if (filter == null) {
            return true;
        }
        String namePattern = filter.getNamePattern();
        if (namePattern != null) {
            try {
                if (!file.getFileName().matches(namePattern)) {
                    return false;
                }
            }
            catch (PatternSyntaxException e) {
                throw new SamFSException(SamUtil.getResourceString("FSRestore.snapshotContents.error.badNamePattern", e.getPattern()), (Throwable)e);
            }
        }
        return true;
    }

    public RestoreFile getRestoreFile(String fsName, String directory, String dumpFile, String fileName) throws SamFSException {
        for (int i = 0; i < 2; ++i) {
            RestoreFile[] files = null;
            switch (i) {
                case 0: {
                    files = this.cachedBrowseResults;
                    break;
                }
                case 1: {
                    files = this.cachedSearchResults;
                    break;
                }
            }
            if (files == null) continue;
            for (int j = 0; j < files.length; ++j) {
                RestoreFile file = files[j];
                if (!file.getAbsolutePath().equals(fileName)) continue;
                return file;
            }
        }
        return null;
    }

    public RestoreFile getEntireFSRestoreFile() throws SamFSException {
        RestoreFileImpl file = new RestoreFileImpl(true, ".", "0", "", "", "", new GregorianCalendar(), new GregorianCalendar(), null, null);
        file.setRestorePath(".");
        return file;
    }

    public long restoreFiles(String fsName, String directory, String dumpFile, int replaceType, RestoreFile[] files) throws SamFSException {
        this.verifyRestoreJobNotRunning();
        if (replaceType != 0 && replaceType != 1 && replaceType != 2) {
            throw new SamFSException("Invalid replace type:  " + String.valueOf(replaceType));
        }
        RestoreFile file = files[0];
        SamQFSSystemJobManagerImpl jobMgr = (SamQFSSystemJobManagerImpl)this.theModel.getSamQFSSystemJobManager();
        if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        RestoreJobImpl restoreJob = new RestoreJobImpl(fsName, directory + dumpFile, file.getAbsolutePath(), file.getRestorePath(), replaceType, file.getStageCopy());
        jobMgr.addJob(restoreJob);
        this.currentRestoreJobId = restoreJob.getJobId();
        this.restoreSearchCnt = 3;
        return this.currentRestoreJobId;
    }

    public StageFile[] getStageFiles(int maxEntries, String dirPath, Filter filter) throws SamFSException {
        return new StageFile[0];
    }

    public String[] getStageCopyDetails(String filePath) throws SamFSException {
        return new String[0];
    }

    public void stageFiles(int[] copy, String[] filePaths, int[] options) throws SamFSException {
    }
}

