/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.archive43;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.arc.DrvDirective;
import com.sun.netstorage.samqfs.web.model.archive43.DriveDirective;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.media.Library;

public class DriveDirectiveImpl
implements DriveDirective {
    private DrvDirective drv = null;
    private SamQFSSystemModelImpl model = null;
    private Library library = null;
    private int count = -1;

    public DriveDirectiveImpl(SamQFSSystemModelImpl model) {
        this.model = model;
    }

    public DriveDirectiveImpl(SamQFSSystemModelImpl model, Library library, int count) {
        this.model = model;
        this.library = library;
        this.count = count;
        if (library != null) {
            try {
                this.drv = new DrvDirective(library.getName(), count);
            }
            catch (Exception removeIt) {
                // empty catch block
            }
        }
    }

    public DriveDirectiveImpl(SamQFSSystemModelImpl model, DrvDirective drv) throws SamFSException {
        this.drv = drv;
        if (drv != null) {
            this.count = drv.getCount();
        }
    }

    public DrvDirective getJniDriveDirective() {
        return this.drv;
    }

    public String getLibraryName() {
        String name = new String();
        if (this.drv != null) {
            name = this.drv.getAutoLib();
        }
        return name;
    }

    public Library getLibrary() throws SamFSException {
        if (this.model != null && this.drv != null) {
            this.library = this.model.getSamQFSSystemMediaManager().getLibraryByName(this.drv.getAutoLib());
        }
        return this.library;
    }

    public void setLibrary(Library library) {
        this.library = library;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
        if (this.drv != null) {
            if (count != -1) {
                this.drv.setCount(count);
            } else {
                this.drv.resetCount();
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.library != null) {
            try {
                buf.append("Library: " + this.library.getName() + "\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            buf.append("Library: " + this.getLibraryName());
        }
        buf.append("Count: " + this.count + "\n");
        return buf.toString();
    }
}

