/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni;

import com.iplanet.jato.model.DefaultModel;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemSharedFSManager;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemSharedFSManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;

public class SamQFSAppModelImpl
extends DefaultModel
implements SamQFSAppModel {
    private HashMap map = new HashMap();
    private boolean dumpOn = false;
    private SamQFSSystemSharedFSManager sharedManager = null;

    public SamQFSAppModelImpl() throws SamFSException {
        String hostname;
        ArrayList<String> hostnames = new ArrayList<String>();
        try {
            BufferedReader in = new BufferedReader(new FileReader("/var/log/webconsole/host.conf"));
            if (in != null) {
                while ((hostname = in.readLine()) != null) {
                    hostnames.add(hostname);
                }
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < hostnames.size(); ++i) {
            if (!SamQFSUtil.isValidString((String)hostnames.get(i))) continue;
            hostname = (String)hostnames.get(i);
            this.map.put(hostname, new SamQFSSystemModelImpl(hostname));
        }
        try {
            BufferedReader in = new BufferedReader(new FileReader("/var/log/webconsole/pref.conf"));
            if (in != null) {
                String pref = in.readLine();
                if ("on".equals(pref)) {
                    this.dumpOn = true;
                }
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SamQFSSystemModel[] getAllSamQFSSystemModels() {
        return this.map.values().toArray(new SamQFSSystemModelImpl[0]);
    }

    public SamQFSSystemModel getSamQFSSystemModel(String hostname) throws SamFSException {
        SamQFSSystemModel[] list;
        if (hostname == null) {
            TraceUtil.trace1("cannot get model for null hostname");
            throw new SamFSException(null, -2001);
        }
        SamQFSSystemModel model = (SamQFSSystemModel)this.map.get(hostname);
        if (model == null && (list = this.getAllSamQFSSystemModels()) != null) {
            for (int i = 0; i < list.length; ++i) {
                String storedName = list[i].getServerHostname();
                if (storedName == null || storedName.compareToIgnoreCase(hostname) != 0) continue;
                model = list[i];
                break;
            }
        }
        if (model == null) {
            throw new SamFSException(null, -2001);
        }
        return model;
    }

    public String getInetHostName(String hostName) throws UnknownHostException {
        boolean existingHost = false;
        String inetHostName = "";
        String hostip = "";
        if (!SamQFSUtil.isValidString(hostName)) {
            throw new UnknownHostException("logic.unknownHost");
        }
        InetAddress addr = InetAddress.getByName(hostName);
        inetHostName = addr.getHostName();
        byte[] ipAddr = addr.getAddress();
        for (int i = 0; i < ipAddr.length; ++i) {
            if (i > 0) {
                hostip = hostip + ".";
            }
            hostip = hostip + (ipAddr[i] & 0xFF);
        }
        Object o = this.map.get(inetHostName);
        if (o != null) {
            return inetHostName;
        }
        o = this.map.get(hostip);
        if (o != null) {
            return inetHostName;
        }
        return null;
    }

    public void addHost(String host) throws SamFSException {
        String inetHostName = null;
        try {
            inetHostName = this.getInetHostName(host);
        }
        catch (UnknownHostException e) {
            throw new SamFSException("logic.unknownHost");
        }
        if (inetHostName != null) {
            this.map.remove(inetHostName);
            this.map.put(inetHostName, new SamQFSSystemModelImpl(inetHostName));
            throw new SamFSException("logic.existingHost");
        }
        this.map.put(host, new SamQFSSystemModelImpl(host));
        try {
            PrintWriter out = new PrintWriter(new FileWriter("/var/log/webconsole/host.conf", true));
            if (out != null) {
                out.println(host);
                out.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeHost(String hostname) throws SamFSException {
        if (SamQFSUtil.isValidString(hostname)) {
            this.map.remove(hostname);
            ArrayList<String> hostnames = new ArrayList<String>();
            BufferedReader in = null;
            PrintWriter out = null;
            try {
                in = new BufferedReader(new FileReader("/var/log/webconsole/host.conf"));
                if (in != null) {
                    String host;
                    while ((host = in.readLine()) != null) {
                        hostnames.add(host);
                    }
                    in.close();
                }
                if ((out = new PrintWriter(new FileWriter("/var/log/webconsole/host.conf", false))) != null) {
                    for (int i = 0; i < hostnames.size(); ++i) {
                        String host = (String)hostnames.get(i);
                        if (host.equals(hostname)) continue;
                        out.println(host);
                    }
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isDumpOn() throws SamFSException {
        return this.dumpOn;
    }

    public void setDumpOn(boolean dump) throws SamFSException {
        this.dumpOn = dump;
        String dumpVal = "off";
        if (dump) {
            dumpVal = new String("on");
        }
        try {
            PrintWriter out = new PrintWriter(new FileWriter("/var/log/webconsole/pref.conf", false));
            if (out != null) {
                out.println(dumpVal);
                out.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateDownServers() {
        SamQFSSystemModel[] models = this.getAllSamQFSSystemModels();
        if (models != null && models.length > 0) {
            for (int i = 0; i < models.length; ++i) {
                if (!models[i].isDown()) continue;
                String hostname = models[i].getHostname();
                SamQFSUtil.doPrint(hostname + " was down!");
                this.map.remove(hostname);
                this.map.put(hostname, new SamQFSSystemModelImpl(hostname));
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("No. of hosts = " + this.map.size() + ".\n");
        if (this.map.size() > 0) {
            SamQFSSystemModelImpl[] systems = this.map.values().toArray(new SamQFSSystemModelImpl[0]);
            for (int i = 0; i < this.map.size(); ++i) {
                buf.append(systems[i].toString());
            }
        }
        return buf.toString();
    }

    public SamQFSSystemSharedFSManager getSamQFSSystemSharedFSManager() {
        if (this.sharedManager == null) {
            this.sharedManager = new SamQFSSystemSharedFSManagerImpl(this);
        }
        return this.sharedManager;
    }

    public void cleanup() {
        SamQFSSystemModel[] models = this.getAllSamQFSSystemModels();
        if (models != null) {
            for (int i = 0; i < models.length; ++i) {
                if (models[i] == null) continue;
                ((SamQFSSystemModelImpl)models[i]).terminateConn();
            }
        }
        if (this.sharedManager != null) {
            this.sharedManager.freeResources();
            this.sharedManager = null;
        }
        this.map = new HashMap(0);
    }
}

