/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiHostException;
import com.sun.netstorage.samqfs.mgmt.fs.DiskDev;
import com.sun.netstorage.samqfs.mgmt.fs.EQ;
import com.sun.netstorage.samqfs.mgmt.fs.FS;
import com.sun.netstorage.samqfs.mgmt.fs.FSInfo;
import com.sun.netstorage.samqfs.mgmt.fs.StripedGrp;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.fs.SharedMember;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.media.DiskCache;
import com.sun.netstorage.samqfs.web.model.media.StripedGroup;
import java.util.ArrayList;

public class MultiHostUtil {
    protected static SamQFSAppModel app = null;

    public static SamQFSAppModel getApp() throws SamFSException {
        if (app == null) {
            app = SamQFSFactory.getSamQFSAppModel();
        }
        return app;
    }

    public static int countOrdinalsRequired(DiskDev[] meta, DiskDev[] data, StripedGrp[] groups) {
        int count = 1;
        if (meta != null) {
            count += meta.length;
        }
        if (data != null) {
            count += data.length;
        }
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                DiskDev[] disks = groups[i].getMembers();
                count += disks.length;
            }
        }
        return count;
    }

    public static int countOrdinalsRequired(DiskCache[] meta, DiskCache[] data, StripedGroup[] groups) {
        int count = 1;
        if (meta != null) {
            count += meta.length;
        }
        if (data != null) {
            count += data.length;
        }
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                DiskCache[] disks = groups[i].getMembers();
                count += disks.length;
            }
        }
        return count;
    }

    public static SamQFSSystemModelImpl getSystemModel(String hostName, ArrayList errorHostNames, ArrayList errorExceptions) {
        SamQFSSystemModelImpl model = null;
        try {
            if (app == null) {
                app = MultiHostUtil.getApp();
            }
            if ((model = (SamQFSSystemModelImpl)app.getSamQFSSystemModel(hostName)).isDown()) {
                errorHostNames.add(hostName);
                errorExceptions.add(new SamFSException("logic.hostIsDown"));
                model = null;
            }
        }
        catch (SamFSException e) {
            errorHostNames.add(hostName);
            errorExceptions.add(new SamFSException("logic.invalidHostName"));
            System.out.println("system model was null for " + hostName);
        }
        return model;
    }

    public static SamQFSSystemModelImpl[] getSystemModels(String[] hostNames) throws SamFSMultiHostException {
        ArrayList errorHostNames = new ArrayList();
        ArrayList errorExceptions = new ArrayList();
        SamQFSSystemModelImpl[] models = new SamQFSSystemModelImpl[hostNames.length];
        for (int i = 0; i < hostNames.length; ++i) {
            models[i] = MultiHostUtil.getSystemModel(hostNames[i], errorHostNames, errorExceptions);
        }
        if (!errorHostNames.isEmpty()) {
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
        return models;
    }

    public static SamQFSSystemModelImpl[] getSystemModels(SharedMember[] members) throws SamFSMultiHostException {
        ArrayList errorHostNames = new ArrayList();
        ArrayList errorExceptions = new ArrayList();
        SamQFSSystemModelImpl[] models = new SamQFSSystemModelImpl[members.length];
        for (int i = 0; i < members.length; ++i) {
            models[i] = MultiHostUtil.getSystemModel(members[i].getHostName(), errorHostNames, errorExceptions);
        }
        if (!errorHostNames.isEmpty()) {
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
        return models;
    }

    public static int getAvailableOrdinals(int count, SamQFSSystemModelImpl[] models) throws SamFSMultiHostException {
        ArrayList<String> errorHostNames = new ArrayList<String>();
        ArrayList<SamFSException> errorExceptions = new ArrayList<SamFSException>();
        int firstAvailableOrdinal = 0;
        int currentHost = 0;
        try {
            int[] in_use = new int[]{};
            EQ eq = null;
            for (currentHost = 0; currentHost < models.length; ++currentHost) {
                eq = FS.getEqOrdinals((Ctx)models[currentHost].getJniContext(), (int)count, (int[])in_use);
                in_use = eq.getEqsInUse();
            }
            firstAvailableOrdinal = eq.getFirstFreeEq();
        }
        catch (SamFSException e) {
            errorHostNames.add(models[currentHost].getHostname());
            errorExceptions.add(e);
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
        return firstAvailableOrdinal;
    }

    protected void verifyEQsAreAvailOnNewHost(FSInfo fsInfo, SamQFSSystemModelImpl hostModel) throws SamFSException {
        int i;
        DiskDev[] dataDevices = fsInfo.getDataDevices();
        DiskDev[] metaDevices = fsInfo.getMetadataDevices();
        StripedGrp[] stripedGroups = fsInfo.getStripedGroups();
        int countEqs = MultiHostUtil.countOrdinalsRequired(metaDevices, dataDevices, stripedGroups);
        int[] eqs = new int[countEqs];
        int eqIndex = 0;
        for (i = 0; i < dataDevices.length; ++i) {
            eqs[eqIndex++] = dataDevices[i].getEquipOrdinal();
        }
        for (i = 0; i < metaDevices.length; ++i) {
            eqs[eqIndex++] = metaDevices[i].getEquipOrdinal();
        }
        for (i = 0; i < stripedGroups.length; ++i) {
            DiskDev[] disks = stripedGroups[i].getMembers();
            for (int j = 0; j < disks.length; ++j) {
                eqs[eqIndex++] = disks[j].getEquipOrdinal();
            }
        }
        eqs[eqIndex] = fsInfo.getEqu();
        FS.checkEqOrdinals((Ctx)hostModel.getJniContext(), (int[])eqs);
    }
}

