/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.fs;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.util.ConversionUtil;
import java.io.File;
import java.util.GregorianCalendar;
import java.util.Properties;

public class RemoteFile
extends File {
    protected boolean isDirectory;
    protected long lastModifiedTime;
    protected GregorianCalendar lastModTimeCal;
    protected long size;
    protected String linkTarget;
    static final int TYPE_MISSING = 0;
    static final int TYPE_REGFILE = 1;
    static final int TYPE_DIRFILE = 2;
    static final int TYPE_RELFILE = 3;
    static final int TYPE_NOTFILE = 4;
    static final String KEY_SIZE = "size";
    static final String KEY_CREATED = "created";
    static final String KEY_MODIFIED = "modified";
    static final String KEY_LINKTARGET = "target";

    public RemoteFile(String name) {
        super(name);
    }

    public RemoteFile(String name, long size, long modifiedTime, boolean isDir) {
        super(name);
        this.size = size;
        this.lastModifiedTime = modifiedTime * 1000L;
        this.lastModTimeCal = new GregorianCalendar();
        this.lastModTimeCal.setTimeInMillis(modifiedTime * 1000L);
        this.isDirectory = isDir;
    }

    void setLinkTarget(String targetPath) {
        this.linkTarget = targetPath;
    }

    public RemoteFile(String name, int status, Properties fileProps) throws SamFSException {
        this(name, ConversionUtil.strToLongVal(fileProps.getProperty(KEY_SIZE)), ConversionUtil.strToLongVal(fileProps.getProperty(KEY_MODIFIED)), status == 2);
        this.setLinkTarget(fileProps.getProperty(KEY_LINKTARGET));
    }

    public long length() {
        return this.size;
    }

    public GregorianCalendar lastModTimeCal() {
        return this.lastModTimeCal;
    }

    public long lastModified() {
        return this.lastModifiedTime;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isFile() {
        return !this.isDirectory;
    }

    public String getLinkTarget() {
        return this.linkTarget;
    }

    public String toString() {
        String s = this.getName() + (this.isDirectory() ? "/" : "");
        s = s + (this.linkTarget == null ? "" : "-> " + this.linkTarget) + "\t" + this.size;
        return s;
    }
}

