/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.fs;

import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.fs.FileSystemMountProperties;

public class FileSystemMountPropsBase
implements FileSystemMountProperties {
    protected FileSystem fs = null;
    protected int hwm = -1;
    protected int lwm = -1;
    protected int stripeWidth = -1;
    protected boolean traceOn = false;
    protected boolean mountInBackground = false;
    protected int noOfMountRetries = -1;
    protected int metadataRefreshRate = -1;
    protected long minBlockAllocation = -1L;
    protected int minBlockAllocationUnit = -1;
    protected long maxBlockAllocation = -1L;
    protected int maxBlockAllocationUnit = -1;
    protected int readLeaseDuration = -1;
    protected int writeLeaseDuration = -1;
    protected int appendLeaseDuration = -1;
    protected int maxConcurrentStreams = -1;
    protected int leaseTimeout = -1;
    protected boolean multiHostWrite = false;
    protected boolean consistencyChecking = false;
    protected int defaultPartialReleaseSize = -1;
    protected int defaultPartialReleaseSizeUnit = -1;
    protected int defaultMaxPartialReleaseSize = -1;
    protected int defaultMaxPartialReleaseSizeUnit = -1;
    protected long partialStageSize = -1L;
    protected int partialStageSizeUnit = -1;
    protected int noOfStageRetries = -1;
    protected long stageWindowSize = -1L;
    protected int stageWindowSizeUnit = -1;
    protected boolean archiverAutoRun = false;
    protected boolean archive = false;
    protected boolean readOnlyMount = false;
    protected boolean noSetUID = false;
    protected boolean quickWrite = false;
    protected long readAhead = -1L;
    protected int readAheadUnit = -1;
    protected long writeBehind = -1L;
    protected int writeBehindUnit = -1;
    protected long writeThrottle = -1L;
    protected int writeThrottleUnit = -1;
    protected int flushBehind = -1;
    protected int flushBehindUnit = -1;
    protected int stageFlushBehind = -1;
    protected int stageFlushBehindUnit = -1;
    protected boolean synchronizedMetadata = false;
    protected int metadataStripeWidth = -1;
    protected boolean softRAID = false;
    protected boolean forceDirectIO = false;
    protected boolean forceNFSAsync = false;
    protected int consecutiveReads = -1;
    protected int wellAlignedReadMin = -1;
    protected int wellAlignedReadMinUnit = -1;
    protected int misAlignedReadMin = -1;
    protected int misAlignedReadMinUnit = -1;
    protected int consecutiveWrites = -1;
    protected int wellAlignedWriteMin = -1;
    protected int wellAlignedWriteMinUnit = -1;
    protected int misAlignedWriteMin = -1;
    protected int misAlignedWriteMinUnit = -1;
    protected boolean directIOZeroing = false;

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public void setFileSystem(FileSystem fs2) {
        this.fs = fs2;
    }

    public int getHWM() {
        return this.hwm;
    }

    public void setHWM(int hwm) {
        this.hwm = hwm;
    }

    public int getLWM() {
        return this.lwm;
    }

    public void setLWM(int lwm) {
        this.lwm = lwm;
    }

    public int getStripeWidth() {
        return this.stripeWidth;
    }

    public void setStripeWidth(int width) {
        this.stripeWidth = width;
    }

    public boolean isTrace() {
        return this.traceOn;
    }

    public void setTrace(boolean traceOn) {
        this.traceOn = traceOn;
    }

    public boolean isMountInBackground() {
        return this.mountInBackground;
    }

    public void setMountInBackground(boolean mountInBackground) {
        this.mountInBackground = mountInBackground;
    }

    public int getNoOfMountRetries() {
        return this.noOfMountRetries;
    }

    public void setNoOfMountRetries(int noOfRetries) {
        this.noOfMountRetries = noOfRetries;
    }

    public int getMetadataRefreshRate() {
        return this.metadataRefreshRate;
    }

    public void setMetadataRefreshRate(int rate) {
        this.metadataRefreshRate = rate;
    }

    public long getMinBlockAllocation() {
        return this.minBlockAllocation;
    }

    public void setMinBlockAllocation(long noOfBlocks) {
        this.minBlockAllocation = noOfBlocks;
    }

    public int getMinBlockAllocationUnit() {
        return this.minBlockAllocationUnit;
    }

    public void setMinBlockAllocationUnit(int unit) {
        this.minBlockAllocationUnit = unit;
    }

    public long getMaxBlockAllocation() {
        return this.maxBlockAllocation;
    }

    public void setMaxBlockAllocation(long noOfBlocks) {
        this.maxBlockAllocation = noOfBlocks;
    }

    public int getMaxBlockAllocationUnit() {
        return this.maxBlockAllocationUnit;
    }

    public void setMaxBlockAllocationUnit(int unit) {
        this.maxBlockAllocationUnit = unit;
    }

    public int getReadLeaseDuration() {
        return this.readLeaseDuration;
    }

    public void setReadLeaseDuration(int duration) {
        this.readLeaseDuration = duration;
    }

    public int getWriteLeaseDuration() {
        return this.writeLeaseDuration;
    }

    public void setWriteLeaseDuration(int duration) {
        this.writeLeaseDuration = duration;
    }

    public int getAppendLeaseDuration() {
        return this.appendLeaseDuration;
    }

    public void setAppendLeaseDuration(int duration) {
        this.appendLeaseDuration = duration;
    }

    public int getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public void setMaxConcurrentStreams(int noOfStreams) {
        this.maxConcurrentStreams = noOfStreams;
    }

    public int getLeaseTimeout() {
        return this.leaseTimeout;
    }

    public void setLeaseTimeout(int leaseTimeout) {
        this.leaseTimeout = leaseTimeout;
    }

    public boolean isMultiHostWrite() {
        return this.multiHostWrite;
    }

    public void setMultiHostWrite(boolean write) {
        this.multiHostWrite = write;
    }

    public boolean isConsistencyChecking() {
        return this.consistencyChecking;
    }

    public void setConsistencyChecking(boolean consistencyChecking) {
        this.consistencyChecking = consistencyChecking;
    }

    public int getDefaultPartialReleaseSize() {
        return this.defaultPartialReleaseSize;
    }

    public void setDefaultPartialReleaseSize(int size) {
        this.defaultPartialReleaseSize = size;
    }

    public int getDefaultPartialReleaseSizeUnit() {
        return this.defaultPartialReleaseSizeUnit;
    }

    public void setDefaultPartialReleaseSizeUnit(int unit) {
        this.defaultPartialReleaseSizeUnit = unit;
    }

    public int getDefaultMaxPartialReleaseSize() {
        return this.defaultMaxPartialReleaseSize;
    }

    public void setDefaultMaxPartialReleaseSize(int size) {
        this.defaultMaxPartialReleaseSize = size;
    }

    public int getDefaultMaxPartialReleaseSizeUnit() {
        return this.defaultMaxPartialReleaseSizeUnit;
    }

    public void setDefaultMaxPartialReleaseSizeUnit(int unit) {
        this.defaultMaxPartialReleaseSizeUnit = unit;
    }

    public long getPartialStageSize() {
        return this.partialStageSize;
    }

    public void setPartialStageSize(long size) {
        this.partialStageSize = size;
    }

    public int getPartialStageSizeUnit() {
        return this.partialStageSizeUnit;
    }

    public void setPartialStageSizeUnit(int unit) {
        this.partialStageSizeUnit = unit;
    }

    public int getNoOfStageRetries() {
        return this.noOfStageRetries;
    }

    public void setNoOfStageRetries(int number) {
        this.noOfStageRetries = number;
    }

    public long getStageWindowSize() {
        return this.stageWindowSize;
    }

    public void setStageWindowSize(long size) {
        this.stageWindowSize = size;
    }

    public int getStageWindowSizeUnit() {
        return this.stageWindowSizeUnit;
    }

    public void setStageWindowSizeUnit(int unit) {
        this.stageWindowSizeUnit = unit;
    }

    public boolean isArchiverAutoRun() {
        return this.archiverAutoRun;
    }

    public void setArchiverAutoRun(boolean auto) {
        this.archiverAutoRun = auto;
    }

    public boolean isArchive() {
        return this.archive;
    }

    public void setArchive(boolean archive) {
        this.archive = archive;
    }

    public boolean isReadOnlyMount() {
        return this.readOnlyMount;
    }

    public void setReadOnlyMount(boolean readOnly) {
        this.readOnlyMount = readOnly;
    }

    public boolean isNoSetUID() {
        return this.noSetUID;
    }

    public void setNoSetUID(boolean noSetUID) {
        this.noSetUID = noSetUID;
    }

    public boolean isQuickWrite() {
        return this.quickWrite;
    }

    public void setQuickWrite(boolean quickWrite) {
        this.quickWrite = quickWrite;
    }

    public long getReadAhead() {
        return this.readAhead;
    }

    public void setReadAhead(long readAhead) {
        this.readAhead = readAhead;
    }

    public int getReadAheadUnit() {
        return this.readAheadUnit;
    }

    public void setReadAheadUnit(int unit) {
        this.readAheadUnit = unit;
    }

    public long getWriteBehind() {
        return this.writeBehind;
    }

    public void setWriteBehind(long writeBehind) {
        this.writeBehind = writeBehind;
    }

    public int getWriteBehindUnit() {
        return this.writeBehindUnit;
    }

    public void setWriteBehindUnit(int unit) {
        this.writeBehindUnit = unit;
    }

    public long getWriteThrottle() {
        return this.writeThrottle;
    }

    public void setWriteThrottle(long writeThrottle) {
        this.writeThrottle = writeThrottle;
    }

    public int getWriteThrottleUnit() {
        return this.writeThrottleUnit;
    }

    public void setWriteThrottleUnit(int unit) {
        this.writeThrottleUnit = unit;
    }

    public int getFlushBehind() {
        return this.flushBehind;
    }

    public void setFlushBehind(int flushBehind) {
        this.flushBehind = flushBehind;
    }

    public int getFlushBehindUnit() {
        return this.flushBehindUnit;
    }

    public void setFlushBehindUnit(int unit) {
        this.flushBehindUnit = unit;
    }

    public int getStageFlushBehind() {
        return this.stageFlushBehind;
    }

    public void setStageFlushBehind(int flushBehind) {
        this.stageFlushBehind = flushBehind;
    }

    public int getStageFlushBehindUnit() {
        return this.stageFlushBehindUnit;
    }

    public void setStageFlushBehindUnit(int unit) {
        this.stageFlushBehindUnit = unit;
    }

    public boolean isSynchronizedMetadata() {
        return this.synchronizedMetadata;
    }

    public void setSynchronizedMetadata(boolean sync) {
        this.synchronizedMetadata = sync;
    }

    public int getMetadataStripeWidth() {
        return this.metadataStripeWidth;
    }

    public void setMetadataStripeWidth(int width) {
        this.metadataStripeWidth = width;
    }

    public boolean isSoftRAID() {
        return this.softRAID;
    }

    public void setSoftRAID(boolean softRAID) {
        this.softRAID = softRAID;
    }

    public boolean isForceDirectIO() {
        return this.forceDirectIO;
    }

    public void setForceDirectIO(boolean forceDirectIO) {
        this.forceDirectIO = forceDirectIO;
    }

    public boolean isForceNFSAsync() {
        return this.forceNFSAsync;
    }

    public void setForceNFSAsync(boolean forceNFSAsync) {
        this.forceNFSAsync = forceNFSAsync;
    }

    public int getConsecutiveReads() {
        return this.consecutiveReads;
    }

    public void setConsecutiveReads(int number) {
        this.consecutiveReads = number;
    }

    public int getWellAlignedReadMin() {
        return this.wellAlignedReadMin;
    }

    public void setWellAlignedReadMin(int readMin) {
        this.wellAlignedReadMin = readMin;
    }

    public int getWellAlignedReadMinUnit() {
        return this.wellAlignedReadMinUnit;
    }

    public void setWellAlignedReadMinUnit(int unit) {
        this.wellAlignedReadMinUnit = unit;
    }

    public int getMisAlignedReadMin() {
        return this.misAlignedReadMin;
    }

    public void setMisAlignedReadMin(int readMin) {
        this.misAlignedReadMin = readMin;
    }

    public int getMisAlignedReadMinUnit() {
        return this.misAlignedReadMinUnit;
    }

    public void setMisAlignedReadMinUnit(int unit) {
        this.misAlignedReadMinUnit = unit;
    }

    public int getConsecutiveWrites() {
        return this.consecutiveWrites;
    }

    public void setConsecutiveWrites(int number) {
        this.consecutiveWrites = number;
    }

    public int getWellAlignedWriteMin() {
        return this.wellAlignedWriteMin;
    }

    public void setWellAlignedWriteMin(int writeMin) {
        this.wellAlignedWriteMin = writeMin;
    }

    public int getWellAlignedWriteMinUnit() {
        return this.wellAlignedWriteMinUnit;
    }

    public void setWellAlignedWriteMinUnit(int unit) {
        this.wellAlignedWriteMinUnit = unit;
    }

    public int getMisAlignedWriteMin() {
        return this.misAlignedWriteMin;
    }

    public void setMisAlignedWriteMin(int writeMin) {
        this.misAlignedWriteMin = writeMin;
    }

    public int getMisAlignedWriteMinUnit() {
        return this.misAlignedWriteMinUnit;
    }

    public void setMisAlignedWriteMinUnit(int unit) {
        this.misAlignedWriteMinUnit = unit;
    }

    public boolean isDirectIOZeroing() {
        return this.directIOZeroing;
    }

    public void setDirectIOZeroing(boolean directIOZeroing) {
        this.directIOZeroing = directIOZeroing;
    }

    public void optimizeForOracle(boolean cluster) {
        if (this.fs.getShareStatus() != 0) {
            this.setMultiHostWrite(true);
            this.setQuickWrite(true);
            if (cluster) {
                this.setStripeWidth(1);
                this.setSynchronizedMetadata(true);
                this.setForceDirectIO(true);
                this.setMaxConcurrentStreams(1024);
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.fs != null) {
            try {
                buf.append("Mount properties for Filesystem " + this.fs.getName());
                buf.append("\n\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        buf.append("Basic mount properties\n");
        buf.append("----------------------\n");
        buf.append("HWM: " + this.hwm + "\n");
        buf.append("LWM: " + this.lwm + "\n");
        buf.append("Stripe Width: " + this.stripeWidth + "\n");
        buf.append("Trace On: " + this.traceOn + "\n\n");
        buf.append("shared QFS mount properties\n");
        buf.append("---------------------------\n");
        buf.append("Mount In Background: " + this.mountInBackground + "\n");
        buf.append("No Of Mount Retries: " + this.noOfMountRetries + "\n");
        buf.append("Metadata Refresh Rate: " + this.metadataRefreshRate + "\n");
        buf.append("Minimum Block Allocation: " + this.minBlockAllocation + "\n");
        buf.append("Maximum Block Allocation: " + this.maxBlockAllocation + "\n");
        buf.append("Read Lease Duration: " + this.readLeaseDuration + "\n");
        buf.append("Write Lease Duration: " + this.writeLeaseDuration + "\n");
        buf.append("Append Lease Duration: " + this.appendLeaseDuration + "\n");
        buf.append("Maximum Concurrent Streams: " + this.maxConcurrentStreams + "\n");
        buf.append("MultiHost Write: " + this.multiHostWrite + "\n\n");
        buf.append("SAM mount properties\n");
        buf.append("--------------------\n");
        buf.append("Default Partial Release Size: " + this.defaultPartialReleaseSize + "\n");
        buf.append("Default Maximum Partial Release Size: " + this.defaultMaxPartialReleaseSize + "\n");
        buf.append("Partial Stage Size: " + this.partialStageSize + "\n");
        buf.append("No Of Stage Retries: " + this.noOfStageRetries + "\n");
        buf.append("Stage Window Size: " + this.stageWindowSize + "\n");
        buf.append("Archiver AutoRun: " + this.archiverAutoRun + "\n\n");
        buf.append("General file system mount properties\n");
        buf.append("------------------------------------\n");
        buf.append("ReadOnly Mount: " + this.readOnlyMount + "\n");
        buf.append("NoSetUID: " + this.noSetUID + "\n");
        buf.append("QuickWrite: " + this.quickWrite + "\n\n");
        buf.append("Performance tuning mount options\n");
        buf.append("--------------------------------\n");
        buf.append("Read Ahead: " + this.readAhead + "\n");
        buf.append("Write Behind: " + this.writeBehind + "\n");
        buf.append("Write BehindUnit: " + this.writeBehindUnit + "\n");
        buf.append("Write Throttle: " + this.writeThrottle + "\n");
        buf.append("Flush Behind: " + this.flushBehind + "\n");
        buf.append("Stage Flush Behind: " + this.stageFlushBehind + "\n");
        buf.append("Synchronized Metadata: " + this.synchronizedMetadata + "\n");
        buf.append("Metadata Stripe Width: " + this.metadataStripeWidth + "\n");
        buf.append("Soft RAID: " + this.softRAID + "\n");
        buf.append("Force Direct IO: " + this.forceDirectIO + "\n\n");
        buf.append("Direct IO discovery mount properties\n");
        buf.append("------------------------------------\n");
        buf.append("Consecutive Reads: " + this.consecutiveReads + "\n");
        buf.append("Well Aligned Read Min: " + this.wellAlignedReadMin + "\n");
        buf.append("Mis-aligned Read Min: " + this.misAlignedReadMin + "\n");
        buf.append("Consecutive Writes: " + this.consecutiveWrites + "\n");
        buf.append("Well Aligned Write Min: " + this.wellAlignedWriteMin + "\n");
        buf.append("Mis-aligned Write Min: " + this.misAlignedWriteMin + "\n\n");
        return buf.toString();
    }
}

