/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.media;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.media.StkVSN;
import com.sun.netstorage.samqfs.web.archive.MultiTableViewBase;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.common.CCPagelet;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.html.CCCheckBox;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;

public class ImportVSNView
extends MultiTableViewBase
implements CCPagelet {
    public static final String VSN_TABLE = "ImportVSNTable";
    public static final String VOLUME_IDS = "VolumeIDs";
    public static final String SELECTED_VOLUME_IDS = "SelectedVolumeIDs";
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;

    public ImportVSNView(View parent, Map models, String name) {
        super(parent, models, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren();
        this.registerChild(VOLUME_IDS, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = ImportVSNView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(SELECTED_VOLUME_IDS, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = ImportVSNView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        TraceUtil.trace3("Entering");
        CCActionTable child = null;
        if (name.equals(VSN_TABLE)) {
            child = this.createTable(name);
        } else if (name.equals(VOLUME_IDS) || name.equals(SELECTED_VOLUME_IDS)) {
            child = new CCHiddenField((ContainerView)this, name, null);
        } else {
            CCActionTableModel model = super.isChildSupported(name);
            if (model != null) {
                child = super.isChildSupported(name).createChild((View)this, name);
            }
        }
        if (child == null) {
            throw new IllegalArgumentException("Invalid Child '" + name + "'");
        }
        TraceUtil.trace3("Exiting");
        return child;
    }

    protected void initializeTableHeaders() {
        CCActionTableModel model = this.getTableModel(VSN_TABLE);
        model.setActionValue("IDColumn", (Object)"ImportVSN.table.heading.volumeid");
        model.setActionValue("ACSColumn", (Object)"ImportVSN.table.heading.acs");
        model.setActionValue("LSMColumn", (Object)"ImportVSN.table.heading.lsm");
        model.setActionValue("PanelColumn", (Object)"ImportVSN.table.heading.panel");
        model.setActionValue("RowColumn", (Object)"ImportVSN.table.heading.row");
        model.setActionValue("ColumnColumn", (Object)"ImportVSN.table.heading.column");
        model.setActionValue("PoolColumn", (Object)"ImportVSN.table.heading.pool");
        model.setActionValue("StatusColumn", (Object)"ImportVSN.table.heading.status");
        model.setActionValue("ServerColumn", (Object)"ImportVSN.table.heading.server");
        model.setActionValue("MediaColumn", (Object)"ImportVSN.table.heading.media");
        model.setActionValue("TypeColumn", (Object)"ImportVSN.table.heading.type");
    }

    public void populateTableModel(String serverName) throws SamFSException {
        String filterCriteria = (String)this.getParentViewBean().getPageSessionAttribute("psa_filter_criteria");
        String libShareAcsServer = (String)this.getParentViewBean().getPageSessionAttribute("psa_same_acsls_lib");
        CCActionTableModel tableModel = this.getTableModel(VSN_TABLE);
        CCActionTable myTable = (CCActionTable)this.getChild(VSN_TABLE);
        tableModel.clear();
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            Library myLibrary = sysModel.getSamQFSSystemMediaManager().getLibraryByName(this.getLibraryName());
            if (myLibrary == null) {
                throw new SamFSException(null, -2502);
            }
            StkVSN[] vsns = myLibrary.getVSNsForStkLib(filterCriteria);
            if (vsns == null) {
                return;
            }
            HashMap[] myMaps = this.createVSNHashMaps(libShareAcsServer);
            NonSyncStringBuffer volumeIDs = new NonSyncStringBuffer();
            for (int i = 0; i < vsns.length; ++i) {
                if (i > 0) {
                    tableModel.appendRow();
                }
                CCCheckBox myCheckBox = (CCCheckBox)myTable.getChild("SelectionCheckbox" + i);
                myCheckBox.setTitle("");
                myCheckBox.setTitleDisabled("");
                if (volumeIDs.length() > 0) {
                    volumeIDs.append(",");
                }
                tableModel.setValue("IDText", (Object)vsns[i].getName());
                volumeIDs.append(vsns[i].getName());
                tableModel.setValue("ACSText", (Object)new Integer(vsns[i].getAcsNum()));
                tableModel.setValue("LSMText", (Object)new Integer(vsns[i].getLsmNum()));
                tableModel.setValue("PanelText", (Object)new Integer(vsns[i].getPanelNum()));
                tableModel.setValue("RowText", (Object)new Integer(vsns[i].getRowID()));
                tableModel.setValue("ColumnText", (Object)new Integer(vsns[i].getColID()));
                tableModel.setValue("PoolText", (Object)new Integer(vsns[i].getPoolID()));
                String status = vsns[i].getStatus();
                tableModel.setValue("StatusText", (Object)status);
                String serverList = this.existsInOtherLibraries(vsns[i].getName(), myMaps);
                tableModel.setValue("ServerText", (Object)serverList);
                tableModel.setValue("MediaText", (Object)vsns[i].getMediaType());
                tableModel.setValue("TypeText", (Object)vsns[i].getUsageType());
                tableModel.setSelectionVisible(serverList.length() == 0 && "home".equals(status));
            }
            ((CCHiddenField)this.getChild(VOLUME_IDS)).setValue((Object)volumeIDs.toString());
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "populateTableModel", "unable to populate table model", serverName);
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ImportVSN.error.populate", sfe.getSAMerrno(), sfe.getMessage(), serverName);
        }
    }

    public void beginDisplay(DisplayEvent evt) throws ModelControlException {
        TraceUtil.trace3("Entering");
        this.initializeTableHeaders();
        TraceUtil.trace3("Exiting");
    }

    public String getPageletUrl() {
        String filterCriteria = (String)this.getParentViewBean().getPageSessionAttribute("psa_filter_criteria");
        if (filterCriteria != null) {
            return "/jsp/media/ImportVSNPagelet.jsp";
        }
        return "/jsp/archive/BlankPagelet.jsp";
    }

    private String getLibraryName() {
        return (String)this.getParentViewBean().getPageSessionAttribute("SAMQFS_LIBRARY_NAME");
    }

    private HashMap[] createVSNHashMaps(String libShareAcsServer) throws SamFSException {
        if (libShareAcsServer.length() == 0) {
            return new HashMap[0];
        }
        String[] libraryNames = libShareAcsServer.split(",");
        HashMap[] myMaps = new HashMap[libraryNames.length];
        for (int i = 0; i < libraryNames.length; ++i) {
            myMaps[i] = new HashMap();
            String[] entries = libraryNames[i].split("@");
            String libName = entries[0];
            String serverName = entries[1];
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            Library testLibrary = sysModel.getSamQFSSystemMediaManager().getLibraryByName(libName);
            if (testLibrary == null) {
                TraceUtil.trace1("Error encountered while creating VSN HashMap! ServerName: " + serverName + " LibName: " + libName);
                myMaps[i].put(serverName, null);
                continue;
            }
            myMaps[i].put(serverName, testLibrary.getVSNNamesForStkLib());
        }
        return myMaps;
    }

    private String existsInOtherLibraries(String vsnName, HashMap[] myMaps) {
        for (int i = 0; i < myMaps.length; ++i) {
            Iterator it = myMaps[i].keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                HashMap vsnMap = (HashMap)myMaps[i].get(key);
                if (!vsnMap.containsKey(vsnName)) continue;
                return key;
            }
        }
        return "";
    }

    public void handleImportButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        String selectedVolumeIDs = (String)this.getDisplayFieldValue(SELECTED_VOLUME_IDS);
        TraceUtil.trace2("Import: SelectedVolumeIDs are " + selectedVolumeIDs);
        String serverName = (String)this.getParentViewBean().getPageSessionAttribute("SERVER_NAME");
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            Library myLibrary = sysModel.getSamQFSSystemMediaManager().getLibraryByName(this.getLibraryName());
            if (myLibrary == null) {
                throw new SamFSException(null, -2502);
            }
            LogUtil.info(((Object)((Object)this)).getClass(), "handleImportButtonRequest", new NonSyncStringBuffer().append("Start importing VSNs ").append(selectedVolumeIDs).toString());
            myLibrary.importVSNInACSLS(selectedVolumeIDs.split(", "));
            LogUtil.info(((Object)((Object)this)).getClass(), "handleImportButtonRequest", new NonSyncStringBuffer().append("Done importing VSNs ").append(selectedVolumeIDs).toString());
            SamUtil.setInfoAlert((ContainerView)this.getParentViewBean(), "Alert", "success.summary", SamUtil.getResourceString("ImportVSN.success.importvsn", selectedVolumeIDs), serverName);
            this.getParentViewBean().removePageSessionAttribute("psa_filter_criteria");
        }
        catch (SamFSException samEx) {
            SamUtil.processException((Exception)((Object)samEx), ((Object)((Object)this)).getClass(), "handleImportButtonRequest", "Failed to import VSN", serverName);
            SamUtil.setErrorAlert((ContainerView)this, "Alert", "ImportVSN.error.importvsn", samEx.getSAMerrno(), samEx.getMessage(), serverName);
            TraceUtil.trace3("Exiting.  Fail to import VSN!");
        }
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

