/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.jobs;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.job.ArchiveJob;
import com.sun.netstorage.samqfs.web.model.job.ArchiveScanJob;
import com.sun.netstorage.samqfs.web.model.job.BaseJob;
import com.sun.netstorage.samqfs.web.model.job.EnableDumpJob;
import com.sun.netstorage.samqfs.web.model.job.FSDumpJob;
import com.sun.netstorage.samqfs.web.model.job.LabelJob;
import com.sun.netstorage.samqfs.web.model.job.MountJob;
import com.sun.netstorage.samqfs.web.model.job.ReleaseJob;
import com.sun.netstorage.samqfs.web.model.job.RestoreJob;
import com.sun.netstorage.samqfs.web.model.job.RestoreSearchJob;
import com.sun.netstorage.samqfs.web.model.job.SamfsckJob;
import com.sun.netstorage.samqfs.web.model.job.StageJob;
import com.sun.netstorage.samqfs.web.util.FormattedDate;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import java.util.ArrayList;

public final class CurrentJobsData
extends ArrayList {
    public static final String[] headings = new String[]{"Jobs.heading1", "Jobs.heading2", "Jobs.heading3", "Jobs.heading4"};
    public static final String[] filterOptions = new String[]{"Jobs.filterOptions0", "Jobs.filterOptions1", "Jobs.filterOptions2", "Jobs.filterOptions3", "Jobs.filterOptions4"};
    public static final String button = "Jobs.button1";

    public CurrentJobsData(String serverName) throws SamFSException {
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering CurrentJobsData");
        SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
        if (sysModel == null) {
            throw new SamFSException(null, -2001);
        }
        BaseJob[] baseJobs = sysModel.getSamQFSSystemJobManager().getJobsByCondition(0);
        if (baseJobs == null) {
            return;
        }
        for (int i = 0; i < baseJobs.length; ++i) {
            String vsn;
            String fileSystem;
            String description = "";
            String comma = ",";
            String jobTypeString = null;
            int jobType = baseJobs[i].getType();
            if (jobType == 1) {
                jobTypeString = "Jobs.jobType1";
                ArchiveJob archiveJob = (ArchiveJob)baseJobs[i];
                fileSystem = archiveJob.getFileSystemName();
                TraceUtil.trace3("fileSystem is " + fileSystem);
                String policyName = archiveJob.getPolicyName();
                TraceUtil.trace3("policyName is " + policyName);
                String copyNumber2 = Integer.toString(archiveJob.getCopyNumber());
                TraceUtil.trace3("copyNumber is " + copyNumber2);
                description = SamUtil.processJobDescription(new String[]{fileSystem, policyName, copyNumber2});
            } else if (jobType == 2) {
                jobTypeString = "Jobs.jobType5";
                ArchiveScanJob archiveScanJob = (ArchiveScanJob)baseJobs[i];
                fileSystem = archiveScanJob.getFileSystemName();
                description = SamUtil.processJobDescription(new String[]{fileSystem});
            } else if (jobType == 4) {
                jobTypeString = "Jobs.jobType2";
                StageJob stageJob = (StageJob)baseJobs[i];
                vsn = stageJob.getVSNName();
                description = SamUtil.processJobDescription(new String[]{vsn});
            } else if (jobType == 5) {
                jobTypeString = "Jobs.jobType3";
                ReleaseJob releaseJob = (ReleaseJob)baseJobs[i];
                fileSystem = releaseJob.getFileSystemName();
                String lwm = releaseJob.getLWM();
                String spaceConsumed = releaseJob.getConsumedSpacePercentage();
                description = SamUtil.processJobDescription(new String[]{fileSystem, lwm, spaceConsumed});
            } else if (jobType == 7) {
                jobTypeString = "Jobs.jobType4";
                MountJob mountJob = (MountJob)baseJobs[i];
                vsn = mountJob.getVSNName();
                String mediaType = SamUtil.getMediaTypeString(mountJob.getMediaType());
                description = SamUtil.processJobDescription(new String[]{vsn, mediaType});
            } else if (jobType == 8) {
                jobTypeString = "Jobs.jobType6";
                SamfsckJob fsckJob = (SamfsckJob)baseJobs[i];
                String fsName = fsckJob.getFileSystemName();
                String initUser = fsckJob.getInitiatingUser();
                String repair = "";
                repair = fsckJob.isRepair() ? "Jobs.repair" : "Jobs.non-repair";
                description = SamUtil.processJobDescription(new String[]{fsName, initUser, SamUtil.getResourceString(repair)});
            } else if (jobType == 9) {
                jobTypeString = "Jobs.jobType7";
                LabelJob labelJob = (LabelJob)baseJobs[i];
                String lib = labelJob.getLibraryName();
                String vsn2 = labelJob.getVSNName();
                description = SamUtil.processJobDescription(new String[]{lib, vsn2});
            } else if (jobType == 23) {
                jobTypeString = "Jobs.jobType.restore";
                RestoreJob restoreJob = (RestoreJob)baseJobs[i];
                description = SamUtil.processJobDescription(new String[]{restoreJob.getFileSystemName(), restoreJob.getFileName()});
            } else if (jobType == 22) {
                jobTypeString = "Jobs.jobType.restoreSearch";
                RestoreSearchJob searchJob = (RestoreSearchJob)baseJobs[i];
                description = SamUtil.processJobDescription(new String[]{searchJob.getFileSystemName(), searchJob.getDumpFileName()});
            } else if (jobType == 20) {
                jobTypeString = "Jobs.jobType.dump";
                FSDumpJob dumpJob = (FSDumpJob)baseJobs[i];
                description = dumpJob.getFileSystemName();
            } else if (jobType == 21) {
                jobTypeString = "Jobs.jobType.dumpEnable";
                EnableDumpJob dumpEnableJob = (EnableDumpJob)baseJobs[i];
                description = SamUtil.processJobDescription(new String[]{dumpEnableJob.getFileSystemName(), dumpEnableJob.getDumpFileName()});
            }
            TraceUtil.trace3("id is " + baseJobs[i].getJobId());
            TraceUtil.trace3("jobTypeString is " + jobTypeString);
            TraceUtil.trace3("timeString is " + SamUtil.getTimeString(baseJobs[i].getStartDateTime()));
            TraceUtil.trace3("description is " + description);
            super.add(new Object[]{new Long(baseJobs[i].getJobId()), jobTypeString, new FormattedDate(baseJobs[i].getStartDateTime(), SamUtil.getTimeFormat()), description});
        }
        TraceUtil.trace3("Exiting");
    }
}

