/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.fs.GenericFileSystem;
import com.sun.netstorage.samqfs.web.model.fs.NFSOptions;
import com.sun.netstorage.samqfs.web.util.BreadCrumbUtil;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.PageInfo;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.PropertySheetUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCBreadCrumbsModel;
import com.sun.web.ui.model.CCBreadCrumbsModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.breadcrumb.CCBreadCrumbs;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCHref;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.servlet.ServletException;

public class NFSDetailsViewBean
extends CommonViewBeanBase {
    public static final String PAGE_NAME = "NFSDetails";
    private static final String DEFAULT_DISPLAY_URL = "/jsp/fs/NFSDetails.jsp";
    private static final int TAB_NAME = 0;
    public static final String CHILD_BREADCRUMB = "BreadCrumb";
    public static final String CHILD_ALERT = "Alert";
    public static final String CHILD_FS_SUMMARY_HREF = "FileSystemSummaryHref";
    public static final String CHILD_FS_DETAILS_HREF = "FileSystemDetailsHref";
    public static final String CHILD_HIDDEN_ADDPOPUP = "AddPopupHiddenField";
    public static final String CHILD_ADDPOPUP_HREF = "AddPopupHref";
    public static final String CHILD_HIDDEN_EDITPOPUP = "EditPopupHiddenField";
    public static final String CHILD_EDITPOPUP_HREF = "EditPopupHref";
    public static final String CHILD_HIDDEN_SERVERNAME = "ServerNameHiddenField";
    public static final String CHILD_HIDDEN_FSMNTPOINT = "MntPointHiddenField";
    public static final String CHILD_HIDDEN_FSNAME = "FSNameHiddenField";
    public static final String CHILD_HIDDEN_ARRAY_SHAREDSTATE = "SharedStateHiddenField";
    public static final String CHILD_HIDDEN_ARRAY_DIRNAMES = "DirNamesHiddenField";
    public static final String CHILD_HIDDEN_CONFIRM_MESSAGE = "ConfirmMessageHiddenField";
    public static final String CHILD_ACTIONMENU = "ActionMenu";
    public static final String CHILD_ACTIONMENU_HREF = "ActionMenuHref";
    private CCPageTitleModel pageTitleModel;
    private CCPropertySheetModel propertySheetModel;
    private CCActionTableModel actionTableModel;
    private CCBreadCrumbsModel breadCrumbsModel;
    static /* synthetic */ Class class$com$sun$web$ui$view$breadcrumb$CCBreadCrumbs;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHref;
    static /* synthetic */ Class class$com$sun$web$ui$view$alert$CCAlertInline;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSDetailsViewBean;

    public NFSDetailsViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL, 0);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.createPageTitleModel();
        this.createPropertySheetModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren();
        PageTitleUtil.registerChildren((ContainerViewBase)this, this.pageTitleModel);
        PropertySheetUtil.registerChildren((ContainerViewBase)this, this.propertySheetModel);
        this.registerChild(CHILD_BREADCRUMB, class$com$sun$web$ui$view$breadcrumb$CCBreadCrumbs == null ? (class$com$sun$web$ui$view$breadcrumb$CCBreadCrumbs = NFSDetailsViewBean.class$("com.sun.web.ui.view.breadcrumb.CCBreadCrumbs")) : class$com$sun$web$ui$view$breadcrumb$CCBreadCrumbs);
        this.registerChild(CHILD_ACTIONMENU_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = NFSDetailsViewBean.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_FS_SUMMARY_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = NFSDetailsViewBean.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_FS_DETAILS_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = NFSDetailsViewBean.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_ALERT, class$com$sun$web$ui$view$alert$CCAlertInline == null ? (class$com$sun$web$ui$view$alert$CCAlertInline = NFSDetailsViewBean.class$("com.sun.web.ui.view.alert.CCAlertInline")) : class$com$sun$web$ui$view$alert$CCAlertInline);
        this.registerChild(CHILD_HIDDEN_ADDPOPUP, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = NFSDetailsViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_HIDDEN_EDITPOPUP, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = NFSDetailsViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_HIDDEN_FSMNTPOINT, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = NFSDetailsViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_HIDDEN_FSNAME, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = NFSDetailsViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_HIDDEN_SERVERNAME, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = NFSDetailsViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_HIDDEN_ARRAY_SHAREDSTATE, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = NFSDetailsViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_HIDDEN_ARRAY_DIRNAMES, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = NFSDetailsViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_HIDDEN_CONFIRM_MESSAGE, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = NFSDetailsViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_ADDPOPUP_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = NFSDetailsViewBean.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_EDITPOPUP_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = NFSDetailsViewBean.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        TraceUtil.trace3("Exiting");
    }

    protected View createChild(String name) {
        TraceUtil.trace3("Entering");
        TraceUtil.trace3("Creating child " + name);
        View child = null;
        if (super.isChildSupported(name)) {
            child = super.createChild(name);
        } else if (name.equals(CHILD_BREADCRUMB)) {
            this.breadCrumbsModel = new CCBreadCrumbsModel("filesystem.nfs.details.title");
            BreadCrumbUtil.createBreadCrumbs((ViewBean)this, name, this.breadCrumbsModel);
            child = new CCBreadCrumbs((View)this, (CCBreadCrumbsModelInterface)this.breadCrumbsModel, name);
        } else if (name.equals(CHILD_HIDDEN_ADDPOPUP) || name.equals(CHILD_HIDDEN_EDITPOPUP) || name.equals(CHILD_HIDDEN_FSMNTPOINT) || name.equals(CHILD_HIDDEN_FSNAME) || name.equals(CHILD_HIDDEN_SERVERNAME) || name.equals(CHILD_HIDDEN_ARRAY_SHAREDSTATE) || name.equals(CHILD_HIDDEN_ARRAY_DIRNAMES)) {
            child = new CCHiddenField((ContainerView)this, name, null);
        } else if (name.equals(CHILD_HIDDEN_CONFIRM_MESSAGE)) {
            StringBuffer msg = new StringBuffer();
            msg.append(SamUtil.getResourceString("filesystem.nfs.delete.confirm")).append("###").append(SamUtil.getResourceString("filesystem.nfs.unshare.confirm"));
            child = new CCHiddenField((ContainerView)this, name, (Object)msg.toString());
        } else if (name.equals(CHILD_FS_SUMMARY_HREF) || name.equals(CHILD_FS_DETAILS_HREF) || name.equals(CHILD_ACTIONMENU_HREF) || name.equals(CHILD_ADDPOPUP_HREF) || name.equals(CHILD_EDITPOPUP_HREF)) {
            child = new CCHref((ContainerView)this, name, null);
        } else if (name.equals(CHILD_ALERT)) {
            child = new CCAlertInline((ContainerView)this, name, null);
        } else if (PageTitleUtil.isChildSupported(this.pageTitleModel, name)) {
            child = PageTitleUtil.createChild((ContainerView)this, this.pageTitleModel, name);
        } else if (PropertySheetUtil.isChildSupported(this.propertySheetModel, name)) {
            child = PropertySheetUtil.createChild((ContainerView)this, this.propertySheetModel, name);
        } else {
            throw new IllegalArgumentException(new NonSyncStringBuffer("Invalid child name [").append(name).append("]").toString());
        }
        TraceUtil.trace3("Exiting");
        return child;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        this.loadPropertySheetModel();
        this.actionTableModel.setRowSelected(false);
        TraceUtil.trace3("Exiting");
    }

    private void createPageTitleModel() {
        if (this.pageTitleModel == null) {
            this.pageTitleModel = new CCPageTitleModel(SamUtil.createBlankPageTitleXML());
        }
    }

    private void createPropertySheetModel() {
        TraceUtil.trace3("Entering");
        if (this.propertySheetModel == null) {
            this.propertySheetModel = PropertySheetUtil.createModel("/jsp/fs/NFSDetailsPropertySheet.xml");
            this.actionTableModel = new CCActionTableModel(RequestManager.getRequestContext().getServletContext(), "/jsp/fs/NFSSharedDirectoryTable.xml");
            this.actionTableModel.setActionValue("AddButton", (Object)"common.button.add");
            this.actionTableModel.setActionValue("EditButton", (Object)"common.button.edit");
            this.actionTableModel.setActionValue("RemoveButton", (Object)"common.button.remove");
            this.actionTableModel.setActionValue("DirNameColumn", (Object)"filesystem.nfs.label.dirName");
            this.actionTableModel.setActionValue("StatusColumn", (Object)"filesystem.nfs.label.status");
            this.propertySheetModel.setModel("tablevalue", (Object)this.actionTableModel);
        }
        TraceUtil.trace3("Exiting");
    }

    private void loadPropertySheetModel() {
        TraceUtil.trace3("Entering");
        this.propertySheetModel.clear();
        try {
            String fsName = (String)this.getPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME");
            this.pageTitleModel.setPageTitleText(SamUtil.getResourceString("filesystem.nfs.details.pageTitle1", fsName));
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            TraceUtil.trace3("Getting the file system information for " + fsName);
            GenericFileSystem fs2 = sysModel.getSamQFSSystemFSManager().getGenericFileSystem(fsName);
            if (fs2 == null) {
                throw new SamFSException(null, -1000);
            }
            this.loadTableModel(fs2);
            this.propertySheetModel.setValue("nameValue", (Object)fsName);
            this.propertySheetModel.setValue("mountValue", (Object)fs2.getMountPoint());
            CCHiddenField hiddenMountPoint = (CCHiddenField)this.getChild(CHILD_HIDDEN_FSMNTPOINT);
            hiddenMountPoint.setValue((Object)fs2.getMountPoint());
            CCHiddenField hiddenfsName = (CCHiddenField)this.getChild(CHILD_HIDDEN_FSNAME);
            hiddenfsName.setValue((Object)fs2.getName());
            CCHiddenField hiddenServerName = (CCHiddenField)this.getChild(CHILD_HIDDEN_SERVERNAME);
            hiddenServerName.setValue((Object)this.getServerName());
            String state = null;
            int fsState = fs2.getState();
            state = fsState == 0 ? "FSSummary.mount" : "FSSummary.unmount";
            this.propertySheetModel.setValue("stateValue", (Object)state);
        }
        catch (SamFSException samEx) {
            SamUtil.processException((Exception)((Object)samEx), ((Object)((Object)this)).getClass(), "NFSDetailsViewBean()", "Failed to populate NFS information", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, "NFSDetailsViewBean.error.failedPopulate", samEx.getSAMerrno(), samEx.getMessage(), this.getServerName());
        }
        catch (ModelControlException modelControlException) {
            // empty catch block
        }
        TraceUtil.trace3("Exiting");
    }

    private void loadTableModel(GenericFileSystem fs2) throws SamFSException, ModelControlException {
        TraceUtil.trace3("Entering");
        TraceUtil.trace3("Clearing the action table model");
        this.actionTableModel.clear();
        this.actionTableModel.setTitle(SamUtil.getResourceString("filesystem.nfs.sharedDirectories.tableTitle", fs2.getName()));
        TraceUtil.trace3("Getting the NFS Options");
        NFSOptions[] optsList = fs2.getNFSOptions();
        if (optsList == null) {
            return;
        }
        TraceUtil.trace3("Reading the NFS options if any for this fs");
        StringBuffer sharedStatus = new StringBuffer();
        StringBuffer bufDirNames = new StringBuffer();
        for (int i = 0; i < optsList.length; ++i) {
            TraceUtil.trace3("i = " + i);
            if (i > 0) {
                this.actionTableModel.appendRow();
            }
            this.actionTableModel.setValue("DirNameText", (Object)optsList[i].getDirName());
            String existDirName = bufDirNames.toString();
            TraceUtil.trace3("existDirName = " + existDirName);
            if (existDirName.trim().equals("")) {
                bufDirNames.append(optsList[i].getDirName());
                TraceUtil.trace3("bufDirNames = " + bufDirNames.toString());
            } else {
                TraceUtil.trace3("Appending to buffer");
                bufDirNames.append("###").append(optsList[i].getDirName());
                TraceUtil.trace3("bufDirNames = " + bufDirNames.toString());
            }
            String fsStatus = optsList[i].isShared() ? "filesystem.nfs.status.shared" : "filesystem.nfs.status.unshared";
            this.actionTableModel.setValue("StatusText", (Object)fsStatus);
            String shareBoolStr = optsList[i].isShared() ? "true" : "false";
            String exist = sharedStatus.toString();
            exist = sharedStatus.toString() != null ? sharedStatus.toString() : "";
            TraceUtil.trace3("exist = " + exist);
            if (exist.trim().equals("")) {
                sharedStatus.append(shareBoolStr);
                TraceUtil.trace3("sharedStatus = " + sharedStatus.toString());
                continue;
            }
            TraceUtil.trace3("Appending to buffer");
            sharedStatus.append("###").append(shareBoolStr);
            TraceUtil.trace3("sharedStatus = " + sharedStatus.toString());
        }
        CCHiddenField hiddenArraySharedState = (CCHiddenField)this.getChild(CHILD_HIDDEN_ARRAY_SHAREDSTATE);
        hiddenArraySharedState.setValue((Object)sharedStatus.toString());
        CCHiddenField hiddenArrayDirNames = (CCHiddenField)this.getChild(CHILD_HIDDEN_ARRAY_DIRNAMES);
        hiddenArrayDirNames.setValue((Object)bufDirNames.toString());
        TraceUtil.trace3("Exiting");
    }

    public void handleFileSystemSummaryHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        String str = (String)this.getDisplayFieldValue(CHILD_FS_SUMMARY_HREF);
        ViewBean targetViewBean = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean = NFSDetailsViewBean.class$("com.sun.netstorage.samqfs.web.fs.FSSummaryViewBean")) : class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean);
        this.removePageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME");
        BreadCrumbUtil.breadCrumbPathBackward((ViewBean)this, PageInfo.getPageInfo().getPageNumber(targetViewBean.getName()), str);
        this.forwardTo(targetViewBean);
        TraceUtil.trace3("Exiting");
    }

    public void handleFileSystemDetailsHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        String str = (String)this.getDisplayFieldValue(CHILD_FS_DETAILS_HREF);
        ViewBean targetViewBean = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$FSDetailsViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$FSDetailsViewBean = NFSDetailsViewBean.class$("com.sun.netstorage.samqfs.web.fs.FSDetailsViewBean")) : class$com$sun$netstorage$samqfs$web$fs$FSDetailsViewBean);
        BreadCrumbUtil.breadCrumbPathBackward((ViewBean)this, PageInfo.getPageInfo().getPageNumber(targetViewBean.getName()), str);
        this.forwardTo(targetViewBean);
        TraceUtil.trace3("Exiting");
    }

    public void handleRemoveButtonRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        this.loadPropertySheetModel();
        NFSOptions[] nfsOpts = null;
        String dirName = "";
        CCActionTable child = (CCActionTable)this.getChild("tablevalue");
        child.restoreStateData();
        Integer[] selRows = this.actionTableModel.getSelectedRows();
        try {
            String fsName = (String)this.getPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME");
            String dirNamesHidden = (String)((CCHiddenField)this.getChild(CHILD_HIDDEN_ARRAY_DIRNAMES)).getValue();
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            GenericFileSystem fs2 = sysModel.getSamQFSSystemFSManager().getGenericFileSystem(fsName);
            if (fs2 != null && dirNamesHidden != null) {
                nfsOpts = fs2.getNFSOptions();
                String[] dirNamesList = dirNamesHidden.split("###");
                dirName = dirNamesList[selRows[0]];
                TraceUtil.trace3("Remove shared directory " + dirName);
                for (int n = 0; n < nfsOpts.length; ++n) {
                    TraceUtil.trace3("Comparing " + dirName + " with " + nfsOpts[n].getDirName());
                    if (!nfsOpts[n].getDirName().equals(dirName)) continue;
                    nfsOpts[n].setShareState("no");
                    fs2.setNFSOptions(nfsOpts[n]);
                    break;
                }
            }
            SamUtil.setInfoAlert((ContainerView)this, CHILD_ALERT, "success.summary", SamUtil.getResourceString("filesystem.nfs.msg.delete", dirName), this.getServerName());
        }
        catch (SamFSException samEx) {
            SamUtil.processException((Exception)((Object)samEx), ((Object)((Object)this)).getClass(), "NFSDetailsViewBean()", "Failed to remove NFS options for chosen directory", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, "NFSDetailsViewBean.error.remove", samEx.getSAMerrno(), samEx.getMessage(), this.getServerName());
        }
        this.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleEditPopupHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        String fsName = (String)this.getPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME");
        String value1 = (String)this.getDisplayFieldValue(CHILD_HIDDEN_EDITPOPUP);
        TraceUtil.trace3(new NonSyncStringBuffer().append("change options for directory ").append(value1).toString());
        StringTokenizer tokens = new StringTokenizer(value1, "###");
        int count = tokens.countTokens();
        TraceUtil.trace3("token count = " + count);
        String roChk = null;
        String rwChk = null;
        String rootChk = null;
        String roAccess = null;
        String rwAccess = null;
        String rootAccess = null;
        String dirName = tokens.nextToken();
        roChk = tokens.nextToken();
        rwChk = tokens.nextToken();
        rootChk = tokens.nextToken();
        roAccess = tokens.nextToken();
        rwAccess = tokens.nextToken();
        rootAccess = tokens.nextToken();
        TraceUtil.trace3("fsName = " + fsName + " dirName = " + dirName + " roChk = " + roChk + " roAccess = " + roAccess + " rwChk = " + rwChk + " rwAccess = " + rwAccess + " rootChk = " + rootChk + " rootAccess = " + rootAccess);
        if (fsName != null && dirName != null) {
            try {
                SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
                LogUtil.info(((Object)((Object)this)).getClass(), "handleEditPopupHrefRequest", new NonSyncStringBuffer().append("Start editing NFS options for ").append(dirName).append(" in file system ").append(fsName).toString());
                GenericFileSystem fs2 = sysModel.getSamQFSSystemFSManager().getGenericFileSystem(fsName);
                NFSOptions[] opts = fs2.getNFSOptions();
                for (int n = 0; n < opts.length; ++n) {
                    TraceUtil.trace3("Comparing " + dirName + " with " + opts[n].getDirName());
                    if (!opts[n].getDirName().equals(dirName)) continue;
                    if (roChk.equals("true")) {
                        String[] roAccessList = roAccess.trim().split(":");
                        opts[n].setReadOnlyAccessList(roAccessList);
                    } else {
                        opts[n].setReadOnlyAccessList(null);
                    }
                    if (rwChk.equals("true")) {
                        String[] rwAccessList = rwAccess.trim().split(":");
                        opts[n].setReadWriteAccessList(rwAccessList);
                    } else {
                        opts[n].setReadWriteAccessList(null);
                    }
                    if (rootChk.equals("true")) {
                        String[] rootAccessList = rootAccess.trim().split(":");
                        opts[n].setRootAccessList(rootAccessList);
                    } else {
                        opts[n].setRootAccessList(null);
                    }
                    fs2.setNFSOptions(opts[n]);
                }
                LogUtil.info(((Object)((Object)this)).getClass(), "handleEditPopupHrefRequest", new NonSyncStringBuffer().append("Finished editing NFS options for ").append(dirName).append(" in file system ").append(fsName).toString());
                SamUtil.setInfoAlert((ContainerView)this, CHILD_ALERT, "success.summary", SamUtil.getResourceString("filesystem.nfs.msg.edit", dirName), this.getServerName());
            }
            catch (SamFSException ex) {
                SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "NFSDetailsViewBean()", "Failed to edit NFS options", this.getServerName());
                SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, "NFSDetailsViewBean.error.failedEdit", ex.getSAMerrno(), ex.getMessage(), this.getServerName());
            }
        }
        TraceUtil.trace3("Forwarding to...");
        this.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleActionMenuHrefRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        this.loadPropertySheetModel();
        String op = null;
        String dirName = "";
        CCActionTable child = (CCActionTable)this.getChild("tablevalue");
        child.restoreStateData();
        String fsName = (String)this.getPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME");
        String dirNamesHidden = (String)((CCHiddenField)this.getChild(CHILD_HIDDEN_ARRAY_DIRNAMES)).getValue();
        String value = (String)this.getDisplayFieldValue(CHILD_ACTIONMENU);
        int option = 0;
        try {
            option = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        Integer[] selectedRows = this.actionTableModel.getSelectedRows();
        int index = selectedRows[0];
        String[] dirNamesList = dirNamesHidden.split("###");
        dirName = dirNamesList[index];
        if (option != 0) {
            try {
                SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
                GenericFileSystem fs2 = sysModel.getSamQFSSystemFSManager().getGenericFileSystem(fsName);
                NFSOptions selNFSOpt = null;
                if (fs2 != null && dirNamesHidden != null) {
                    NFSOptions[] nfsOpts = fs2.getNFSOptions();
                    for (int n = 0; n < nfsOpts.length; ++n) {
                        TraceUtil.trace3("Comparing " + dirName + " with " + nfsOpts[n].getDirName());
                        if (!nfsOpts[n].getDirName().equals(dirName)) continue;
                        selNFSOpt = nfsOpts[n];
                        break;
                    }
                    switch (option) {
                        case 1: {
                            op = "filesystem.nfs.msg.share";
                            if (selNFSOpt == null) break;
                            selNFSOpt.setShareState("yes");
                            fs2.setNFSOptions(selNFSOpt);
                            break;
                        }
                        case 2: {
                            op = "filesystem.nfs.msg.unshare";
                            if (selNFSOpt == null) break;
                            selNFSOpt.setShareState("config");
                            fs2.setNFSOptions(selNFSOpt);
                            break;
                        }
                        default: {
                            throw new SamFSException(null, -1000);
                        }
                    }
                }
                SamUtil.setInfoAlert((ContainerView)this, CHILD_ALERT, "success.summary", SamUtil.getResourceString(op, dirName), this.getServerName());
            }
            catch (SamFSException smfex) {
                SamUtil.processException((Exception)((Object)smfex), ((Object)((Object)this)).getClass(), "NFSDetailsViewBean()", "Failed to perform the operation", this.getServerName());
                SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, "NFSDetailsViewBean.error.failedOperation", smfex.getSAMerrno(), smfex.getMessage(), this.getServerName());
            }
        }
        this.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

