/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemFSManager;
import com.sun.netstorage.samqfs.web.model.fs.RestoreFile;
import com.sun.netstorage.samqfs.web.util.Filter;
import com.sun.netstorage.samqfs.web.util.LargeDataSet;
import com.sun.netstorage.samqfs.web.util.TraceUtil;

public final class FSRestoreSnapshotContentsData
implements LargeDataSet {
    private SamQFSSystemFSManager fsMgr;
    private String fileSystemName;
    private String directory;
    private String dumpFileName;
    private String dirName;
    private Filter filter;
    private int maxCount;
    private boolean isBrowseContents;
    private int totalRecords;

    private FSRestoreSnapshotContentsData() {
    }

    public FSRestoreSnapshotContentsData(SamQFSSystemFSManager fsMgr) {
        TraceUtil.initTrace();
        this.fsMgr = fsMgr;
        TraceUtil.trace3("Entering");
    }

    public void setBrowse(String fileSystemName, String directory, String dumpFileName, String dirName, Filter filter, int maxCount) {
        this.fileSystemName = fileSystemName;
        this.directory = directory;
        this.dumpFileName = dumpFileName;
        this.dirName = dirName;
        this.filter = filter;
        this.maxCount = maxCount;
        this.isBrowseContents = true;
    }

    public void setSearch(String fileSystemName) {
        this.fileSystemName = fileSystemName;
        this.isBrowseContents = false;
    }

    public Object[] getData(int start, int num, String sortName, String sortOrder) throws SamFSException {
        TraceUtil.trace3(new NonSyncStringBuffer("Entering start = ").append(start).append(" num = ").append(num).append(" sortName = ").append(sortName).append(" sortOrder = ").append(sortOrder).toString());
        RestoreFile[] restoreFiles = this.isBrowseContents ? this.fsMgr.getDumpFileContents(this.fileSystemName, this.directory, this.dumpFileName, this.dirName, this.filter, this.maxCount, start, num) : this.fsMgr.getSearchResults(this.fileSystemName, start, num);
        if (restoreFiles == null) {
            restoreFiles = new RestoreFile[]{};
        }
        this.totalRecords = restoreFiles.length;
        TraceUtil.trace3("Exiting");
        return restoreFiles;
    }

    public int getTotalRecords() throws SamFSException {
        TraceUtil.trace3("Entering");
        TraceUtil.trace3("Exiting");
        return this.totalRecords;
    }
}

