/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive.wizards;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.archive.PolicyUtil;
import com.sun.netstorage.samqfs.web.archive.ReservationMethodHelper;
import com.sun.netstorage.samqfs.web.archive.SelectableGroupHelper;
import com.sun.netstorage.samqfs.web.archive.wizards.NewCopyDiskVSNParametersBean;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveCopyGUIWrapper;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveVSNMap;
import com.sun.netstorage.samqfs.web.model.media.DiskVolume;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.netstorage.samqfs.web.wizard.SamWizardModel;
import com.sun.web.ui.model.wizard.WizardEvent;

public class CopyMediaValidator {
    public static final String COPY_TYPE = "copy_archive_type";
    public static final String AT_DISK = "disk";
    public static final String AT_TAPE = "tape";
    public static final String NDV_KEY = "new_disk_vsn_key.";
    private SamWizardModel model;
    private WizardEvent event;
    private ArchiveCopyGUIWrapper wrapper;
    private int copyNumber;
    private String summaryArchiveAge;
    private String summaryArchiveType;
    private String summaryDiskVSNName;
    private String summaryDiskVSNPath;
    private String summaryDiskVSNHost;
    private String summaryMediaType;
    private String summaryVSNPoolName;
    private String summarySpecifiedVSNs;
    private String summaryRMString;
    private int selectedMediaType;

    public CopyMediaValidator(SamWizardModel model, WizardEvent event, ArchiveCopyGUIWrapper wrapper) {
        this(model, event, wrapper, -1);
    }

    public CopyMediaValidator(SamWizardModel model, WizardEvent event, ArchiveCopyGUIWrapper wrapper, int copyNumber2) {
        this.model = model;
        this.event = event;
        this.wrapper = wrapper;
        this.copyNumber = copyNumber2;
    }

    public boolean validate() {
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        String serverName = (String)this.model.getValue("SERVER_NAME");
        String radioValue = (String)this.model.getValue("existingVSNRadio");
        this.model.setValue("selected_vsn_radio", radioValue);
        String archiveAge = (String)this.model.getValue("archiveAge");
        if (archiveAge == null || archiveAge.trim().length() == 0) {
            this.event.setSeverity(0);
            this.event.setErrorMessage("NewArchivePolWizard.page3.errArchiveAgeNegInt");
            return false;
        }
        long age = -1L;
        try {
            age = Long.parseLong(archiveAge);
            if (age < 0L) {
                this.event.setSeverity(0);
                this.event.setErrorMessage("NewArchivePolWizard.page3.errArchiveAgeNegInt");
                return false;
            }
            this.wrapper.getArchivePolCriteriaCopy().setArchiveAge(age);
        }
        catch (NumberFormatException nfe) {
            this.event.setSeverity(0);
            this.event.setErrorMessage("NewArchivePolWizard.page3.errArchiveAge");
            return false;
        }
        String ageUnitStr = (String)this.model.getValue("archiveAgeUnit");
        if (SelectableGroupHelper.NOVAL.equals(ageUnitStr)) {
            this.event.setSeverity(0);
            this.event.setErrorMessage("NewArchivePolWizard.page3.errArchiveAgeDropDown");
            return false;
        }
        int ageUnit = Integer.parseInt(ageUnitStr);
        this.wrapper.getArchivePolCriteriaCopy().setArchiveAgeUnit(ageUnit);
        NonSyncStringBuffer temp = new NonSyncStringBuffer();
        temp.append(age).append(" ").append(PolicyUtil.getTimeUnitAsString(ageUnit));
        this.summaryArchiveAge = temp.toString();
        String useVSNs = (String)this.model.getValue("existingVSNRadio");
        ArchiveVSNMap vsnMap = this.wrapper.getArchiveCopy().getArchiveVSNMap();
        int mType = 133;
        if (useVSNs.equals("existingvsn")) {
            String startVSN;
            String mediaType = (String)this.model.getValue("mediaType");
            if (mediaType.equals(SelectableGroupHelper.NOVAL)) {
                this.event.setSeverity(0);
                this.event.setErrorMessage("NewArchivePolWizard.page3.errMediaType");
                return false;
            }
            boolean hasPoolName = false;
            boolean hasRange = false;
            boolean hasList = false;
            mType = Integer.parseInt(mediaType);
            vsnMap.setArchiveMediaType(mType);
            String poolName = (String)this.model.getValue("poolName");
            System.out.println("Selected Pool : " + poolName);
            if (!poolName.equals(SelectableGroupHelper.NOVAL)) {
                vsnMap.setPoolExpression(poolName);
                this.summaryVSNPoolName = poolName;
                hasPoolName = true;
            }
            startVSN = (startVSN = (String)this.model.getValue("from")) == null ? "" : startVSN.trim();
            String endVSN = (String)this.model.getValue("to");
            String string = endVSN = endVSN == null ? "" : endVSN.trim();
            if (!startVSN.equals("") && !endVSN.equals("")) {
                if (mType != 133) {
                    if (!SamUtil.isValidVSNString(startVSN)) {
                        this.event.setSeverity(0);
                        this.event.setErrorMessage("NewArchivePolWizard.page3.errStartInvalidVSN");
                        return false;
                    }
                    if (!SamUtil.isValidVSNString(endVSN)) {
                        this.event.setSeverity(0);
                        this.event.setErrorMessage("NewArchivePolWizard.page3.errEndInvalidVSN");
                        return false;
                    }
                }
                vsnMap.setMapExpressionStartVSN(startVSN);
                vsnMap.setMapExpressionEndVSN(endVSN);
                hasRange = true;
            } else {
                vsnMap.setMapExpressionStartVSN("");
                vsnMap.setMapExpressionEndVSN("");
            }
            if (!startVSN.equals("") && endVSN.equals("")) {
                this.event.setSeverity(0);
                this.event.setErrorMessage("NewArchivePolWizard.page3.errEndVSN");
                return false;
            }
            if (startVSN.equals("") && !endVSN.equals("")) {
                this.event.setSeverity(0);
                this.event.setErrorMessage("NewArchivePolWizard.page3.errStartVSN");
                return false;
            }
            String list = (String)this.model.getValue("list");
            String string2 = list = list == null ? "" : list.trim();
            if (!list.equals("")) {
                vsnMap.setMapExpression(list);
                hasList = true;
            } else {
                vsnMap.setMapExpression("");
            }
            this.summarySpecifiedVSNs = this.getSpecifiedVSNString(startVSN, endVSN, list);
            if (!(hasPoolName || hasRange || hasList)) {
                this.event.setSeverity(0);
                this.event.setErrorMessage("NewArchivePolWizard.page3.errMediaTypeParam");
                return false;
            }
            if (mType != 133) {
                String rmFS;
                String rmPolicy;
                ReservationMethodHelper rmh = new ReservationMethodHelper();
                String rmAttributes = (String)this.model.getValue("rmAttributes");
                if (!rmAttributes.equals(SelectableGroupHelper.NOVAL)) {
                    rmh.setAttributes(Integer.parseInt(rmAttributes));
                }
                if ("true".equals(rmPolicy = (String)this.model.getValue("rmPolicy"))) {
                    rmh.setSet(1);
                }
                if ("true".equals(rmFS = (String)this.model.getValue("rmFS"))) {
                    rmh.setFS(4);
                }
                int reservationMethod = rmh.getValue();
                this.wrapper.getArchiveCopy().setReservationMethod(reservationMethod);
                this.model.setValue("reservation_method_int", new Integer(reservationMethod));
                this.summaryRMString = rmh.toString();
            }
        } else {
            this.model.setValue(COPY_TYPE, AT_DISK);
            String name = (String)this.model.getValue("name");
            String string = name = name == null ? "" : name.trim();
            if (name.equals("")) {
                this.event.setSeverity(0);
                this.event.setErrorMessage("archiving.diskvsn.newvsn.error.namenull");
                return false;
            }
            if (!SamUtil.isValidFSNameString(name)) {
                this.event.setSeverity(0);
                this.event.setErrorMessage("archiving.diskvsn.newvsn.error.alphanumeric");
                return false;
            }
            boolean found = false;
            try {
                int i;
                SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
                DiskVolume[] diskVolumes = sysModel.getSamQFSSystemMediaManager().getDiskVSNs();
                for (i = 0; !found && i < diskVolumes.length; ++i) {
                    if (!name.equals(diskVolumes[i].getName())) continue;
                    found = true;
                }
                if (this.copyNumber > 1) {
                    for (i = 1; i < this.copyNumber && !found; ++i) {
                        NewCopyDiskVSNParametersBean bean = (NewCopyDiskVSNParametersBean)this.model.getValue(NDV_KEY + i);
                        if (bean == null || !bean.getName().equals(name)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) {
                    this.event.setSeverity(0);
                    this.event.setErrorMessage("archiving.diskvsn.newvsn.error.nameused");
                    return false;
                }
                String host = (String)this.model.getValue("host");
                String path = (String)this.model.getValue("path");
                path = path == null ? "" : path.trim();
                String createPath = (String)this.model.getValue("createPath");
                if (path.equals("")) {
                    this.event.setSeverity(0);
                    this.event.setErrorMessage("archiving.diskvsn.newvsn.error.pathnull");
                    return false;
                }
                if (!SamUtil.isWellFormedPath(path)) {
                    this.event.setSeverity(0);
                    this.event.setErrorMessage("archiving.diskvsn.newvsn.error.pathwellformed");
                    return false;
                }
                if (!createPath.equals("true") && !sysModel.doesFileExist(path)) {
                    this.event.setSeverity(0);
                    this.event.setErrorMessage("archiving.diskvsn.newvsn.error.pathnonexistent");
                    return false;
                }
                this.summaryDiskVSNName = name;
                this.summaryDiskVSNPath = path;
                this.summaryDiskVSNHost = host;
                vsnMap.setArchiveMediaType(133);
                mType = 133;
                if (this.copyNumber != -1) {
                    NewCopyDiskVSNParametersBean bean = new NewCopyDiskVSNParametersBean(name, host, path);
                    String key = NDV_KEY + this.copyNumber;
                    this.model.setValue(key, bean);
                }
            }
            catch (SamFSException sfe) {
                TraceUtil.trace1("SamFSException caught while retrieving disk volumes");
                SamUtil.processException((Exception)((Object)sfe), this.getClass(), "processCopyMediaParameters", "Retrieving disk volumes", serverName);
                this.model.setValue("ERROR", "Yes");
                this.model.setValue("ERROR_MSGS", sfe.getMessage());
                this.model.setValue("ERROR_CODE", Integer.toString(sfe.getSAMerrno()));
            }
            vsnMap.setPoolExpression("");
            vsnMap.setMapExpressionStartVSN("");
            vsnMap.setMapExpressionEndVSN("");
            vsnMap.setMapExpression("");
        }
        this.selectedMediaType = mType;
        if (mType == 133) {
            this.model.setValue(COPY_TYPE, AT_DISK);
            this.model.setValue("new_copy_media_type", AT_DISK);
        } else {
            this.model.setValue(COPY_TYPE, AT_TAPE);
            this.model.setValue("new_copy_media_type", AT_TAPE);
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    private String getSpecifiedVSNString(String startVSN, String endVSN, String list) {
        NonSyncStringBuffer returnStringBuffer = new NonSyncStringBuffer();
        if (startVSN.length() != 0 && endVSN.length() != 0) {
            returnStringBuffer.append(SamUtil.getResourceString("NewPolicyWizard.specifyVSN", new String[]{startVSN, endVSN}));
        }
        if (list.length() != 0) {
            if (returnStringBuffer.length() != 0) {
                returnStringBuffer.append(", ");
            }
            return returnStringBuffer.append(list).toString();
        }
        return returnStringBuffer.toString();
    }

    public String getSummaryArchiveAge() {
        return this.summaryArchiveAge;
    }

    public String getSummaryArchiveType() {
        return this.summaryArchiveType;
    }

    public String getSummaryDiskVSNName() {
        return this.summaryDiskVSNName;
    }

    public String getSummaryDiskVSNPath() {
        return this.summaryDiskVSNPath;
    }

    public String getSummaryDiskVSNHost() {
        return this.summaryDiskVSNHost;
    }

    public String getSummaryMediaType() {
        return this.summaryMediaType;
    }

    public String getSummaryVSNPoolName() {
        return this.summaryVSNPoolName;
    }

    public String getSummarySpecifiedVSNs() {
        return this.summarySpecifiedVSNs;
    }

    public String getSummaryRMString() {
        return this.summaryRMString;
    }

    public int getMediaType() {
        return this.selectedMediaType;
    }
}

