/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiMsgException;
import com.sun.netstorage.samqfs.mgmt.SamFSWarnings;
import com.sun.netstorage.samqfs.web.archive.VSNPoolDetailsModel;
import com.sun.netstorage.samqfs.web.archive.VSNPoolDetailsView;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.VSNPool;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.BreadCrumbUtil;
import com.sun.netstorage.samqfs.web.util.Capacity;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.PageInfo;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.PropertySheetUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.SecurityManagerFactory;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCBreadCrumbsModel;
import com.sun.web.ui.model.CCBreadCrumbsModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.view.breadcrumb.CCBreadCrumbs;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCHref;
import com.sun.web.ui.view.html.CCStaticTextField;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.servlet.ServletException;

public class VSNPoolDetailsViewBean
extends CommonViewBeanBase {
    private static final String PAGE_NAME = "VSNPoolDetails";
    private static final String DEFAULT_DISPLAY_URL = "/jsp/archive/VSNPoolDetails.jsp";
    private static final int TAB_NAME = 8;
    private CCPageTitleModel pageTitleModel;
    private CCPropertySheetModel propertySheetModel;
    private VSNPoolDetailsModel vsnModel;
    private CCBreadCrumbsModel breadCrumbsModel;
    private static final String CHILD_BREADCRUMB = "BreadCrumb";
    private static final String CHILD_BACKTOVSNSUM_HREF = "VSNPoolSummaryHref";
    public static final String CHILD_NE_HIDDEN_FIELD1 = "NEHiddenField1";
    public static final String CHILD_NE_HIDDEN_FIELD2 = "NEHiddenField2";
    public static final String CHILD_NE_HIDDEN_FIELD3 = "NEHiddenField3";
    public static final String CHILD_NE_HIDDEN_FIELD4 = "NEHiddenField4";
    public static final String CHILD_NE_HIDDEN_FIELD5 = "NEHiddenField5";
    public static final String CHILD_POOL_NAME = "VSNPoolNameField";
    public static final String CHILD_EDITVSNPOOL_HREF = "EditVSNPoolHref";
    public static final String CHILD_STATIC_TEXT = "StaticText";
    public static final String CHILD_CONTAINER_VIEW = "VSNPoolDetailsView";
    public static final String RESERVED_VSN_MESSAGE = "reservedVSNMessage";
    public static final String DELETE_CONFIRMATION = "deleteConfirmation";
    private boolean disableButton;
    static /* synthetic */ Class class$com$sun$web$ui$view$breadcrumb$CCBreadCrumbs;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$archive$VSNPoolDetailsView;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHref;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCStaticTextField;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$archive$VSNPoolSummaryViewBean;

    public VSNPoolDetailsViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL, 8);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.pageTitleModel = this.createPageTitleModel();
        this.propertySheetModel = this.createPropertySheetModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren();
        PageTitleUtil.registerChildren((ContainerViewBase)this, this.pageTitleModel);
        PropertySheetUtil.registerChildren((ContainerViewBase)this, this.propertySheetModel);
        this.registerChild(CHILD_BREADCRUMB, class$com$sun$web$ui$view$breadcrumb$CCBreadCrumbs == null ? (class$com$sun$web$ui$view$breadcrumb$CCBreadCrumbs = VSNPoolDetailsViewBean.class$("com.sun.web.ui.view.breadcrumb.CCBreadCrumbs")) : class$com$sun$web$ui$view$breadcrumb$CCBreadCrumbs);
        this.registerChild(CHILD_CONTAINER_VIEW, class$com$sun$netstorage$samqfs$web$archive$VSNPoolDetailsView == null ? (class$com$sun$netstorage$samqfs$web$archive$VSNPoolDetailsView = VSNPoolDetailsViewBean.class$("com.sun.netstorage.samqfs.web.archive.VSNPoolDetailsView")) : class$com$sun$netstorage$samqfs$web$archive$VSNPoolDetailsView);
        this.registerChild(CHILD_BACKTOVSNSUM_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = VSNPoolDetailsViewBean.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_NE_HIDDEN_FIELD1, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = VSNPoolDetailsViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_NE_HIDDEN_FIELD2, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = VSNPoolDetailsViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_NE_HIDDEN_FIELD3, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = VSNPoolDetailsViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_NE_HIDDEN_FIELD4, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = VSNPoolDetailsViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_NE_HIDDEN_FIELD5, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = VSNPoolDetailsViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_POOL_NAME, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = VSNPoolDetailsViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_EDITVSNPOOL_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = VSNPoolDetailsViewBean.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_STATIC_TEXT, class$com$sun$web$ui$view$html$CCStaticTextField == null ? (class$com$sun$web$ui$view$html$CCStaticTextField = VSNPoolDetailsViewBean.class$("com.sun.web.ui.view.html.CCStaticTextField")) : class$com$sun$web$ui$view$html$CCStaticTextField);
        this.registerChild(RESERVED_VSN_MESSAGE, class$com$sun$web$ui$view$html$CCStaticTextField == null ? (class$com$sun$web$ui$view$html$CCStaticTextField = VSNPoolDetailsViewBean.class$("com.sun.web.ui.view.html.CCStaticTextField")) : class$com$sun$web$ui$view$html$CCStaticTextField);
        this.registerChild(DELETE_CONFIRMATION, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = VSNPoolDetailsViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        TraceUtil.trace3("Exiting");
    }

    protected View createChild(String name) {
        if (super.isChildSupported(name)) {
            return super.createChild(name);
        }
        if (PageTitleUtil.isChildSupported(this.pageTitleModel, name)) {
            return PageTitleUtil.createChild((ContainerView)this, this.pageTitleModel, name);
        }
        if (PropertySheetUtil.isChildSupported(this.propertySheetModel, name)) {
            TraceUtil.trace3("Exiting");
            return PropertySheetUtil.createChild((ContainerView)this, this.propertySheetModel, name);
        }
        if (name.equals(CHILD_STATIC_TEXT) || name.equals(RESERVED_VSN_MESSAGE)) {
            TraceUtil.trace3("Exiting");
            return new CCStaticTextField((ContainerView)this, name, null);
        }
        if (name.equals(CHILD_BREADCRUMB)) {
            this.breadCrumbsModel = new CCBreadCrumbsModel("VSNPoolDetails.pageTitle");
            BreadCrumbUtil.createBreadCrumbs((ViewBean)this, name, this.breadCrumbsModel);
            CCBreadCrumbs child = new CCBreadCrumbs((View)this, (CCBreadCrumbsModelInterface)this.breadCrumbsModel, name);
            TraceUtil.trace3("Exiting");
            return child;
        }
        if (name.equals(CHILD_CONTAINER_VIEW)) {
            TraceUtil.trace3("Exiting");
            return new VSNPoolDetailsView((View)this, name);
        }
        if (name.equals(CHILD_BACKTOVSNSUM_HREF) || name.equals(CHILD_EDITVSNPOOL_HREF)) {
            TraceUtil.trace3("Exiting");
            return new CCHref((ContainerView)this, name, null);
        }
        if (name.equals(CHILD_NE_HIDDEN_FIELD1) || name.equals(CHILD_NE_HIDDEN_FIELD2) || name.equals(CHILD_NE_HIDDEN_FIELD3) || name.equals(CHILD_NE_HIDDEN_FIELD4) || name.equals(CHILD_NE_HIDDEN_FIELD5) || name.equals(CHILD_POOL_NAME) || name.equals(DELETE_CONFIRMATION)) {
            CCHiddenField child = new CCHiddenField((ContainerView)this, name, null);
            TraceUtil.trace3("Exiting");
            return child;
        }
        throw new IllegalArgumentException("invalid child '" + name + "'");
    }

    private CCPageTitleModel createPageTitleModel() {
        TraceUtil.trace3("Entering");
        if (this.pageTitleModel == null) {
            this.pageTitleModel = PageTitleUtil.createModel("/jsp/archive/VSNPoolDetailsPageTitle.xml");
            this.pageTitleModel.setValue("Edit", (Object)"common.edit");
            this.pageTitleModel.setValue("Delete", (Object)"common.delete");
        }
        TraceUtil.trace3("Exiting");
        return this.pageTitleModel;
    }

    private CCPropertySheetModel createPropertySheetModel() {
        TraceUtil.trace3("Entering");
        this.propertySheetModel = PropertySheetUtil.createModel("/jsp/archive/VSNPoolDetailsPropSheet.xml");
        TraceUtil.trace3("Exiting");
        return this.propertySheetModel;
    }

    public void loadPropertySheetModel() {
        String serverName = this.getServerName();
        String poolName = (String)this.getPageSessionAttribute("SAMQFS_vsn_pool_name");
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            VSNPool vsnPool = sysModel.getSamQFSSystemArchiveManager43().getVSNPool(poolName);
            if (vsnPool == null) {
                throw new SamFSException(null, -2010);
            }
            this.propertySheetModel.setValue("vsnPoolNameText", (Object)poolName);
            this.propertySheetModel.setValue("mediaTypeText", (Object)SamUtil.getMediaTypeString(vsnPool.getMediaType()));
            Capacity freeSpace = new Capacity(vsnPool.getSpaceAvailable(), 2);
            this.propertySheetModel.setValue("spaceAvailableText", (Object)freeSpace);
            this.propertySheetModel.setValue("regexpText", (Object)vsnPool.getVSNExpression());
        }
        catch (SamFSWarnings sfw) {
            SamUtil.processException((Exception)((Object)sfw), ((Object)((Object)this)).getClass(), "createPropertySheetModel", "Could not retrieve VSN details", serverName);
            SamUtil.setWarningAlert((ContainerView)this, "Alert", "ArchiveConfig.error.summary", sfw.getMessage());
        }
        catch (SamFSMultiMsgException smme) {
            SamUtil.processException((Exception)((Object)smme), ((Object)((Object)this)).getClass(), "createPropertySheetModel", "Could not retrieve VSN details", serverName);
            SamUtil.setErrorAlert((ContainerView)this, "Alert", "ArchiveConfig.error.summary", smme.getSAMerrno(), "ArchiveConfig.error.detail", serverName);
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "createPropertySheetModel", "Could not retrieve VSN details", serverName);
            SamUtil.setErrorAlert((ContainerView)this, "Alert", "VSNPoolDetails.error.failedPopulateVSNPoolDetails", sfe.getSAMerrno(), sfe.getMessage(), serverName);
            this.disableButton = true;
        }
    }

    public void handleVSNPoolSummaryHrefRequest(RequestInvocationEvent event) {
        TraceUtil.trace3("Entering");
        String s = (String)this.getDisplayFieldValue(CHILD_BACKTOVSNSUM_HREF);
        ViewBean target = this.getViewBean(class$com$sun$netstorage$samqfs$web$archive$VSNPoolSummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$archive$VSNPoolSummaryViewBean = VSNPoolDetailsViewBean.class$("com.sun.netstorage.samqfs.web.archive.VSNPoolSummaryViewBean")) : class$com$sun$netstorage$samqfs$web$archive$VSNPoolSummaryViewBean);
        BreadCrumbUtil.breadCrumbPathBackward((ViewBean)this, PageInfo.getPageInfo().getPageNumber(target.getName()), s);
        this.forwardTo(target);
        TraceUtil.trace3("Exiting");
    }

    public void handleEditRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        this.forwardTo();
        TraceUtil.trace3("Exiting");
    }

    public void handleDeleteRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        String serverName = this.getServerName();
        String poolName = (String)this.getPageSessionAttribute("SAMQFS_vsn_pool_name");
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            sysModel.getSamQFSSystemArchiveManager43().deleteVSNPool(poolName);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException iex) {
                TraceUtil.trace3("InterruptedException Caught: Reason: " + iex.getMessage());
            }
            CommonViewBeanBase target = (CommonViewBeanBase)this.getViewBean(class$com$sun$netstorage$samqfs$web$archive$VSNPoolSummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$archive$VSNPoolSummaryViewBean = VSNPoolDetailsViewBean.class$("com.sun.netstorage.samqfs.web.archive.VSNPoolSummaryViewBean")) : class$com$sun$netstorage$samqfs$web$archive$VSNPoolSummaryViewBean);
            this.showAlert((ViewBean)target, "VSNPoolSummary.delete.alert", poolName);
            this.forwardTo((ViewBean)target);
        }
        catch (SamFSException smfex) {
            String processMsg = null;
            String errMsg = null;
            String errCause = null;
            boolean multiMsgOccurred = false;
            boolean warningOccurred = false;
            if (smfex instanceof SamFSMultiMsgException) {
                processMsg = "Error in archiver configuration";
                errMsg = "ArchiveConfig.error";
                errCause = "ArchiveConfig.error.detail";
                multiMsgOccurred = true;
            } else if (smfex instanceof SamFSWarnings) {
                warningOccurred = true;
                processMsg = "Warning in archiver configuration";
                errMsg = "ArchiveConfig.error";
                errCause = "ArchiveConfig.warning.detail";
            } else {
                processMsg = "Failed to delete VSN Pool";
                errMsg = "VSNPoolDetails.error.failedDelete";
                errCause = smfex.getMessage();
            }
            SamUtil.processException((Exception)((Object)smfex), ((Object)((Object)this)).getClass(), "handleDeleteRequest", processMsg, serverName);
            if (!multiMsgOccurred && !warningOccurred) {
                SamUtil.setErrorAlert((ContainerView)this, "Alert", errMsg, smfex.getSAMerrno(), errCause);
                this.forwardTo();
            }
            ViewBean target = this.getViewBean(class$com$sun$netstorage$samqfs$web$archive$VSNPoolSummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$archive$VSNPoolSummaryViewBean = VSNPoolDetailsViewBean.class$("com.sun.netstorage.samqfs.web.archive.VSNPoolSummaryViewBean")) : class$com$sun$netstorage$samqfs$web$archive$VSNPoolSummaryViewBean);
            if (multiMsgOccurred) {
                SamUtil.setErrorAlert((ContainerView)target, "Alert", errMsg, smfex.getSAMerrno(), errCause);
            } else if (warningOccurred) {
                SamUtil.setWarningAlert((ContainerView)target, "Alert", errMsg, errCause);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException iex) {
                TraceUtil.trace3("InterruptedException Caught: Reason: " + iex.getMessage());
            }
            this.forwardTo(target);
        }
        TraceUtil.trace3("Exiting");
    }

    private void checkRolePrivilege() {
        TraceUtil.trace3("Entering");
        if (!SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.MEDIA_OPERATOR)) {
            ((CCButton)this.getChild("Edit")).setDisabled(true);
            ((CCButton)this.getChild("Delete")).setDisabled(true);
        }
        TraceUtil.trace3("Exiting");
    }

    private void disableButtons() {
        ((CCButton)this.getChild("Edit")).setDisabled(true);
        ((CCButton)this.getChild("Delete")).setDisabled(true);
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        this.checkRolePrivilege();
        this.loadPropertySheetModel();
        String poolName = (String)this.getPageSessionAttribute("SAMQFS_vsn_pool_name");
        this.pageTitleModel.setPageTitleText(SamUtil.getResourceString("VSNPoolDetails.title", poolName));
        VSNPoolDetailsView view = (VSNPoolDetailsView)this.getChild(CHILD_CONTAINER_VIEW);
        String serverName = this.getServerName();
        try {
            view.populateData();
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            boolean inuse = sysModel.getSamQFSSystemArchiveManager43().isPoolInUse(poolName);
            if (inuse) {
                ((CCButton)this.getChild("Delete")).setDisabled(true);
            }
        }
        catch (SamFSException smfex) {
            SamUtil.processException((Exception)((Object)smfex), ((Object)((Object)this)).getClass(), "VSNPoolDetailsViewBean()", "Cannot populate vsns", serverName);
            SamUtil.setErrorAlert((ContainerView)this, "Alert", "VSNPoolDetails.error.failedPopulateVSNPoolDetails", smfex.getSAMerrno(), smfex.getMessage(), serverName);
        }
        if (this.disableButton) {
            this.disableButtons();
        }
        this.disableButton = false;
        ((CCHiddenField)this.getChild(CHILD_POOL_NAME)).setValue((Object)poolName);
        Boolean containsReservedVSN = (Boolean)RequestManager.getRequestContext().getRequest().getAttribute("vsnPoolContainsAReservedVSN");
        if (containsReservedVSN != null && containsReservedVSN.booleanValue()) {
            String msg = SamUtil.getResourceString("archiving.reservedvsninpool", "&#8224");
            CCStaticTextField child = (CCStaticTextField)this.getChild(RESERVED_VSN_MESSAGE);
            child.setValue((Object)msg);
        }
        ((CCHiddenField)this.getChild(DELETE_CONFIRMATION)).setValue((Object)SamUtil.getResourceString("VSNPoolSummary.confirmMsg1"));
        TraceUtil.trace3("Exiting");
    }

    public void handleEditVSNPoolHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        String specifyVSN;
        TraceUtil.trace3("Entering");
        String start = null;
        String end = null;
        String vsnName = (String)this.getDisplayFieldValue(CHILD_NE_HIDDEN_FIELD1);
        TraceUtil.trace3("vsnName is " + vsnName);
        if (vsnName != null) {
            vsnName = vsnName.trim();
        }
        String mediaType = (String)this.getDisplayFieldValue(CHILD_NE_HIDDEN_FIELD2);
        TraceUtil.trace3("mediaType is " + mediaType);
        if (mediaType != null) {
            mediaType = mediaType.trim();
        }
        String startend = (String)this.getDisplayFieldValue(CHILD_NE_HIDDEN_FIELD3);
        TraceUtil.trace3("startend is " + startend);
        if (startend != null) {
            startend = startend.trim();
        }
        String vsnRange = (String)this.getDisplayFieldValue(CHILD_NE_HIDDEN_FIELD4);
        TraceUtil.trace3("vsnRange is " + vsnRange);
        if (vsnRange != null) {
            vsnRange = vsnRange.trim();
        }
        if ((specifyVSN = (String)this.getDisplayFieldValue(CHILD_NE_HIDDEN_FIELD5)) != null) {
            specifyVSN = specifyVSN.trim();
        }
        if (specifyVSN != null && specifyVSN.equals("startend")) {
            StringTokenizer tokens = new StringTokenizer(startend, ",");
            start = tokens.nextToken();
            end = tokens.nextToken();
        }
        String express = null;
        if (specifyVSN != null && specifyVSN.equals("range")) {
            express = vsnRange;
        } else if (specifyVSN != null && specifyVSN.equals("startend")) {
            express = SamQFSUtil.createExpression(start, end);
        }
        int media = Integer.parseInt(mediaType);
        String serverName = this.getServerName();
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            VSNPool existedPool = null;
            VSNPool[] pools = sysModel.getSamQFSSystemArchiveManager43().getAllVSNPools();
            for (int i = 0; i < pools.length; ++i) {
                if (!pools[i].getPoolName().equals(vsnName)) continue;
                existedPool = pools[i];
            }
            LogUtil.info(((Object)((Object)this)).getClass(), "handleEditVSNPoolHrefRequest", "Start editing VSN pool " + vsnName);
            existedPool.setMemberVSNs(media, express);
            sysModel.getSamQFSSystemArchiveManager43().updateVSNPool(vsnName);
            LogUtil.info(((Object)((Object)this)).getClass(), "handleEditVSNPoolHrefRequest", "Done editing VSN pool " + vsnName);
            this.showAlertDetail("VSNPoolDetails.edit.alert", vsnName);
        }
        catch (SamFSException smfex) {
            String processMsg = null;
            String errMsg = null;
            String errCause = null;
            boolean warning = false;
            if (smfex instanceof SamFSMultiMsgException) {
                processMsg = "Error in archiver configuration";
                errMsg = "ArchiveConfig.error";
                errCause = "ArchiveConfig.error.detail";
            } else if (smfex instanceof SamFSWarnings) {
                warning = true;
                processMsg = "Warning in archiver configuration";
                errMsg = "ArchiveConfig.error";
                errCause = "ArchiveConfig.warning.detail";
            } else {
                processMsg = "Failed to edit VSN Pool";
                errMsg = "VSNPoolDetails.error.failedEdit";
                errCause = smfex.getMessage();
            }
            SamUtil.processException((Exception)((Object)smfex), ((Object)((Object)this)).getClass(), "handleEditVSNPoolHrefRequest", processMsg, serverName);
            if (!warning) {
                SamUtil.setErrorAlert((ContainerView)this, "Alert", errMsg, smfex.getSAMerrno(), errCause, serverName);
            }
            SamUtil.setWarningAlert((ContainerView)this, "Alert", errMsg, errCause);
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException iex) {
            TraceUtil.trace3("InterruptedException Caught: Reason: " + iex.getMessage());
        }
        this.forwardTo();
        TraceUtil.trace3("Exiting");
    }

    private void showAlert(ViewBean targetView, String operation, String key) {
        TraceUtil.trace3("Entering");
        SamUtil.setInfoAlert((ContainerView)targetView, "Alert", "success.summary", SamUtil.getResourceString(operation, key));
        TraceUtil.trace3("Exiting");
    }

    private void showAlertDetail(String operation, String key) {
        TraceUtil.trace3("Entering");
        SamUtil.setInfoAlert((ContainerView)this, "Alert", "success.summary", SamUtil.getResourceString(operation, key));
        TraceUtil.trace3("Exiting");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

