/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.model.Model;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.RequestHandlingViewBase;
import com.iplanet.jato.view.View;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.archive.CopyOptions;
import com.sun.netstorage.samqfs.web.archive.PolicyUtil;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.PropertySheetUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.common.CCPagelet;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.view.html.CCCheckBox;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCLabel;
import com.sun.web.ui.view.html.CCTextField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class CopyOptionsViewBase
extends RequestHandlingViewBase
implements CopyOptions,
CCPagelet {
    protected CCPropertySheetModel model = null;
    protected ArchiveCopy _theCopy = null;

    protected CopyOptionsViewBase(View parent, String psFileName, String name) {
        super(parent, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.createModel(psFileName);
        this.setDefaultModel((Model)this.model);
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        PropertySheetUtil.registerChildren((ContainerViewBase)this, this.model);
    }

    public View createChild(String name) {
        if (PropertySheetUtil.isChildSupported(this.model, name)) {
            return PropertySheetUtil.createChild((ContainerView)this, this.model, name);
        }
        throw new IllegalArgumentException("invalid child '" + name + "'");
    }

    public void createModel(String xmlFile) {
        this.model = PropertySheetUtil.createModel(xmlFile);
    }

    public abstract String getPageletUrl();

    public abstract void loadCopyOptions() throws SamFSException;

    public abstract List validateCopyOptions() throws SamFSException;

    protected ArchiveCopy getCurrentArchiveCopy() throws SamFSException {
        if (this._theCopy == null) {
            CommonViewBeanBase parent = (CommonViewBeanBase)this.getParentViewBean();
            String serverName = parent.getServerName();
            String policyName = (String)parent.getPageSessionAttribute("SAMQFS_POLICY_NAME");
            Integer copyNumber2 = (Integer)parent.getPageSessionAttribute("SAMQFS_copy_number");
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            ArchivePolicy thePolicy = sysModel.getSamQFSSystemArchiveManager43().getArchivePolicy(policyName);
            this._theCopy = thePolicy.getArchiveCopy(copyNumber2);
        }
        return this._theCopy;
    }

    protected void loadCommonCopyOptions() throws SamFSException {
        CCTextField textField;
        ArchiveCopy theCopy = this.getCurrentArchiveCopy();
        int sortMethod = theCopy.getArchiveSortMethod();
        if (sortMethod == -1) {
            sortMethod = 9;
        }
        CCDropDownMenu dropDown = (CCDropDownMenu)this.getChild("sortMethod");
        dropDown.setValue((Object)Integer.toString(sortMethod));
        int unarchiveTimeRef = theCopy.getUnarchiveTimeReference();
        if (unarchiveTimeRef == -1) {
            unarchiveTimeRef = 11;
        }
        dropDown = (CCDropDownMenu)this.getChild("unarchiveTimeRef");
        dropDown.setValue((Object)Integer.toString(unarchiveTimeRef));
        String joinMethod = theCopy.getJoinMethod() == 2 ? "true" : "false";
        CCCheckBox checkBox = (CCCheckBox)this.getChild("joinMethod");
        checkBox.setValue((Object)joinMethod);
        int offlineMethod = theCopy.getOfflineCopyMethod();
        if (offlineMethod == -1) {
            offlineMethod = 4;
        }
        dropDown = (CCDropDownMenu)this.getChild("offlineMethod");
        dropDown.setValue((Object)Integer.toString(offlineMethod));
        long maxSizeForArchive = theCopy.getArchiveMaxSize();
        dropDown = (CCDropDownMenu)this.getChild("maxSizeForArchiveUnit");
        if (maxSizeForArchive != -1L) {
            textField = (CCTextField)this.getChild("maxSizeForArchive");
            textField.setValue((Object)Long.toString(maxSizeForArchive));
            dropDown.setValue((Object)Integer.toString(theCopy.getArchiveMaxSizeUnit()));
        } else {
            dropDown.setValue((Object)Integer.toString(2));
        }
        int bufferSize = theCopy.getBufferSize();
        if (bufferSize != -1) {
            textField = (CCTextField)this.getChild("bufferSize");
            textField.setValue((Object)Integer.toString(bufferSize));
        }
        String lockBuffer = theCopy.isBufferLocked() ? "true" : "false";
        checkBox = (CCCheckBox)this.getChild("lockBuffer");
        checkBox.setValue((Object)lockBuffer);
        long startAge = theCopy.getStartAge();
        dropDown = (CCDropDownMenu)this.getChild("startAgeUnit");
        if (startAge != -1L) {
            textField = (CCTextField)this.getChild("startAge");
            textField.setValue((Object)Long.toString(startAge));
            dropDown.setValue((Object)Integer.toString(theCopy.getStartAgeUnit()));
        } else {
            dropDown.setValue((Object)Integer.toString(6));
        }
        int startCount = theCopy.getStartCount();
        if (startCount != -1) {
            textField = (CCTextField)this.getChild("startCount");
            textField.setValue((Object)Integer.toString(startCount));
        }
        long startSize = theCopy.getStartSize();
        dropDown = (CCDropDownMenu)this.getChild("startSizeUnit");
        if (startSize != -1L) {
            textField = (CCTextField)this.getChild("startSize");
            textField.setValue((Object)Long.toString(startSize));
            dropDown.setValue((Object)Integer.toString(theCopy.getStartSizeUnit()));
        } else {
            dropDown.setValue((Object)Integer.toString(2));
        }
        String disableRecycler = theCopy.isIgnoreRecycle() ? "true" : "false";
        checkBox = (CCCheckBox)this.getChild("disableRecycler");
        checkBox.setValue((Object)disableRecycler);
        int highWaterMark = theCopy.getRecycleHWM();
        if (highWaterMark != -1) {
            textField = (CCTextField)this.getChild("highWaterMark");
            textField.setValue((Object)Integer.toString(highWaterMark));
        }
        textField = (CCTextField)this.getChild("emailAddress");
        textField.setValue((Object)theCopy.getNotificationAddress());
        int minGain = theCopy.getMinGain();
        if (minGain != -1) {
            textField = (CCTextField)this.getChild("minGain");
            textField.setValue((Object)Integer.toString(minGain));
        }
    }

    protected List validateCommonCopyOptions() throws SamFSException {
        ArrayList<String> errors;
        block45: {
            ArchiveCopy theCopy;
            block44: {
                block43: {
                    block42: {
                        block41: {
                            block40: {
                                block39: {
                                    errors = new ArrayList<String>();
                                    theCopy = this.getCurrentArchiveCopy();
                                    int sortMethod = Integer.parseInt(this.getDisplayFieldStringValue("sortMethod"));
                                    theCopy.setArchiveSortMethod(sortMethod);
                                    int unarchiveTimeRef = Integer.parseInt(this.getDisplayFieldStringValue("unarchiveTimeRef"));
                                    theCopy.setUnarchiveTimeReference(unarchiveTimeRef);
                                    int joinMethod = "true".equals(this.getDisplayFieldStringValue("joinMethod")) ? 2 : 1;
                                    theCopy.setJoinMethod(joinMethod);
                                    int offlineCopyMethod = Integer.parseInt(this.getDisplayFieldStringValue("offlineMethod"));
                                    theCopy.setOfflineCopyMethod(offlineCopyMethod);
                                    String maxSizeString = this.getDisplayFieldStringValue("maxSizeForArchive");
                                    String string = maxSizeString = maxSizeString == null ? "" : maxSizeString.trim();
                                    if (!maxSizeString.equals("")) {
                                        CCLabel label = (CCLabel)this.getChild("maxSizeForArchive".concat("Label"));
                                        try {
                                            long maxSize = Long.parseLong(maxSizeString);
                                            int maxSizeUnit = Integer.parseInt(this.getDisplayFieldStringValue("maxSizeForArchiveUnit"));
                                            if (PolicyUtil.isValidSize(maxSize, maxSizeUnit)) {
                                                theCopy.setArchiveMaxSize(maxSize);
                                                theCopy.setArchiveMaxSizeUnit(maxSizeUnit);
                                                break block39;
                                            }
                                            errors.add("archiving.error.archivemax");
                                            label.setShowError(true);
                                        }
                                        catch (NumberFormatException nfe) {
                                            errors.add("archiving.error.archivemax");
                                            label.setShowError(true);
                                        }
                                    } else {
                                        theCopy.setArchiveMaxSize(-1L);
                                        theCopy.setArchiveMaxSizeUnit(-1);
                                    }
                                }
                                String bufferSizeString = this.getDisplayFieldStringValue("bufferSize");
                                String string = bufferSizeString = bufferSizeString == null ? "" : bufferSizeString.trim();
                                if (!bufferSizeString.equals("")) {
                                    CCLabel label = (CCLabel)this.getChild("bufferSize".concat("Label"));
                                    try {
                                        int bufferSize = Integer.parseInt(bufferSizeString);
                                        if (bufferSize < 2 || bufferSize > 1024) {
                                            errors.add("ArchivePolCopy.error.buffSize");
                                            label.setShowError(true);
                                            break block40;
                                        }
                                        theCopy.setBufferSize(bufferSize);
                                    }
                                    catch (NumberFormatException nfe) {
                                        errors.add("ArchivePolCopy.error.buffSize");
                                        label.setShowError(true);
                                    }
                                } else {
                                    theCopy.setBufferSize(-1);
                                }
                            }
                            String lb = this.getDisplayFieldStringValue("lockBuffer");
                            boolean lockBuffer = "true".equals(lb);
                            theCopy.setBufferLocked(lockBuffer);
                            String startAgeString = this.getDisplayFieldStringValue("startAge");
                            String string = startAgeString = startAgeString == null ? "" : startAgeString.trim();
                            if (!startAgeString.equals("")) {
                                CCLabel label = (CCLabel)this.getChild("startAge".concat("Label"));
                                try {
                                    long startAge = Long.parseLong(startAgeString);
                                    int startAgeUnit = Integer.parseInt(this.getDisplayFieldStringValue("startAgeUnit"));
                                    if (PolicyUtil.isValidTime(startAge, startAgeUnit)) {
                                        theCopy.setStartAge(startAge);
                                        theCopy.setStartAgeUnit(startAgeUnit);
                                        break block41;
                                    }
                                    errors.add("archiving.error.startage");
                                    label.setShowError(true);
                                }
                                catch (NumberFormatException nfe) {
                                    errors.add("archiving.error.startage");
                                    label.setShowError(true);
                                }
                            } else {
                                theCopy.setStartAge(-1L);
                                theCopy.setStartAgeUnit(-1);
                            }
                        }
                        String startCountString = this.getDisplayFieldStringValue("startCount");
                        String string = startCountString = startCountString == null ? "" : startCountString.trim();
                        if (!startCountString.equals("")) {
                            CCLabel label = (CCLabel)this.getChild("startCount".concat("Label"));
                            try {
                                int startCount = Integer.parseInt(startCountString);
                                if (startCount > 0) {
                                    theCopy.setStartCount(startCount);
                                    break block42;
                                }
                                errors.add("ArchivePolCopy.error.startCount");
                                label.setShowError(true);
                            }
                            catch (NumberFormatException nfe) {
                                errors.add("ArchivePolCopy.error.startCount");
                                label.setShowError(true);
                            }
                        } else {
                            theCopy.setStartCount(-1);
                        }
                    }
                    String startSizeString = this.getDisplayFieldStringValue("startSize");
                    String string = startSizeString = startSizeString == null ? "" : startSizeString.trim();
                    if (!startSizeString.equals("")) {
                        CCLabel label = (CCLabel)this.getChild("startSize".concat("Label"));
                        try {
                            long startSize = Long.parseLong(startSizeString);
                            int startSizeUnit = Integer.parseInt(this.getDisplayFieldStringValue("startSizeUnit"));
                            if (PolicyUtil.isValidSize(startSize, startSizeUnit)) {
                                theCopy.setStartSize(startSize);
                                theCopy.setStartSizeUnit(startSizeUnit);
                                break block43;
                            }
                            errors.add("archiving.error.startsize");
                            label.setShowError(true);
                        }
                        catch (NumberFormatException nfe) {
                            errors.add("archiving.error.startsize");
                            label.setShowError(true);
                        }
                    } else {
                        theCopy.setStartSize(-1L);
                        theCopy.setStartSizeUnit(-1);
                    }
                }
                boolean disableRecycler = "true".equals(this.getDisplayFieldStringValue("disableRecycler"));
                theCopy.setIgnoreRecycle(disableRecycler);
                String email = this.getDisplayFieldStringValue("emailAddress");
                String string = email = email == null ? "" : email.trim();
                if (!email.equals("")) {
                    CCLabel label = (CCLabel)this.getChild("emailAddress".concat("Label"));
                    if (email.indexOf("@") != -1) {
                        theCopy.setNotificationAddress(email);
                    } else {
                        errors.add("ArchivePolCopy.error.mailAddress");
                        label.setShowError(true);
                    }
                } else {
                    theCopy.setNotificationAddress("");
                }
                String hwString = this.getDisplayFieldStringValue("highWaterMark");
                String string2 = hwString = hwString == null ? "" : hwString.trim();
                if (!hwString.equals("")) {
                    CCLabel label = (CCLabel)this.getChild("highWaterMark".concat("Label"));
                    try {
                        int hw = Integer.parseInt(hwString);
                        if (hw > 0 && hw <= 100) {
                            theCopy.setRecycleHWM(hw);
                            break block44;
                        }
                        errors.add("ArchivePolCopy.error.recycleHwm");
                        label.setShowError(true);
                    }
                    catch (NumberFormatException nfe) {
                        errors.add("ArchivePolCopy.error.recycleHwm");
                        label.setShowError(true);
                    }
                } else {
                    theCopy.setRecycleHWM(-1);
                }
            }
            String minGainString = this.getDisplayFieldStringValue("minGain");
            String string = minGainString = minGainString == null ? "" : minGainString.trim();
            if (!minGainString.equals("")) {
                CCLabel label = (CCLabel)this.getChild("minGain".concat("Label"));
                try {
                    int minGain = Integer.parseInt(minGainString);
                    if (minGain > 0 && minGain <= 100) {
                        theCopy.setMinGain(minGain);
                        break block45;
                    }
                    errors.add("ArchivePolCopy.error.minimumGain");
                    label.setShowError(true);
                }
                catch (NumberFormatException nfe) {
                    errors.add("ArchivePolCopy.error.minimumGain");
                    label.setShowError(true);
                }
            } else {
                theCopy.setMinGain(-1);
            }
        }
        return errors;
    }

    public void printErrorMessages(List errors) {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer();
        Iterator it = errors.iterator();
        CommonViewBeanBase parent = (CommonViewBeanBase)this.getParentViewBean();
        String serverName = parent.getServerName();
        buffer.append("<ul>");
        while (it.hasNext()) {
            String error = (String)it.next();
            buffer.append("<li>");
            buffer.append(SamUtil.getResourceString(error)).append("<br>");
            buffer.append("</li>");
        }
        buffer.append("</ul>");
        SamUtil.setErrorAlert((ContainerView)parent, "Alert", "ArchivePolCopy.error.save", -2026, buffer.toString(), serverName);
    }
}

