#!/bin/sh

#    SAM-QFS_notice_begin
#
#      Solaris 2.x Sun Storage & Archiving Management File System
#
#      Copyright (c) 2006 Sun Microsystems, Inc.
#      All Rights Reserved.
#
#      Government Rights Notice
#      Use, duplication, or disclosure by the U.S. Government is
#      subject to restrictions set forth in the Sun Microsystems,
#      Inc. license agreements and as provided in DFARS 227.7202-1(a)
#      and 227.7202-3(a) (1995), DRAS 252.227-7013(c)(ii) (OCT 1988),
#      FAR 12.212(a)(1995), FAR 52.227-19, or FAR 52.227-14 (ALT III),
#      as applicable.  Sun Microsystems, Inc.
#
#    SAM-QFS_notice_end

# $Id: stageback.sh,v 1.6.12.1 2006/02/08 20:02:17 jdunn Exp $
#
# stage from archive_audit output
#
# stage each file, set it to no-release, and
# optionally mark it for rearchive.
#

cat << /EOF > /tmp/$$.awk
{
#       it's a full path - may contain spaces

    fullfile = \$8;
    if ( NF > 9 ) {
        for (i = 9; i <= NF-1; i++) fullfile = fullfile " " \$i
        print "\"" fullfile "\""
    } else {
        print fullfile
    }
}
/EOF

/bin/sort -f -k 6,6n $1 | /bin/nawk -f /tmp/$$.awk > $1.1

while read file
do
    echo stage $file
    eval /opt/SUNWsamfs/bin/stage $file
    echo release -n $file
    eval /opt/SUNWsamfs/bin/release -n $file
#    echo rearch  $file
#
#   Edit the following line for the correct media type and VSN
#
#    eval /opt/SUNWsamfs/sbin/rearch -m MEDIA -v VSN $file
done < $1.1
echo " "
echo "Done staging files."
/bin/rm $1.1 /tmp/$$.awk
