#!/bin/csh -f

#    SAM-QFS_notice_begin
#
#      Solaris 2.x Sun Storage & Archiving Management File System
#
#      Copyright (c) 2006 Sun Microsystems, Inc.
#      All Rights Reserved.
#
#      Government Rights Notice
#      Use, duplication, or disclosure by the U.S. Government is
#      subject to restrictions set forth in the Sun Microsystems,
#      Inc. license agreements and as provided in DFARS 227.7202-1(a)
#      and 227.7202-3(a) (1995), DRAS 252.227-7013(c)(ii) (OCT 1988),
#      FAR 12.212(a)(1995), FAR 52.227-19, or FAR 52.227-14 (ALT III),
#      as applicable.  Sun Microsystems, Inc.
#
#    SAM-QFS_notice_end

#
# This script is used by the robot daemon to keep a copy of ssi_so running.
# If this script exits, the daemon will start another.  If the site
# for whatever reason, has its own version of ssi, then this script
# should be modified to wait for a SIGTERM signal and then exit.  SIGTERM is
# the signal sent by the daemon to stop the process.
#
#
# Find the correct logger
if ( -x /usr/bin/logger) then
	set LOGGER = /usr/bin/logger
else
	if ( -x /usr/ucb/logger ) then
		set LOGGER = /usr/ucb/logger
	endif
endif
#
# find the syslog facility
if ( -r /etc/opt/SUNWsamfs/defaults.conf ) then
	set SAM_LOGGER_FACILITY = `grep -v "^#" /etc/opt/SUNWsamfs/defaults.conf | grep LOCAL | sed -e "s/^.*LOG_//"`
	if ( x${SAM_LOGGER_FACILITY} == "x" ) then
		set SAM_LOGGER_FACILITY = local7
	endif
else
	set SAM_LOGGER_FACILITY = local7
endif

/usr/sbin/ping ${CSI_HOSTNAME} >&! /dev/null
if ( $status != "0" ) then
	${LOGGER} -i -t ssi.sh -p ${SAM_LOGGER_FACILITY}.warning ${CSI_HOSTNAME} is unpingable:  network problem\?
endif
#
#
setenv CSI_TCP_RPCSERVICE TRUE
setenv CSI_UDP_RPCSERVICE TRUE
setenv CSI_CONNECT_AGETIME 172800
setenv CSI_RETRY_TIMEOUT 4
setenv CSI_RETRY_TRIES 5
setenv ACSAPI_PACKET_VERSION 4
exec /opt/SUNWsamfs/sbin/ssi_so $3 ${ACSAPI_SSI_SOCKET} 23 

