/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.util;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import java.security.InvalidParameterException;

public class FsmVersion {
    public static final String CURRENT_UI_VERSION = "4.5";
    protected String uiVersion = null;
    protected String serverName = null;
    protected String compatibleAPIVersion = null;
    protected String serverAPIVersion = null;
    protected boolean isServerCompatibleWithUI;

    private FsmVersion() {
    }

    public FsmVersion(String serverName) {
        this(CURRENT_UI_VERSION, serverName);
    }

    public FsmVersion(String uiVersion, String serverName) {
        if (uiVersion == null) {
            throw new InvalidParameterException("You must specify the ui version.");
        }
        this.uiVersion = uiVersion;
        if (serverName == null) {
            throw new InvalidParameterException("You must specify the server name.");
        }
        this.serverName = serverName;
        this.compatibleAPIVersion = SamUtil.getAPIVersionFromUIVersion(uiVersion);
        try {
            this.serverAPIVersion = SamUtil.getAPIVersion(serverName);
        }
        catch (SamFSException e) {
            TraceUtil.trace1(SamUtil.getResourceString("VersionUtil.serverAPIError", new String[]{serverName, this.compatibleAPIVersion, uiVersion}), e);
            this.serverAPIVersion = this.compatibleAPIVersion;
        }
        this.isServerCompatibleWithUI = SamUtil.isVersionCurrentOrLaterThan(this.serverAPIVersion, this.compatibleAPIVersion);
    }

    public boolean isAPICompatibleWithUI() {
        return this.isServerCompatibleWithUI;
    }

    public String getUIVersion() {
        return this.uiVersion;
    }

    public String getServerName() {
        return this.serverName;
    }
}

