/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.util;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import java.util.Comparator;

public class Capacity
implements Comparable,
Comparator {
    private long size;
    private int unit;
    NonSyncStringBuffer sizeStr;
    private static final int UNIT_B = 0;
    private static final int UNIT_KB = 1;
    private static final int UNIT_MB = 2;
    private static final int UNIT_GB = 3;
    private static final int UNIT_TB = 4;
    private static final int UNIT_PB = 5;
    public static final long BYTE = 1L;
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;
    public static final long PB = 0x4000000000000L;
    public static final long[] unitSizes = new long[]{1L, 1024L, 0x100000L, 0x40000000L, 0x10000000000L, 0x4000000000000L};

    public static Capacity newCapacity(long size, int unit) {
        return new Capacity(size, unit, false);
    }

    public static Capacity newExactCapacity(long size, int unit) {
        return new Capacity(size, unit, true);
    }

    protected Capacity() {
    }

    public Capacity(long size, int unit) {
        this(size, unit, false);
    }

    protected Capacity(long size, int unit, boolean exact) {
        this.size = size;
        this.unit = this.convertSysUnitToLocalUnit(unit);
        this.format(0, exact ? -1 : 2, exact);
    }

    protected int convertSysUnitToLocalUnit(int sysModelUnit) {
        switch (sysModelUnit) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 41: {
                return 5;
            }
        }
        return -1;
    }

    protected int convertLocalUnitToSysUnit(int localUnit) {
        switch (localUnit) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 41;
            }
        }
        return -1;
    }

    protected void format(int decPart, int precision, boolean exact) {
        if (this.sizeStr == null) {
            this.sizeStr = new NonSyncStringBuffer();
        }
        if (this.unit < 5) {
            if (this.size >= 1024L) {
                int newDecPart = (int)(this.size % 1024L);
                if (exact && newDecPart != 0) {
                    this.sizeStr.append(this.size);
                    return;
                }
                this.size /= 1024L;
                ++this.unit;
                this.format(newDecPart, precision, exact);
                return;
            }
            this.sizeStr.append(this.size);
            if (precision > 0 && this.unit > 0) {
                this.sizeStr.append(".");
                double decPartDbl = (double)decPart / 1024.0;
                for (int i = 0; i < precision; ++i) {
                    if ((decPartDbl *= 10.0) < 1.0) {
                        this.sizeStr.append("0");
                    } else {
                        this.sizeStr.append((int)decPartDbl);
                    }
                    decPartDbl -= (double)((int)decPartDbl);
                }
            }
        } else {
            this.sizeStr.append(this.size);
        }
        this.sizeStr.append(" ");
        int sunit = this.convertLocalUnitToSysUnit(this.unit);
        this.sizeStr.append(SamUtil.getSizeUnitL10NString(sunit));
    }

    protected void setSize(long size) {
        this.size = size;
    }

    protected void setUnit(int unit) {
        this.unit = unit;
    }

    public long getSize() {
        return this.size;
    }

    public int getUnit() {
        return this.convertLocalUnitToSysUnit(this.unit);
    }

    public void format(int precision) {
        this.format(0, precision, precision < 0);
    }

    public void format() {
        this.format(0, 2, false);
    }

    public Object getValue() {
        return this.toString();
    }

    public String toString() {
        String temp = this.sizeStr.toString();
        if (temp.indexOf(45) != -1) {
            return "";
        }
        return temp;
    }

    public int compareTo(Object o) {
        return this.compareTo((Capacity)o);
    }

    public int compareTo(Capacity c) {
        long this_size = this.size * unitSizes[this.unit] / 1024L;
        long c_size = c.getSize() * unitSizes[c.getUnit()] / 1024L;
        if (this_size < c_size) {
            return -1;
        }
        if (this_size > c_size) {
            return 1;
        }
        return this.toString().compareTo(c.toString());
    }

    public int compare(Object o1, Object o2) {
        return this.compare((Capacity)o1, (Capacity)o2);
    }

    public int compare(Capacity c1, Capacity c2) {
        return c1.compareTo(c2);
    }

    public static void main(String[] args) {
        boolean exact;
        if (args.length < 2) {
            System.out.println("usage : capacity <size unit> [-e]");
            System.exit(1);
        }
        boolean bl = exact = args.length == 3;
        if (exact) {
            System.out.println("[exact mode requested - no rounding]");
        }
        long size = Long.parseLong(args[0]);
        int unit = Integer.parseInt(args[1]);
        Capacity c = new Capacity(size, unit, exact);
        System.out.println("capacity.toString : " + c);
        System.out.println("capacity.getValue : " + c.getValue());
    }
}

