/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.server;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.SystemCapacity;
import com.sun.netstorage.samqfs.web.model.SystemInfo;
import com.sun.netstorage.samqfs.web.model.alarm.Alarm;
import com.sun.netstorage.samqfs.web.model.alarm.AlarmSummary;
import com.sun.netstorage.samqfs.web.util.Capacity;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.common.CCClientSniffer;
import java.util.StringTokenizer;

public class ServerUtil {
    public static final String lineBreak = "<br>";
    public static final String delimitor = "###";
    public static final int ALARM_NO_ERROR = 0;
    public static final int ALARM_CRITICAL = 1;
    public static final int ALARM_MAJOR = 2;
    public static final int ALARM_MINOR = 3;
    public static final int ALARM_DOWN = 4;
    public static final int ALARM_ACCESS_DENIED = 5;
    public static final int ALARM_NOT_SUPPORTED = 6;

    public static boolean isClientBrowserSupported() {
        TraceUtil.trace3("Entering");
        boolean isBrowserSupported = false;
        CCClientSniffer cs = new CCClientSniffer(RequestManager.getRequestContext().getRequest());
        if (cs != null) {
            SamUtil.doPrint(new NonSyncStringBuffer("Client Browser User Agent: ").append(cs.getUserAgent()).toString());
            if (cs.isGecko() || cs.isNav7up() || cs.isIe6up()) {
                SamUtil.doPrint("Browser is supported");
                isBrowserSupported = true;
            } else if (cs.isIe() && ServerUtil.isIe55up(cs.getUserAgent())) {
                SamUtil.doPrint("Browser is supported");
                isBrowserSupported = true;
            } else {
                SamUtil.doPrint("Browser is not supported");
            }
        } else {
            SamUtil.doPrint("ClientSniffer object is null.");
        }
        TraceUtil.trace3("Exiting");
        return isBrowserSupported;
    }

    private static boolean isIe55up(String agentStr) {
        TraceUtil.trace3("Entering");
        boolean returnValue = true;
        StringTokenizer firstTokens = new StringTokenizer(agentStr, ";");
        if (firstTokens.countTokens() < 2) {
            returnValue = false;
        }
        String tmpStr = firstTokens.nextToken();
        StringTokenizer secondTokens = new StringTokenizer(firstTokens.nextToken(), " ");
        if (secondTokens.countTokens() < 2) {
            returnValue = false;
        }
        tmpStr = secondTokens.nextToken();
        StringTokenizer thirdTokens = new StringTokenizer(secondTokens.nextToken(), ".");
        if (thirdTokens.countTokens() < 2) {
            returnValue = false;
        }
        tmpStr = thirdTokens.nextToken();
        try {
            int minorVersion = Integer.parseInt(thirdTokens.nextToken());
            if (minorVersion < 5) {
                returnValue = false;
            }
        }
        catch (NumberFormatException numEx) {
            TraceUtil.trace3(new NonSyncStringBuffer("Number Format ").append("Exception caught while fetching browser information").toString());
            returnValue = false;
        }
        TraceUtil.trace3("Exiting");
        return returnValue;
    }

    public static String createStringWithPercentage(long totalSize, long availableSize) {
        int percentage = 0;
        String percentSymbol = SamUtil.getResourceString("ServerSelection.percentSymbol");
        if (totalSize != 0L) {
            percentage = (int)(availableSize * 100L / totalSize);
        }
        return new NonSyncStringBuffer(ServerUtil.generateNumberWithUnitString(totalSize)).append(" (").append(percentage).append(percentSymbol).append(")").toString();
    }

    public static int getServerMostSevereAlarm(AlarmSummary myAlarmSummary) {
        int critical = myAlarmSummary.getCriticalTotal();
        int major = myAlarmSummary.getMajorTotal();
        int minor = myAlarmSummary.getMinorTotal();
        if (myAlarmSummary == null) {
            return 5;
        }
        if (critical != 0) {
            return 2;
        }
        if (major != 0) {
            return 3;
        }
        if (minor != 0) {
            return 4;
        }
        return 5;
    }

    public static int getLibraryMostSevereAlarm(Alarm[] allAlarms) throws SamFSException {
        int[] alarmInfo = SamUtil.getAlarmInfo(allAlarms);
        switch (alarmInfo[0]) {
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 5;
    }

    public static String createOSString(String name, String release, String version) {
        return new NonSyncStringBuffer(name).append(" ").append(SamUtil.getResourceString("ServerConfiguration.general.word.release")).append(" ").append(release).append(" ").append(SamUtil.getResourceString("ServerConfiguration.general.word.version")).append(" ").append(version).toString();
    }

    public static String createServerEntry(SamQFSSystemModel sysModel) throws SamFSException {
        NonSyncStringBuffer myBuf = new NonSyncStringBuffer("");
        String diskCacheWord = SamUtil.getResourceString("SiteInformation.server.word.diskCache");
        String memoryWord = SamUtil.getResourceString("SiteInformation.server.word.memory");
        String cpusWord = SamUtil.getResourceString("SiteInformation.server.word.cpus");
        SystemInfo mySystemInfo = sysModel.getSystemInfo();
        SystemCapacity mySystemCapacity = sysModel.getCapacity();
        String memoryValue = new Capacity(mySystemInfo.getMemoryMB(), 2).toString();
        String osString = ServerUtil.createOSString(mySystemInfo.getOSname(), mySystemInfo.getRelease(), mySystemInfo.getVersion());
        String serverDiskCache = mySystemCapacity.getDiskCacheKB() == -1L ? new NonSyncStringBuffer("0 ").append(SamUtil.getSizeUnitL10NString(1)).toString() : ServerUtil.generateNumberWithUnitString(mySystemCapacity.getDiskCacheKB());
        String serverName = sysModel.getHostname();
        String samfsServerAPIVersion = sysModel.getServerAPIVersion();
        String string = samfsServerAPIVersion = samfsServerAPIVersion == null ? "1.3" : samfsServerAPIVersion;
        if (SamUtil.isVersionCurrentOrLaterThan(samfsServerAPIVersion, "1.4") && sysModel.isClusterNode()) {
            serverName = SamUtil.getResourceString("ServerSelection.host.clusterword", new String[]{serverName, sysModel.getClusterName()});
        }
        myBuf.append("<b>").append(serverName);
        myBuf.append("     ").append(ServerUtil.createIPAddressesString(mySystemInfo.getIPAddresses()));
        myBuf.append("</b><br />");
        myBuf.append(osString).append("<br />");
        myBuf.append(Integer.toString(mySystemInfo.getCPUs())).append(" ").append(cpusWord).append(" ");
        myBuf.append(serverDiskCache).append(" ").append(diskCacheWord);
        myBuf.append("<br />").append(memoryValue).append(" ").append(memoryWord);
        return myBuf.toString();
    }

    private static String createIPAddressesString(String origIPAddressString) {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer();
        String[] ipArray = origIPAddressString.split(" ");
        buffer.append(" ( <i>");
        for (int i = 0; i < ipArray.length; ++i) {
            if (i > 0) {
                buffer.append(" ,  ");
            }
            buffer.append(ipArray[i]);
        }
        buffer.append(" </i>)");
        return buffer.toString();
    }

    public static String generateNumberWithUnitString(String numberString) {
        long number = -1L;
        try {
            number = Long.parseLong(numberString);
        }
        catch (NumberFormatException numEx) {
            return Long.toString(number);
        }
        Capacity myCapacity = new Capacity(number, 1);
        return myCapacity.toString();
    }

    public static String generateNumberWithUnitString(long number) {
        Capacity myCapacity = new Capacity(number, 1);
        return myCapacity.toString();
    }

    public static String getVersionString(String guiVersionString) {
        if (guiVersionString.compareTo("4.5") >= 0) {
            return SamUtil.getResourceString("ServerSelection.version.45");
        }
        if (guiVersionString.compareTo("4.4") >= 0) {
            return SamUtil.getResourceString("ServerSelection.version.44");
        }
        return SamUtil.getResourceString("ServerSelection.version.unknown");
    }
}

