/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.server;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.archive.MultiTableViewBase;
import com.sun.netstorage.samqfs.web.model.ClusterNodeInfo;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.common.CCPagelet;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.html.CCCheckBox;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCStaticTextField;
import com.sun.web.ui.view.table.CCActionTable;
import java.net.UnknownHostException;
import java.util.Map;

public class AddClusterView
extends MultiTableViewBase
implements CCPagelet {
    public static final String STATIC_TEXT = "StaticText";
    public static final String CLUSTER_TABLE = "AddClusterTable";
    public static final String NODE_NAMES = "NodeNames";
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCStaticTextField;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;

    public AddClusterView(View parent, Map models, String name) {
        super(parent, models, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren();
        this.registerChild(STATIC_TEXT, class$com$sun$web$ui$view$html$CCStaticTextField == null ? (class$com$sun$web$ui$view$html$CCStaticTextField = AddClusterView.class$("com.sun.web.ui.view.html.CCStaticTextField")) : class$com$sun$web$ui$view$html$CCStaticTextField);
        this.registerChild(NODE_NAMES, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = AddClusterView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        TraceUtil.trace3("Entering");
        CCStaticTextField child = null;
        if (name.equals(STATIC_TEXT)) {
            child = new CCStaticTextField((ContainerView)this, name, null);
        } else if (name.equals(CLUSTER_TABLE)) {
            child = this.createTable(name);
        } else if (name.equals(NODE_NAMES)) {
            child = new CCHiddenField((ContainerView)this, name, null);
        } else {
            CCActionTableModel model = super.isChildSupported(name);
            if (model != null) {
                child = super.isChildSupported(name).createChild((View)this, name);
            }
        }
        if (child == null) {
            throw new IllegalArgumentException("Invalid Child '" + name + "'");
        }
        TraceUtil.trace3("Exiting");
        return child;
    }

    protected void initializeTableHeaders() {
        CCActionTableModel model = this.getTableModel(CLUSTER_TABLE);
        model.setActionValue("NameColumn", (Object)"AddCluster.heading.name");
        model.setActionValue("StatusColumn", (Object)"AddCluster.heading.status");
        model.setActionValue("IDColumn", (Object)"AddCluster.heading.id");
        model.setActionValue("PrivateIPColumn", (Object)"AddCluster.heading.privateip");
    }

    public void populateTableModel() {
        String alreadyAddedClusterNode = (String)this.getParentViewBean().getPageSessionAttribute("SAMQFS_CLUSTER_NODE");
        CCActionTableModel tableModel = this.getTableModel(CLUSTER_TABLE);
        tableModel.clear();
        int counter = 0;
        try {
            SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
            SamQFSSystemModel sysModel = appModel.getSamQFSSystemModel(alreadyAddedClusterNode);
            NonSyncStringBuffer nodeBuf = new NonSyncStringBuffer();
            String clusterVersion = sysModel.getClusterVersion();
            String clusterName = sysModel.getClusterName();
            tableModel.setTitle(SamUtil.getResourceString("AddCluster.tabletitle", new String[]{alreadyAddedClusterNode, clusterVersion}));
            ClusterNodeInfo[] nodeInfos = sysModel.getClusterNodes();
            CCActionTable myTable = (CCActionTable)this.getChild(CLUSTER_TABLE);
            for (int i = 0; i < nodeInfos.length; ++i) {
                String nodeName = nodeInfos[i].getName();
                if (alreadyAddedClusterNode.equals(nodeName) || appModel.getInetHostName(nodeName) != null) continue;
                CCCheckBox myCheckBox = (CCCheckBox)myTable.getChild("SelectionCheckbox" + counter);
                myCheckBox.setTitle("");
                myCheckBox.setTitleDisabled("");
                if (counter++ > 0) {
                    tableModel.appendRow();
                }
                tableModel.setValue("NameText", (Object)nodeName);
                tableModel.setValue("StatusText", (Object)nodeInfos[i].getStatus());
                tableModel.setValue("IDText", (Object)new Integer(nodeInfos[i].getID()));
                tableModel.setValue("PrivateIPText", (Object)nodeInfos[i].getPrivIP());
                nodeBuf.append(nodeName).append(";");
            }
            ((CCHiddenField)this.getChild(NODE_NAMES)).setValue((Object)nodeBuf.toString());
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "populateTableModel", "unable to populate table model", alreadyAddedClusterNode);
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "AddCluster.error.showall", sfe.getSAMerrno(), sfe.getMessage(), alreadyAddedClusterNode);
        }
        catch (UnknownHostException ex) {
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "AddCluster.error.showall", -2551, ex.getMessage(), alreadyAddedClusterNode);
        }
    }

    public void beginDisplay(DisplayEvent evt) throws ModelControlException {
        TraceUtil.trace3("Entering");
        this.initializeTableHeaders();
        String clusterNode = (String)this.getParentViewBean().getPageSessionAttribute("SAMQFS_CLUSTER_NODE");
        if (clusterNode != null) {
            ((CCStaticTextField)this.getChild(STATIC_TEXT)).setValue((Object)SamUtil.getResourceString("AddCluster.instruction", new String[]{clusterNode}));
        }
        TraceUtil.trace3("Exiting");
    }

    public String getPageletUrl() {
        String clusterNode = (String)this.getParentViewBean().getPageSessionAttribute("SAMQFS_CLUSTER_NODE");
        if (clusterNode != null) {
            return "/jsp/server/AddClusterPagelet.jsp";
        }
        return "/jsp/archive/BlankPagelet.jsp";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

