/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.test.fs;

import com.sun.netstorage.samqfs.web.model.SamQFSSystemFSManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.fs.RemoteFile;
import com.sun.netstorage.samqfs.web.model.impl.test.BaseTest;

public class DirListTest {
    static int MAX_ENTRIES = 100;
    static String DEFAULT_PATH = "/";

    public static void main(String[] args) {
        String path = args.length == 0 ? DEFAULT_PATH : args[0];
        try {
            SamQFSSystemModel[] models = BaseTest.getAllSamQFSSystemModels();
            if (models != null && models.length > 0) {
                SamQFSSystemModel selModel = models[0];
                System.out.println("List files under " + path + " on host " + selModel.getHostname());
                SamQFSSystemFSManager fsMgr = selModel.getSamQFSSystemFSManager();
                RemoteFile[] files = fsMgr.getDirEntries(MAX_ENTRIES, path, null);
                if (files != null) {
                    if (files.length > 0) {
                        for (int i = 0; i < files.length; ++i) {
                            System.out.println("\t " + files[i]);
                        }
                    } else {
                        System.out.println("no files found");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

