/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator.fs;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.fs.RestoreFile;
import com.sun.netstorage.samqfs.web.model.impl.simulator.fs.RestoreFileImpl;
import java.io.File;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Random;

public class RestoreDumpFileContents {
    private RestoreFile[] entries;
    private String fileSystemName;
    private static final int MAX_DIRECTORY_DEPTH = 4;
    private static final String ROOT = "/";
    private static final HashSet EXCLUSION_LIST = new HashSet();

    private RestoreDumpFileContents() {
    }

    public RestoreDumpFileContents(String fileSystemName, int maxNumberOfEntries) throws SamFSException {
        this.fileSystemName = fileSystemName;
        if (maxNumberOfEntries < 1) {
            throw new SamFSException("Max number of entries specified for dump file is invalid:  " + String.valueOf(maxNumberOfEntries));
        }
        this.entries = new RestoreFile[maxNumberOfEntries];
        int currentEntry = 0;
        int directoryDepth = 0;
        File rootFile = new File(ROOT);
        File[] sysFiles = rootFile.listFiles();
        currentEntry = this.loadEntries(sysFiles, currentEntry, maxNumberOfEntries, directoryDepth);
    }

    public int loadEntries(File[] sysFiles, int currentEntry, int maxNumberOfEntries, int directoryDepth) throws SamFSException {
        if (sysFiles == null) {
            return currentEntry;
        }
        ++directoryDepth;
        GregorianCalendar now = new GregorianCalendar();
        Random rand = new Random(now.getTimeInMillis());
        for (int i = 0; i < sysFiles.length && currentEntry < maxNumberOfEntries; ++i) {
            String path;
            File sysFile = sysFiles[i];
            GregorianCalendar modifiedDate = new GregorianCalendar();
            modifiedDate.setTimeInMillis(sysFile.lastModified());
            Boolean isDamaged = rand.nextBoolean();
            Boolean isOnline = rand.nextBoolean();
            if (!sysFile.isDirectory()) {
                this.entries[currentEntry] = new RestoreFileImpl(false, "." + sysFile.getAbsolutePath(), Long.toString(sysFile.length()), "-rwxrwxrwx", "root", "other", modifiedDate, modifiedDate, isDamaged, isOnline);
                ++currentEntry;
                continue;
            }
            if (directoryDepth >= 4 || EXCLUSION_LIST.contains(path = sysFile.getAbsolutePath())) continue;
            this.entries[currentEntry] = new RestoreFileImpl(true, "." + path, Long.toString(sysFile.length()), "drwxrwxrwx", "root", "other", modifiedDate, modifiedDate, isDamaged, isOnline);
            ++currentEntry;
            File[] nextLevelDir = sysFile.listFiles();
            currentEntry = this.loadEntries(nextLevelDir, currentEntry, maxNumberOfEntries, directoryDepth);
        }
        --directoryDepth;
        return currentEntry;
    }

    public RestoreFile[] getRestoreFiles() {
        return this.entries;
    }

    static {
        EXCLUSION_LIST.add("/lost+found");
    }
}

