/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator.archive43;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.archive43.VSNPool;
import com.sun.netstorage.samqfs.web.model.media.DiskVolume;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import java.util.ArrayList;

public class VSNPoolImpl
implements VSNPool {
    private String poolName = null;
    private int mediaType = -1;
    private long spaceAvailable = -1L;
    private String vsnExp = null;
    private ArrayList memberVSNs = null;
    private ArrayList memberDiskVols = null;

    public VSNPoolImpl() {
    }

    public VSNPoolImpl(String poolName, int mediaType, String vsnExp, ArrayList memberVSNs, ArrayList diskVols) {
        this.poolName = poolName;
        this.mediaType = mediaType;
        this.vsnExp = vsnExp;
        this.memberVSNs = memberVSNs;
        this.memberDiskVols = diskVols;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public int getMediaType() {
        return this.mediaType;
    }

    public long getSpaceAvailable() throws SamFSException {
        long available = 0L;
        if (this.memberVSNs != null) {
            for (int i = 0; i < this.memberVSNs.size(); ++i) {
                available += ((VSN)this.memberVSNs.get(i)).getAvailableSpace();
            }
        }
        return available;
    }

    public String getVSNExpression() {
        return this.vsnExp;
    }

    public VSN[] getMemberVSNs() throws SamFSException {
        return this.memberVSNs.toArray(new VSN[0]);
    }

    public VSN[] getMemberVSNs(int start, int size, int sortby, boolean ascending) throws SamFSException {
        return this.memberVSNs.toArray(new VSN[0]);
    }

    public void setMemberVSNs(int mediaType, String expression, VSN[] memberVSNs) throws SamFSException {
        this.mediaType = mediaType;
        this.vsnExp = expression;
        if (this.memberVSNs == null) {
            this.memberVSNs = new ArrayList();
        } else {
            this.memberVSNs.clear();
        }
        if (memberVSNs != null) {
            for (int i = 0; i < memberVSNs.length; ++i) {
                this.memberVSNs.add(memberVSNs[i]);
            }
        }
    }

    public void setMemberVSNs(int mediaType, String expression) throws SamFSException {
        this.mediaType = mediaType;
        this.vsnExp = expression;
    }

    public int getNoOfVSNsInPool() throws SamFSException {
        return this.memberVSNs.size();
    }

    public Object clone() {
        VSNPoolImpl newPool = null;
        try {
            ArrayList vsnList = null;
            if (this.memberVSNs != null) {
                vsnList = new ArrayList();
                for (int i = 0; i < this.memberVSNs.size(); ++i) {
                    vsnList.add(this.memberVSNs.get(i));
                }
            }
            ArrayList dvolList = null;
            if (this.memberDiskVols != null) {
                dvolList = new ArrayList();
                for (int i = 0; i < this.memberDiskVols.size(); ++i) {
                    dvolList.add(this.memberDiskVols.get(i));
                }
            }
            newPool = new VSNPoolImpl(this.getPoolName(), this.getMediaType(), this.getVSNExpression(), vsnList, dvolList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newPool;
    }

    public String toString() {
        long spaceAvailable = 0L;
        try {
            spaceAvailable = this.getSpaceAvailable();
        }
        catch (Exception e) {
            // empty catch block
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Pool Name: " + this.poolName + "\n");
        buf.append("Media Type: " + this.mediaType + "\n");
        buf.append("Space Available: " + spaceAvailable + "\n");
        buf.append("VSN Expression: " + this.vsnExp + "\n");
        try {
            if (this.memberVSNs != null) {
                for (int i = 0; i < this.memberVSNs.size(); ++i) {
                    buf.append("VSN Members: " + (VSN)this.memberVSNs.get(i) + "\n\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    public DiskVolume[] getMemberDiskVolumes(int start, int size, int sortby, boolean ascending) throws SamFSException {
        return this.memberDiskVols.toArray(new DiskVolume[0]);
    }
}

