/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator.archive43;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.archive43.BufferDirective;
import com.sun.netstorage.samqfs.web.model.media.Library;
import java.util.ArrayList;

public class BufferDirectiveImpl
implements BufferDirective {
    private int mediaType = -1;
    private long size = -1L;
    private boolean lock = false;
    private ArrayList libList = new ArrayList();

    public BufferDirectiveImpl() {
    }

    public BufferDirectiveImpl(int mediaType, long size, boolean lock) {
        this.mediaType = mediaType;
        this.size = size;
        this.lock = lock;
    }

    public int getMediaType() {
        return this.mediaType;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getSizeString() {
        return Long.toString(this.size);
    }

    public void setSizeString(String sizeStr) {
        try {
            this.size = new Integer(sizeStr).intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isLocked() {
        return this.lock;
    }

    public void setLocked(boolean lock) {
        this.lock = lock;
    }

    public void addLibrary(Library lib) throws SamFSException {
        if (lib == null) {
            throw new SamFSException("INVALID_LIBRARY");
        }
        int index = this.libList.indexOf(lib);
        if (index == -1) {
            this.libList.add(lib);
        }
    }

    public void removeLibrary(Library lib) throws SamFSException {
        if (lib == null) {
            throw new SamFSException("INVALID_LIBRARY");
        }
        int index = this.libList.indexOf(lib);
        if (index == -1) {
            throw new SamFSException("NO_SUCH_LIBRARY");
        }
        this.libList.remove(index);
    }

    public int getNoOfLibraries() {
        return this.libList.size();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Media Type: " + this.mediaType + "\n");
        buf.append("Size: " + this.size + "\n");
        buf.append("Locked: " + this.lock + "\n");
        return buf.toString();
    }
}

