/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemArchiveManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive.ArchiveCopy;
import com.sun.netstorage.samqfs.web.model.archive.ArchiveFileParams;
import com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.archive.GlobalArchiveDirective;
import com.sun.netstorage.samqfs.web.model.archive.VSNPool;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive.ArchivePolicyImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive.GlobalArchiveDirectiveImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive.VSNPoolImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.fs.FileSystemImpl;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import java.util.ArrayList;
import java.util.HashMap;

public class SamQFSSystemArchiveManagerImpl
implements SamQFSSystemArchiveManager {
    SamQFSSystemModelImpl theModel;
    private HashMap vsnPoolMap = new HashMap();
    private GlobalArchiveDirectiveImpl globalArch = new GlobalArchiveDirectiveImpl();

    public SamQFSSystemArchiveManagerImpl(SamQFSSystemModel model) {
        this.theModel = (SamQFSSystemModelImpl)model;
    }

    public GlobalArchiveDirective getGlobalDirective() throws SamFSException {
        return this.globalArch;
    }

    public void setGlobalDirective(GlobalArchiveDirective global) throws SamFSException {
        this.globalArch = (GlobalArchiveDirectiveImpl)global;
    }

    public boolean isValidGroup(String groupName) throws SamFSException {
        return true;
    }

    public String[] getAllArchivePolicyNames() throws SamFSException {
        String[] names = new String[]{};
        ArchivePolicy[] pols = this.getAllArchivePolicies();
        if (pols != null) {
            names = new String[pols.length];
            for (int i = 0; i < pols.length; ++i) {
                names[i] = pols[i].getPolicyName();
            }
        }
        return names;
    }

    public ArchivePolicy[] getAllArchivePolicies() throws SamFSException {
        return this.theModel.getPolicyMap().values().toArray(new ArchivePolicy[0]);
    }

    public ArchivePolicy getArchivePolicy(String policyName) throws SamFSException {
        return (ArchivePolicy)this.theModel.getPolicyMap().get(policyName);
    }

    public ArchivePolicy getDefaultArchivePolicy() throws SamFSException {
        return SamQFSUtil.createDefaultPolicy();
    }

    public ArchivePolicy createArchivePolicy(String policyName, String startingDir, ArchiveFileParams param, ArchiveCopy[] copies, FileSystem[] filesystems) throws SamFSException {
        int i;
        ArrayList<ArchiveCopy> copy = null;
        if (copies != null && !policyName.equals("no_archive")) {
            copy = new ArrayList<ArchiveCopy>();
            for (int i2 = 0; i2 < copies.length; ++i2) {
                copy.add(copies[i2]);
            }
        }
        ArrayList<FileSystem> fs2 = null;
        if (filesystems != null) {
            fs2 = new ArrayList<FileSystem>();
            for (i = 0; i < filesystems.length; ++i) {
                fs2.add(filesystems[i]);
            }
        }
        if (filesystems != null) {
            block2: for (i = 0; i < filesystems.length; ++i) {
                ArchivePolicy[] pols = filesystems[i].getArchivePoliciesForFS();
                if (pols == null || pols.length <= 0) continue;
                for (int j = 0; j < pols.length; ++j) {
                    if (!pols[j].getPolicyName().equals(policyName)) continue;
                    ((FileSystemImpl)filesystems[i]).removePol(policyName);
                    continue block2;
                }
            }
        }
        ArchivePolicyImpl policy = new ArchivePolicyImpl(this.theModel, policyName, startingDir, param, copy, fs2);
        this.theModel.getPolicyMap().put(policyName, policy);
        if (filesystems != null) {
            for (int i3 = 0; i3 < filesystems.length; ++i3) {
                ((FileSystemImpl)filesystems[i3]).addPol(policy);
            }
        }
        this.theModel.getDataStore().clearSavedPolicy();
        return policy;
    }

    public void convertLegacyPolicy(ArchivePolicy pol) throws SamFSException {
        ((ArchivePolicyImpl)pol).setLegacy(false);
    }

    public void deleteArchivePolicy(ArchivePolicy pol) throws SamFSException {
        if (pol == null) {
            throw new SamFSException("INVALID_POLICY");
        }
        FileSystem[] fs2 = pol.getFileSystemsForPolicy();
        if (fs2 != null) {
            for (int i = 0; i < fs2.length; ++i) {
                fs2[i].removePolicy(pol);
            }
        }
        this.theModel.getPolicyMap().remove(pol.getPolicyName());
    }

    public String[] getAllPoolNames() throws SamFSException {
        VSNPool[] pools = this.getAllVSNPools();
        String[] names = new String[]{};
        if (pools != null) {
            names = new String[pools.length];
            for (int i = 0; i < pools.length; ++i) {
                names[i] = pools[i].getPoolName();
            }
        }
        return names;
    }

    public VSNPool[] getAllVSNPools() throws SamFSException {
        return this.vsnPoolMap.values().toArray(new VSNPool[0]);
    }

    public VSNPool getVSNPool(String poolName) throws SamFSException {
        return (VSNPool)this.vsnPoolMap.get(poolName);
    }

    public VSNPool createVSNPool(String poolName, int mediaType, String vsnExpr) throws SamFSException {
        return this.createVSNPool(poolName, mediaType, vsnExpr, null);
    }

    public VSNPool createVSNPool(String poolName, int mediaType, String vsnExpr, VSN[] memberVSNs) throws SamFSException {
        ArrayList<VSN> vsn = null;
        if (memberVSNs != null) {
            vsn = new ArrayList<VSN>();
            for (int i = 0; i < memberVSNs.length; ++i) {
                vsn.add(memberVSNs[i]);
            }
        }
        VSNPoolImpl pool = new VSNPoolImpl(poolName, mediaType, vsnExpr, vsn);
        this.vsnPoolMap.put(poolName, pool);
        return pool;
    }

    public void updateVSNPool(String poolName) throws SamFSException {
    }

    public boolean isPoolInUse(String poolName) throws SamFSException {
        return false;
    }

    public void deleteVSNPool(VSNPool pool) throws SamFSException {
        if (pool == null) {
            throw new SamFSException("INVALID_POOL");
        }
        this.vsnPoolMap.remove(pool.getPoolName());
    }

    public void deleteVSNPool(String poolName) throws SamFSException {
        this.deleteVSNPool(this.getVSNPool(poolName));
    }
}

