/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.archive43;

import com.sun.netstorage.samqfs.mgmt.arc.BufDirective;
import com.sun.netstorage.samqfs.web.model.archive43.BufferDirective;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;

public class BufferDirectiveImpl
implements BufferDirective {
    private BufDirective buf = null;
    private int mediaType = -1;
    private long size = -1L;
    private boolean lock = false;

    public BufferDirectiveImpl() {
    }

    public BufferDirectiveImpl(int mediaType, long size, boolean lock) {
        this.mediaType = mediaType;
        this.size = size;
        this.lock = lock;
        this.buf = new BufDirective(SamQFSUtil.getMediaTypeString(mediaType), String.valueOf(size), lock);
    }

    public BufferDirectiveImpl(BufDirective buf) {
        this.buf = buf;
        if (buf != null) {
            this.mediaType = SamQFSUtil.getMediaTypeInteger(buf.getMediaType());
            try {
                String jniSize = buf.getSize();
                if (SamQFSUtil.isValidString(jniSize)) {
                    this.size = Long.parseLong(jniSize);
                }
            }
            catch (NumberFormatException ne) {
                SamQFSUtil.doPrint(buf.getSize());
                SamQFSUtil.doPrint("Unit needs to be fixed.");
                this.size = -1L;
            }
            this.lock = buf.isLock();
        }
    }

    public BufDirective getJniBufferDirective() {
        return this.buf;
    }

    public int getMediaType() {
        return this.mediaType;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
        if (this.buf != null) {
            if (size != -1L) {
                this.buf.setSize(String.valueOf(size));
            } else {
                this.buf.resetSize();
            }
        }
    }

    public String getSizeString() {
        String jniSize;
        String sizeStr = new String();
        if (this.buf != null && SamQFSUtil.isValidString(jniSize = this.buf.getSize())) {
            sizeStr = jniSize;
        }
        return sizeStr;
    }

    public void setSizeString(String sizeStr) {
        if (SamQFSUtil.isValidString(sizeStr)) {
            this.size = -1L;
            try {
                this.size = Long.parseLong(sizeStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.buf != null) {
                this.buf.setSize(sizeStr);
            }
        } else {
            this.size = -1L;
            if (this.buf != null) {
                this.buf.resetSize();
            }
        }
    }

    public boolean isLocked() {
        return this.lock;
    }

    public void setLocked(boolean lock) {
        this.lock = lock;
        if (this.buf != null) {
            this.buf.setLock(lock);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Media Type: " + this.mediaType + "\n");
        buf.append("Size: " + this.size + "\n");
        buf.append("Locked: " + this.lock + "\n");
        return buf.toString();
    }
}

