/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.archive43;

import com.sun.netstorage.samqfs.mgmt.arc.Copy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaCopy;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;

public class ArchivePolCriteriaCopyImpl
implements ArchivePolCriteriaCopy {
    private ArchivePolCriteria archPolCriteria = null;
    private Copy copy = null;
    private int copyNumber = -1;
    private long archAge = -1L;
    private int archAgeUnit = -1;
    private long unarchAge = -1L;
    private int unarchAgeUnit = -1;
    private boolean release = false;
    private boolean noRelease = false;

    public ArchivePolCriteriaCopyImpl(ArchivePolCriteria archPolCriteria, Copy copy, int copyNumber2) {
        this.archPolCriteria = archPolCriteria;
        this.copy = copy;
        this.copyNumber = copyNumber2;
        if (copy != null) {
            String tmp;
            long sec = copy.getArchiveAge();
            if (sec >= 0L) {
                tmp = SamQFSUtil.longToInterval(sec);
                this.archAge = SamQFSUtil.getLongValSecond(tmp);
                this.archAgeUnit = SamQFSUtil.getTimeUnitInteger(tmp);
            }
            if ((sec = copy.getUnarchiveAge()) >= 0L) {
                tmp = SamQFSUtil.longToInterval(sec);
                this.unarchAge = SamQFSUtil.getLongValSecond(tmp);
                this.unarchAgeUnit = SamQFSUtil.getTimeUnitInteger(tmp);
            }
            this.release = copy.isRelease();
            this.noRelease = copy.isNoRelease();
        } else {
            this.copy = new Copy();
        }
    }

    public ArchivePolCriteria getArchivePolCriteria() {
        return this.archPolCriteria;
    }

    public void setArchivePolCriteria(ArchivePolCriteria archPolCriteria) {
        this.archPolCriteria = archPolCriteria;
    }

    public Copy getJniCopy() {
        return this.copy;
    }

    public int getArchivePolCriteriaCopyNumber() {
        return this.copyNumber;
    }

    public void setArchivePolCriteriaCopyNumber(int copyNumber2) {
        this.copyNumber = copyNumber2;
    }

    public long getArchiveAge() {
        return this.archAge;
    }

    public void setArchiveAge(long archAge) {
        this.archAge = archAge;
        if (archAge != -1L && this.archAgeUnit != -1) {
            this.copy.setArchiveAge(SamQFSUtil.convertToSecond(archAge, this.archAgeUnit));
        } else {
            this.copy.resetArchiveAge();
        }
    }

    public int getArchiveAgeUnit() {
        return this.archAgeUnit;
    }

    public void setArchiveAgeUnit(int archAgeUnit) {
        this.archAgeUnit = archAgeUnit;
        if (this.archAge != -1L && archAgeUnit != -1) {
            this.copy.setArchiveAge(SamQFSUtil.convertToSecond(this.archAge, archAgeUnit));
        } else {
            this.copy.resetArchiveAge();
        }
    }

    public long getUnarchiveAge() {
        return this.unarchAge;
    }

    public void setUnarchiveAge(long unarchAge) {
        this.unarchAge = unarchAge;
        if (unarchAge != -1L && this.unarchAgeUnit != -1) {
            this.copy.setUnarchiveAge(SamQFSUtil.convertToSecond(unarchAge, this.unarchAgeUnit));
        } else {
            this.copy.resetUnarchiveAge();
        }
    }

    public int getUnarchiveAgeUnit() {
        return this.unarchAgeUnit;
    }

    public void setUnarchiveAgeUnit(int unarchAgeUnit) {
        this.unarchAgeUnit = unarchAgeUnit;
        if (this.unarchAge != -1L && unarchAgeUnit != -1) {
            this.copy.setUnarchiveAge(SamQFSUtil.convertToSecond(this.unarchAge, unarchAgeUnit));
        } else {
            this.copy.resetUnarchiveAge();
        }
    }

    public boolean isRelease() {
        return this.release;
    }

    public void setRelease(boolean release) {
        this.release = release;
        this.copy.setRelease(release);
    }

    public boolean isNoRelease() {
        return this.noRelease;
    }

    public void setNoRelease(boolean noRelease) {
        this.noRelease = noRelease;
        this.copy.setNoRelease(noRelease);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.archPolCriteria == null) {
            buf.append("Policy criteria is null for this copy object.\n");
        }
        buf.append("Archive Age: " + this.archAge + "\n");
        buf.append("Archive Age Unit: " + this.archAgeUnit + "\n");
        buf.append("Unarchive Age: " + this.unarchAge + "\n");
        buf.append("Unarchive Age Unit: " + this.unarchAgeUnit + "\n");
        buf.append("Release: " + this.release + "\n");
        buf.append("NoRelease: " + this.noRelease + "\n");
        return buf.toString();
    }
}

