/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.archive43;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.arc.CopyParams;
import com.sun.netstorage.samqfs.mgmt.rec.RecyclerParams;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveVSNMap;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.ArchiveVSNMapImpl;

public class ArchiveCopyImpl
implements ArchiveCopy {
    private ArchivePolicy archPolicy = null;
    private ArchiveVSNMap archVSNMap = null;
    private int copyNumber = -1;
    private CopyParams param = null;
    private boolean rearchive = false;
    private String diskArchVSN = new String();
    private String diskArchVSNPath = new String();
    private String diskArchVSNHost = new String();
    private int resMethod = -1;
    private int archSortMethod = -1;
    private int offlineCopyMethod = -1;
    private int drives = -1;
    private long maxDrives = -1L;
    private int maxDrivesUnit = -1;
    private long minDrives = -1L;
    private int minDrivesUnit = -1;
    private int joinMethod = -1;
    private int unarchTimeRef = -1;
    private boolean fillVSNs = false;
    private long overflowMinSize = -1L;
    private int overflowMinSizeUnit = -1;
    private long archMaxSize = -1L;
    private int archMaxSizeUnit = -1;
    private int bufSize = -1;
    private boolean bufLocked = false;
    private long startAge = -1L;
    private int startAgeUnit = -1;
    private int startCount = -1;
    private long startSize = -1L;
    private int startSizeUnit = -1;
    private long recDataSize = -1L;
    private int recDataSizeUnit = -1;
    private int recHWM = -1;
    private boolean ignoreRec = false;
    private String notifyAddr = new String();
    private int minGain = -1;
    private int maxVSNCount = -1;

    public ArchiveCopyImpl(ArchivePolicy policy, ArchiveVSNMap map, int copyNumber2, CopyParams param) {
        this.archPolicy = policy;
        this.archVSNMap = map;
        this.copyNumber = copyNumber2;
        this.param = param;
        if (param != null) {
            RecyclerParams recP;
            String size;
            this.resMethod = param.getReservationMethod();
            this.archSortMethod = SamQFSUtil.convertARSortMethod(param.getArchiveSortMethod());
            this.offlineCopyMethod = SamQFSUtil.convertAROfflineCopyMethod(param.getOfflineCopyMethod());
            this.diskArchVSN = param.getDiskArchiveVol();
            this.drives = param.getDrives();
            String tmp = param.getMaxDrives();
            if (SamQFSUtil.isValidString(tmp)) {
                size = SamQFSUtil.stringToFsize(tmp);
                this.maxDrives = SamQFSUtil.getLongVal(size);
                this.maxDrivesUnit = SamQFSUtil.getSizeUnitInteger(size);
            }
            if (SamQFSUtil.isValidString(tmp = param.getMinDrives())) {
                size = SamQFSUtil.stringToFsize(tmp);
                this.minDrives = SamQFSUtil.getLongVal(size);
                this.minDrivesUnit = SamQFSUtil.getSizeUnitInteger(size);
            }
            this.joinMethod = SamQFSUtil.convertARJoinMethod(param.getJoinMethod());
            this.unarchTimeRef = !param.getUnarchAge() ? 11 : 12;
            this.fillVSNs = param.isFillVSNs();
            tmp = param.getOverflowMinSize();
            if (SamQFSUtil.isValidString(tmp)) {
                size = SamQFSUtil.stringToFsize(tmp);
                this.overflowMinSize = SamQFSUtil.getLongVal(size);
                this.overflowMinSizeUnit = SamQFSUtil.getSizeUnitInteger(size);
            }
            if (SamQFSUtil.isValidString(tmp = param.getArchMax())) {
                size = SamQFSUtil.stringToFsize(tmp);
                this.archMaxSize = SamQFSUtil.getLongVal(size);
                this.archMaxSizeUnit = SamQFSUtil.getSizeUnitInteger(size);
            }
            this.bufSize = param.getBufSize();
            if (this.bufSize < 2 || this.bufSize > 1024) {
                this.bufSize = -1;
            }
            this.bufLocked = param.isBufferLocked();
            long sec = param.getStartAge();
            if (sec >= 0L) {
                tmp = SamQFSUtil.longToInterval(sec);
                this.startAge = SamQFSUtil.getLongValSecond(tmp);
                this.startAgeUnit = SamQFSUtil.getTimeUnitInteger(tmp);
            }
            this.startCount = param.getStartCount();
            tmp = param.getStartSize();
            if (SamQFSUtil.isValidString(tmp)) {
                size = SamQFSUtil.stringToFsize(tmp);
                this.startSize = SamQFSUtil.getLongVal(size);
                this.startSizeUnit = SamQFSUtil.getSizeUnitInteger(size);
            }
            if ((recP = param.getRecyclerParams()) != null) {
                if (SamQFSUtil.isValidString(recP.getDatasize())) {
                    String size2 = SamQFSUtil.stringToFsize(recP.getDatasize());
                    this.recDataSize = SamQFSUtil.getLongVal(size2);
                    this.recDataSizeUnit = SamQFSUtil.getSizeUnitInteger(size2);
                }
                this.recHWM = recP.getHWM();
                this.ignoreRec = recP.getIgnore();
                this.notifyAddr = recP.getEmailAddr();
                this.minGain = recP.getMinGain();
                this.maxVSNCount = recP.getVSNCount();
            }
        } else {
            this.param = new CopyParams("Unknown");
        }
    }

    public CopyParams getJniCopyParams() {
        ArchivePolicy pol;
        if (this.param.getName().equals("Unknown") && (pol = this.getArchivePolicy()) != null) {
            this.param = new CopyParams(pol.getPolicyName() + "." + this.getCopyNumber(), this.param);
        }
        return this.param;
    }

    public ArchivePolicy getArchivePolicy() {
        return this.archPolicy;
    }

    public void setArchivePolicy(ArchivePolicy archPolicy) {
        this.archPolicy = archPolicy;
    }

    public int getCopyNumber() {
        return this.copyNumber;
    }

    public void setCopyNumber(int copyNumber2) {
        this.copyNumber = copyNumber2;
    }

    public ArchiveVSNMap _getEffectiveArchiveVSNMap() throws SamFSException {
        if (this.archVSNMap != null) {
            return this.archVSNMap;
        }
        SamQFSSystemModel model = this.getArchivePolicy().getModel();
        ArchivePolicy allsets = model.getSamQFSSystemArchiveManager43().getArchivePolicy("allsets");
        ArchiveCopy matchingAllsetsCopy = allsets.getArchiveCopy(this.getCopyNumber());
        if (matchingAllsetsCopy != null) {
            this.archVSNMap = matchingAllsetsCopy.getArchiveVSNMap();
        }
        if (this.archVSNMap == null) {
            this.archVSNMap = allsets.getArchiveCopy(5).getArchiveVSNMap();
        }
        if (this.archVSNMap == null) {
            this.archVSNMap = new ArchiveVSNMapImpl(this, null);
            String copyName = this.getArchivePolicy().getPolicyName().concat(".").concat(Integer.toString(this.getCopyNumber()));
            this.archVSNMap.getInternalVSNMap().setCopyName(copyName);
        }
        return this.archVSNMap;
    }

    public ArchiveVSNMap getArchiveVSNMap() {
        return this.archVSNMap;
    }

    public void setArchiveVSNMap(ArchiveVSNMap archVSNMap) {
        this.archVSNMap = archVSNMap;
    }

    public boolean isRearchive() {
        return this.rearchive;
    }

    public void setRearchive(boolean rearchive) {
        this.rearchive = rearchive;
    }

    public String getDiskArchiveVSN() {
        return this.diskArchVSN;
    }

    public void setDiskArchiveVSN(String vsn) {
        this.diskArchVSN = vsn;
        if (this.param != null) {
            if (SamQFSUtil.isValidString(vsn)) {
                this.param.setDiskArchiveVol(vsn);
            } else {
                this.param.resetDiskArchiveVol();
            }
        }
    }

    public String getDiskArchiveVSNPath() {
        return this.diskArchVSNPath;
    }

    public void setDiskArchiveVSNPath(String path) {
        this.diskArchVSNPath = path;
    }

    public String getDiskArchiveVSNHost() {
        return this.diskArchVSNHost;
    }

    public void setDiskArchiveVSNHost(String hostname) {
        this.diskArchVSNHost = hostname;
    }

    public int getReservationMethod() {
        return this.resMethod;
    }

    public void setReservationMethod(int method) {
        this.resMethod = method;
        if (this.param != null) {
            if (method != -1) {
                this.param.setReservationMethod((short)method);
            } else {
                this.param.reserReservationMethod();
            }
        }
    }

    public int getArchiveSortMethod() {
        return this.archSortMethod;
    }

    public void setArchiveSortMethod(int method) {
        this.archSortMethod = method;
        if (this.param != null) {
            if (method != -1) {
                this.param.setArchiveSortMethod(SamQFSUtil.convertARSortMethodJni(method));
            } else {
                this.param.resetArchiveSortMethod();
            }
        }
    }

    public int getOfflineCopyMethod() {
        return this.offlineCopyMethod;
    }

    public void setOfflineCopyMethod(int method) {
        this.offlineCopyMethod = method;
        if (this.param != null) {
            if (method != -1) {
                this.param.setOfflineCopyMethod(SamQFSUtil.convertAROfflineCopyMethodJni(method));
            } else {
                this.param.resetOfflineCopyMethod();
            }
        }
    }

    public int getDrives() {
        return this.drives;
    }

    public void setDrives(int drives) {
        this.drives = drives;
        if (this.param != null) {
            if (drives != -1) {
                this.param.setDrives(drives);
            } else {
                this.param.resetDrives();
            }
        }
    }

    public long getMaxDrives() {
        return this.maxDrives;
    }

    public void setMaxDrives(long size) {
        this.maxDrives = size;
        if (this.param != null) {
            if (size != -1L) {
                if (this.maxDrivesUnit != -1) {
                    String unit = SamQFSUtil.getUnitString(this.maxDrivesUnit);
                    this.param.setMaxDrives(SamQFSUtil.fsizeToString(new Long(this.maxDrives).toString() + unit));
                }
            } else {
                this.param.resetMaxDrives();
            }
        }
    }

    public int getMaxDrivesUnit() {
        return this.maxDrivesUnit;
    }

    public void setMaxDrivesUnit(int sizeUnit) {
        this.maxDrivesUnit = sizeUnit;
        if (this.param != null) {
            if (sizeUnit != -1) {
                if (this.maxDrives != -1L) {
                    String unit = SamQFSUtil.getUnitString(this.maxDrivesUnit);
                    this.param.setMaxDrives(SamQFSUtil.fsizeToString(new Long(this.maxDrives).toString() + unit));
                }
            } else {
                this.param.resetMaxDrives();
            }
        }
    }

    public long getMinDrives() {
        return this.minDrives;
    }

    public void setMinDrives(long size) {
        this.minDrives = size;
        if (this.param != null) {
            if (size != -1L) {
                if (this.minDrivesUnit != -1) {
                    String unit = SamQFSUtil.getUnitString(this.minDrivesUnit);
                    this.param.setMinDrives(SamQFSUtil.fsizeToString(new Long(this.minDrives).toString() + unit));
                }
            } else {
                this.param.resetMinDrives();
            }
        }
    }

    public int getMinDrivesUnit() {
        return this.minDrivesUnit;
    }

    public void setMinDrivesUnit(int sizeUnit) {
        this.minDrivesUnit = sizeUnit;
        if (this.param != null) {
            if (sizeUnit != -1) {
                if (this.minDrives != -1L) {
                    String unit = SamQFSUtil.getUnitString(this.minDrivesUnit);
                    this.param.setMinDrives(SamQFSUtil.fsizeToString(new Long(this.minDrives).toString() + unit));
                }
            } else {
                this.param.resetMinDrives();
            }
        }
    }

    public int getJoinMethod() {
        return this.joinMethod;
    }

    public void setJoinMethod(int method) {
        this.joinMethod = method;
        if (this.param != null) {
            if (method != -1) {
                this.param.setJoinMethod(SamQFSUtil.convertARJoinMethodJni(method));
            } else {
                this.param.resetJoinMethod();
            }
        }
    }

    public int getUnarchiveTimeReference() {
        return this.unarchTimeRef;
    }

    public void setUnarchiveTimeReference(int ref) {
        this.unarchTimeRef = ref;
        if (this.param != null) {
            if (ref == -1) {
                this.param.resetUnarchAge();
            } else if (ref == 12) {
                this.param.setUnarchAge(true);
            } else if (ref == 11) {
                this.param.setUnarchAge(false);
            }
        }
    }

    public boolean isFillVSNs() {
        return this.fillVSNs;
    }

    public void setFillVSNs(boolean fillVSN) {
        this.fillVSNs = fillVSN;
        if (this.param != null) {
            this.param.setFillVSNs(fillVSN);
        }
    }

    public long getOverflowMinSize() {
        return this.overflowMinSize;
    }

    public void setOverflowMinSize(long size) {
        this.overflowMinSize = size;
        if (this.param != null) {
            if (size != -1L) {
                if (this.overflowMinSizeUnit != -1) {
                    String unit = SamQFSUtil.getUnitString(this.overflowMinSizeUnit);
                    this.param.setOverflowMinSize(SamQFSUtil.fsizeToString(new Long(this.overflowMinSize).toString() + unit));
                }
            } else {
                this.param.resetOverflowMinSize();
            }
        }
    }

    public int getOverflowMinSizeUnit() {
        return this.overflowMinSizeUnit;
    }

    public void setOverflowMinSizeUnit(int sizeUnit) {
        this.overflowMinSizeUnit = sizeUnit;
        if (this.param != null) {
            if (sizeUnit != -1) {
                if (this.overflowMinSize != -1L) {
                    String unit = SamQFSUtil.getUnitString(this.overflowMinSizeUnit);
                    this.param.setOverflowMinSize(SamQFSUtil.fsizeToString(new Long(this.overflowMinSize).toString() + unit));
                }
            } else {
                this.param.resetOverflowMinSize();
            }
        }
    }

    public long getArchiveMaxSize() {
        return this.archMaxSize;
    }

    public void setArchiveMaxSize(long size) {
        this.archMaxSize = size;
        if (this.param != null) {
            if (size != -1L) {
                if (this.archMaxSizeUnit != -1) {
                    String unit = SamQFSUtil.getUnitString(this.archMaxSizeUnit);
                    this.param.setArchMax(SamQFSUtil.fsizeToString(new Long(this.archMaxSize).toString() + unit));
                }
            } else {
                this.param.resetArchMax();
            }
        }
    }

    public int getArchiveMaxSizeUnit() {
        return this.archMaxSizeUnit;
    }

    public void setArchiveMaxSizeUnit(int sizeUnit) {
        this.archMaxSizeUnit = sizeUnit;
        if (this.param != null) {
            if (sizeUnit != -1) {
                if (this.archMaxSize != -1L) {
                    String unit = SamQFSUtil.getUnitString(this.archMaxSizeUnit);
                    this.param.setArchMax(SamQFSUtil.fsizeToString(new Long(this.archMaxSize).toString() + unit));
                }
            } else {
                this.param.resetArchMax();
            }
        }
    }

    public int getBufferSize() {
        return this.bufSize;
    }

    public void setBufferSize(int size) {
        this.bufSize = size;
        if (this.param != null) {
            if (size != -1) {
                this.param.setBufSize(size);
            } else {
                this.param.resetBufSize();
            }
        }
    }

    public boolean isBufferLocked() {
        return this.bufLocked;
    }

    public void setBufferLocked(boolean lock) {
        this.bufLocked = lock;
        if (this.param != null) {
            this.param.setBufferLocked(lock);
        }
    }

    public long getStartAge() {
        return this.startAge;
    }

    public void setStartAge(long age) {
        this.startAge = age;
        if (this.param != null) {
            if (age != -1L) {
                if (this.startAgeUnit != -1) {
                    this.param.setStartAge(SamQFSUtil.convertToSecond(this.startAge, this.startAgeUnit));
                }
            } else {
                this.param.resetStartAge();
            }
        }
    }

    public int getStartAgeUnit() {
        return this.startAgeUnit;
    }

    public void setStartAgeUnit(int ageUnit) {
        this.startAgeUnit = ageUnit;
        if (this.param != null) {
            if (ageUnit != -1) {
                if (this.startAge != -1L) {
                    this.param.setStartAge(SamQFSUtil.convertToSecond(this.startAge, this.startAgeUnit));
                }
            } else {
                this.param.resetStartAge();
            }
        }
    }

    public int getStartCount() {
        return this.startCount;
    }

    public void setStartCount(int count) {
        this.startCount = count;
        if (this.param != null) {
            if (count != -1) {
                this.param.setStartCount(count);
            } else {
                this.param.resetStartCount();
            }
        }
    }

    public long getStartSize() {
        return this.startSize;
    }

    public void setStartSize(long size) {
        this.startSize = size;
        if (this.param != null) {
            if (size != -1L) {
                if (this.startSizeUnit != -1) {
                    String unit = SamQFSUtil.getUnitString(this.startSizeUnit);
                    this.param.setStartSize(SamQFSUtil.fsizeToString(new Long(this.startSize).toString() + unit));
                }
            } else {
                this.param.resetStartSize();
            }
        }
    }

    public int getStartSizeUnit() {
        return this.startSizeUnit;
    }

    public void setStartSizeUnit(int sizeUnit) {
        this.startSizeUnit = sizeUnit;
        if (this.param != null) {
            if (sizeUnit != -1) {
                if (this.startSize != -1L) {
                    String unit = SamQFSUtil.getUnitString(this.startSizeUnit);
                    this.param.setStartSize(SamQFSUtil.fsizeToString(new Long(this.startSize).toString() + unit));
                }
            } else {
                this.param.resetStartSize();
            }
        }
    }

    public long getRecycleDataSize() {
        return this.recDataSize;
    }

    public void setRecycleDataSize(long size) {
        this.recDataSize = size;
        if (this.param != null) {
            RecyclerParams rec = this.param.getRecyclerParams();
            if (rec == null) {
                rec = new RecyclerParams();
                this.param.setRecyclerParams(rec);
            }
            if (size != -1L) {
                if (this.recDataSizeUnit != -1) {
                    String unit = SamQFSUtil.getUnitString(this.recDataSizeUnit);
                    rec.setDatasize(SamQFSUtil.fsizeToString(new Long(this.recDataSize).toString() + unit));
                }
            } else {
                rec.resetDatasize();
            }
            this.param.setRecyclerParams(rec);
        }
    }

    public int getRecycleDataSizeUnit() {
        return this.recDataSizeUnit;
    }

    public void setRecycleDataSizeUnit(int sizeUnit) {
        this.recDataSizeUnit = sizeUnit;
        if (this.param != null) {
            RecyclerParams rec = this.param.getRecyclerParams();
            if (rec == null) {
                rec = new RecyclerParams();
                this.param.setRecyclerParams(rec);
            }
            if (sizeUnit != -1) {
                if (this.recDataSize != -1L) {
                    String unit = SamQFSUtil.getUnitString(this.recDataSizeUnit);
                    rec.setDatasize(SamQFSUtil.fsizeToString(new Long(this.recDataSize).toString() + unit));
                }
            } else {
                rec.resetDatasize();
            }
            this.param.setRecyclerParams(rec);
        }
    }

    public int getRecycleHWM() {
        return this.recHWM;
    }

    public void setRecycleHWM(int hwm) {
        this.recHWM = hwm;
        if (this.param != null) {
            RecyclerParams rec = this.param.getRecyclerParams();
            if (rec == null) {
                rec = new RecyclerParams();
                this.param.setRecyclerParams(rec);
            }
            if (hwm != -1) {
                rec.setHWM(hwm);
            } else {
                rec.resetHWM();
            }
            this.param.setRecyclerParams(rec);
        }
    }

    public boolean isIgnoreRecycle() {
        return this.ignoreRec;
    }

    public void setIgnoreRecycle(boolean ignore) {
        this.ignoreRec = ignore;
        if (this.param != null) {
            RecyclerParams rec = this.param.getRecyclerParams();
            if (rec == null) {
                rec = new RecyclerParams();
                this.param.setRecyclerParams(rec);
            }
            rec.setIgnore(ignore);
            this.param.setRecyclerParams(rec);
        }
    }

    public String getNotificationAddress() {
        return this.notifyAddr;
    }

    public void setNotificationAddress(String addr) {
        this.notifyAddr = addr;
        if (this.param != null) {
            RecyclerParams rec = this.param.getRecyclerParams();
            if (rec == null) {
                rec = new RecyclerParams();
                this.param.setRecyclerParams(rec);
            }
            if (SamQFSUtil.isValidString(addr)) {
                rec.setEmailAddr(addr);
            } else {
                rec.resetEmailAddr();
            }
            this.param.setRecyclerParams(rec);
        }
    }

    public int getMinGain() {
        return this.minGain;
    }

    public void setMinGain(int gain) {
        this.minGain = gain;
        if (this.param != null) {
            RecyclerParams rec = this.param.getRecyclerParams();
            if (rec == null) {
                rec = new RecyclerParams();
                this.param.setRecyclerParams(rec);
            }
            if (gain != -1) {
                rec.setMinGain(gain);
            } else {
                rec.resetMinGain();
            }
            this.param.setRecyclerParams(rec);
        }
    }

    public int getMaxVSNCount() {
        return this.maxVSNCount;
    }

    public void setMaxVSNCount(int count) {
        this.maxVSNCount = count;
        if (this.param != null) {
            RecyclerParams rec = this.param.getRecyclerParams();
            if (rec == null) {
                rec = new RecyclerParams();
                this.param.setRecyclerParams(rec);
            }
            if (count != -1) {
                rec.setVSNCount(count);
            } else {
                rec.resetVSNCount();
            }
            this.param.setRecyclerParams(rec);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.archPolicy != null) {
            buf.append("Archive Policy: " + this.archPolicy.getPolicyName() + "\n");
        }
        buf.append("Copy Number: " + this.copyNumber + "\n");
        buf.append("Rearchive: " + this.rearchive + "\n");
        buf.append("DiskArchive VSN: " + this.diskArchVSN + "\n");
        buf.append("DiskArchive VSN Path: " + this.diskArchVSNPath + "\n");
        buf.append("DiskArchive VSN Host: " + this.diskArchVSNHost + "\n");
        buf.append("Reservation Method: " + this.resMethod + "\n");
        buf.append("Archive Sort Method: " + this.archSortMethod + "\n");
        buf.append("Offline Copy Method: " + this.offlineCopyMethod + "\n");
        buf.append("Drives: " + this.drives + "\n");
        buf.append("Max Drives: " + this.maxDrives + "\n");
        buf.append("Max Drives Unit: " + this.maxDrivesUnit + "\n");
        buf.append("Min Drives: " + this.minDrives + "\n");
        buf.append("Min Drives Unit: " + this.minDrivesUnit + "\n");
        buf.append("Join Method: " + this.joinMethod + "\n");
        buf.append("Unarchive Time Reference: " + this.unarchTimeRef + "\n");
        buf.append("Fill VSNs: " + this.fillVSNs + "\n");
        buf.append("Overflow Min Size: " + this.overflowMinSize + "\n");
        buf.append("Overflow Min Size Unit: " + this.overflowMinSizeUnit + "\n");
        buf.append("Archive Max Size: " + this.archMaxSize + "\n");
        buf.append("Archive Max Size Unit: " + this.archMaxSizeUnit + "\n");
        buf.append("Buffer Size: " + this.bufSize + "\n");
        buf.append("Buffer Locked: " + this.bufLocked + "\n");
        buf.append("Start Age: " + this.startAge + "\n");
        buf.append("Start Age Unit: " + this.startAgeUnit + "\n");
        buf.append("Start Count: " + this.startCount + "\n");
        buf.append("Start Size: " + this.startSize + "\n");
        buf.append("Start Size Unit: " + this.startSizeUnit + "\n");
        buf.append("Recycle Data Size: " + this.recDataSize + "\n");
        buf.append("Recycle Data Size Unit: " + this.recDataSizeUnit + "\n");
        buf.append("Recycle HWM: " + this.recHWM + "\n");
        buf.append("Ignore Recycle: " + this.ignoreRec + "\n");
        buf.append("Notification Address: " + this.notifyAddr + "\n");
        buf.append("Min Gain: " + this.minGain + "\n");
        buf.append("Max VSN Count: " + this.maxVSNCount + "\n");
        if (this.archVSNMap != null) {
            buf.append("Archive VSNMap: " + this.archVSNMap.toString() + "\n");
        }
        return buf.toString();
    }
}

