/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.FileUtil;
import com.sun.netstorage.samqfs.mgmt.SamFSConnection;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.arc.DiskVol;
import com.sun.netstorage.samqfs.mgmt.media.CatEntry;
import com.sun.netstorage.samqfs.mgmt.media.Discovered;
import com.sun.netstorage.samqfs.mgmt.media.DriveDev;
import com.sun.netstorage.samqfs.mgmt.media.LibDev;
import com.sun.netstorage.samqfs.mgmt.media.Media;
import com.sun.netstorage.samqfs.mgmt.media.NetAttachLibInfo;
import com.sun.netstorage.samqfs.mgmt.media.StkClntConn;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemMediaManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.jni.media.DiskVolumeImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.media.DriveImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.media.LibraryImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.media.VSNImpl;
import com.sun.netstorage.samqfs.web.model.media.DiskVolume;
import com.sun.netstorage.samqfs.web.model.media.Drive;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import java.util.ArrayList;

public class SamQFSSystemMediaManagerImpl
implements SamQFSSystemMediaManager {
    private SamQFSSystemModelImpl theModel;

    public SamQFSSystemMediaManagerImpl(SamQFSSystemModel model) {
        this.theModel = (SamQFSSystemModelImpl)model;
    }

    public int[] getAvailableMediaTypes() throws SamFSException {
        String[] mTypes = Media.getAvailMediaTypes((Ctx)this.theModel.getJniContext());
        int[] mVals = null;
        if (mTypes == null) {
            mVals = new int[]{};
        } else {
            mVals = new int[mTypes.length];
            for (int i = 0; i < mTypes.length; ++i) {
                mVals[i] = SamQFSUtil.getMediaTypeInteger(mTypes[i]);
            }
        }
        return mVals;
    }

    public int[] getAvailableArchiveMediaTypes() throws SamFSException {
        int[] mediaTypes = this.getAvailableMediaTypes();
        if (this.theModel.getServerAPIVersion().compareTo("1.3") >= 0) {
            int[] result = new int[mediaTypes.length + 1];
            result[0] = 133;
            int i = 0;
            int j = 1;
            while (i < mediaTypes.length) {
                result[j] = mediaTypes[i];
                ++i;
                ++j;
            }
            return result;
        }
        return mediaTypes;
    }

    public Drive[] discoverStandAloneDrives() throws SamFSException {
        SamFSConnection connection = this.theModel.getJniConnection();
        if (connection != null) {
            connection.setTimeout(SamQFSSystemModelImpl.DEFAULT_RPC_MAX_TIME_OUT);
        }
        Discovered dis = Media.discoverUnusedDrives((Ctx)this.theModel.getJniContext(), null);
        if (connection != null) {
            connection.setTimeout(SamQFSSystemModelImpl.DEFAULT_RPC_TIME_OUT);
        }
        DriveDev[] drvs = dis.drives();
        ArrayList<DriveImpl> list = new ArrayList<DriveImpl>();
        if (drvs != null && drvs.length > 0) {
            for (int i = 0; i < drvs.length; ++i) {
                list.add(new DriveImpl(this.theModel, drvs[i]));
            }
        }
        return list.toArray(new Drive[0]);
    }

    public Library[] discoverLibraries() throws SamFSException {
        SamFSConnection connection = this.theModel.getJniConnection();
        if (connection != null) {
            connection.setTimeout(SamQFSSystemModelImpl.DEFAULT_RPC_MAX_TIME_OUT);
        }
        Discovered dis = Media.discoverUnused((Ctx)this.theModel.getJniContext(), null);
        if (connection != null) {
            connection.setTimeout(SamQFSSystemModelImpl.DEFAULT_RPC_TIME_OUT);
        }
        LibDev[] libs = dis.libraries();
        ArrayList<LibraryImpl> list = new ArrayList<LibraryImpl>();
        if (libs != null && libs.length > 0) {
            for (int i = 0; i < libs.length; ++i) {
                list.add(new LibraryImpl(this.theModel, libs[i], true));
            }
        }
        return list.toArray(new Library[0]);
    }

    public Library[] discoverSTKLibraries(StkClntConn[] conns) throws SamFSException {
        SamFSConnection connection = this.theModel.getJniConnection();
        if (connection != null) {
            connection.setTimeout(SamQFSSystemModelImpl.DEFAULT_RPC_MAX_TIME_OUT);
        }
        LibDev[] libs = Media.discoverStk((Ctx)this.theModel.getJniContext(), (StkClntConn[])conns);
        if (connection != null) {
            connection.setTimeout(SamQFSSystemModelImpl.DEFAULT_RPC_TIME_OUT);
        }
        ArrayList<LibraryImpl> list = new ArrayList<LibraryImpl>();
        if (libs != null && libs.length > 0) {
            for (int i = 0; i < libs.length; ++i) {
                list.add(new LibraryImpl(this.theModel, libs[i], true));
            }
        }
        return list.toArray(new Library[0]);
    }

    public Library discoverNetworkLibrary(String libName, int mediaType, String catalog, String paramFile, int ordinal) throws SamFSException {
        int jniType = -1;
        switch (mediaType) {
            case 117: {
                jniType = 0;
                break;
            }
            case 118: {
                jniType = 3;
                break;
            }
            case 119: {
                jniType = 2;
                break;
            }
            case 120: {
                jniType = 4;
                break;
            }
            case 121: {
                jniType = 1;
            }
        }
        if (ordinal == -1) {
            ordinal = 0;
        }
        NetAttachLibInfo nwaLib = new NetAttachLibInfo(libName, jniType, 0, catalog, paramFile);
        LibDev lib = Media.getNetAttachLib((Ctx)this.theModel.getJniContext(), (NetAttachLibInfo)nwaLib);
        if (ordinal != 0 && lib.getEquipOrdinal() != ordinal) {
            lib.setEquipOrdinal(ordinal);
        }
        LibraryImpl newLib = null;
        if (lib != null) {
            newLib = new LibraryImpl(this.theModel, lib, true);
        }
        return newLib;
    }

    public Library[] getAllLibraries() throws SamFSException {
        ArrayList<LibraryImpl> list = new ArrayList<LibraryImpl>();
        LibDev[] libs = Media.getLibraries((Ctx)this.theModel.getJniContext());
        if (libs != null && libs.length > 0) {
            for (int i = 0; i < libs.length; ++i) {
                list.add(new LibraryImpl(this.theModel, libs[i]));
            }
        }
        return list.toArray(new Library[0]);
    }

    public Library getLibraryByName(String libraryName) throws SamFSException {
        Library lib = null;
        if (SamQFSUtil.isValidString(libraryName)) {
            if (libraryName.equals("historian") || libraryName.equals("Historian")) {
                Library[] libs = this.getAllLibraries();
                if (libs != null) {
                    for (int i = 0; i < libs.length; ++i) {
                        String libName = libs[i].getName();
                        if (!"historian".equals(libName) && !"Historian".equals(libName)) continue;
                        lib = libs[i];
                        break;
                    }
                }
            } else {
                LibDev jni = Media.getLibraryByFSet((Ctx)this.theModel.getJniContext(), (String)libraryName);
                if (jni != null) {
                    lib = new LibraryImpl(this.theModel, jni);
                }
            }
        }
        return lib;
    }

    public Library getLibraryByEQ(int libraryEQ) throws SamFSException {
        LibraryImpl lib = null;
        LibDev jni = Media.getLibraryByEq((Ctx)this.theModel.getJniContext(), (int)libraryEQ);
        if (jni != null) {
            lib = new LibraryImpl(this.theModel, jni);
        }
        return lib;
    }

    public void addLibrary(Library library) throws SamFSException {
        if (library == null) {
            throw new SamFSException("logic.invalidLibrary");
        }
        boolean resetCtx = false;
        if (SamQFSUtil.isValidString(this.theModel.getDumpPath())) {
            this.theModel.getJniContext().setDumpPath(this.theModel.getDumpPath());
            resetCtx = true;
        }
        Media.addLibrary((Ctx)this.theModel.getJniContext(), (LibDev)((LibraryImpl)library).getJniLibrary());
        this.theModel.setDumpPath(null);
        if (resetCtx) {
            this.theModel.getJniContext().setDumpPath(null);
        }
    }

    public void addLibraries(Library[] libArray) throws SamFSException {
        if (libArray == null || libArray.length == 0) {
            throw new SamFSException("logic.invalidLibrary");
        }
        boolean resetCtx = false;
        if (SamQFSUtil.isValidString(this.theModel.getDumpPath())) {
            this.theModel.getJniContext().setDumpPath(this.theModel.getDumpPath());
            resetCtx = true;
        }
        LibDev[] libs = new LibDev[libArray.length];
        for (int i = 0; i < libArray.length; ++i) {
            LibDev myLib = ((LibraryImpl)libArray[i]).getJniLibrary();
            if (myLib == null) {
                throw new SamFSException("logic.invalidLibrary");
            }
            libs[i] = myLib;
        }
        Media.addLibraries((Ctx)this.theModel.getJniContext(), (LibDev[])libs);
        this.theModel.setDumpPath(null);
        if (resetCtx) {
            this.theModel.getJniContext().setDumpPath(null);
        }
    }

    public void addLibrary(Library library, Drive[] includedDrives) throws SamFSException {
        if (library == null) {
            throw new SamFSException("logic.invalidLibrary");
        }
        boolean resetCtx = false;
        if (SamQFSUtil.isValidString(this.theModel.getDumpPath())) {
            this.theModel.getJniContext().setDumpPath(this.theModel.getDumpPath());
            resetCtx = true;
        }
        LibDev lib = ((LibraryImpl)library).getJniLibrary();
        DriveDev[] drvs = new DriveDev[includedDrives.length];
        for (int i = 0; i < includedDrives.length; ++i) {
            drvs[i] = ((DriveImpl)includedDrives[i]).getJniDrive();
        }
        lib.setDrives(drvs);
        Media.addLibrary((Ctx)this.theModel.getJniContext(), (LibDev)((LibraryImpl)library).getJniLibrary());
        this.theModel.setDumpPath(null);
        if (resetCtx) {
            this.theModel.getJniContext().setDumpPath(null);
        }
    }

    public void addNetworkLibrary(Library library, Drive[] includedDrives) throws SamFSException {
        LibDev lib = ((LibraryImpl)library).getJniLibrary();
        DriveDev[] drvs = new DriveDev[includedDrives.length];
        for (int i = 0; i < includedDrives.length; ++i) {
            drvs[i] = ((DriveImpl)includedDrives[i]).getJniDrive();
        }
        lib.setDrives(drvs);
        boolean resetCtx = false;
        if (SamQFSUtil.isValidString(this.theModel.getDumpPath())) {
            this.theModel.getJniContext().setDumpPath(this.theModel.getDumpPath());
            resetCtx = true;
        }
        Media.addLibrary((Ctx)this.theModel.getJniContext(), (LibDev)lib);
        this.theModel.setDumpPath(null);
        if (resetCtx) {
            this.theModel.getJniContext().setDumpPath(null);
        }
    }

    public void removeLibrary(Library library) throws SamFSException {
        if (library != null) {
            Media.removeLibrary((Ctx)this.theModel.getJniContext(), (int)library.getEquipOrdinal(), (boolean)false);
        }
    }

    public Drive[] getAllStandAloneDrives() throws SamFSException {
        ArrayList<DriveImpl> list = new ArrayList<DriveImpl>();
        DriveDev[] devs = Media.getStdDrives((Ctx)this.theModel.getJniContext());
        if (devs != null && devs.length > 0) {
            for (int i = 0; i < devs.length; ++i) {
                list.add(new DriveImpl(this.theModel, devs[i]));
            }
        }
        return list.toArray(new Drive[0]);
    }

    public Drive getStdAloneDrvByPath(String drivePath) throws SamFSException {
        DriveImpl drv = null;
        DriveDev jni = Media.getStdDriveByPath((Ctx)this.theModel.getJniContext(), (String)drivePath);
        if (jni != null) {
            drv = new DriveImpl(this.theModel, jni);
        }
        return drv;
    }

    public Drive getStdAloneByEQ(int driveEQ) throws SamFSException {
        DriveImpl drv = null;
        DriveDev jni = Media.getStdDriveByEq((Ctx)this.theModel.getJniContext(), (int)driveEQ);
        if (jni != null) {
            drv = new DriveImpl(this.theModel, jni);
        }
        return drv;
    }

    public void addStandAloneDrive(Drive drive) throws SamFSException {
        DriveDev drv = ((DriveImpl)drive).getJniDrive();
        if (drv != null) {
            boolean resetCtx = false;
            if (SamQFSUtil.isValidString(this.theModel.getDumpPath())) {
                this.theModel.getJniContext().setDumpPath(this.theModel.getDumpPath());
                resetCtx = true;
            }
            Media.addStdDrive((Ctx)this.theModel.getJniContext(), (DriveDev)drv);
            this.theModel.setDumpPath(null);
            if (resetCtx) {
                this.theModel.getJniContext().setDumpPath(null);
            }
        }
    }

    public void removeStandAloneDrive(Drive drive) throws SamFSException {
        if (drive != null) {
            Media.removeStdDrive((Ctx)this.theModel.getJniContext(), (int)drive.getEquipOrdinal());
        }
    }

    public VSN[] searchVSNInLibraries(String vsnName) throws SamFSException {
        ArrayList<VSNImpl> list = new ArrayList<VSNImpl>();
        CatEntry[] cat = null;
        try {
            cat = Media.getCatEntriesForVSN((Ctx)this.theModel.getJniContext(), (String)vsnName);
        }
        catch (SamFSException e) {
            this.theModel.processException((Exception)((Object)e));
        }
        if (cat != null && cat.length > 0) {
            for (int i = 0; i < cat.length; ++i) {
                list.add(new VSNImpl(this.theModel, cat[i]));
            }
        }
        return list.toArray(new VSN[0]);
    }

    public VSN getVSN(CatEntry entry) throws SamFSException {
        return new VSNImpl(this.theModel, entry);
    }

    public VSN searchVSNInStandAloneDrive(String vsnString, int eq) throws SamFSException {
        VSN[] allvsns = this.searchVSNInLibraries(vsnString);
        VSN currentVSN = null;
        if (allvsns != null) {
            for (int i = 0; i < allvsns.length; ++i) {
                if (allvsns[i].getDrive().getEquipOrdinal() != eq) continue;
                currentVSN = allvsns[i];
                break;
            }
        }
        return currentVSN;
    }

    public DiskVolume[] getDiskVSNs() throws SamFSException {
        DiskVolumeImpl[] vols = null;
        DiskVol[] nativeVols = DiskVol.getAll((Ctx)this.theModel.getJniContext());
        if (nativeVols != null) {
            vols = new DiskVolumeImpl[nativeVols.length];
            for (int i = 0; i < nativeVols.length; ++i) {
                vols[i] = new DiskVolumeImpl(nativeVols[i]);
            }
        }
        return vols;
    }

    public DiskVolume getDiskVSN(String name) throws SamFSException {
        DiskVol nativeVol = DiskVol.get((Ctx)this.theModel.getJniContext(), (String)name);
        DiskVolumeImpl vol = new DiskVolumeImpl(nativeVol);
        return vol;
    }

    public void createDiskVSN(String name, String remoteHost, String path) throws SamFSException {
        if (remoteHost != null) {
            SamQFSSystemModelImpl modelForRHost = (SamQFSSystemModelImpl)SamQFSFactory.getSamQFSAppModel().getSamQFSSystemModel(remoteHost);
            String fullPath = "";
            if (path != null) {
                fullPath = path;
                if (!path.endsWith("/")) {
                    fullPath = fullPath + "/";
                }
            }
            if (SamQFSUtil.isValidString(fullPath = fullPath + name)) {
                FileUtil.createDir((Ctx)modelForRHost.getJniContext(), (String)fullPath);
            }
            DiskVol.addClient((Ctx)modelForRHost.getJniContext(), (String)this.theModel.getHostname());
        }
        DiskVol nativeVol = new DiskVol(name, remoteHost, path);
        DiskVol.add((Ctx)this.theModel.getJniContext(), (DiskVol)nativeVol);
    }

    public void updateDiskVSNFlags(DiskVolume vol) throws SamFSException {
        ((DiskVolumeImpl)vol).updateFlags(this.theModel.getJniContext());
    }
}

