/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.FileUtil;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.adm.License;
import com.sun.netstorage.samqfs.mgmt.adm.NotifSummary;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemAdminManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.admin.Notification;
import com.sun.netstorage.samqfs.web.model.admin.SystemLicense;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.admin.NotificationImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.admin.SystemLicenseImpl;
import java.util.HashMap;

public class SamQFSSystemAdminManagerImpl
implements SamQFSSystemAdminManager {
    private SamQFSSystemModelImpl theModel;
    private HashMap notifications = new HashMap();

    public SamQFSSystemAdminManagerImpl(SamQFSSystemModel model) {
        this.theModel = (SamQFSSystemModelImpl)model;
    }

    public Notification[] getAllNotifications() throws SamFSException {
        this.notifications.clear();
        NotifSummary[] n = NotifSummary.get((Ctx)this.theModel.getJniContext());
        if (n != null && n.length > 0) {
            for (int i = 0; i < n.length; ++i) {
                if (n[i].getEmailAddr().charAt(0) == '$') {
                    this.notifications.put(n[i].getEmailAddr().concat(n[i].getAdminName()), new NotificationImpl(n[i]));
                    continue;
                }
                this.notifications.put(n[i].getEmailAddr(), new NotificationImpl(n[i]));
            }
        }
        return this.notifications.values().toArray(new Notification[0]);
    }

    public Notification getNotification(String emailAddress) throws SamFSException {
        this.getAllNotifications();
        return (Notification)this.notifications.get(emailAddress);
    }

    public String getNotificationEmailsForSubject(int subject) throws SamFSException {
        if (subject != 1 && subject != 0 && subject != 4 && subject != 5 && subject != 2 && subject != 3) {
            throw new SamFSException("Invalid notification subject: " + String.valueOf(subject));
        }
        return NotifSummary.getEmailAddrsForSubject((Ctx)this.theModel.getJniContext(), (int)subject);
    }

    public Notification createNotification(String name, String emailAddress, boolean devDown, boolean archIntr, boolean reqMedia, boolean recycle) throws SamFSException {
        boolean[] bools = new boolean[5];
        bools[0] = devDown;
        bools[1] = archIntr;
        bools[2] = reqMedia;
        bools[3] = recycle;
        NotifSummary jniNotif = new NotifSummary(name, emailAddress, bools);
        NotificationImpl n = new NotificationImpl(jniNotif);
        NotifSummary.add((Ctx)this.theModel.getJniContext(), (NotifSummary)jniNotif);
        this.notifications.remove(emailAddress);
        this.notifications.put(emailAddress, n);
        return n;
    }

    public Notification createNotification(String name, String emailAddress, boolean devDown, boolean archIntr, boolean reqMedia, boolean recycle, boolean dumpIntr, boolean fsFull) throws SamFSException {
        boolean[] bools = new boolean[]{devDown, archIntr, reqMedia, recycle, dumpIntr, fsFull};
        NotifSummary jniNotif = new NotifSummary(name, emailAddress, bools);
        NotificationImpl n = new NotificationImpl(jniNotif);
        NotifSummary.add((Ctx)this.theModel.getJniContext(), (NotifSummary)jniNotif);
        this.notifications.remove(emailAddress);
        this.notifications.put(emailAddress, n);
        return n;
    }

    public void editNotification(Notification notification) throws SamFSException {
        boolean[] bools = new boolean[]{notification.isDeviceDownNotify(), notification.isArchiverInterruptNotify(), notification.isReqMediaNotify(), notification.isRecycleNotify(), notification.isDumpInterruptNotify(), notification.isFsNospaceNotify()};
        NotifSummary jniNotif = new NotifSummary(notification.getName(), notification.getEmailAddress(), bools);
        NotifSummary.modify((Ctx)this.theModel.getJniContext(), (String)((NotificationImpl)notification).getOrigEmailAddress(), (NotifSummary)jniNotif);
        this.notifications.remove(notification.getEmailAddress());
        this.notifications.put(notification.getEmailAddress(), new NotificationImpl(jniNotif));
    }

    public void deleteNotification(Notification notification) throws SamFSException {
        NotifSummary.delete((Ctx)this.theModel.getJniContext(), (NotifSummary)((NotificationImpl)notification).getJniNotif());
        this.notifications.remove(notification.getEmailAddress());
    }

    public SystemLicense getLicense() throws SamFSException {
        SystemLicenseImpl license = null;
        License jniLicense = License.getLicense((Ctx)this.theModel.getJniContext());
        if (jniLicense != null) {
            license = new SystemLicenseImpl(jniLicense);
        }
        return license;
    }

    public String[] tailFile(String path, int maxLines) throws SamFSException {
        return FileUtil.tailFile((Ctx)this.theModel.getJniContext(), (String)path, (int)maxLines);
    }

    public String[] getTxtFile(String path, int start, int end) throws SamFSException {
        return FileUtil.getTxtFile((Ctx)this.theModel.getJniContext(), (String)path, (int)start, (int)end);
    }
}

