/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.fs;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.util.ConversionUtil;
import java.util.Properties;

public class NFSOptions {
    protected String dirName;
    protected boolean shared;
    protected String shareState;
    protected String[] roClients;
    protected String[] rwClients;
    protected String[] rootClients;
    protected static final String KEY_DIRNAME = "dirname";
    protected static final String KEY_SHSTATE = "nfs";
    protected static final String KEY_RO = "ro";
    protected static final String KEY_RW = "rw";
    protected static final String KEY_ROOT = "root";
    public static final String NFS_SHARED = "yes";
    public static final String NFS_NOTSHARED = "no";
    public static final String NFS_CONFIGURED = "config";

    public NFSOptions(String propsStr) throws SamFSException {
        this(ConversionUtil.strToProps(propsStr));
    }

    public NFSOptions(Properties props) throws SamFSException {
        if (props == null) {
            System.out.println("NULL props");
            return;
        }
        props.list(System.out);
        this.dirName = props.getProperty(KEY_DIRNAME);
        this.setShareState(props.getProperty(KEY_SHSTATE));
        this.roClients = ConversionUtil.strToArray(props.getProperty(KEY_RO), ':');
        this.rwClients = ConversionUtil.strToArray(props.getProperty(KEY_RW), ':');
        this.rootClients = ConversionUtil.strToArray(props.getProperty(KEY_ROOT), ':');
    }

    public NFSOptions(String dirName, String shareState) {
        this.dirName = dirName;
        this.setShareState(shareState);
    }

    public String getDirName() {
        return this.dirName;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShareState(String shareState) {
        this.shareState = shareState;
        this.shared = NFS_SHARED.equals(shareState);
    }

    public String getShareState() {
        return this.shareState;
    }

    public String[] getReadOnlyAccessList() {
        return this.roClients;
    }

    public void setReadOnlyAccessList(String[] clients) {
        this.roClients = clients;
    }

    public String[] getReadWriteAccessList() {
        return this.rwClients;
    }

    public void setReadWriteAccessList(String[] clients) {
        this.rwClients = clients;
    }

    public String[] getRootAccessList() {
        return this.rootClients;
    }

    public void setRootAccessList(String[] clients) {
        this.rootClients = clients;
    }

    public String toString() {
        String E = "=";
        String C = ",";
        char sep = ':';
        String s = KEY_DIRNAME + E + this.dirName + C + KEY_SHSTATE + E + this.shareState;
        if (null != this.roClients) {
            s = s + C + KEY_RO + E + ConversionUtil.arrayToStr(this.roClients, sep);
        }
        if (null != this.rwClients) {
            s = s + C + KEY_RW + E + ConversionUtil.arrayToStr(this.rwClients, sep);
        }
        if (null != this.rootClients) {
            s = s + C + KEY_ROOT + E + ConversionUtil.arrayToStr(this.rootClients, sep);
        }
        return s;
    }
}

