/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.jobs;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.job.BaseJob;
import com.sun.netstorage.samqfs.web.model.job.StageJob;
import com.sun.netstorage.samqfs.web.model.job.StageJobFileData;
import com.sun.netstorage.samqfs.web.util.LargeDataSet;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;

public final class StageJobsData
implements LargeDataSet {
    private String serverName;
    private long stageJobID;
    public static final String[] headings = new String[]{"JobsDetails.stageJob.header1", "JobsDetails.stageJob.header2", "JobsDetails.stageJob.header3", "JobsDetails.stageJob.header4", "JobsDetails.stageJob.header5"};

    public StageJobsData(String inServerName, long jobID) {
        TraceUtil.initTrace();
        this.serverName = inServerName;
        this.stageJobID = jobID;
    }

    public Object[] getData(int start, int num, String sortName, String sortOrder) throws SamFSException {
        TraceUtil.trace3("Entering start = " + start + " num = " + num + " sortName = " + sortName + " sortOrder = " + sortOrder);
        SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
        if (sysModel == null) {
            throw new SamFSException(null, -2001);
        }
        BaseJob baseJob = sysModel.getSamQFSSystemJobManager().getJobById(this.stageJobID);
        if (baseJob == null) {
            throw new SamFSException(null, -2011);
        }
        StageJob stageJob = (StageJob)baseJob;
        int sortby = 11;
        if (sortName != null && "StageText0".compareTo(sortName) == 0) {
            sortby = 11;
        }
        boolean ascending = true;
        if (sortOrder != null && "descending".compareTo(sortOrder) == 0) {
            ascending = false;
        }
        StageJobFileData[] jobData = stageJob.getFileData(start, num, sortby, ascending);
        TraceUtil.trace3("jobData.length is " + jobData.length);
        if (jobData == null) {
            return new StageJobFileData[0];
        }
        TraceUtil.trace3("Exiting");
        return jobData;
    }

    public int getTotalRecords() throws SamFSException {
        TraceUtil.trace3("Entering");
        SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
        if (sysModel == null) {
            throw new SamFSException(null, -2001);
        }
        BaseJob baseJob = sysModel.getSamQFSSystemJobManager().getJobById(this.stageJobID);
        if (baseJob == null) {
            throw new SamFSException(null, -2011);
        }
        StageJob stageJob = (StageJob)baseJob;
        int totalJobData = (int)stageJob.getNumberOfFiles();
        TraceUtil.trace3("NUMBER OF FILES IS " + totalJobData);
        return totalJobData;
    }
}

