/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.fs.FSUtil;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemFSManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.fs.DumpSched;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.fs.FileSystemMountProperties;
import com.sun.netstorage.samqfs.web.model.fs.GenericFileSystem;
import com.sun.netstorage.samqfs.web.util.Capacity;
import com.sun.netstorage.samqfs.web.util.FsmVersion;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.ArrayList;

public class FileSystemSummaryModel
extends CCActionTableModel {
    private boolean filtered = false;
    private int filterSetting = -1;
    private ArrayList latestRows = new ArrayList();
    protected String apiVersion;
    protected boolean isAtLeastVersion44;
    protected boolean qfsStandalone;
    public static final int ViewPolicyButton = 0;
    public static final int SamQFSWizardGrowFSButton = 1;
    public static final int SamQFSWizardNewPolicyButton = 2;
    public static final int SamQFSWizardGrowFSButton_QFS = 0;
    public static final int EditMountOptions = 1;
    public static final int CheckFileSystem = 2;
    public static final int MountFileSystem = 3;
    public static final int UnMountFileSystem = 4;
    public static final int DeleteFileSystem = 5;
    public static final int NFS = 6;
    public static final int StopArchive = 7;
    public static final int IdleArchive = 8;
    public static final int RunArchive = 9;
    public static final int ScheduleSnapshot = 10;
    public static final int TakeSnapshot = 11;
    public static final int RemoveSchedule = 12;
    public static final int Restore = 13;
    public static final int STAGE = 14;
    public static final int StopArchive_43 = 6;
    public static final int IdleArchive_43 = 7;
    public static final int RunArchive_43 = 8;
    public static final int ENABLED = 1;
    public static final int DISABLED = 0;
    public static final String UFS_ROOT = "/";

    private FileSystemSummaryModel() {
    }

    public FileSystemSummaryModel(String xmlSchema, String serverApiVersion, boolean qfsStandalone) {
        super(RequestManager.getRequestContext().getServletContext(), xmlSchema);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.apiVersion = serverApiVersion;
        this.qfsStandalone = qfsStandalone;
        this.isAtLeastVersion44 = SamUtil.isVersionCurrentOrLaterThan(this.apiVersion, "1.3");
        this.initActionButtons();
        this.initActionMenu();
        this.initFilterMenu();
        this.initHeaders();
        this.initProductName();
        TraceUtil.trace3("Exiting");
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    protected void initActionButtons() {
        TraceUtil.trace3("Entering");
        this.setActionValue("SamQFSWizardNewFSButton", "FSSummary.NewFSButton");
        this.setActionValue("ViewPolicyButton", "FSSummary.ViewPolicyButton");
        this.setActionValue("SamQFSWizardGrowFSButton", "FSSummary.GrowFSButton");
        this.setActionValue("SamQFSWizardNewPolicyButton", "FSSummary.NewArchivePolicyButton");
        TraceUtil.trace3("Exiting");
    }

    protected void initActionMenu() {
        TraceUtil.trace3("Entering");
        TraceUtil.trace3("init action menu");
        this.setActionValue("ActionMenu", "FSSummary.actionMenu.defaultOption");
        TraceUtil.trace3("Exiting");
    }

    protected void initFilterMenu() {
        TraceUtil.trace3("Entering");
        this.setActionValue("FilterMenu", "FSSummary.filterOption.qfs");
        TraceUtil.trace3("Exiting");
    }

    protected void initHeaders() {
        TraceUtil.trace3("Entering");
        this.setActionValue("fsName", "FSSummary.heading.fsName");
        this.setActionValue("type", "FSSummary.heading.type");
        this.setActionValue("usage", "FSSummary.heading.diskusage");
        this.setActionValue("highWaterMark", "FSSummary.heading.highWaterMark");
        this.setActionValue("mountPoint", "FSSummary.heading.mountPoint");
        this.setActionValue("nfsShared", "FSSummary.heading.nfsShared");
        if (this.isAtLeastVersion44) {
            this.setActionValue("dumpScheduled", "FSSummary.heading.dumpScheduled");
        }
        TraceUtil.trace3("Exiting");
    }

    protected void initProductName() {
        TraceUtil.trace3("Entering");
        this.setProductNameAlt("secondaryMasthead.productNameAlt");
        this.setProductNameSrc("secondaryMasthead.productNameSrc");
        this.setProductNameHeight("20");
        this.setProductNameWidth("170");
        TraceUtil.trace3("Exiting");
    }

    public void initModelRows(String serverName) throws SamFSException {
        String point;
        String name;
        TraceUtil.trace3("Entering");
        this.clear();
        this.latestRows.clear();
        SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
        SamQFSSystemFSManager fsManager = sysModel.getSamQFSSystemFSManager();
        FileSystem[] fsList = fsManager.getAllFileSystems();
        GenericFileSystem[] fileSystems = null;
        FsmVersion version45 = new FsmVersion("4.5", serverName);
        if (this.isAtLeastVersion44) {
            fileSystems = fsManager.getNonSAMQFileSystems();
        }
        if (fsList == null && fileSystems == null) {
            TraceUtil.trace3("Exiting");
            return;
        }
        int i = 0;
        boolean archiveEnabled = false;
        boolean growEnabled = false;
        boolean mountEnabled = false;
        boolean umountEnabled = false;
        boolean deleteEnabled = false;
        boolean fsckEnabled = false;
        boolean snapshotEnabled = false;
        for (i = 0; fsList != null && i < fsList.length; ++i) {
            int len;
            String noAlarm = "";
            name = null;
            point = null;
            String state = null;
            long cap = 0L;
            long free = 0L;
            int consumed = 0;
            int hwm = 0;
            name = fsList[i].getName();
            int fsType = fsList[i].getFSTypeByProduct();
            int fsDescription = FSUtil.getFileSystemDescription(fsList[i]);
            int fsState = fsList[i].getState();
            state = fsState == 0 ? "FSSummary.mount" : "FSSummary.unmount";
            int fsShareStatus = fsList[i].getShareStatus();
            fsckEnabled = fsShareStatus == 0 || fsShareStatus == 1 && fsState == 1;
            cap = fsList[i].getCapacity();
            consumed = fsList[i].getConsumedSpacePercentage();
            free = fsList[i].getAvailableSpace();
            point = fsList[i].getMountPoint();
            FileSystemMountProperties properties = fsList[i].getMountProperties();
            hwm = properties.getHWM();
            boolean bl = archiveEnabled = !fsList[i].isHA() && !this.qfsStandalone && fsShareStatus == 0 && fsList[i].getArchivingType() == 2;
            if (this.filtered && this.shouldThisFSBeExcluded(fsDescription, fsList[i].hasNFSShares())) continue;
            this.latestRows.add(new Integer(i));
            if (i > 0) {
                this.appendRow();
            }
            this.setValue("fsNameText", name);
            this.setValue("typeText", FSUtil.getFileSystemDescriptionString(fsList[i]));
            if (fsState == 1) {
                this.setValue("usageText", new Integer(-1));
                this.setValue("capacityText", state);
                this.setValue("UsageBarImage", "/samqfsui/images/samqfs_blank.gif");
            } else {
                if (consumed < 0 || consumed > 100) {
                    this.setValue("UsageBarImage", "/samqfsui/images/samqfs_blank.gif");
                } else if (archiveEnabled && consumed >= hwm) {
                    this.setValue("UsageBarImage", new NonSyncStringBuffer("/samqfsui/images/usagebar/red/").append(consumed).append(".gif").toString());
                } else {
                    this.setValue("UsageBarImage", new NonSyncStringBuffer("/samqfsui/images/usagebar/").append(consumed).append(".gif").toString());
                }
                this.setValue("capacityText", new NonSyncStringBuffer("(").append((Object)new Capacity(cap, 1)).append(")").toString());
                this.setValue("usageText", new Integer(consumed));
            }
            if (archiveEnabled) {
                this.setValue("highWaterMarkText", new Integer(hwm));
            } else {
                this.setValue("highWaterMarkText", "");
            }
            this.setValue("mountPointText", FSUtil.truncateMountPointString(point));
            StringBuffer enabledButtons = new StringBuffer();
            StringBuffer enabledMenuOptions = new StringBuffer();
            growEnabled = !fsList[i].isHA() && fsState == 1 && fsShareStatus == 0;
            mountEnabled = fsState == 1;
            umountEnabled = fsState == 0 && !UFS_ROOT.equals(point);
            boolean bl2 = deleteEnabled = fsState == 1 && !UFS_ROOT.equals(point);
            if (this.qfsStandalone) {
                if (growEnabled) {
                    enabledButtons.append(0);
                }
            } else {
                if (archiveEnabled) {
                    enabledButtons.append(0).append(',');
                }
                if (growEnabled) {
                    enabledButtons.append(1).append(',');
                }
                if (archiveEnabled) {
                    enabledButtons.append(2);
                }
            }
            if ((len = enabledButtons.length()) > 0 && enabledButtons.charAt(len - 1) == ',') {
                enabledButtons.deleteCharAt(len - 1);
            }
            enabledMenuOptions.append(1).append(',');
            if (fsckEnabled) {
                enabledMenuOptions.append(2).append(',');
            }
            if (mountEnabled) {
                enabledMenuOptions.append(3).append(',');
            }
            if (umountEnabled) {
                enabledMenuOptions.append(4).append(',');
            }
            if (deleteEnabled) {
                enabledMenuOptions.append(5).append(',');
            }
            if (!this.isAtLeastVersion44) {
                if (archiveEnabled) {
                    enabledMenuOptions.append(6).append(',');
                }
                if (archiveEnabled) {
                    enabledMenuOptions.append(7).append(',');
                }
                if (archiveEnabled) {
                    enabledMenuOptions.append(8).append(',');
                }
            } else {
                if (archiveEnabled) {
                    enabledMenuOptions.append(7).append(',');
                }
                if (archiveEnabled) {
                    enabledMenuOptions.append(8).append(',');
                }
                if (archiveEnabled) {
                    enabledMenuOptions.append(9).append(',');
                }
                if (archiveEnabled && SamUtil.isVersionCurrentOrLaterThan(this.apiVersion, "1.4")) {
                    enabledMenuOptions.append(14).append(",");
                }
            }
            if (this.isAtLeastVersion44) {
                String dumpScheduleDisp = "";
                if (archiveEnabled && fsState == 0) {
                    enabledMenuOptions.append(10).append(',');
                    enabledMenuOptions.append(11).append(',');
                    DumpSched dump = fsManager.getMetadataDumpSchedParams(fsList[i].getName());
                    if (dump != null) {
                        dumpScheduleDisp = dump.getDisplayString();
                        enabledMenuOptions.append(12).append(',');
                    }
                    if (version45.isAPICompatibleWithUI() || dump != null) {
                        enabledMenuOptions.append(13).append(',');
                    }
                }
                this.setValue("dumpScheduledText", dumpScheduleDisp);
            }
            if (SamUtil.isVersionCurrentOrLaterThan(this.apiVersion, "1.3.3") && !mountEnabled) {
                enabledMenuOptions.append(6).append(',');
                deleteEnabled = false;
            }
            if ((len = enabledMenuOptions.length()) > 0 && enabledMenuOptions.charAt(len - 1) == ',') {
                enabledMenuOptions.deleteCharAt(len - 1);
            }
            this.setValue("HiddenDynamicButtons", enabledButtons.toString());
            this.setValue("HiddenDynamicMenuOptions", enabledMenuOptions.toString());
            this.setValue("Href", new NonSyncStringBuffer(name).append(':').append(fsType).append(':').append("qfs").append(':').append(archiveEnabled).append(':').append(fsShareStatus).toString());
            this.setValue("FSHiddenField", name);
            this.initQueryParams();
            String nfsShared = fsList[i].hasNFSShares() ? SamUtil.getResourceString("samqfsui.yes") : "";
            this.setValue("nfsSharedText", nfsShared);
        }
        if (this.filtered && this.filterSetting == 0) {
            TraceUtil.trace3("Exiting");
            return;
        }
        for (int j = 0; fileSystems != null && j < fileSystems.length; ++j) {
            int len;
            name = null;
            point = null;
            String type = null;
            String state = null;
            long cap = 0L;
            long free = 0L;
            int consumed = 0;
            name = fileSystems[j].getName();
            int fsState = fileSystems[j].getState();
            state = fsState == 0 ? "FSSummary.mount" : (fsState == 1 ? "FSSummary.unmount" : "");
            int fsType = fileSystems[j].getFSTypeByProduct();
            type = fileSystems[j].getFSTypeName();
            cap = fileSystems[j].getCapacity();
            free = fileSystems[j].getAvailableSpace();
            consumed = fileSystems[j].getConsumedSpacePercentage();
            point = fileSystems[j].getMountPoint();
            int fsDescription = FSUtil.getFileSystemDescription(fileSystems[j]);
            if (this.filtered && this.shouldThisFSBeExcluded(fsDescription, fileSystems[j].hasNFSShares())) continue;
            this.latestRows.add(new Integer(i + j));
            if (i + j > 0) {
                this.appendRow();
            }
            this.setValue("fsNameText", SamUtil.getResourceString("FSSummary.nosam.descriptor", type));
            this.setValue("typeText", FSUtil.getFileSystemDescriptionString(fileSystems[j]));
            if (fsState == 1) {
                this.setValue("usageText", new Integer(-1));
                this.setValue("capacityText", state);
                this.setValue("UsageBarImage", "/samqfsui/images/samqfs_blank.gif");
            } else {
                if (consumed < 0 || consumed > 100) {
                    this.setValue("UsageBarImage", "/samqfsui/images/samqfs_blank.gif");
                } else {
                    this.setValue("UsageBarImage", new NonSyncStringBuffer("/samqfsui/images/usagebar/").append(consumed).append(".gif").toString());
                }
                this.setValue("capacityText", new NonSyncStringBuffer("(").append((Object)new Capacity(cap, 1)).append(")").toString());
                this.setValue("usageText", new Integer(consumed));
            }
            this.setValue("highWaterMarkText", "");
            this.setValue("mountPointText", FSUtil.truncateMountPointString(point));
            this.setValue("dumpScheduledText", "");
            StringBuffer enabledButtons = new StringBuffer();
            StringBuffer enabledMenuOptions = new StringBuffer();
            growEnabled = fsState == 1;
            mountEnabled = fsState == 1;
            umountEnabled = fsState == 0 && !UFS_ROOT.equals(point);
            deleteEnabled = fsState == 1 && !UFS_ROOT.equals(point);
            growEnabled = false;
            if (growEnabled) {
                if (this.qfsStandalone) {
                    enabledButtons.append(0);
                } else {
                    enabledButtons.append(1);
                }
            }
            if ((len = enabledButtons.length()) > 0 && enabledButtons.charAt(len - 1) == ',') {
                enabledButtons.deleteCharAt(len - 1);
            }
            if (mountEnabled) {
                enabledMenuOptions.append(3).append(',');
            }
            if (umountEnabled) {
                enabledMenuOptions.append(4).append(',');
            }
            if (deleteEnabled) {
                enabledMenuOptions.append(5).append(',');
            }
            if (SamUtil.isVersionCurrentOrLaterThan(this.apiVersion, "1.3.3") && !mountEnabled) {
                enabledMenuOptions.append(6).append(',');
            }
            if ((len = enabledMenuOptions.length()) > 0 && enabledMenuOptions.charAt(len - 1) == ',') {
                enabledMenuOptions.deleteCharAt(len - 1);
            }
            this.setValue("HiddenDynamicButtons", enabledButtons.toString());
            this.setValue("HiddenDynamicMenuOptions", enabledMenuOptions.toString());
            this.setValue("Href", new NonSyncStringBuffer(name).append(':').append(fsType).append(':').append(type).append(':').append(archiveEnabled).toString());
            this.setValue("FSHiddenField", name);
            this.initQueryParams();
            String nfsShared = fileSystems[j].hasNFSShares() ? SamUtil.getResourceString("samqfsui.yes") : "";
            this.setValue("nfsSharedText", nfsShared);
        }
        TraceUtil.trace3("Exiting");
    }

    private void initQueryParams() {
        TraceUtil.trace3("Entering");
        String index = new Integer(this.getRowIndex()).toString();
        TraceUtil.trace3("index in model " + index);
        TraceUtil.trace3("Exiting");
    }

    public void setFilter(String selectedType) {
        TraceUtil.trace3("Entering");
        this.filtered = true;
        if (selectedType.equals("ALL")) {
            this.filterSetting = -1;
        } else {
            this.filterSetting = -1;
            try {
                this.filterSetting = Integer.parseInt(selectedType);
            }
            catch (NumberFormatException numEx) {
                this.filterSetting = -1;
            }
        }
        TraceUtil.trace3("Exiting");
    }

    public ArrayList getLatestIndex() {
        TraceUtil.trace3("Entering");
        TraceUtil.trace3("Exiting");
        return this.latestRows;
    }

    private boolean shouldThisFSBeExcluded(int fsDescription, boolean hasNFSShares) {
        switch (this.filterSetting) {
            case 0: {
                return fsDescription < 0 || fsDescription > 7;
            }
            case 1: {
                return fsDescription != 8;
            }
            case 2: {
                return fsDescription != 11;
            }
            case 3: {
                return !hasNFSShares;
            }
        }
        return false;
    }
}

